/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.StartEntry;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTFindMacrosWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.GuardBlockWalker;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;

public final class FileInfoQueryImpl
extends CsmFileInfoQuery {
    private final ConcurrentMap<CsmFile, Object> macroUsagesLocks = new ConcurrentHashMap<CsmFile, Object>();

    public List<FSPath> getSystemIncludePaths(CsmFile csmFile) {
        return this.getIncludePaths(csmFile, true);
    }

    public List<FSPath> getUserIncludePaths(CsmFile csmFile) {
        return this.getIncludePaths(csmFile, false);
    }

    private List<FSPath> getIncludePaths(CsmFile csmFile, boolean bl) {
        NativeFileItem nativeFileItem;
        List list = Collections.emptyList();
        if (csmFile instanceof FileImpl && (nativeFileItem = Utils.getCompiledFileItem((FileImpl)csmFile)) != null) {
            if (nativeFileItem.getLanguage() == NativeFileItem.Language.C_HEADER) {
                NativeProject nativeProject = nativeFileItem.getNativeProject();
                if (nativeProject != null) {
                    list = bl ? nativeProject.getSystemIncludePaths() : nativeProject.getUserIncludePaths();
                }
            } else {
                list = bl ? nativeFileItem.getSystemIncludePaths() : nativeFileItem.getUserIncludePaths();
            }
        }
        return list;
    }

    public List<CsmOffsetable> getUnusedCodeBlocks(CsmFile csmFile) {
        List<CsmOffsetable> list = Collections.emptyList();
        if (csmFile instanceof FileImpl) {
            FileImpl fileImpl = (FileImpl)csmFile;
            Collection<PreprocessorStatePair> collection = fileImpl.getPreprocStatePairs();
            List<CsmOffsetable> list2 = new ArrayList<CsmOffsetable>();
            boolean bl = true;
            for (PreprocessorStatePair iterator2 : collection) {
                FilePreprocessorConditionState filePreprocessorConditionState = iterator2.pcState;
                if (filePreprocessorConditionState == FilePreprocessorConditionState.PARSING) continue;
                List<CsmOffsetable> list3 = filePreprocessorConditionState.createBlocksForFile(fileImpl);
                if (bl) {
                    list2 = list3;
                    bl = false;
                    continue;
                }
                if (!(list2 = FileInfoQueryImpl.intersection(list2, list3)).isEmpty()) continue;
                break;
            }
            CsmOffsetable csmOffsetable = null;
            Iterator<CsmErrorDirective> iterator = fileImpl.getErrors().iterator();
            if (iterator.hasNext()) {
                CsmErrorDirective csmErrorDirective = iterator.next();
                csmOffsetable = Utils.createOffsetable(fileImpl, csmErrorDirective.getEndOffset(), Integer.MAX_VALUE);
            }
            if (csmOffsetable != null) {
                list = new ArrayList<CsmOffsetable>(list2.size());
                for (CsmOffsetable csmOffsetable2 : list2) {
                    if (csmOffsetable2.getEndOffset() >= csmOffsetable.getStartOffset()) break;
                    list.add(csmOffsetable2);
                }
                list.add(csmOffsetable);
            } else {
                list = list2;
            }
        }
        return list;
    }

    private static boolean contains(CsmOffsetable csmOffsetable, CsmOffsetable csmOffsetable2) {
        return csmOffsetable != null && csmOffsetable2 != null && csmOffsetable.getStartOffset() <= csmOffsetable2.getStartOffset() && csmOffsetable2.getEndOffset() <= csmOffsetable.getEndOffset();
    }

    private static List<CsmOffsetable> intersection(Collection<CsmOffsetable> collection, Collection<CsmOffsetable> collection2) {
        ArrayList<CsmOffsetable> arrayList = new ArrayList<CsmOffsetable>(Math.max(collection.size(), collection2.size()));
        for (CsmOffsetable csmOffsetable : collection) {
            for (CsmOffsetable csmOffsetable2 : collection2) {
                if (csmOffsetable == null) continue;
                if (csmOffsetable.equals(csmOffsetable2)) {
                    arrayList.add(csmOffsetable);
                    continue;
                }
                if (FileInfoQueryImpl.contains(csmOffsetable, csmOffsetable2)) {
                    arrayList.add(csmOffsetable2);
                    continue;
                }
                if (!FileInfoQueryImpl.contains(csmOffsetable2, csmOffsetable)) continue;
                arrayList.add(csmOffsetable);
            }
        }
        return arrayList;
    }

    public CharSequence getName(CsmUID<CsmFile> csmUID) {
        return FileInfoQueryImpl.getFileName(csmUID);
    }

    public static CharSequence getFileName(CsmUID<CsmFile> csmUID) {
        CharSequence charSequence = UIDUtilities.getFileName(csmUID);
        int n = CharSequenceUtilities.lastIndexOf((CharSequence)charSequence, (int)47);
        if (n < 0) {
            n = CharSequenceUtilities.lastIndexOf((CharSequence)charSequence, (int)92);
        }
        if (n > 0 && n < charSequence.length()) {
            charSequence = CharSequenceUtilities.toString((CharSequence)charSequence, (int)(n + 1), (int)charSequence.length());
        }
        return charSequence;
    }

    public CharSequence getAbsolutePath(CsmUID<CsmFile> csmUID) {
        return UIDUtilities.getFileName(csmUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public List<CsmReference> getMacroUsages(CsmFile var1_1) {
        block19: {
            var2_2 = Collections.emptyList();
            if (!(var1_1 instanceof FileImpl)) break block19;
            var3_3 = (FileImpl)var1_1;
            var4_4 = new NamedLock("getMacroUsages lock for " + var1_1.getAbsolutePath());
            var5_5 = this.macroUsagesLocks.putIfAbsent(var3_3, var4_4);
            var4_4 = var5_5 != null ? var5_5 : var4_4;
            var6_6 = var4_4;
            synchronized (var6_6) {
                var7_7 = var3_3.getLastMacroUsages();
                if (var7_7 == null) ** break block16
                var8_8 = var7_7;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl14 : MonitorExitStatement: MONITOREXIT : var6_6
                this.macroUsagesLocks.remove(var3_3, var4_4);
            }
            return var8_8;
            {
                var8_9 = var3_3.getLastParsedTime();
                var10_12 = APTDriver.findAPT((APTFileBuffer)var3_3.getBuffer(), (String)var3_3.getFileLanguage());
                if (var10_12 == null) ** GOTO lbl52
                var11_13 = var3_3.getPreprocHandlers();
                if (!var11_13.isEmpty()) ** break block17
                DiagnosticExceptoins.register(new IllegalStateException("Empty preprocessor handlers for " + var1_1.getAbsolutePath()));
                var12_14 = Collections.emptyList();
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl26 : MonitorExitStatement: MONITOREXIT : var6_6
                this.macroUsagesLocks.remove(var3_3, var4_4);
            }
            return var12_14;
            {
                try {
                    if (var11_13.size() == 1) {
                        var12_15 = var11_13.iterator().next();
                        var13_17 = var3_3.getAPTCacheEntry(var12_15, Boolean.FALSE);
                        var14_19 = new APTFindMacrosWalker(var10_12, var3_3, var12_15, var13_17);
                        var2_2 = var14_19.collectMacros();
                        var3_3.setAPTCacheEntry(var12_15, var13_17, false);
                    } else {
                        var12_16 = new OffsetableComparator<T>();
                        var13_18 = new TreeSet<T>(var12_16);
                        for (APTPreprocHandler var15_21 : var11_13) {
                            var16_22 = var3_3.getAPTCacheEntry(var15_21, Boolean.FALSE);
                            var17_23 = new APTFindMacrosWalker(var10_12, var3_3, var15_21, var16_22);
                            var13_18.addAll(var17_23.collectMacros());
                            var3_3.setAPTCacheEntry(var15_21, var16_22, false);
                        }
                        var2_2 = new ArrayList<T>(var13_18);
                    }
lbl52:
                    // 3 sources

                    if (var8_9 == var3_3.getLastParsedTime()) {
                        var3_3.setLastMacroUsages(var2_2);
                    }
                }
                catch (FileNotFoundException var8_10) {
                }
                catch (IOException var8_11) {
                    System.err.println("skip marking macros\nreason:" + var8_11.getMessage());
                    DiagnosticExceptoins.register(var8_11);
                }
                break block19;
                {
                    catch (Throwable var18_24) {
                        throw var18_24;
                    }
                }
            }
            {
                finally {
                    this.macroUsagesLocks.remove(var3_3, var4_4);
                }
            }
        }
        return var2_2;
    }

    public CsmOffsetable getGuardOffset(CsmFile csmFile) {
        if (csmFile instanceof FileImpl) {
            FileImpl fileImpl = (FileImpl)csmFile;
            try {
                Token token;
                APTFile aPTFile = APTDriver.findAPT((APTFileBuffer)fileImpl.getBuffer(), (String)fileImpl.getFileLanguage());
                GuardBlockWalker guardBlockWalker = new GuardBlockWalker(aPTFile);
                TokenStream tokenStream = guardBlockWalker.getTokenStream();
                try {
                    token = tokenStream.nextToken();
                    while (!APTUtils.isEOF((Token)token)) {
                        if (!APTUtils.isCommentToken((Token)token)) {
                            guardBlockWalker.clearGuard();
                            break;
                        }
                        token = tokenStream.nextToken();
                    }
                }
                catch (TokenStreamException tokenStreamException) {
                    guardBlockWalker.clearGuard();
                }
                token = guardBlockWalker.getGuard();
                if (token != null && token instanceof APTToken) {
                    APTToken aPTToken = (APTToken)token;
                    return OffsetableBase.create(csmFile, aPTToken.getOffset(), aPTToken.getEndOffset());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                System.err.println("IOExeption in getGuardOffset:" + iOException.getMessage());
            }
        }
        return null;
    }

    public NativeFileItem getNativeFileItem(CsmFile csmFile) {
        if (csmFile instanceof FileImpl) {
            return ((FileImpl)csmFile).getNativeFileItem();
        }
        return null;
    }

    public Collection<CsmCompilationUnit> getCompilationUnits(CsmFile csmFile, int n) {
        CsmCompilationUnit csmCompilationUnit = CsmCompilationUnit.createCompilationUnit((CsmProject)csmFile.getProject(), (CharSequence)csmFile.getAbsolutePath(), (CsmFile)csmFile);
        ArrayList<CsmCompilationUnit> arrayList = new ArrayList<CsmCompilationUnit>(1);
        boolean bl = true;
        if (csmFile instanceof FileImpl) {
            FileImpl fileImpl = (FileImpl)csmFile;
            Collection<APTPreprocHandler.State> collection = ((ProjectBase)fileImpl.getProject()).getPreprocStates(fileImpl);
            for (APTPreprocHandler.State state : collection) {
                StartEntry startEntry = APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state);
                ProjectBase projectBase = Utils.getStartProject(startEntry);
                if (projectBase == null) continue;
                CharSequence charSequence = startEntry.getStartFile();
                FileImpl fileImpl2 = projectBase.getFile(charSequence, false);
                if (fileImpl2 != null) {
                    bl = false;
                }
                CsmCompilationUnit csmCompilationUnit2 = CsmCompilationUnit.createCompilationUnit((CsmProject)projectBase, (CharSequence)charSequence, (CsmFile)fileImpl2);
                arrayList.add(csmCompilationUnit2);
            }
        }
        if (bl) {
            arrayList.add(csmCompilationUnit);
        }
        return arrayList;
    }

    public List<CsmInclude> getIncludeStack(CsmFile csmFile) {
        if (csmFile instanceof FileImpl) {
            FileImpl fileImpl;
            FileImpl fileImpl2 = (FileImpl)csmFile;
            Collection<APTPreprocHandler.State> collection = ((ProjectBase)fileImpl2.getProject()).getPreprocStates(fileImpl2);
            if (collection.isEmpty()) {
                return Collections.emptyList();
            }
            APTPreprocHandler.State state = collection.iterator().next();
            CndUtils.assertNotNull((Object)state, (String)"state must not be null in non empty collection");
            LinkedList linkedList = APTHandlersSupport.extractIncludeStack((APTPreprocHandler.State)state);
            StartEntry startEntry = APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state);
            ProjectBase projectBase = Utils.getStartProject(startEntry);
            if (projectBase != null && (fileImpl = projectBase.getFile(startEntry.getStartFile(), false)) != null) {
                ArrayList<CsmInclude> arrayList = new ArrayList<CsmInclude>();
                for (APTIncludeHandler.IncludeInfo includeInfo : linkedList) {
                    int n = includeInfo.getIncludeDirectiveOffset();
                    CsmInclude csmInclude = null;
                    for (CsmInclude csmInclude2 : fileImpl.getIncludes()) {
                        if (n != csmInclude2.getStartOffset()) continue;
                        csmInclude = csmInclude2;
                        break;
                    }
                    if (csmInclude == null) break;
                    arrayList.add(csmInclude);
                    fileImpl = csmInclude.getIncludeFile();
                    if (fileImpl != null) continue;
                    break;
                }
                return arrayList;
            }
        }
        return Collections.emptyList();
    }

    public boolean hasBrokenIncludes(CsmFile csmFile) {
        if (csmFile instanceof FileImpl) {
            return ((FileImpl)csmFile).hasBrokenIncludes();
        }
        return false;
    }

    public Collection<CsmInclude> getBrokenIncludes(CsmFile csmFile) {
        if (csmFile instanceof FileImpl && ((FileImpl)csmFile).hasBrokenIncludes()) {
            return ((FileImpl)csmFile).getBrokenIncludes();
        }
        return Collections.emptyList();
    }

    public long getFileVersion(CsmFile csmFile) {
        if (csmFile instanceof FileImpl) {
            return FileImpl.getLongParseCount();
        }
        return 0L;
    }

    public long getOffset(CsmFile csmFile, int n, int n2) {
        if (csmFile instanceof FileImpl) {
            return ((FileImpl)csmFile).getOffset(n, n2);
        }
        return 0L;
    }

    private static class OffsetableComparator<T extends CsmOffsetable>
    implements Comparator<T> {
        private OffsetableComparator() {
        }

        @Override
        public int compare(CsmOffsetable csmOffsetable, CsmOffsetable csmOffsetable2) {
            int n = csmOffsetable.getStartOffset() - csmOffsetable2.getStartOffset();
            if (n == 0) {
                return csmOffsetable.getEndOffset() - csmOffsetable2.getEndOffset();
            }
            return n;
        }
    }

    private static final class NamedLock {
        private final String name;

        public NamedLock(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            NamedLock namedLock = (NamedLock)object;
            return !(this.name == null ? namedLock.name != null : !this.name.equals(namedLock.name));
        }

        public int hashCode() {
            int n = 5;
            n = 97 * n + (this.name != null ? this.name.hashCode() : 0);
            return n;
        }
    }
}

