/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

public abstract class StatementBase
extends OffsetableBase
implements CsmStatement {
    private final AST ast;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;

    protected StatementBase(AST aST, CsmFile csmFile, CsmScope csmScope) {
        this(aST, csmFile, StatementBase.getStartOffset(aST), StatementBase.getEndOffset(aST), csmScope);
    }

    protected StatementBase(CsmFile csmFile, int n, int n2, CsmScope csmScope) {
        this(null, csmFile, n, n2, csmScope);
    }

    private StatementBase(AST aST, CsmFile csmFile, int n, int n2, CsmScope csmScope) {
        super(csmFile, n, n2);
        this.ast = aST;
        if (csmScope != null) {
            this.setScope(csmScope);
        }
    }

    public CsmScope getScope() {
        CsmScope csmScope = this.scopeRef;
        if (csmScope == null) {
            csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
        return csmScope;
    }

    protected final void setScope(CsmScope csmScope) {
        if (csmScope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
            assert (this.scopeUID != null || csmScope == null);
        } else {
            this.scopeRef = csmScope;
        }
    }

    protected AST getAst() {
        return this.ast;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, dataOutput);
    }

    protected StatementBase(DataInput dataInput) throws IOException {
        super(dataInput);
        this.ast = null;
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }

    @Override
    public String toString() {
        return "" + this.getKind() + ' ' + this.getOffsetString();
    }

    private void onDispose() {
        if (this.scopeRef == null) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null) : "no object for UID " + this.scopeUID;
        }
    }
}

