/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.api.project.NativeProjectSettings;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.apt.support.APTSystemStorage;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ListenersImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryEvent;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryListener;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryNotifier;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.repository.KeyManager;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.FileNameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.ProjectNameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.UniqueNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.netbeans.modules.cnd.utils.cache.TextCache;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class ModelImpl
implements CsmModel,
LowMemoryListener {
    private final String clientTaskPrefix = "Code Model Client Request";
    private static final String modelTaskPrefix = "Code Model Request Processor";
    private final Object lock = new Lock();
    private final Map<Object, CsmUID<CsmProject>> platf2csm = new HashMap<Object, CsmUID<CsmProject>>();
    private CsmModelState state;
    private double warningThreshold = 0.98;
    private final Set<Object> disabledProjects = new HashSet<Object>();
    private final RequestProcessor modelProcessor = new RequestProcessor("Code model request processor", 1);
    private final RequestProcessor userTasksProcessor = new RequestProcessor("User model tasks processor", 4);

    public ModelImpl() {
        this.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmProject findProject(Object object) {
        ProjectBase projectBase = null;
        if (object != null) {
            Object object2 = this.lock;
            synchronized (object2) {
                projectBase = this.obj2Project(object);
            }
        }
        return projectBase;
    }

    private ProjectBase obj2Project(Object object) {
        CsmUID<CsmProject> csmUID = this.platf2csm.get(object);
        ProjectBase projectBase = (ProjectBase)UIDCsmConverter.UIDtoProject(csmUID);
        assert (projectBase != null || csmUID == null) : "null object for UID " + csmUID;
        return projectBase;
    }

    public CsmProject getProject(Object object) {
        NativeProject nativeProject;
        if (object instanceof Project && (nativeProject = (NativeProject)((Project)object).getLookup().lookup(NativeProject.class)) != null) {
            object = nativeProject;
        }
        return this.findProject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CsmProject _getProject(Object object) {
        ProjectBase projectBase = null;
        if (object != null) {
            Object object2 = this.lock;
            synchronized (object2) {
                projectBase = this.obj2Project(object);
                if (projectBase == null && object instanceof Project) {
                    if (TraceFlags.DEBUG) {
                        System.err.println("getProject called with Project... expected NativeProject");
                        new Throwable().printStackTrace(System.err);
                    }
                    ProjectBase projectBase2 = projectBase = (object = ((Project)object).getLookup().lookup(NativeProject.class)) != null ? this.obj2Project(object) : null;
                }
                if (projectBase == null) {
                    String string;
                    if (this.disabledProjects.contains(object)) {
                        return null;
                    }
                    if (object instanceof NativeProject) {
                        string = ((NativeProject)object).getProjectDisplayName();
                    } else {
                        new IllegalStateException("CsmProject does not exist: " + object).printStackTrace(System.err);
                        string = "<unnamed>";
                    }
                    projectBase = ProjectImpl.createInstance(this, (NativeProject)object, string);
                    this.putProject2Map(object, projectBase);
                }
            }
        }
        return projectBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectBase addProject(NativeProject nativeProject, String string, boolean bl) {
        ProjectBase projectBase = null;
        assert (nativeProject != null) : "The platform project is null";
        if (bl && !this.disabledProjects.contains(nativeProject)) {
            boolean bl2 = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.state != CsmModelState.ON) {
                    if (TraceFlags.TRACE_MODEL_STATE) {
                        System.err.println("project " + string + " wasn't added because model is " + this.state + "\n\t" + nativeProject);
                    }
                    return null;
                }
                projectBase = this.obj2Project(nativeProject);
                if (projectBase == null) {
                    projectBase = ProjectImpl.createInstance(this, nativeProject, string);
                    this.putProject2Map(nativeProject, projectBase);
                    bl2 = true;
                } else {
                    String string2 = ((Object)ProjectBase.getUniqueName(nativeProject)).toString();
                    String string3 = ((Object)projectBase.getUniqueName()).toString();
                    if (!string3.equals(string2)) {
                        new IllegalStateException("Existing project unique name differ: " + string3 + " - expected " + string2).printStackTrace(System.err);
                    }
                }
            }
            if (bl2) {
                ListenersImpl.getImpl().fireProjectOpened(projectBase);
            }
        } else {
            this.disabledProjects.add(nativeProject);
        }
        return projectBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectBase addProject(ProjectBase projectBase) {
        Object object = this.lock;
        synchronized (object) {
            Object object2 = projectBase.getPlatformProject();
            if (this.obj2Project(object2) != null) {
                new IllegalStateException("CsmProject already exists: " + object2).printStackTrace(System.err);
                return null;
            }
            this.putProject2Map(object2, projectBase);
        }
        ListenersImpl.getImpl().fireProjectOpened(projectBase);
        return projectBase;
    }

    private void putProject2Map(Object object, ProjectBase projectBase) {
        CsmUID<CsmProject> csmUID = UIDCsmConverter.projectToUID(projectBase);
        this.platf2csm.put(object, csmUID);
    }

    public void closeProject(Object object) {
        this._closeProject(null, object, !TraceFlags.PERSISTENT_REPOSITORY);
    }

    public void closeProject(Object object, boolean bl) {
        this._closeProject(null, object, bl);
    }

    public void closeProjectBase(ProjectBase projectBase) {
        this._closeProject(projectBase, projectBase.getPlatformProject(), !TraceFlags.PERSISTENT_REPOSITORY);
    }

    public void closeProjectBase(ProjectBase projectBase, boolean bl) {
        this._closeProject(projectBase, projectBase.getPlatformProject(), bl);
    }

    private void _closeProject(final ProjectBase projectBase, final Object object, final boolean bl) {
        this._closeProject2_pre(projectBase, object);
        if (SwingUtilities.isEventDispatchThread()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ModelImpl.this._closeProject2(projectBase, object, bl);
                }
            };
            this.enqueueModelTask(runnable, "Closing Project ");
        } else {
            this._closeProject2(projectBase, object, bl);
        }
    }

    private void _closeProject2_pre(ProjectBase projectBase, Object object) {
        ProjectBase projectBase2;
        ProjectBase projectBase3 = projectBase2 = projectBase == null ? (ProjectBase)this.getProject(object) : projectBase;
        if (projectBase2 != null) {
            projectBase2.setDisposed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _closeProject2(ProjectBase projectBase, Object object, boolean bl) {
        ProjectBase projectBase2 = projectBase;
        boolean bl2 = false;
        Object object2 = this.lock;
        synchronized (object2) {
            CsmUID<CsmProject> csmUID = this.platf2csm.remove(object);
            if (csmUID != null) {
                ProjectBase projectBase3 = projectBase2 = projectBase2 == null ? (ProjectBase)UIDCsmConverter.UIDtoProject(csmUID) : projectBase2;
                assert (projectBase2 != null) : "null object for UID " + csmUID;
            }
            bl2 = this.platf2csm.isEmpty();
        }
        if (projectBase2 != null) {
            this.disposeProject(projectBase2, bl);
            if (!projectBase2.isArtificial()) {
                LibraryManager.getInstance().onProjectClose(projectBase2.getUID());
            }
        }
        if (bl2) {
            this.cleanCaches();
        }
    }

    void disposeProject(ProjectBase projectBase) {
        this.disposeProject(projectBase, !TraceFlags.PERSISTENT_REPOSITORY);
    }

    void disposeProject(ProjectBase projectBase, boolean bl) {
        assert (projectBase != null);
        if (projectBase != null) {
            CharSequence charSequence = projectBase.getName();
            if (TraceFlags.TRACE_CLOSE_PROJECT) {
                System.err.println("dispose project " + charSequence);
            }
            projectBase.setDisposed();
            ListenersImpl.getImpl().fireProjectClosed(projectBase);
            ParserThreadManager.instance().waitEmptyProjectQueue(projectBase);
            projectBase.dispose(bl);
            if (TraceFlags.TRACE_CLOSE_PROJECT) {
                System.err.println("project closed " + charSequence);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmProject> projects() {
        ArrayList<CsmUID<CsmProject>> arrayList;
        ArrayList<CsmProject> arrayList2 = this.lock;
        synchronized (arrayList2) {
            arrayList = new ArrayList<CsmUID<CsmProject>>(this.platf2csm.values());
        }
        arrayList2 = new ArrayList<CsmProject>(arrayList.size());
        for (CsmUID csmUID : arrayList) {
            ProjectBase projectBase = (ProjectBase)UIDCsmConverter.UIDtoProject((CsmUID<CsmProject>)csmUID);
            assert (projectBase != null) : "null project for UID " + csmUID;
            if (projectBase == null) continue;
            arrayList2.add(projectBase);
        }
        return arrayList2;
    }

    public Cancellable enqueue(Runnable runnable, CharSequence charSequence) {
        return this.enqueue(this.userTasksProcessor, runnable, "Code Model Client Request :" + charSequence);
    }

    public static ModelImpl instance() {
        return (ModelImpl)CsmModelAccessor.getModel();
    }

    public Cancellable enqueueModelTask(Runnable runnable, String string) {
        return this.enqueue(this.modelProcessor, runnable, "Code Model Request Processor: " + string);
    }

    private Cancellable enqueue(RequestProcessor requestProcessor, final Runnable runnable, final String string) {
        if (TraceFlags.TRACE_182342_BUG) {
            new Exception(string).printStackTrace(System.err);
        }
        return requestProcessor.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String string2 = Thread.currentThread().getName();
                Thread.currentThread().setName(string);
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    DiagnosticExceptoins.register(throwable);
                }
                finally {
                    Thread.currentThread().setName(string2);
                }
            }
        });
    }

    public CsmFile findFile(CharSequence charSequence, boolean bl, boolean bl2) {
        Object object;
        CsmProject csmProject3;
        CndUtils.assertAbsolutePathInConsole((String)((Object)charSequence).toString());
        Collection<CsmProject> collection = this.projects();
        CsmProject csmProject2 = null;
        for (CsmProject csmProject3 : collection) {
            CsmFile csmFile;
            ProjectBase projectBase;
            if (!(csmProject3 instanceof ProjectBase) || (projectBase = ((ProjectBase)csmProject3).findFileProject(charSequence, bl)) == null || (csmFile = projectBase.findFile(charSequence, bl, bl2)) == null) continue;
            csmProject2 = csmFile;
            if (CsmStandaloneFileProvider.getDefault().isStandalone(csmFile)) continue;
            return csmProject2;
        }
        try {
            object = new File(((Object)charSequence).toString()).getCanonicalPath();
        }
        catch (IOException iOException) {
            object = null;
        }
        if (object != null && !((String)object).equals(charSequence) && (csmProject3 = this.findFile((CharSequence)object, true, bl2)) != null) {
            csmProject2 = csmProject3;
        }
        return csmProject2;
    }

    public CsmModelState getState() {
        return this.state;
    }

    public final void startup() {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.startup");
        }
        ModelSupport.instance().setModel(this);
        this.setState(CsmModelState.ON);
        if (TraceFlags.CHECK_MEMORY && this.warningThreshold > 0.0) {
            LowMemoryNotifier.instance().addListener(this);
            LowMemoryNotifier.instance().setThresholdPercentage(this.warningThreshold);
        }
        ParserThreadManager.instance().startup(CndUtils.isStandalone());
        RepositoryUtils.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Collection<CsmProject> collection;
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.shutdown");
        }
        this.setState(CsmModelState.CLOSING);
        ParserThreadManager.instance().shutdown();
        if (TraceFlags.CHECK_MEMORY) {
            LowMemoryNotifier.instance().removeListener(this);
        }
        HashSet hashSet = new HashSet();
        Iterator<Object> iterator = this.lock;
        synchronized (iterator) {
            collection = this.projects();
            this.platf2csm.clear();
        }
        for (ProjectBase projectBase : collection) {
            hashSet.addAll(projectBase.getLibraries());
            this.disposeProject(projectBase);
        }
        iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.disposeProject((ProjectBase)iterator.next());
        }
        LibraryManager.getInstance().shutdown();
        this.cleanCaches();
        this.setState(CsmModelState.OFF);
        RepositoryUtils.shutdown();
        ModelSupport.instance().setModel(null);
    }

    @Override
    public void memoryLow(final LowMemoryEvent lowMemoryEvent) {
        double d = (double)lowMemoryEvent.getUsedMemory() / (double)lowMemoryEvent.getMaxMemory();
        boolean bl = d >= this.warningThreshold && this.projects().size() > 0;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName("Code model low memory handler");
                ModelSupport.instance().onMemoryLow(lowMemoryEvent, false);
            }
        };
        new Thread(runnable).start();
    }

    private void setState(CsmModelState csmModelState) {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("  ModelImpl.setState " + this.state + " -> " + csmModelState);
        }
        if (csmModelState != this.state) {
            CsmModelState csmModelState2 = this.state;
            this.state = csmModelState;
            ListenersImpl.getImpl().fireModelStateChanged(csmModelState, csmModelState2);
        }
    }

    public void suspend() {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.suspend");
        }
        this.setState(CsmModelState.SUSPENDED);
        ParserQueue.instance().suspend();
    }

    public void resume() {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.resume");
        }
        this.setState(CsmModelState.ON);
        ParserQueue.instance().resume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableProject(NativeProject nativeProject) {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.disableProject " + nativeProject.getProjectDisplayName());
        }
        Object object = this.lock;
        synchronized (object) {
            this.disabledProjects.add(nativeProject);
        }
        object = (ProjectBase)this.findProject(nativeProject);
        if (object != null) {
            this.disableProject2((ProjectBase)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableProject(ProjectBase projectBase) {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.disableProject " + projectBase);
        }
        if (projectBase != null) {
            Object object = this.lock;
            synchronized (object) {
                this.disabledProjects.add(projectBase.getPlatformProject());
            }
            this.disableProject2(projectBase);
        }
    }

    private void disableProject2(ProjectBase projectBase) {
        projectBase.setDisposed();
        Lookup.Provider provider = ModelImpl.findProjectByNativeProject(ModelSupport.getNativeProject(projectBase.getPlatformProject()));
        this.setCodeAssistanceEnabled(provider, false);
        this.disableProject3(projectBase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableProject3(ProjectBase projectBase) {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.disableProject3");
        }
        this.suspend();
        try {
            boolean bl;
            while (ParserQueue.instance().isParsing(projectBase)) {
                try {
                    if (TraceFlags.TRACE_MODEL_STATE) {
                        System.err.println("ModelImpl.disableProject3: waiting for current parse...");
                    }
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.closeProjectBase(projectBase);
            Object object = this.lock;
            synchronized (object) {
                bl = this.platf2csm.isEmpty();
            }
            if (bl) {
                this.cleanCaches();
            }
        }
        finally {
            this.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableProject(NativeProject nativeProject) {
        if (TraceFlags.TRACE_MODEL_STATE) {
            System.err.println("ModelImpl.enableProject " + nativeProject.getProjectDisplayName());
        }
        Object object = this.lock;
        synchronized (object) {
            this.disabledProjects.remove(nativeProject);
        }
        object = ModelImpl.findProjectByNativeProject(nativeProject);
        this.setCodeAssistanceEnabled((Lookup.Provider)object, true);
        this.addProject(nativeProject, nativeProject.getProjectDisplayName(), Boolean.TRUE);
    }

    private void setCodeAssistanceEnabled(Lookup.Provider provider, boolean bl) {
        NativeProjectSettings nativeProjectSettings;
        if (provider != null && (nativeProjectSettings = (NativeProjectSettings)provider.getLookup().lookup(NativeProjectSettings.class)) != null) {
            nativeProjectSettings.setCodeAssistanceEnabled(bl);
        }
    }

    public static Lookup.Provider findProjectByNativeProject(NativeProject nativeProject) {
        for (NativeProject nativeProject2 : NativeProjectRegistry.getDefault().getOpenProjects()) {
            if (nativeProject2 != nativeProject) continue;
            return nativeProject2.getProject();
        }
        return null;
    }

    public boolean isProjectEnabled(NativeProject nativeProject) {
        ProjectBase projectBase = (ProjectBase)this.findProject(nativeProject);
        return projectBase != null && !projectBase.isDisposing();
    }

    public boolean isProjectDiabled(NativeProject nativeProject) {
        return this.disabledProjects.contains(nativeProject);
    }

    private void cleanCaches() {
        TextCache.getManager().dispose();
        FilePathCache.getManager().dispose();
        QualifiedNameCache.getManager().dispose();
        NameCache.getManager().dispose();
        UniqueNameCache.getManager().dispose();
        FileNameCache.getManager().dispose();
        ProjectNameCache.getManager().dispose();
        APTDriver.close();
        APTFileCacheManager.close();
        UIDManager.instance().dispose();
        KeyManager.instance().dispose();
        CndFileUtils.clearFileExistenceCache();
        APTSystemStorage.dispose();
    }

    public void scheduleReparse(Collection<CsmProject> collection) {
        Object object;
        CndFileUtils.clearFileExistenceCache();
        ParserQueue.instance().clearParseWatch();
        HashSet<LibProjectImpl> hashSet = new HashSet<LibProjectImpl>();
        HashSet<ProjectBase> hashSet2 = new HashSet<ProjectBase>();
        for (CsmProject object22 : collection) {
            if (!(object22 instanceof ProjectBase)) continue;
            ProjectBase projectBase = (ProjectBase)object22;
            hashSet2.add(projectBase);
            for (CsmProject csmProject2 : projectBase.getLibraries()) {
                LibProjectImpl libProjectImpl;
                if (!(csmProject2 instanceof LibProjectImpl) || hashSet.contains(libProjectImpl = (LibProjectImpl)csmProject2)) continue;
                hashSet.add(libProjectImpl);
            }
        }
        for (CsmProject csmProject : this.projects()) {
            if (collection.contains(csmProject) || !(csmProject instanceof ProjectBase)) continue;
            ProjectBase projectBase = (ProjectBase)csmProject;
            for (CsmProject csmProject2 : projectBase.getLibraries()) {
                if (!(csmProject2 instanceof LibProjectImpl)) continue;
                hashSet.remove((LibProjectImpl)csmProject2);
            }
        }
        for (LibProjectImpl libProjectImpl : hashSet) {
            libProjectImpl.initFields();
        }
        ArrayList arrayList = new ArrayList();
        for (ProjectBase projectBase : hashSet2) {
            object = projectBase.getPlatformProject();
            arrayList.add(object);
            this.closeProject(object, true);
        }
        for (LibProjectImpl libProjectImpl : hashSet) {
            this.closeProject(libProjectImpl.getPlatformProject(), true);
        }
        LibraryManager.getInstance().cleanLibrariesData(hashSet);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            object = (ProjectBase)this._getProject(e);
            if (object == null) continue;
            ((ProjectBase)object).scheduleReparse();
            ListenersImpl.getImpl().fireProjectOpened((ProjectBase)object);
        }
    }

    public void dumpInfo(PrintWriter printWriter, boolean bl) {
        printWriter.printf("ModelImpl: disabled=%d, projects=%d\n", this.disabledProjects.size(), this.platf2csm.size());
        int n = 1;
        for (Object object : this.disabledProjects) {
            printWriter.printf("D[%d] %s\n", n++, object);
        }
        n = 1;
        for (Map.Entry entry : this.platf2csm.entrySet()) {
            Object k = entry.getKey();
            CsmUID csmUID = (CsmUID)entry.getValue();
            printWriter.printf("[%d] key=[%s] %s\n\tprj=(%d)%s\n", n, k.getClass().getSimpleName(), k, System.identityHashCode(csmUID), csmUID);
            CsmProject csmProject = UIDCsmConverter.UIDtoProject((CsmUID<CsmProject>)csmUID);
            if (csmProject == null) {
                printWriter.printf("Project was NOT restored from repository\n", new Object[0]);
            } else if (csmProject instanceof ProjectBase) {
                printWriter.printf("[%d] disposing?=%s\n", n, ((ProjectBase)csmProject).isDisposing());
                Collection collection = csmProject.getLibraries();
                int n2 = 0;
                for (CsmProject csmProject2 : collection) {
                    printWriter.printf("\tlib[%d]=%s\n", ++n2, csmProject2);
                }
                Object object = csmProject.getPlatformProject();
                printWriter.printf("platformProjec=%s\n", object);
                if (object instanceof NativeProject) {
                    CsmProject csmProject2;
                    csmProject2 = (NativeProject)object;
                    List list = csmProject2.getDependences();
                    n2 = 0;
                    for (NativeProject nativeProject : list) {
                        printWriter.printf("\tnativeLib[%d]=%s\n", ++n2, nativeProject);
                    }
                }
                if (bl) {
                    ((ProjectBase)csmProject).traceFileContainer(printWriter);
                }
            } else {
                printWriter.printf("Project has unexpected class type %s\n", csmProject.getClass().getName());
            }
            ++n;
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

