/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class FilePreprocessorConditionState {
    public static final FilePreprocessorConditionState PARSING = new FilePreprocessorConditionState("PARSING", new int[]{0, Integer.MAX_VALUE});
    private final int[] offsets;
    private final transient CharSequence fileName;

    private FilePreprocessorConditionState(CharSequence charSequence, int[] nArray) {
        this.offsets = nArray;
        this.fileName = charSequence;
    }

    public FilePreprocessorConditionState(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n > 0) {
            this.offsets = new int[n];
            for (int i = 0; i < n; ++i) {
                this.offsets[i] = dataInput.readInt();
            }
        } else {
            this.offsets = new int[0];
        }
        this.fileName = null;
    }

    public void write(DataOutput dataOutput) throws IOException {
        int n = this.offsets.length;
        dataOutput.writeInt(n);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                dataOutput.writeInt(this.offsets[i]);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FilePreprocessorConditionState filePreprocessorConditionState = (FilePreprocessorConditionState)object;
        return Arrays.equals(this.offsets, filePreprocessorConditionState.offsets);
    }

    public int hashCode() {
        int n = 5 + Arrays.hashCode(this.offsets);
        return n;
    }

    public String toString() {
        return FilePreprocessorConditionState.toStringBrief(this);
    }

    static String toStringBrief(FilePreprocessorConditionState filePreprocessorConditionState) {
        if (filePreprocessorConditionState == PARSING) {
            return ((Object)FilePreprocessorConditionState.PARSING.fileName).toString();
        }
        if (filePreprocessorConditionState == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i = 0; i < filePreprocessorConditionState.offsets.length; i += 2) {
            if (i > 0) {
                stringBuilder.append("][");
            }
            stringBuilder.append(filePreprocessorConditionState.offsets[i]);
            stringBuilder.append("-");
            stringBuilder.append(filePreprocessorConditionState.offsets[i + 1]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public boolean isInActiveBlock(int n, int n2) {
        if (this.offsets.length == 0 || n == 0) {
            return true;
        }
        for (int i = 0; i < this.offsets.length; i += 2) {
            int n3 = this.offsets[i];
            int n4 = this.offsets[i + 1];
            if (n3 <= n && n <= n4) {
                return false;
            }
            if (n3 > n2 || n2 > n4) continue;
            return false;
        }
        return true;
    }

    public final boolean isBetterOrEqual(FilePreprocessorConditionState filePreprocessorConditionState) {
        if (filePreprocessorConditionState == null) {
            return false;
        }
        if (this.offsets.length == 0) {
            return true;
        }
        if (filePreprocessorConditionState.offsets.length == 0) {
            return false;
        }
        for (int i = 0; i < this.offsets.length; i += 2) {
            int n = this.offsets[i];
            int n2 = this.offsets[i + 1];
            boolean bl = true;
            for (int j = 0; j < filePreprocessorConditionState.offsets.length; j += 2) {
                int n3 = filePreprocessorConditionState.offsets[j];
                int n4 = filePreprocessorConditionState.offsets[j + 1];
                if (n3 <= n && n2 <= n4) {
                    bl = false;
                } else if (n < n3 && n4 < n2) {
                    return false;
                }
                if (!bl || n2 < n3) break;
            }
            if (!bl) continue;
            return false;
        }
        return true;
    }

    public final List<CsmOffsetable> createBlocksForFile(CsmFile csmFile) {
        ArrayList<CsmOffsetable> arrayList = new ArrayList<CsmOffsetable>();
        for (int i = 0; i < this.offsets.length; i += 2) {
            arrayList.add(Utils.createOffsetable(csmFile, this.offsets[i], this.offsets[i + 1]));
        }
        return arrayList;
    }

    public static final class Builder
    implements APTParseFileWalker.EvalCallback {
        private final SortedSet<int[]> blocks = new TreeSet<int[]>(COMPARATOR);
        private final CharSequence name;
        private static final Comparator<int[]> COMPARATOR = new Comparator<int[]>(){

            @Override
            public int compare(int[] nArray, int[] nArray2) {
                return nArray[0] - nArray2[0];
            }
        };

        public Builder(CharSequence charSequence) {
            this.name = charSequence;
        }

        final Builder addBlockImpl(int n, int n2) {
            assert (n2 >= n) : "incorrect offsets " + n + " and " + n2;
            if (n2 > n) {
                this.blocks.add(new int[]{n, n2});
            }
            return this;
        }

        private void addDeadBlock(APT aPT, APT aPT2) {
            if (aPT != null && aPT2 != null) {
                int n = aPT.getEndOffset();
                int n2 = aPT2.getOffset() - 1;
                this.addBlockImpl(n, n2);
            }
        }

        @Override
        public void onStoppedDirective(APT aPT) {
            this.addBlockImpl(aPT.getToken().getOffset(), Integer.MAX_VALUE);
        }

        @Override
        public void onEval(APT aPT, boolean bl) {
            if (bl) {
                APT aPT2;
                APT aPT3 = aPT.getNextSibling();
                block7: while (aPT3 != null && (aPT2 = aPT3.getNextSibling()) != null) {
                    switch (aPT2.getType()) {
                        case 10: 
                        case 11: {
                            this.addDeadBlock(aPT3, aPT2);
                            aPT3 = aPT2;
                            continue block7;
                        }
                        case 12: {
                            this.addDeadBlock(aPT3, aPT2);
                            aPT3 = null;
                            continue block7;
                        }
                    }
                    aPT3 = null;
                }
            } else {
                APT aPT4 = aPT.getNextSibling();
                if (aPT4 != null) {
                    switch (aPT4.getType()) {
                        case 10: 
                        case 11: 
                        case 12: {
                            this.addDeadBlock(aPT, aPT4);
                        }
                    }
                }
            }
        }

        public FilePreprocessorConditionState build() {
            int n = 0;
            for (int[] nArray : this.blocks) {
                ++n;
                if (nArray[1] != Integer.MAX_VALUE) continue;
                break;
            }
            Object object = new int[n * 2];
            int n2 = 0;
            for (int[] nArray : this.blocks) {
                object[n2++] = nArray[0];
                object[n2++] = nArray[1];
                if (nArray[1] != Integer.MAX_VALUE) continue;
                break;
            }
            return Builder.build(this.name, (int[])object);
        }

        private static void checkConsistency(FilePreprocessorConditionState filePreprocessorConditionState) {
            for (int i = 0; i < filePreprocessorConditionState.offsets.length; ++i) {
                if (i + 1 >= filePreprocessorConditionState.offsets.length || filePreprocessorConditionState.offsets[i] < filePreprocessorConditionState.offsets[i + 1]) continue;
                CndUtils.assertTrue((boolean)false, (String)("inconsistent state " + filePreprocessorConditionState));
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.name != null) {
                stringBuilder.append(this.name);
            }
            stringBuilder.append("[");
            int n = 0;
            for (int[] nArray : this.blocks) {
                if (n++ > 0) {
                    stringBuilder.append("][");
                }
                stringBuilder.append(nArray[0]);
                stringBuilder.append("-");
                stringBuilder.append(nArray[1]);
                if (nArray[1] != Integer.MAX_VALUE) continue;
                break;
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        static FilePreprocessorConditionState build(CharSequence charSequence, int[] nArray) {
            FilePreprocessorConditionState filePreprocessorConditionState = new FilePreprocessorConditionState(charSequence, nArray);
            if (CndUtils.isDebugMode()) {
                Builder.checkConsistency(filePreprocessorConditionState);
            }
            return filePreprocessorConditionState;
        }

        static int[] getDeadBlocks(FilePreprocessorConditionState filePreprocessorConditionState) {
            return filePreprocessorConditionState.offsets;
        }
    }
}

