/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.UniqueNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.openide.util.CharSequences;

public abstract class DeclarationContainer
extends ProjectComponent
implements Persistent,
SelfPersistent {
    private final TreeMap<CharSequence, Object> declarations;
    private final ReadWriteLock declarationsLock = new ReentrantReadWriteLock();

    protected DeclarationContainer(Key key, boolean bl) {
        super(key, bl);
        this.declarations = new TreeMap(CharSequences.comparator());
    }

    protected DeclarationContainer(DataInput dataInput) throws IOException {
        super(dataInput);
        this.declarations = UIDObjectFactory.getDefaultFactory().readStringToArrayUIDMap(dataInput, UniqueNameCache.getManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CharSequence charSequence = CharSequences.create((CharSequence)csmOffsetableDeclaration.getUniqueName());
        CsmUID<CsmOffsetableDeclaration> csmUID = UIDCsmConverter.declarationToUID(csmOffsetableDeclaration);
        Object object = null;
        try {
            this.declarationsLock.writeLock().lock();
            object = this.declarations.get(charSequence);
            if (object instanceof CsmUID[]) {
                CsmUID[] csmUIDArray = (CsmUID[])object;
                int n = csmUIDArray.length;
                CsmUID csmUID2 = null;
                int n2 = n;
                for (int i = 0; i < n; ++i) {
                    CsmUID csmUID3 = csmUIDArray[i];
                    if (UIDUtilities.isSameFile((CsmUID<CsmOffsetableDeclaration>)csmUID3, csmUID)) {
                        csmUIDArray[i] = null;
                        --n2;
                        continue;
                    }
                    csmUID2 = csmUID3;
                }
                if (n2 == 0) {
                    this.declarations.remove(charSequence);
                } else if (n2 == 1) {
                    this.declarations.put(charSequence, csmUID2);
                } else {
                    CsmUID[] csmUIDArray2 = new CsmUID[n2];
                    n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        CsmUID csmUID4 = csmUIDArray[i];
                        if (csmUID4 == null) continue;
                        csmUIDArray2[n2] = csmUID4;
                        ++n2;
                    }
                    this.declarations.put(charSequence, csmUIDArray2);
                }
            } else if (object instanceof CsmUID) {
                this.declarations.remove(charSequence);
            }
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        this.onRemoveDeclaration(csmOffsetableDeclaration);
        this.put();
    }

    protected void onRemoveDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
    }

    protected ReadWriteLock getLock() {
        return this.declarationsLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        Object object;
        CharSequence charSequence = UniqueNameCache.getManager().getString(csmOffsetableDeclaration.getUniqueName());
        CsmUID<CsmOffsetableDeclaration> csmUID = RepositoryUtils.put(csmOffsetableDeclaration);
        assert (csmUID != null);
        if (!(csmUID instanceof SelfPersistent)) {
            object = " [" + csmOffsetableDeclaration.getStartPosition().getLine() + ":" + csmOffsetableDeclaration.getStartPosition().getColumn() + "-" + csmOffsetableDeclaration.getEndPosition().getLine() + ":" + csmOffsetableDeclaration.getEndPosition().getColumn() + "]";
            new Exception("attempt to put local declaration " + csmOffsetableDeclaration + (String)object).printStackTrace();
        }
        try {
            this.declarationsLock.writeLock().lock();
            object = this.declarations.get(charSequence);
            if (object instanceof CsmUID[]) {
                CsmUID[] csmUIDArray = (CsmUID[])object;
                boolean bl = false;
                for (int i = 0; i < csmUIDArray.length; ++i) {
                    if (!UIDUtilities.isSameFile((CsmUID<CsmOffsetableDeclaration>)csmUIDArray[i], csmUID)) continue;
                    csmUIDArray[i] = csmUID;
                    bl = true;
                    break;
                }
                if (!bl) {
                    CsmUID[] csmUIDArray2 = new CsmUID[csmUIDArray.length + 1];
                    csmUIDArray2[0] = csmUID;
                    System.arraycopy(csmUIDArray, 0, csmUIDArray2, 1, csmUIDArray.length);
                    this.declarations.put(charSequence, csmUIDArray2);
                }
            } else if (object instanceof CsmUID) {
                CsmUID csmUID2 = (CsmUID)object;
                if (UIDUtilities.isSameFile((CsmUID<CsmOffsetableDeclaration>)csmUID2, csmUID)) {
                    this.declarations.put(charSequence, csmUID);
                } else {
                    CsmUID[] csmUIDArray = new CsmUID[]{csmUID, csmUID2};
                    this.declarations.put(charSequence, csmUIDArray);
                }
            } else {
                this.declarations.put(charSequence, csmUID);
            }
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        this.onPutDeclaration(csmOffsetableDeclaration);
        this.put();
    }

    protected void onPutDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getUIDsRange(CharSequence charSequence, CharSequence charSequence2) {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> arrayList = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        charSequence = CharSequences.create((CharSequence)charSequence);
        charSequence2 = CharSequences.create((CharSequence)charSequence2);
        try {
            this.declarationsLock.readLock().lock();
            for (Map.Entry<CharSequence, Object> entry : this.declarations.subMap(charSequence, charSequence2).entrySet()) {
                DeclarationContainer.addAll(arrayList, entry.getValue());
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getUIDsFQN(CharSequence charSequence, CsmDeclaration.Kind[] kindArray) {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> arrayList = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        char c = '\u00ff';
        for (CsmDeclaration.Kind kind : kindArray) {
            String string = Utils.getCsmDeclarationKindkey(kind) + ':' + charSequence;
            CharSequence charSequence2 = CharSequences.create((CharSequence)string);
            CharSequence charSequence3 = CharSequences.create((CharSequence)(string + c));
            try {
                this.declarationsLock.readLock().lock();
                for (Map.Entry<CharSequence, Object> entry : this.declarations.subMap(charSequence2, charSequence3).entrySet()) {
                    DeclarationContainer.addAll(arrayList, entry.getValue());
                }
            }
            finally {
                this.declarationsLock.readLock().unlock();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SortedMap<CharSequence, Object> testDeclarations() {
        try {
            this.declarationsLock.readLock().lock();
            TreeMap<CharSequence, Object> treeMap = new TreeMap<CharSequence, Object>((SortedMap<CharSequence, Object>)this.declarations);
            return treeMap;
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
    }

    private static void addAll(Collection<CsmUID<CsmOffsetableDeclaration>> collection, Object object) {
        if (object instanceof CsmUID[]) {
            CsmUID[] csmUIDArray = (CsmUID[])object;
            collection.addAll(Arrays.asList(csmUIDArray));
        } else if (object instanceof CsmUID) {
            CsmUID csmUID = (CsmUID)object;
            collection.add((CsmUID<CsmOffsetableDeclaration>)csmUID);
        }
    }

    public Collection<CsmOffsetableDeclaration> getDeclarationsRange(CharSequence charSequence, CharSequence charSequence2) {
        return UIDCsmConverter.UIDsToDeclarations(this.getUIDsRange(charSequence, charSequence2));
    }

    public Collection<CsmOffsetableDeclaration> getDeclarationsRange(CharSequence charSequence, CsmDeclaration.Kind[] kindArray) {
        return UIDCsmConverter.UIDsToDeclarations(this.getUIDsFQN(charSequence, kindArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getDeclarationsUIDs() {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> arrayList = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        try {
            this.declarationsLock.readLock().lock();
            for (Object object : this.declarations.values()) {
                DeclarationContainer.addAll(arrayList, object);
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmOffsetableDeclaration> findDeclarations(CharSequence charSequence) {
        ArrayList arrayList = new ArrayList();
        charSequence = CharSequences.create((CharSequence)charSequence);
        try {
            this.declarationsLock.readLock().lock();
            DeclarationContainer.addAll(arrayList, this.declarations.get(charSequence));
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return UIDCsmConverter.UIDsToDeclarations(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmDeclaration getDeclaration(CharSequence charSequence) {
        CsmUID csmUID = null;
        charSequence = CharSequences.create((CharSequence)charSequence);
        try {
            this.declarationsLock.readLock().lock();
            Object object = this.declarations.get(charSequence);
            if (object instanceof CsmUID[]) {
                CsmUID[] csmUIDArray = (CsmUID[])object;
                csmUID = csmUIDArray[0];
            } else if (object instanceof CsmUID) {
                CsmUID csmUID2;
                csmUID = csmUID2 = (CsmUID)object;
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        Object t = UIDCsmConverter.UIDtoDeclaration(csmUID);
        if (csmUID != null && t == null) {
            DiagnosticExceptoins.register(new IllegalStateException("no declaration for UID " + csmUID));
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDeclarations() {
        try {
            this.declarationsLock.writeLock().lock();
            this.declarations.clear();
            this.put();
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        try {
            this.declarationsLock.readLock().lock();
            UIDObjectFactory.getDefaultFactory().writeStringToArrayUIDMap(this.declarations, dataOutput, false);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
    }
}

