/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.File;
import java.io.PrintWriter;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.api.project.DefaultSystemSettings;
import org.netbeans.modules.cnd.api.project.NativeExitStatus;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.trace.NativeProjectProvider;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class CsmStandaloneFileProviderImpl
extends CsmStandaloneFileProvider {
    private static final boolean TRACE = Boolean.getBoolean("cnd.standalone.trace");
    private static final Lock lock = new Lock();
    private static final Set<String> toBeRmoved = new HashSet<String>();
    private final CsmModelListener listener = new CsmModelListener(){

        public void projectOpened(CsmProject csmProject) {
        }

        public void projectClosed(CsmProject csmProject) {
        }

        public void modelChanged(CsmChangeEvent csmChangeEvent) {
            for (CsmFile csmFile : csmChangeEvent.getNewFiles()) {
                CsmStandaloneFileProviderImpl.this.clean(csmFile);
            }
            for (CsmFile csmFile : csmChangeEvent.getRemovedFiles()) {
                CsmStandaloneFileProviderImpl.this.onFileRemove(csmFile);
            }
        }
    };
    private final CsmProgressListener progressListener = new CsmProgressAdapter(){

        public void projectLoaded(CsmProject csmProject) {
            CsmStandaloneFileProviderImpl.this.clean((ProjectBase)csmProject);
        }

        public void projectParsingFinished(CsmProject csmProject) {
        }
    };

    public CsmStandaloneFileProviderImpl() {
        CsmListeners.getDefault().addModelListener(this.listener);
        CsmListeners.getDefault().addProgressListener(this.progressListener);
    }

    static CsmStandaloneFileProviderImpl getDefaultImpl() {
        return (CsmStandaloneFileProviderImpl)CsmStandaloneFileProvider.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmFile getCsmFile(FileObject fileObject) {
        if (fileObject == null || !fileObject.isValid() || !CsmUtilities.isCsmSuitable((FileObject)fileObject)) {
            return null;
        }
        CsmModelState csmModelState = CsmModelAccessor.getModelState();
        if (csmModelState != CsmModelState.ON) {
            if (TRACE) {
                CsmStandaloneFileProviderImpl.trace("model is %s, no extra work for %s", csmModelState, fileObject.getPath());
            }
            return null;
        }
        File file = CndFileUtils.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        String string = CndFileUtils.normalizePath((FileObject)fileObject);
        ProjectBase projectBase = null;
        Object object = this;
        synchronized (object) {
            CsmFile csmFile = ModelImpl.instance().findFile(string, true, false);
            if (csmFile != null) {
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("returns file %s", csmFile);
                }
                return csmFile;
            }
            Lock lock = CsmStandaloneFileProviderImpl.lock;
            synchronized (lock) {
                if (toBeRmoved.contains(string)) {
                    return null;
                }
                NativeProject nativeProject = NativeProjectImpl.getNativeProjectImpl(fileObject);
                if (nativeProject != null) {
                    projectBase = ModelImpl.instance().addProject(nativeProject, string, true);
                    if (TRACE) {
                        CsmStandaloneFileProviderImpl.trace("added project %s", projectBase);
                    }
                    if (projectBase != null) {
                        projectBase.ensureFilesCreated();
                    }
                }
            }
        }
        if (projectBase != null && projectBase.isValid()) {
            try {
                object = projectBase.getFile(string, false);
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("RETURNS STANALONE FILE %s", object);
                }
                return object;
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                DiagnosticExceptoins.register(bufferUnderflowException);
            }
            catch (IllegalStateException illegalStateException) {
                DiagnosticExceptoins.register(illegalStateException);
            }
        }
        return null;
    }

    private void clean(ProjectBase projectBase) {
        if (projectBase.getPlatformProject() instanceof NativeProjectImpl) {
            return;
        }
        if (TRACE) {
            CsmStandaloneFileProviderImpl.trace("checking project %s", projectBase.toString());
        }
        for (CsmProject csmProject : ModelImpl.instance().projects()) {
            if (!(csmProject.getPlatformProject() instanceof NativeProjectImpl)) continue;
            for (CsmFile csmFile : csmProject.getAllFiles()) {
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("\nchecking file %s", csmFile.getAbsolutePath());
                }
                if (projectBase.getFile(((FileImpl)csmFile).getAbsolutePath(), false) == null) continue;
                this.scheduleProjectRemoval(csmProject);
            }
        }
    }

    private void clean(CsmFile csmFile) {
        if (!(csmFile.getProject().getPlatformProject() instanceof NativeProjectImpl)) {
            this.notifyClosed(csmFile);
        }
    }

    void onFileRemove(CsmFile csmFile) {
        FileObject fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
        if (fileObject != null && this.isOpen(fileObject)) {
            this.getCsmFile(fileObject);
        }
    }

    private boolean isOpen(FileObject fileObject) {
        try {
            EditorCookie editorCookie;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
                return CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)editorCookie) != null;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public synchronized void notifyClosed(CsmFile csmFile) {
        String string = ((Object)csmFile.getAbsolutePath()).toString();
        for (CsmProject csmProject : ModelImpl.instance().projects()) {
            NativeProjectImpl nativeProjectImpl;
            Object object = csmProject.getPlatformProject();
            if (!(object instanceof NativeProjectImpl) || !(nativeProjectImpl = (NativeProjectImpl)object).getProjectRoot().equals(string)) continue;
            for (CsmFile csmFile2 : csmProject.getAllFiles()) {
                NativeFileItemSet nativeFileItemSet;
                FileObject fileObject = ((FileImpl)csmFile2).getFileObject();
                DataObject dataObject = NativeProjectProvider.getDataObject(fileObject);
                if (dataObject == null || (nativeFileItemSet = (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class)) == null) continue;
                nativeFileItemSet.remove((NativeFileItem)nativeProjectImpl.findFileItem(fileObject));
            }
            this.scheduleProjectRemoval(csmProject);
        }
    }

    public boolean isStandalone(CsmFile csmFile) {
        NativeFileItem nativeFileItem;
        return csmFile instanceof FileImpl && (nativeFileItem = ((FileImpl)csmFile).getNativeFileItem()) instanceof NativeFileItemImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleProjectRemoval(final CsmProject csmProject) {
        final String string = ((NativeProject)csmProject.getPlatformProject()).getProjectRoot();
        if (TRACE) {
            CsmStandaloneFileProviderImpl.trace("schedulling removal %s", csmProject.toString());
        }
        Lock lock = CsmStandaloneFileProviderImpl.lock;
        synchronized (lock) {
            toBeRmoved.add(string);
        }
        ModelImpl.instance().enqueueModelTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (csmProject.isValid()) {
                    if (TRACE) {
                        CsmStandaloneFileProviderImpl.trace("removing %s", new Object[]{csmProject.toString()});
                    }
                    ProjectBase projectBase = (ProjectBase)csmProject;
                    ModelImpl.instance().closeProjectBase(projectBase, false);
                    Lock lock = lock;
                    synchronized (lock) {
                        toBeRmoved.remove(string);
                    }
                    if (TRACE) {
                        CsmStandaloneFileProviderImpl.trace("removed %s", new Object[]{csmProject.toString()});
                    }
                }
            }
        }, "Standalone project removal.");
    }

    private static void trace(String string, Object ... objectArray) {
        assert (TRACE) : "Should not be called if TRACE is off!";
        System.err.printf("### Standalone provider:  %s\n", String.format(string, objectArray));
    }

    public void dumpInfo(PrintWriter printWriter) {
        printWriter.printf("SAProvider %s has toBeRemoved=%d entries\n", ((Object)((Object)this)).getClass().getSimpleName(), toBeRmoved.size());
        int n = 1;
        for (String string : toBeRmoved) {
            printWriter.printf("[%d] %s\n", n++, string);
        }
    }

    private static final class NativeFileItemImpl
    implements NativeFileItem {
        private final FileObject fileObject;
        private final NativeProjectImpl project;
        private final NativeFileItem.Language lang;

        public NativeFileItemImpl(FileObject fileObject, NativeProjectImpl nativeProjectImpl, NativeFileItem.Language language) {
            this.project = nativeProjectImpl;
            this.fileObject = fileObject;
            this.lang = language;
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public String getAbsolutePath() {
            return CndFileUtils.normalizePath((FileObject)this.fileObject);
        }

        public String getName() {
            return this.fileObject.getNameExt();
        }

        public List<FSPath> getSystemIncludePaths() {
            List<FSPath> list = this.project.getSystemIncludePaths();
            this.checkAbsolute(list);
            return list;
        }

        public List<FSPath> getUserIncludePaths() {
            List<FSPath> list = this.project.getUserIncludePaths();
            this.checkAbsolute(list);
            return list;
        }

        private void checkAbsolute(List<FSPath> list) {
            ArrayList arrayList = new ArrayList(list.size());
            for (FSPath fSPath : list) {
                CndUtils.assertAbsolutePathInConsole((String)fSPath.getPath());
            }
        }

        public List<String> getSystemMacroDefinitions() {
            return this.project.getSystemMacroDefinitions();
        }

        public List<String> getUserMacroDefinitions() {
            return this.project.getUserMacroDefinitions();
        }

        public NativeFileItem.Language getLanguage() {
            return this.lang;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return NativeFileItem.LanguageFlavor.UNKNOWN;
        }

        public boolean isExcluded() {
            return false;
        }

        public String toString() {
            return "SA " + this.fileObject + " " + System.identityHashCode(this) + " " + this.lang + " from project:" + this.project;
        }
    }

    private static final class NativeProjectImpl
    implements NativeProject {
        private final List<FSPath> sysIncludes;
        private final List<FSPath> usrIncludes;
        private final List<String> sysMacros;
        private final List<String> usrMacros;
        private final List<NativeFileItemImpl> files = new ArrayList<NativeFileItemImpl>();
        private final FileObject projectRoot;
        private final FileSystem fileSystem;
        private List<NativeProjectItemsListener> listeners = new ArrayList<NativeProjectItemsListener>();
        private final Object listenersLock = new Lock();

        static NativeProject getNativeProjectImpl(FileObject fileObject) {
            FileSystem fileSystem;
            Object object2;
            DataObject dataObject = NativeProjectProvider.getDataObject(fileObject);
            if (dataObject == null) {
                return null;
            }
            NativeFileItemSet nativeFileItemSet = (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class);
            if (nativeFileItemSet == null || !nativeFileItemSet.isEmpty()) {
                return null;
            }
            ModelImpl modelImpl = ModelImpl.instance();
            ArrayList<FSPath> arrayList = new ArrayList<FSPath>();
            ArrayList<FSPath> arrayList2 = new ArrayList<FSPath>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            NativeFileItem.Language language = NativeProjectProvider.getLanguage(fileObject, dataObject);
            NativeProject nativeProject = null;
            for (Object object2 : modelImpl.projects()) {
                Object object3 = object2.getPlatformProject();
                if (!(object3 instanceof NativeProject)) continue;
                NativeProject nativeProject2 = (NativeProject)object3;
                if (fileObject.getPath().startsWith(nativeProject2.getProjectRoot())) {
                    nativeProject = nativeProject2;
                    break;
                }
                for (String string : nativeProject2.getSourceRoots()) {
                    if (!fileObject.getPath().startsWith(string)) continue;
                    nativeProject = nativeProject2;
                    break;
                }
                if (nativeProject == null) continue;
                break;
            }
            try {
                fileSystem = fileObject.getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                fileSystem = CndFileUtils.getLocalFileSystem();
            }
            if (nativeProject == null) {
                arrayList.addAll(CndFileUtils.toFSPathList((FileSystem)fileSystem, (Collection)DefaultSystemSettings.getDefault().getSystemIncludes(language)));
                arrayList3.addAll(DefaultSystemSettings.getDefault().getSystemMacros(language));
            } else {
                if (ModelImpl.instance().isProjectDiabled(nativeProject)) {
                    return null;
                }
                arrayList.addAll(nativeProject.getSystemIncludePaths());
                arrayList3.addAll(nativeProject.getSystemMacroDefinitions());
                arrayList2.addAll(nativeProject.getUserIncludePaths());
                arrayList4.addAll(nativeProject.getUserMacroDefinitions());
            }
            object2 = new NativeProjectImpl(fileObject, arrayList, arrayList2, arrayList3, arrayList4);
            super.addFile(fileObject);
            nativeFileItemSet.add((NativeFileItem)((NativeProjectImpl)object2).findFileItem(fileObject));
            return object2;
        }

        private NativeProjectImpl(FileObject fileObject, List<FSPath> list, List<FSPath> list2, List<String> list3, List<String> list4) {
            this.projectRoot = fileObject;
            this.fileSystem = NativeProjectImpl.getFileSystem(fileObject);
            this.sysIncludes = this.createIncludes(list);
            this.usrIncludes = this.createIncludes(list2);
            this.sysMacros = new ArrayList<String>(list3);
            this.usrMacros = new ArrayList<String>(list4);
        }

        private static FileSystem getFileSystem(FileObject fileObject) {
            try {
                return fileObject.getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                return CndFileUtils.getLocalFileSystem();
            }
        }

        private List<FSPath> createIncludes(List<FSPath> list) {
            ArrayList<FSPath> arrayList = new ArrayList<FSPath>(list.size());
            for (FSPath fSPath : list) {
                if (CndPathUtilitities.isPathAbsolute((CharSequence)fSPath.getPath())) {
                    arrayList.add(fSPath);
                    continue;
                }
                CndUtils.assertTrueInConsole((boolean)false, (String)"Can not maconvert ");
            }
            return arrayList;
        }

        private void addFile(FileObject fileObject) {
            DataObject dataObject = NativeProjectProvider.getDataObject(fileObject);
            NativeFileItem.Language language = NativeProjectProvider.getLanguage(fileObject, dataObject);
            NativeFileItemImpl nativeFileItemImpl = new NativeFileItemImpl(fileObject, this, language);
            this.files.add(nativeFileItemImpl);
        }

        public Lookup.Provider getProject() {
            return null;
        }

        public List<String> getSourceRoots() {
            return Collections.emptyList();
        }

        public String getProjectRoot() {
            return this.projectRoot.getPath();
        }

        public FileSystem getFileSystem() {
            try {
                return this.projectRoot.getFileSystem();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                return CndFileUtils.getLocalFileSystem();
            }
        }

        public String getProjectDisplayName() {
            return this.getProjectRoot();
        }

        public List<NativeFileItem> getAllFiles() {
            return Collections.unmodifiableList(this.files);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectItemsListener(NativeProjectItemsListener nativeProjectItemsListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.add(nativeProjectItemsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProjectItemsListener(NativeProjectItemsListener nativeProjectItemsListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.remove(nativeProjectItemsListener);
            }
        }

        public NativeFileItemImpl findFileItem(FileObject fileObject) {
            for (NativeFileItemImpl nativeFileItemImpl : this.files) {
                if (!nativeFileItemImpl.getFileObject().equals(fileObject)) continue;
                return nativeFileItemImpl;
            }
            return null;
        }

        public NativeFileSearch getNativeFileSearch() {
            return new NativeFileSearch(){

                public Collection<CharSequence> searchFile(NativeProject nativeProject, String string) {
                    return Collections.emptyList();
                }
            };
        }

        public List<FSPath> getSystemIncludePaths() {
            return this.sysIncludes;
        }

        public List<FSPath> getUserIncludePaths() {
            return this.usrIncludes;
        }

        public List<String> getSystemMacroDefinitions() {
            return this.sysMacros;
        }

        public List<String> getUserMacroDefinitions() {
            return this.usrMacros;
        }

        public List<NativeProject> getDependences() {
            return Collections.emptyList();
        }

        public void runOnProjectReadiness(NamedRunnable namedRunnable) {
            namedRunnable.run();
        }

        public NativeExitStatus execute(String string, String[] stringArray, String ... stringArray2) {
            return null;
        }

        public String getPlatformName() {
            return null;
        }

        public final String toString() {
            return "SA " + this.projectRoot + ' ' + this.getClass().getName() + " @" + this.hashCode() + ":" + System.identityHashCode(this);
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

