/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Line2Offset;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;

public abstract class AbstractFileBuffer
implements FileBuffer {
    private final CharSequence absPath;
    private final FileSystem fileSystem;
    private Reference<Line2Offset> lines = new WeakReference<Object>(null);

    protected AbstractFileBuffer(FileObject fileObject) {
        this.absPath = FilePathCache.getManager().getString((CharSequence)CndFileUtils.normalizePath((FileObject)fileObject));
        this.fileSystem = AbstractFileBuffer.getFileSystem(fileObject);
    }

    protected final String getEncoding() {
        FileObject fileObject = this.getFileObject();
        Charset charset = null;
        if (fileObject != null && fileObject.isValid()) {
            charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        }
        if (charset == null) {
            charset = FileEncodingQuery.getDefaultEncoding();
        }
        return charset.name();
    }

    private static FileSystem getFileSystem(FileObject fileObject) {
        try {
            return fileObject.getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            return InvalidFileObjectSupport.getDummyFileSystem();
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
    }

    public CharSequence getAbsolutePath() {
        return this.absPath;
    }

    @Override
    public CharSequence getUrl() {
        return CndFileSystemProvider.toUrl((FileSystem)this.fileSystem, (CharSequence)this.absPath);
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public FileObject getFileObject() {
        FileObject fileObject = CndFileUtils.toFileObject((FileSystem)this.fileSystem, (CharSequence)this.absPath);
        if (fileObject == null) {
            fileObject = InvalidFileObjectSupport.getInvalidFileObject((FileSystem)this.fileSystem, (CharSequence)this.absPath);
        }
        return fileObject;
    }

    public final void write(DataOutput dataOutput) throws IOException {
        assert (this.absPath != null);
        PersistentUtils.writeUTF(this.absPath, dataOutput);
        PersistentUtils.writeFileSystem(this.fileSystem, dataOutput);
    }

    protected AbstractFileBuffer(DataInput dataInput) throws IOException {
        this.absPath = PersistentUtils.readUTF(dataInput, FilePathCache.getManager());
        this.fileSystem = PersistentUtils.readFileSystem(dataInput);
        assert (this.absPath != null);
    }

    @Override
    public int[] getLineColumnByOffset(int n) throws IOException {
        return this.getLine2Offset().getLineColumnByOffset(n);
    }

    @Override
    public int getOffsetByLineColumn(int n, int n2) throws IOException {
        return this.getLine2Offset().getOffsetByLineColumn(n, n2);
    }

    private Line2Offset getLine2Offset() throws IOException {
        Line2Offset line2Offset = null;
        Reference<Line2Offset> reference = this.lines;
        if (reference != null) {
            line2Offset = reference.get();
        }
        if (line2Offset == null) {
            line2Offset = new Line2Offset(this.getCharBuffer());
            this.lines = new WeakReference<Line2Offset>(line2Offset);
        }
        return line2Offset;
    }

    protected void clearLineCache() {
        Reference<Line2Offset> reference = this.lines;
        if (reference != null) {
            reference.clear();
        }
    }
}

