/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifierBasedTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.openide.util.CharSequences;

public final class TemplateParameterImpl<T>
extends OffsetableDeclarationBase<T>
implements CsmClassifierBasedTemplateParameter,
CsmTemplate,
SelfPersistent {
    private final CharSequence name;
    private CsmUID<CsmScope> scope;
    private CsmType defaultValue = null;
    private TemplateDescriptor templateDescriptor = null;

    public TemplateParameterImpl(AST aST, CharSequence charSequence, CsmFile csmFile, CsmScope csmScope, boolean bl) {
        super(aST, csmFile);
        this.name = NameCache.getManager().getString(charSequence);
        this.templateDescriptor = TemplateDescriptor.createIfNeeded(aST, csmFile, csmScope, bl);
        if (csmScope instanceof CsmIdentifiable) {
            this.scope = UIDCsmConverter.scopeToUID(csmScope);
        }
    }

    public TemplateParameterImpl(AST aST, CharSequence charSequence, CsmFile csmFile, CsmScope csmScope, boolean bl, AST aST2) {
        this(aST, charSequence, csmFile, csmScope, bl);
        this.defaultValue = TypeFactory.createType(aST2, csmFile, null, 0);
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmObject getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof TemplateParameterImpl && this.getName().equals(((TemplateParameterImpl)object).getName())) {
            if (this.scope != null) {
                return this.scope.equals(((TemplateParameterImpl)object).scope);
            }
            return ((TemplateParameterImpl)object).scope == null;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public boolean isSpecialization() {
        return false;
    }

    public boolean isExplicitSpecialization() {
        return false;
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequences.create((CharSequence)(((Object)this.getName()).toString() + this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        PersistentUtils.writeUTF(this.name, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scope, dataOutput);
        PersistentUtils.writeType(this.defaultValue, dataOutput);
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, dataOutput);
    }

    public TemplateParameterImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        this.scope = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.defaultValue = PersistentUtils.readType(dataInput);
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(dataInput);
    }

    public CsmScope getScope() {
        return this.scope == null ? null : (CsmScope)this.scope.getObject();
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.TEMPLATE_PARAMETER;
    }

    public CharSequence getQualifiedName() {
        CsmScope csmScope = this.getScope();
        if (CsmKindUtilities.isFunction((CsmObject)csmScope)) {
            return CharSequences.create((CharSequence)(((CsmFunction)csmScope).getQualifiedName() + "::" + this.name));
        }
        if (CsmKindUtilities.isClass((CsmObject)csmScope)) {
            return CharSequences.create((CharSequence)(((CsmClass)csmScope).getQualifiedName() + "::" + this.name));
        }
        return this.name;
    }

    @Override
    public String toString() {
        return ((Object)this.getQualifiedName()).toString() + this.getPositionString();
    }
}

