/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeclarationContainerNamespace;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.openide.util.CharSequences;

public class NamespaceImpl
implements CsmNamespace,
MutableDeclarationsContainer,
Persistent,
SelfPersistent,
Disposable,
CsmIdentifiable {
    private static final CharSequence GLOBAL = CharSequences.create((CharSequence)"$Global$");
    private Object projectRef;
    private final CsmUID<CsmProject> projectUID;
    private CsmNamespace parentRef;
    private final CsmUID<CsmNamespace> parentUID;
    private final CharSequence name;
    private final CharSequence qualifiedName;
    private final Map<CharSequence, CsmUID<CsmNamespace>> nestedNamespaces;
    private final Key declarationsSorageKey;
    private final Set<CsmUID<CsmOffsetableDeclaration>> unnamedDeclarations;
    private final TreeMap<FileNameSortedKey, CsmUID<CsmNamespaceDefinition>> nsDefinitions;
    private final ReadWriteLock nsDefinitionsLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock projectLock = new ReentrantReadWriteLock();
    private final boolean global;
    private static final boolean CHECK_PARENT = false;
    private static final String UNNAMED_PREFIX = "<unnamed>";
    private Set<Integer> unnamedNrs = new HashSet<Integer>();
    private WeakReference<DeclarationContainerNamespace> weakDeclarationContainer = TraceFlags.USE_WEAK_MEMORY_CACHE ? new WeakReference<Object>(null) : null;
    private int preventMultiplyDiagnosticExceptions = 0;
    private CsmUID<CsmNamespace> uid = null;
    public static final Comparator<FileNameSortedKey> defenitionComparator = new Comparator<FileNameSortedKey>(){

        @Override
        public int compare(FileNameSortedKey fileNameSortedKey, FileNameSortedKey fileNameSortedKey2) {
            return fileNameSortedKey.compareTo(fileNameSortedKey2);
        }
    };

    private NamespaceImpl(ProjectBase projectBase, boolean bl) {
        this.name = GLOBAL;
        this.qualifiedName = CharSequences.empty();
        this.parentUID = null;
        this.parentRef = null;
        this.global = true;
        assert (projectBase != null);
        this.projectUID = UIDCsmConverter.projectToUID(projectBase);
        assert (this.projectUID != null);
        this.unnamedDeclarations = Collections.synchronizedSet(new HashSet());
        this.nestedNamespaces = new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>();
        this.nsDefinitions = new TreeMap(defenitionComparator);
        this.projectRef = new WeakReference<ProjectBase>(projectBase);
        this.declarationsSorageKey = bl ? null : new DeclarationContainerNamespace(this).getKey();
    }

    public static NamespaceImpl create(ProjectBase projectBase, boolean bl) {
        NamespaceImpl namespaceImpl = new NamespaceImpl(projectBase, bl);
        if (!bl) {
            projectBase.registerNamespace(namespaceImpl);
        }
        return namespaceImpl;
    }

    protected NamespaceImpl(ProjectBase projectBase, NamespaceImpl namespaceImpl, String string, String string2) {
        this.name = NameCache.getManager().getString((CharSequence)string);
        this.global = false;
        assert (projectBase != null);
        this.projectUID = UIDCsmConverter.projectToUID(projectBase);
        assert (this.projectUID != null);
        this.unnamedDeclarations = Collections.synchronizedSet(new HashSet());
        this.nestedNamespaces = new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>();
        this.nsDefinitions = new TreeMap(defenitionComparator);
        this.projectRef = new WeakReference<ProjectBase>(projectBase);
        this.qualifiedName = QualifiedNameCache.getManager().getString((CharSequence)string2);
        this.parentUID = UIDCsmConverter.namespaceToUID(namespaceImpl);
        assert (this.parentUID != null || namespaceImpl == null);
        this.parentRef = null;
        this.declarationsSorageKey = new DeclarationContainerNamespace(this).getKey();
    }

    public static NamespaceImpl create(ProjectBase projectBase, NamespaceImpl namespaceImpl, String string, String string2) {
        NamespaceImpl namespaceImpl2 = new NamespaceImpl(projectBase, namespaceImpl, string, string2);
        projectBase.registerNamespace(namespaceImpl2);
        if (namespaceImpl != null) {
            namespaceImpl.addNestedNamespace(namespaceImpl2);
        }
        namespaceImpl2.notify(namespaceImpl2, NotifyEvent.NAMESPACE_ADDED);
        return namespaceImpl2;
    }

    protected void notify(CsmObject csmObject, NotifyEvent notifyEvent) {
        switch (notifyEvent) {
            case DECLARATION_ADDED: {
                assert (csmObject instanceof CsmOffsetableDeclaration);
                if (ForwardClass.isForwardClass((CsmDeclaration)((CsmOffsetableDeclaration)csmObject))) break;
                Notificator.instance().registerNewDeclaration((CsmOffsetableDeclaration)csmObject);
                break;
            }
            case DECLARATION_REMOVED: {
                assert (csmObject instanceof CsmOffsetableDeclaration);
                if (ForwardClass.isForwardClass((CsmDeclaration)((CsmOffsetableDeclaration)csmObject))) break;
                Notificator.instance().registerRemovedDeclaration((CsmOffsetableDeclaration)csmObject);
                break;
            }
            case NAMESPACE_ADDED: {
                assert (csmObject instanceof CsmNamespace);
                assert (!((CsmNamespace)csmObject).isGlobal());
                Notificator.instance().registerNewNamespace((CsmNamespace)csmObject);
                break;
            }
            case NAMESPACE_REMOVED: {
                assert (csmObject instanceof CsmNamespace);
                assert (!((CsmNamespace)csmObject).isGlobal());
                Notificator.instance().registerRemovedNamespace((CsmNamespace)csmObject);
                break;
            }
            default: {
                throw new IllegalArgumentException("unexpected kind " + (Object)((Object)notifyEvent));
            }
        }
    }

    @Override
    public void dispose() {
        this.onDispose();
        this.notify(this, NotifyEvent.NAMESPACE_REMOVED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDispose() {
        this.projectLock.writeLock().lock();
        try {
            if (this.projectRef == null) {
                this.projectRef = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
                assert (this.projectRef != null || this.projectUID == null) : "no object for UID " + this.projectUID;
            }
            if (this.parentRef == null) {
                this.parentRef = UIDCsmConverter.UIDtoNamespace(this.parentUID);
                assert (this.parentRef != null || this.parentUID == null) : "no object for UID " + this.parentUID;
            }
        }
        finally {
            this.projectLock.writeLock().unlock();
        }
        this.weakDeclarationContainer = null;
    }

    public String getNameForUnnamedElement() {
        String string = UNNAMED_PREFIX;
        int n = this.getMinUnnamedValue();
        if (n != 0) {
            string = string + n;
        }
        this.unnamedNrs.add(n);
        return string;
    }

    private int getMinUnnamedValue() {
        for (int i = 0; i < this.unnamedNrs.size(); ++i) {
            if (this.unnamedNrs.contains(i)) continue;
            return i;
        }
        return this.unnamedNrs.size();
    }

    public CsmNamespace getParent() {
        return this._getParentNamespace();
    }

    public Collection<CsmNamespace> getNestedNamespaces() {
        Collection<CsmNamespace> collection = UIDCsmConverter.UIDsToNamespaces(new ArrayList(this.nestedNamespaces.values()));
        return collection;
    }

    private DeclarationContainerNamespace getDeclarationsSorage() {
        if (this.declarationsSorageKey == null) {
            return DeclarationContainerNamespace.empty();
        }
        DeclarationContainerNamespace declarationContainerNamespace = null;
        WeakReference<DeclarationContainerNamespace> weakReference = null;
        if (TraceFlags.USE_WEAK_MEMORY_CACHE && (weakReference = this.weakDeclarationContainer) != null && (declarationContainerNamespace = (DeclarationContainerNamespace)weakReference.get()) != null) {
            return declarationContainerNamespace;
        }
        declarationContainerNamespace = (DeclarationContainerNamespace)RepositoryUtils.get(this.declarationsSorageKey);
        if (declarationContainerNamespace == null && this.preventMultiplyDiagnosticExceptions < 3) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get DeclarationsSorage by key " + this.declarationsSorageKey));
            ++this.preventMultiplyDiagnosticExceptions;
        }
        if (TraceFlags.USE_WEAK_MEMORY_CACHE && declarationContainerNamespace != null && this.weakDeclarationContainer != null) {
            this.weakDeclarationContainer = new WeakReference<DeclarationContainerNamespace>(declarationContainerNamespace);
        }
        return declarationContainerNamespace != null ? declarationContainerNamespace : DeclarationContainerNamespace.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        DeclarationContainerNamespace declarationContainerNamespace = this.getDeclarationsSorage();
        Collection collection = declarationContainerNamespace.getDeclarationsUIDs();
        Collection<Object> collection2 = this.unnamedDeclarations;
        synchronized (collection2) {
            collection.addAll(this.unnamedDeclarations);
        }
        collection2 = UIDCsmConverter.UIDsToDeclarations(collection);
        return collection2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmSelect.CsmFilter csmFilter) {
        DeclarationContainerNamespace declarationContainerNamespace = this.getDeclarationsSorage();
        Collection collection = declarationContainerNamespace.getDeclarationsUIDs();
        Set<CsmUID<CsmOffsetableDeclaration>> set = this.unnamedDeclarations;
        synchronized (set) {
            collection.addAll(this.unnamedDeclarations);
        }
        return UIDCsmConverter.UIDsToDeclarations(collection, csmFilter);
    }

    public Collection<CsmUID<CsmOffsetableDeclaration>> findUidsByPrefix(String string) {
        char c = '\u00ff';
        return this.findUidsRange(string, string + c);
    }

    public Collection<CsmUID<CsmOffsetableDeclaration>> findUidsRange(String string, String string2) {
        DeclarationContainerNamespace declarationContainerNamespace = this.getDeclarationsSorage();
        return declarationContainerNamespace.getUIDsRange(string, string2);
    }

    public Collection<CsmOffsetableDeclaration> getDeclarationsRange(CharSequence charSequence, CsmDeclaration.Kind[] kindArray) {
        DeclarationContainerNamespace declarationContainerNamespace = this.getDeclarationsSorage();
        return declarationContainerNamespace.getDeclarationsRange(charSequence, kindArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getUnnamedUids() {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> arrayList;
        Set<CsmUID<CsmOffsetableDeclaration>> set = this.unnamedDeclarations;
        synchronized (set) {
            arrayList = new ArrayList<CsmUID<CsmOffsetableDeclaration>>(this.unnamedDeclarations);
        }
        return arrayList;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public CharSequence getQualifiedName() {
        return this.qualifiedName;
    }

    public CharSequence getName() {
        return this.name;
    }

    private void addNestedNamespace(NamespaceImpl namespaceImpl) {
        assert (namespaceImpl != null);
        CsmUID<NamespaceImpl> csmUID = RepositoryUtils.put(namespaceImpl);
        assert (csmUID != null);
        this.nestedNamespaces.put(namespaceImpl.getQualifiedName(), csmUID);
        RepositoryUtils.put(this);
    }

    private void removeNestedNamespace(NamespaceImpl namespaceImpl) {
        assert (namespaceImpl != null);
        CsmUID<CsmNamespace> csmUID = this.nestedNamespaces.remove(namespaceImpl.getQualifiedName());
        assert (csmUID != null);
        if (namespaceImpl.getName().length() == 0) {
            String string = ((Object)namespaceImpl.getQualifiedName()).toString();
            int n = string.lastIndexOf(62);
            assert (n >= 0);
            if (n + 1 < string.length()) {
                try {
                    Integer n2 = Integer.parseInt(string.substring(n + 1));
                    this.unnamedNrs.remove(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    DiagnosticExceptoins.register(numberFormatException);
                }
            } else {
                this.unnamedNrs.remove(0);
            }
        }
        RepositoryUtils.put(this);
    }

    public static boolean isNamespaceScope(VariableImpl<?> variableImpl, boolean bl) {
        if (((FileImpl)variableImpl.getContainingFile()).isHeaderFile() && !CsmKindUtilities.isVariableDefinition(variableImpl)) {
            return true;
        }
        if (variableImpl.isStatic()) {
            return false;
        }
        return !variableImpl.isConst() || !bl || variableImpl.isExtern();
    }

    public static boolean isNamespaceScope(FunctionImpl<?> functionImpl) {
        if (((FileImpl)functionImpl.getContainingFile()).isHeaderFile() && !functionImpl.isPureDefinition()) {
            return true;
        }
        return !functionImpl.isStatic();
    }

    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int n, int n2, CharSequence charSequence) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        boolean bl;
        boolean bl2 = bl = !Utils.canRegisterDeclaration((CsmDeclaration)csmOffsetableDeclaration);
        if (bl && !CsmKindUtilities.isEnum((CsmObject)csmOffsetableDeclaration)) {
            return;
        }
        if (csmOffsetableDeclaration instanceof VariableImpl) {
            VariableImpl variableImpl = (VariableImpl)csmOffsetableDeclaration;
            if (NamespaceImpl.isNamespaceScope(variableImpl, this.isGlobal())) {
                variableImpl.setScope((CsmScope)this);
            } else {
                return;
            }
        }
        if (bl) {
            this.unnamedDeclarations.add(UIDCsmConverter.declarationToUID(csmOffsetableDeclaration));
        } else {
            this.getDeclarationsSorage().putDeclaration(csmOffsetableDeclaration);
        }
        RepositoryUtils.put(this);
        this.notify((CsmObject)csmOffsetableDeclaration, NotifyEvent.DECLARATION_ADDED);
    }

    @Override
    public void removeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        if (csmOffsetableDeclaration.getName().length() == 0) {
            CsmUID csmUID = UIDs.get((Object)csmOffsetableDeclaration);
            this.unnamedDeclarations.remove(csmUID);
        } else {
            this.getDeclarationsSorage().removeDeclaration(csmOffsetableDeclaration);
        }
        RepositoryUtils.put(this);
        this.notify((CsmObject)csmOffsetableDeclaration, NotifyEvent.DECLARATION_REMOVED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmNamespaceDefinition> getDefinitions() {
        ArrayList arrayList = new ArrayList();
        try {
            this.nsDefinitionsLock.readLock().lock();
            arrayList.addAll(this.nsDefinitions.values());
        }
        finally {
            this.nsDefinitionsLock.readLock().unlock();
        }
        Collection<CsmNamespaceDefinition> collection = UIDCsmConverter.UIDsToDeclarations(arrayList);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNamespaceDefinition(CsmNamespaceDefinition csmNamespaceDefinition) {
        CsmUID<CsmNamespaceDefinition> csmUID = RepositoryUtils.put(csmNamespaceDefinition);
        boolean bl = false;
        try {
            this.nsDefinitionsLock.writeLock().lock();
            bl = this.nsDefinitions.isEmpty();
            this.nsDefinitions.put(NamespaceImpl.getSortKey(csmNamespaceDefinition), csmUID);
        }
        finally {
            this.nsDefinitionsLock.writeLock().unlock();
        }
        RepositoryUtils.put(this);
        if (bl) {
            this.addRemoveInParentNamespace(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addRemoveInParentNamespace(boolean bl) {
        if (bl) {
            NamespaceImpl namespaceImpl = (NamespaceImpl)this._getParentNamespace();
            if (namespaceImpl != null) {
                namespaceImpl.addNestedNamespace(this);
            }
            this._getProject().registerNamespace(this);
        } else {
            try {
                this.nsDefinitionsLock.readLock().lock();
                if (!this.nsDefinitions.isEmpty()) {
                    return;
                }
            }
            finally {
                this.nsDefinitionsLock.readLock().unlock();
            }
            NamespaceImpl namespaceImpl = (NamespaceImpl)this._getParentNamespace();
            if (namespaceImpl != null) {
                namespaceImpl.removeNestedNamespace(this);
            }
            this.projectRef = this._getProject();
            ((ProjectBase)this.projectRef).unregisterNamesace(this);
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNamespaceDefinition(CsmNamespaceDefinition csmNamespaceDefinition) {
        assert (!this.isGlobal());
        boolean bl = false;
        CsmUID<CsmNamespaceDefinition> csmUID = null;
        try {
            this.nsDefinitionsLock.writeLock().lock();
            csmUID = this.nsDefinitions.remove(NamespaceImpl.getSortKey(csmNamespaceDefinition));
            bl = this.nsDefinitions.isEmpty();
        }
        finally {
            this.nsDefinitionsLock.writeLock().unlock();
        }
        RepositoryUtils.put(this);
        if (bl) {
            this.addRemoveInParentNamespace(false);
        }
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return (List)this.getDeclarations();
    }

    public CsmProject getProject() {
        return this._getProject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CsmUID<CsmNamespace> getUID() {
        CsmUID<CsmNamespace> csmUID = this.uid;
        if (csmUID == null) {
            NamespaceImpl namespaceImpl = this;
            synchronized (namespaceImpl) {
                if (this.uid == null) {
                    this.uid = csmUID = this.createUID();
                }
            }
        }
        return this.uid;
    }

    protected CsmUID<CsmNamespace> createUID() {
        return UIDUtilities.createNamespaceUID(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectBase _getProject() {
        ProjectBase projectBase;
        Object object = this.projectRef;
        if (object instanceof ProjectBase) {
            return (ProjectBase)object;
        }
        if (object instanceof Reference && (projectBase = (ProjectBase)((Reference)object).get()) != null) {
            return projectBase;
        }
        this.projectLock.readLock().lock();
        try {
            Object object2;
            projectBase = null;
            if (this.projectRef instanceof ProjectBase) {
                projectBase = (ProjectBase)this.projectRef;
            } else if (this.projectRef instanceof Reference) {
                object2 = (Reference)this.projectRef;
                projectBase = (ProjectBase)((Reference)object2).get();
            }
            if (projectBase == null) {
                projectBase = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
                assert (projectBase != null || this.projectUID == null) : "empty project for UID " + this.projectUID;
                this.projectRef = new WeakReference<ProjectBase>(projectBase);
            }
            object2 = projectBase;
            return object2;
        }
        finally {
            this.projectLock.readLock().unlock();
        }
    }

    private CsmNamespace _getParentNamespace() {
        CsmNamespace csmNamespace = this.parentRef;
        if (csmNamespace == null) {
            csmNamespace = UIDCsmConverter.UIDtoNamespace(this.parentUID);
            assert (csmNamespace != null || this.parentUID == null) : "null object for UID " + this.parentUID;
        }
        return csmNamespace;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        stringBuilder.append(' ');
        stringBuilder.append(this.getQualifiedName());
        stringBuilder.append(" NamespaceImpl @");
        stringBuilder.append(this.hashCode());
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.global);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        assert (this.projectUID != null);
        uIDObjectFactory.writeUID(this.projectUID, dataOutput);
        uIDObjectFactory.writeUID(this.parentUID, dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        assert (this.qualifiedName != null);
        PersistentUtils.writeUTF(this.qualifiedName, dataOutput);
        uIDObjectFactory.writeStringToUIDMap(this.nestedNamespaces, dataOutput, true);
        ProjectComponent.writeKey(this.declarationsSorageKey, dataOutput);
        try {
            this.nsDefinitionsLock.readLock().lock();
            uIDObjectFactory.writeNameSortedToUIDMap2(this.nsDefinitions, dataOutput, false);
        }
        finally {
            this.nsDefinitionsLock.readLock().unlock();
        }
        uIDObjectFactory.writeUIDCollection(this.unnamedDeclarations, dataOutput, true);
    }

    public NamespaceImpl(DataInput dataInput) throws IOException {
        this.global = dataInput.readBoolean();
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.projectUID = uIDObjectFactory.readUID(dataInput);
        this.parentUID = uIDObjectFactory.readUID(dataInput);
        assert (this.projectUID != null);
        this.projectRef = null;
        this.parentRef = null;
        this.name = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        assert (this.name != null);
        this.qualifiedName = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        assert (this.qualifiedName != null);
        int n = dataInput.readInt();
        this.nestedNamespaces = n <= 0 ? new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>(0) : new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>(n);
        uIDObjectFactory.readStringToUIDMap(this.nestedNamespaces, dataInput, QualifiedNameCache.getManager(), n);
        this.declarationsSorageKey = ProjectComponent.readKey(dataInput);
        assert (this.declarationsSorageKey != null) : "declarationsSorageKey can not be null";
        this.nsDefinitions = uIDObjectFactory.readNameSortedToUIDMap2(dataInput, null);
        n = dataInput.readInt();
        this.unnamedDeclarations = n < 0 ? Collections.synchronizedSet(new HashSet(0)) : Collections.synchronizedSet(new HashSet(n));
        uIDObjectFactory.readUIDCollection(this.unnamedDeclarations, dataInput, n);
    }

    private static FileNameSortedKey getSortKey(CsmNamespaceDefinition csmNamespaceDefinition) {
        return new FileNameSortedKey(csmNamespaceDefinition);
    }

    public static class FileNameSortedKey
    implements Comparable<FileNameSortedKey>,
    Persistent,
    SelfPersistent {
        private final int start;
        private final int fileIndex;

        private FileNameSortedKey(CsmNamespaceDefinition csmNamespaceDefinition) {
            this(UIDUtilities.getFileID(((FileImpl)csmNamespaceDefinition.getContainingFile()).getUID()), csmNamespaceDefinition.getStartOffset());
        }

        private FileNameSortedKey(int n, int n2) {
            this.start = n2;
            this.fileIndex = n;
        }

        @Override
        public int compareTo(FileNameSortedKey fileNameSortedKey) {
            int n = this.fileIndex - fileNameSortedKey.fileIndex;
            if (n == 0) {
                n = this.start - fileNameSortedKey.start;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof FileNameSortedKey) {
                FileNameSortedKey fileNameSortedKey = (FileNameSortedKey)object;
                return this.compareTo(fileNameSortedKey) == 0;
            }
            return false;
        }

        public int hashCode() {
            int n = 7;
            n = 37 * n + this.start;
            n = 37 * n + this.fileIndex;
            return n;
        }

        public String toString() {
            return "FileNameSortedKey: " + this.fileIndex + "[" + this.start;
        }

        public void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeInt(this.start);
            dataOutput.writeInt(this.fileIndex);
        }

        public FileNameSortedKey(DataInput dataInput) throws IOException {
            this.start = dataInput.readInt();
            this.fileIndex = dataInput.readInt();
        }
    }

    protected static enum NotifyEvent {
        DECLARATION_ADDED,
        DECLARATION_REMOVED,
        NAMESPACE_ADDED,
        NAMESPACE_REMOVED;

    }
}

