/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.xml.namespace.QName;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.apisupport.AdaptNbVersion;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.apisupport.ExamineManifest;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class MavenNbModuleImpl
implements NbModuleProvider {
    private Project project;
    private DependencyAdder dependencyAdder = new DependencyAdder();
    private RequestProcessor.Task tsk = RequestProcessor.getDefault().create((Runnable)this.dependencyAdder);
    public static final String PROP_NETBEANS_INSTALL = "netbeans.installation";
    public static final String GROUPID_MOJO = "org.codehaus.mojo";
    public static final String NBM_PLUGIN = "nbm-maven-plugin";

    public MavenNbModuleImpl(Project project) {
        this.project = project;
    }

    static RepositoryInfo netbeansRepo() {
        return RepositoryPreferences.getInstance().getRepositoryInfoById("netbeans");
    }

    private File getModuleXmlLocation() {
        File rel;
        String file = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)GROUPID_MOJO, (String)NBM_PLUGIN, (String)"descriptor", null);
        if (file == null) {
            file = "src/main/nbm/module.xml";
        }
        if (!(rel = new File(file)).isAbsolute()) {
            rel = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), file);
        }
        return FileUtil.normalizeFile((File)rel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Xpp3Dom getModuleDom() throws UnsupportedEncodingException, IOException, XmlPullParserException {
        if (!this.getModuleXmlLocation().exists()) {
            return null;
        }
        FileInputStream is = new FileInputStream(this.getModuleXmlLocation());
        InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
        try {
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build((Reader)reader);
            return xpp3Dom;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    public String getSpecVersion() {
        NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        String specVersion = AdaptNbVersion.adaptVersion(watch.getMavenProject().getVersion(), "spec");
        return specVersion;
    }

    public String getCodeNameBase() {
        try {
            Xpp3Dom cnb;
            Xpp3Dom dom = this.getModuleDom();
            if (dom != null && (cnb = dom.getChild("codeNameBase")) != null) {
                String val = cnb.getValue();
                if (val.indexOf("/") > -1) {
                    val = val.substring(0, val.indexOf("/"));
                }
                return val;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MavenProject prj = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
        String codename = prj.getGroupId() + "." + prj.getArtifactId();
        codename = codename.replaceAll("-", ".");
        return codename;
    }

    public String getSourceDirectoryPath() {
        return "src/main/java";
    }

    public FileObject getSourceDirectory() {
        FileObject fo = this.project.getProjectDirectory().getFileObject(this.getSourceDirectoryPath());
        if (fo == null) {
            try {
                fo = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)this.getSourceDirectoryPath());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return fo;
    }

    public FileObject getManifestFile() {
        String path = "src/main/nbm/manifest.mf";
        try {
            Xpp3Dom cnb;
            Xpp3Dom dom = this.getModuleDom();
            if (dom != null && (cnb = dom.getChild("manifest")) != null) {
                path = cnb.getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.project.getProjectDirectory().getFileObject(path);
    }

    public String getResourceDirectoryPath(boolean isTest) {
        if (isTest) {
            return "src/test/resources";
        }
        return "src/main/resources";
    }

    public boolean addDependency(String codeNameBase, String releaseVersion, SpecificationVersion version, boolean useInCompiler) throws IOException {
        List versions;
        List lst;
        Iterator i$;
        File platformFile;
        String artifactId = codeNameBase.replaceAll("\\.", "-");
        NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        if (this.hasDependency(codeNameBase)) {
            return false;
        }
        Dependency dep = null;
        RepositoryInfo nbrepo = MavenNbModuleImpl.netbeansRepo();
        if (nbrepo != null && (platformFile = this.lookForModuleInPlatform(artifactId)) != null && (i$ = (lst = RepositoryQueries.findBySHA1((File)platformFile, (RepositoryInfo[])new RepositoryInfo[]{nbrepo})).iterator()).hasNext()) {
            NBVersionInfo elem = (NBVersionInfo)i$.next();
            dep = new Dependency();
            dep.setArtifactId(elem.getArtifactId());
            dep.setGroupId(elem.getGroupId());
            dep.setVersion(elem.getVersion());
        }
        if (dep == null) {
            dep = new Dependency();
            dep.setGroupId("org.netbeans.api");
            dep.setArtifactId(artifactId);
            if (version != null) {
                dep.setVersion(version.toString());
            } else {
                List deps = watch.getMavenProject().getModel().getDependencies();
                if (deps != null) {
                    for (Dependency d : deps) {
                        if (!"org.netbeans.api".equals(d.getGroupId())) continue;
                        dep.setVersion(d.getVersion());
                    }
                }
            }
        }
        if (dep.getVersion() == null && nbrepo != null && !(versions = RepositoryQueries.getVersions((String)"org.netbeans.cluster", (String)"platform", (RepositoryInfo[])new RepositoryInfo[]{nbrepo})).isEmpty()) {
            dep.setVersion(((NBVersionInfo)versions.get(0)).getVersion());
        }
        if (dep.getVersion() == null) {
            dep.setVersion("99.99");
        }
        this.dependencyAdder.addDependency(dep);
        this.tsk.schedule(200);
        return true;
    }

    public File getModuleJarLocation() {
        return null;
    }

    public boolean hasDependency(String codeNameBase) throws IOException {
        String artifactId = codeNameBase.replaceAll("\\.", "-");
        NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Set set = watch.getMavenProject().getDependencyArtifacts();
        if (set != null) {
            for (Artifact art : set) {
                if (!art.getGroupId().startsWith("org.netbeans") || !art.getArtifactId().equals(artifactId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean prepareContext(String featureDisplayName) throws IllegalStateException {
        File platformDir = this.findPlatformFolder();
        if (null == platformDir) {
            return false;
        }
        if (!(null == platformDir || platformDir.exists() && platformDir.list().length != 0)) {
            this.notifyBuildNeeded(featureDisplayName);
            return false;
        }
        return true;
    }

    private void notifyBuildNeeded(String featureDisplayName) {
        if (!NbPreferences.forModule(MavenNbModuleImpl.class).getBoolean("showNextTime_BuildNeeded", true)) {
            return;
        }
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.add((Component)new JLabel(Bundle.Lbl_BuildNeeded()), "Center");
        JCheckBox checkShowNextTime = new JCheckBox(Bundle.Lbl_ShowNextTime());
        checkShowNextTime.setSelected(true);
        panel.add((Component)checkShowNextTime, "South");
        JButton btnClose = new JButton(Bundle.Lbl_Close());
        DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)panel, featureDisplayName, -1, 1, new Object[]{btnClose}, (Object)btnClose));
        NbPreferences.forModule(MavenNbModuleImpl.class).putBoolean("showNextTime_BuildNeeded", checkShowNextTime.isSelected());
    }

    public String getReleaseDirectoryPath() {
        return "src/main/release";
    }

    public FileObject getReleaseDirectory() throws IOException {
        Utilities.performPOMModelOperations((FileObject)this.project.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                Plugin nbmPlugin;
                Build build = model.getProject().getBuild();
                if (build != null && (nbmPlugin = build.findPluginById(MavenNbModuleImpl.GROUPID_MOJO, MavenNbModuleImpl.NBM_PLUGIN)) != null) {
                    Configuration configuration = nbmPlugin.getConfiguration();
                    if (configuration == null) {
                        configuration = model.getFactory().createConfiguration();
                        nbmPlugin.setConfiguration(configuration);
                    }
                    POMExtensibilityElement resources = ModelUtils.getOrCreateChild((POMComponent)configuration, (String)"nbmResources", (POMModel)model);
                    boolean needed = true;
                    block0: for (POMExtensibilityElement configurationElement : resources.getExtensibilityElements()) {
                        if (!configurationElement.getQName().getLocalPart().equals("nbmResource")) continue;
                        for (POMExtensibilityElement dir : configurationElement.getExtensibilityElements()) {
                            if (!dir.getQName().getLocalPart().equals("directory") || !dir.getElementText().equals(MavenNbModuleImpl.this.getReleaseDirectoryPath())) continue;
                            needed = false;
                            break block0;
                        }
                    }
                    if (needed) {
                        POMExtensibilityElement dir = model.getFactory().createPOMExtensibilityElement(new QName("directory"));
                        dir.setElementText(MavenNbModuleImpl.this.getReleaseDirectoryPath());
                        POMExtensibilityElement res = model.getFactory().createPOMExtensibilityElement(new QName("nbmResource"));
                        res.addExtensibilityElement(dir);
                        resources.addExtensibilityElement(res);
                    }
                }
            }
        }));
        return FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)this.getReleaseDirectoryPath());
    }

    public NbModuleProvider.NbModuleType getModuleType() {
        return NbModuleProvider.STANDALONE;
    }

    public String getProjectFilePath() {
        return "pom.xml";
    }

    public SpecificationVersion getDependencyVersion(String codenamebase) throws IOException {
        String artifactId = codenamebase.replaceAll("\\.", "-");
        NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        for (Artifact art : watch.getMavenProject().getArtifacts()) {
            if (!art.getGroupId().startsWith("org.netbeans") || !art.getArtifactId().equals(artifactId)) continue;
            ExamineManifest exa = new ExamineManifest();
            exa.setJarFile(art.getFile());
            try {
                exa.checkFile();
            }
            catch (MojoExecutionException x) {
                throw new IOException(x);
            }
            if (exa.getSpecVersion() == null) continue;
            return new SpecificationVersion(exa.getSpecVersion());
        }
        for (Artifact art : watch.getMavenProject().getArtifacts()) {
            Artifact art2;
            File jar;
            if (!art.getGroupId().startsWith("org.netbeans") || (jar = (art2 = EmbedderFactory.getProjectEmbedder().getLocalRepository().find((Artifact)new DefaultArtifact("org.netbeans.api", artifactId, art.getVersion(), null, "jar", null, (ArtifactHandler)new DefaultArtifactHandler("jar")))).getFile()) == null || !jar.isFile()) continue;
            ExamineManifest exa = new ExamineManifest();
            exa.setJarFile(jar);
            try {
                exa.checkFile();
            }
            catch (MojoExecutionException x) {
                throw new IOException(x);
            }
            if (exa.getSpecVersion() == null) continue;
            return new SpecificationVersion(exa.getSpecVersion());
        }
        File fil = this.lookForModuleInPlatform(artifactId);
        if (fil != null) {
            ExamineManifest exa = new ExamineManifest();
            exa.setJarFile(fil);
            try {
                exa.checkFile();
            }
            catch (MojoExecutionException x) {
                throw new IOException(x);
            }
            if (exa.getSpecVersion() != null) {
                return new SpecificationVersion(exa.getSpecVersion());
            }
        }
        return null;
    }

    private File lookForModuleInPlatform(String artifactId) {
        File actPlatform = this.getActivePlatformLocation();
        if (actPlatform != null) {
            DirectoryScanner walk = new DirectoryScanner();
            walk.setBasedir(actPlatform);
            walk.setIncludes(new String[]{"**/" + artifactId + ".jar"});
            walk.scan();
            String[] candidates = walk.getIncludedFiles();
            assert (candidates != null && candidates.length <= 1);
            if (candidates.length > 0) {
                return new File(actPlatform, candidates[0]);
            }
        }
        return null;
    }

    public File getActivePlatformLocation() {
        File fil;
        File platformDir = this.findPlatformFolder();
        if (null != platformDir && platformDir.exists() && platformDir.isDirectory()) {
            return platformDir;
        }
        Project suitProject = this.project;
        NbMavenProject watch = (NbMavenProject)suitProject.getLookup().lookup(NbMavenProject.class);
        String installProp = watch.getMavenProject().getProperties().getProperty(PROP_NETBEANS_INSTALL);
        if (installProp == null) {
            installProp = PluginPropertyUtils.getPluginProperty((MavenProject)watch.getMavenProject(), (String)GROUPID_MOJO, (String)NBM_PLUGIN, (String)"netbeansInstallation", (String)"run-ide");
        }
        if (installProp != null && (fil = FileUtilities.convertStringToFile((String)installProp)).exists()) {
            return fil;
        }
        return null;
    }

    static Project findAppProject(Project nbmProject) {
        NbMavenProject mp = (NbMavenProject)nbmProject.getLookup().lookup(NbMavenProject.class);
        if (mp == null) {
            return null;
        }
        String groupId = mp.getMavenProject().getGroupId();
        String artifactId = mp.getMavenProject().getArtifactId();
        Project candidate = null;
        for (Project p : OpenProjects.getDefault().getOpenProjects()) {
            NbMavenProject mp2 = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class);
            if (mp2 == null || !"nbm-application".equals(mp2.getPackagingType())) continue;
            for (Dependency dep : mp2.getMavenProject().getDependencies()) {
                if (!dep.getGroupId().equals(groupId) || !dep.getArtifactId().equals(artifactId)) continue;
                if (candidate != null) {
                    return null;
                }
                candidate = p;
            }
        }
        return candidate;
    }

    private File findPlatformFolder() {
        Project appProject = MavenNbModuleImpl.findAppProject(this.project);
        if (appProject == null) {
            return null;
        }
        NbMavenProject watch = (NbMavenProject)appProject.getLookup().lookup(NbMavenProject.class);
        if (watch == null) {
            return null;
        }
        String outputDir = PluginPropertyUtils.getPluginProperty((MavenProject)watch.getMavenProject(), (String)GROUPID_MOJO, (String)NBM_PLUGIN, (String)"outputDirectory", (String)"cluster-app");
        if (null == outputDir) {
            outputDir = "target";
        }
        String brandingToken = PluginPropertyUtils.getPluginProperty((MavenProject)watch.getMavenProject(), (String)GROUPID_MOJO, (String)NBM_PLUGIN, (String)"brandingToken", (String)"cluster-app");
        return FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)appProject.getProjectDirectory()), (String)(outputDir + File.separator + brandingToken));
    }

    public static class RemoveOldPathToNbApplicationModule
    extends ProjectOpenedHook {
        private final Project p;

        public RemoveOldPathToNbApplicationModule(Project p) {
            this.p = p;
        }

        protected void projectOpened() {
            AuxiliaryProperties aux = (AuxiliaryProperties)this.p.getLookup().lookup(AuxiliaryProperties.class);
            if (aux != null) {
                aux.put("pathToNbApplicationModule", null, true);
            }
        }

        protected void projectClosed() {
        }
    }

    private class DependencyAdder
    implements Runnable {
        List<Dependency> toAdd = new ArrayList<Dependency>();

        private DependencyAdder() {
        }

        private synchronized void addDependency(Dependency dep) {
            this.toAdd.add(dep);
        }

        @Override
        public void run() {
            FileObject fo = MavenNbModuleImpl.this.project.getProjectDirectory().getFileObject("pom.xml");
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void performOperation(POMModel model) {
                    DependencyAdder dependencyAdder = DependencyAdder.this;
                    synchronized (dependencyAdder) {
                        for (Dependency dep : DependencyAdder.this.toAdd) {
                            org.netbeans.modules.maven.model.pom.Dependency mdlDep = ModelUtils.checkModelDependency((POMModel)model, (String)dep.getGroupId(), (String)dep.getArtifactId(), (boolean)true);
                            mdlDep.setVersion(dep.getVersion());
                        }
                        DependencyAdder.this.toAdd.clear();
                    }
                }
            };
            Utilities.performPOMModelOperations((FileObject)fo, Collections.singletonList(operation));
            NbMavenProject.fireMavenProjectReload((Project)MavenNbModuleImpl.this.project);
            ((NbMavenProject)MavenNbModuleImpl.this.project.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
        }
    }
}

