/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.api.NodeFactoryUtils;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.maven.apisupport.AnnotatedNode;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public class ImportantFilesNodeFactory
implements NodeFactory {
    static final String IMPORTANT_FILES_NAME = "important.files";
    static final String LAYER = "LAYER-FILE.PLACEHOLDER";
    static final RequestProcessor RP = new RequestProcessor();

    public NodeList createNodes(Project p) {
        if (p.getLookup().lookup(NbModuleProvider.class) != null) {
            return new ImpFilesNL(p);
        }
        return NodeFactorySupport.fixedNodeList((Node[])new Node[0]);
    }

    private static String computeAnnotatedHtmlDisplayName(String htmlDisplayName, Set<FileObject> files) {
        String result = null;
        if (files != null && files.iterator().hasNext()) {
            try {
                FileSystem.HtmlStatus hstat;
                String annotated;
                FileObject fo = files.iterator().next();
                FileSystem.Status stat = fo.getFileSystem().getStatus();
                if (stat instanceof FileSystem.HtmlStatus && !htmlDisplayName.equals(annotated = (hstat = (FileSystem.HtmlStatus)stat).annotateNameHtml(htmlDisplayName, files))) {
                    result = annotated;
                }
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return result;
    }

    static final class SpecialFileNode
    extends FilterNode {
        private final String displayName;

        public SpecialFileNode(Node orig, String displayName) {
            super(orig);
            this.displayName = displayName;
        }

        public String getDisplayName() {
            if (this.displayName != null) {
                return this.displayName;
            }
            return super.getDisplayName();
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public String getHtmlDisplayName() {
            String result = null;
            DataObject dob = (DataObject)this.getLookup().lookup(DataObject.class);
            if (dob != null) {
                Set files = dob.files();
                result = ImportantFilesNodeFactory.computeAnnotatedHtmlDisplayName(this.getDisplayName(), files);
            }
            return result;
        }
    }

    private static final class ImportantFilesChildren
    extends Children.Keys<String> {
        private List<String> visibleFiles = new ArrayList<String>();
        private FileChangeListener fcl;
        boolean nolayer = false;
        private FileChangeListener layerfcl = new FileChangeAdapter(){

            public void fileDeleted(FileEvent fe) {
                ImportantFilesChildren.this.nolayer = true;
                ImportantFilesChildren.this.refreshKeys();
            }
        };
        private static final Map<String, String> FILES = new LinkedHashMap<String, String>();
        private final Project project;

        public ImportantFilesChildren(Project project) {
            this.project = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.attachListeners();
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            this.removeListeners();
            super.removeNotify();
        }

        protected Node[] createNodes(String key) {
            if (ImportantFilesNodeFactory.LAYER.equals(key)) {
                Node nd = NodeFactoryUtils.createLayersNode((Project)this.project);
                if (nd != null) {
                    DataObject dobj = (DataObject)nd.getLookup().lookup(DataObject.class);
                    if (dobj != null) {
                        FileObject fo = dobj.getPrimaryFile();
                        fo.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.layerfcl, (Object)fo));
                    }
                    return new Node[]{nd};
                }
                return new Node[0];
            }
            FileObject file = this.project.getProjectDirectory().getFileObject(key);
            if (file != null) {
                try {
                    Node orig = DataObject.find((FileObject)file).getNodeDelegate();
                    return new Node[]{new SpecialFileNode(orig, FILES.get(key))};
                }
                catch (DataObjectNotFoundException e) {
                    throw new AssertionError((Object)e);
                }
            }
            return new Node[0];
        }

        private void refreshKeys() {
            if (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        ImportantFilesChildren.this.refreshKeys();
                    }
                });
                return;
            }
            HashSet<FileObject> files = new HashSet<FileObject>();
            ArrayList<String> newVisibleFiles = new ArrayList<String>();
            if (!this.nolayer) {
                newVisibleFiles.add(ImportantFilesNodeFactory.LAYER);
                this.nolayer = false;
            }
            for (String loc : FILES.keySet()) {
                FileObject file = this.project.getProjectDirectory().getFileObject(loc);
                if (file == null) continue;
                newVisibleFiles.add(loc);
                files.add(file);
            }
            if (!this.isInitialized() || !((Object)newVisibleFiles).equals(this.visibleFiles)) {
                this.visibleFiles = newVisibleFiles;
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        ImportantFilesChildren.this.setKeys(ImportantFilesChildren.this.visibleFiles);
                    }
                });
                ((ImportantFilesNode)this.getNode()).setFiles(files);
            }
        }

        private void attachListeners() {
            block3: {
                try {
                    if (this.fcl == null) {
                        this.fcl = new FileChangeAdapter(){

                            public void fileDataCreated(FileEvent fe) {
                                ImportantFilesChildren.this.refreshKeys();
                            }

                            public void fileDeleted(FileEvent fe) {
                                ImportantFilesChildren.this.refreshKeys();
                            }
                        };
                        this.project.getProjectDirectory().getFileSystem().addFileChangeListener(this.fcl);
                    }
                }
                catch (FileStateInvalidException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)e);
                }
            }
        }

        private void removeListeners() {
            if (this.fcl != null) {
                block3: {
                    try {
                        this.project.getProjectDirectory().getFileSystem().removeFileChangeListener(this.fcl);
                    }
                    catch (FileStateInvalidException e) {
                        if ($assertionsDisabled) break block3;
                        throw new AssertionError((Object)e);
                    }
                }
                this.fcl = null;
            }
        }

        static {
            FILES.put("src/main/nbm/manifest.mf", Bundle.LBL_module_manifest());
            FILES.put("src/main/nbm/module.xml", Bundle.LBL_module_xml());
        }
    }

    static final class ImportantFilesNode
    extends AnnotatedNode {
        public ImportantFilesNode(Project project) {
            super((Children)new ImportantFilesChildren(project));
        }

        ImportantFilesNode(Children ch) {
            super(ch);
        }

        public String getName() {
            return ImportantFilesNodeFactory.IMPORTANT_FILES_NAME;
        }

        private Image getIcon(boolean opened) {
            Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/apisupport/config-badge.gif", (boolean)true);
            return ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon((boolean)opened), (Image)badge, (int)8, (int)8);
        }

        public String getDisplayName() {
            return this.annotateName(Bundle.LBL_important_files());
        }

        public String getHtmlDisplayName() {
            return ImportantFilesNodeFactory.computeAnnotatedHtmlDisplayName(Bundle.LBL_important_files(), this.getFiles());
        }

        public Image getIcon(int type) {
            return this.annotateIcon(this.getIcon(false), type);
        }

        public Image getOpenedIcon(int type) {
            return this.annotateIcon(this.getIcon(true), type);
        }
    }

    private static class ImpFilesNL
    implements NodeList<String> {
        private Project project;

        public ImpFilesNL(Project p) {
            this.project = p;
        }

        public List<String> keys() {
            return Collections.singletonList(ImportantFilesNodeFactory.IMPORTANT_FILES_NAME);
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }

        public Node node(String key) {
            assert (key == ImportantFilesNodeFactory.IMPORTANT_FILES_NAME);
            return new ImportantFilesNode(this.project);
        }

        public void addNotify() {
        }

        public void removeNotify() {
        }
    }
}

