/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.memorylint.rules;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.modules.profiler.heapwalk.memorylint.FieldAccess;
import org.netbeans.modules.profiler.heapwalk.memorylint.IteratingRule;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Utils;
import org.openide.util.NbBundle;

public class WrongWeakHashMap
extends IteratingRule {
    private FieldAccess fldHMEKey;
    private FieldAccess fldHMENext;
    private FieldAccess fldHMEValue;
    private FieldAccess fldHMTable;
    private JavaClass clsHM;
    private JavaClass clsHME;
    private Set<WHMRecord> poorWHM = new HashSet<WHMRecord>();

    public WrongWeakHashMap() {
        super(NbBundle.getMessage(WrongWeakHashMap.class, (String)"LBL_WWMH_Name"), NbBundle.getMessage(WrongWeakHashMap.class, (String)"LBL_WWMH_Desc"), "java.util.WeakHashMap");
    }

    @Override
    public String getHTMLDescription() {
        return NbBundle.getMessage(WrongWeakHashMap.class, (String)"LBL_WWMH_LongDesc");
    }

    @Override
    protected void perform(Instance hm) {
        this.scanWeakHashmap(hm);
    }

    @Override
    protected void prepareRule(MemoryLint context) {
        Heap heap = context.getHeap();
        this.clsHM = heap.getJavaClassByName("java.util.WeakHashMap");
        this.clsHME = heap.getJavaClassByName("java.util.WeakHashMap$Entry");
        this.fldHMTable = new FieldAccess(this.clsHM, "table");
        JavaClass ref = heap.getJavaClassByName("java.lang.ref.Reference");
        this.fldHMEKey = new FieldAccess(ref, "referent");
        this.fldHMEValue = new FieldAccess(this.clsHME, "value");
        this.fldHMENext = new FieldAccess(this.clsHME, "next");
    }

    @Override
    protected void summary() {
        for (WHMRecord whm : this.poorWHM) {
            this.getContext().appendResults(whm.toString());
        }
    }

    private void scanWeakHashmap(Instance hm) {
        ObjectArrayInstance table = (ObjectArrayInstance)this.fldHMTable.getRefValue(hm);
        if (table == null) {
            return;
        }
        List tval = table.getValues();
        for (Instance entry : tval) {
            while (entry != null) {
                Instance value;
                Instance key = this.fldHMEKey.getRefValue(entry);
                if (key != null && Utils.isReachableFrom(value = this.fldHMEValue.getRefValue(entry), key)) {
                    this.poorWHM.add(new WHMRecord(hm, key, value));
                    return;
                }
                entry = this.fldHMENext.getRefValue(entry);
            }
        }
    }

    private class WHMRecord {
        private Instance hm;
        private Instance key;
        private Instance value;

        WHMRecord(Instance hm, Instance key, Instance value) {
            this.hm = hm;
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return NbBundle.getMessage(WrongWeakHashMap.class, (String)"FMT_WWMH_Entry", (Object[])new Object[]{Utils.printClass(WrongWeakHashMap.this.getContext(), WrongWeakHashMap.this.getContext().getRootIncommingString(this.hm)), Utils.printInstance(this.hm), Utils.printInstance(this.key), Utils.printInstance(this.value)});
        }
    }
}

