/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.codegen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyContainer;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.spi.grammar.DialogFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public class DependencyGenerator
implements CodeGenerator {
    private POMModel model;
    private JTextComponent component;

    private DependencyGenerator(POMModel model, JTextComponent component) {
        this.model = model;
        this.component = component;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(DependencyGenerator.class, (String)"NAME_Dependency");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke() {
        String[] ret;
        try {
            this.model.sync();
        }
        catch (IOException ex) {
            Logger.getLogger(DependencyGenerator.class.getName()).log(Level.INFO, "Error while syncing the editor document with model for pom.xml file", ex);
        }
        if (!this.model.getState().equals((Object)Model.State.VALID)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DependencyGenerator.class, (String)"MSG_Cannot_Parse"));
            return;
        }
        FileObject fo = (FileObject)this.model.getModelSource().getLookup().lookup(FileObject.class);
        assert (fo != null);
        Project prj = FileOwnerQuery.getOwner((FileObject)fo);
        assert (prj != null);
        int pos = this.component.getCaretPosition();
        DocumentComponent c = this.model.findComponent(pos);
        boolean dm = false;
        if (c != null) {
            String xpath = this.model.getXPathExpression(c);
            dm = xpath.contains("dependencyManagement");
        }
        if ((ret = DialogFactory.showDependencyDialog((Project)prj, (!dm ? 1 : 0) != 0)) != null) {
            String groupId = ret[0];
            String artifactId = ret[1];
            String version = ret[2];
            String scope = ret[3];
            String type = ret[4];
            String classifier = ret[5];
            int newPos = -1;
            try {
                this.model.startTransaction();
                pos = this.component.getCaretPosition();
                DependencyContainer container = this.findContainer(pos, this.model);
                Dependency dep = container.findDependencyById(groupId, artifactId, classifier);
                if (dep == null) {
                    dep = this.model.getFactory().createDependency();
                    dep.setGroupId(groupId);
                    dep.setArtifactId(artifactId);
                    dep.setVersion(version);
                    dep.setScope(scope);
                    dep.setType(type);
                    dep.setClassifier(classifier);
                    container.addDependency(dep);
                }
                newPos = dep.getModel().getAccess().findPosition((Node)dep.getPeer());
            }
            finally {
                this.model.endTransaction();
            }
            if (newPos != -1) {
                this.component.setCaretPosition(newPos);
            }
        }
    }

    private DependencyContainer findContainer(int pos, POMModel model) {
        for (DocumentComponent dc = model.findComponent(pos); dc != null; dc = dc.getParent()) {
            if (!(dc instanceof DependencyContainer)) continue;
            return (DependencyContainer)dc;
        }
        return model.getProject();
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            ArrayList<DependencyGenerator> toRet = new ArrayList<DependencyGenerator>();
            POMModel model = (POMModel)context.lookup(POMModel.class);
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            if (model != null) {
                toRet.add(new DependencyGenerator(model, component));
            }
            return toRet;
        }
    }
}

