/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.converter.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.commands.CommandCD;
import org.netbeans.modules.vmd.midp.components.displayables.AlertCD;
import org.netbeans.modules.vmd.midp.components.displayables.CanvasCD;
import org.netbeans.modules.vmd.midp.components.displayables.DisplayableCD;
import org.netbeans.modules.vmd.midp.components.displayables.FormCD;
import org.netbeans.modules.vmd.midp.components.displayables.ListCD;
import org.netbeans.modules.vmd.midp.components.displayables.ScreenCD;
import org.netbeans.modules.vmd.midp.components.displayables.TextBoxCD;
import org.netbeans.modules.vmd.midp.components.items.ChoiceGroupCD;
import org.netbeans.modules.vmd.midp.components.items.CustomItemCD;
import org.netbeans.modules.vmd.midp.components.items.DateFieldCD;
import org.netbeans.modules.vmd.midp.components.items.GaugeCD;
import org.netbeans.modules.vmd.midp.components.items.ImageItemCD;
import org.netbeans.modules.vmd.midp.components.items.ItemCD;
import org.netbeans.modules.vmd.midp.components.items.SpacerCD;
import org.netbeans.modules.vmd.midp.components.items.StringItemCD;
import org.netbeans.modules.vmd.midp.components.items.TextFieldCD;
import org.netbeans.modules.vmd.midp.components.resources.TickerCD;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterBuilt;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterDisplayables;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItem;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterItems;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterResources;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterSVG;
import org.netbeans.modules.vmd.midp.converter.wizard.ConverterUtil;
import org.netbeans.modules.vmd.midp.palette.wizard.ComponentInstaller;
import org.netbeans.modules.vmd.midpnb.components.displayables.AbstractInfoScreenCD;
import org.netbeans.modules.vmd.midpnb.components.displayables.SplashScreenCD;
import org.netbeans.modules.vmd.midpnb.components.displayables.WaitScreenCD;
import org.netbeans.modules.vmd.midpnb.components.items.TableItemCD;
import org.netbeans.modules.vmd.midpnb.components.resources.SimpleCancellableTaskCD;
import org.netbeans.modules.vmd.midpnb.components.resources.SimpleTableModelCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGAnimatorWrapperCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGImageCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGMenuCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGSplashScreenCD;
import org.netbeans.modules.vmd.midpnb.components.svg.SVGWaitScreenCD;
import org.openide.util.Utilities;

public class ConverterCustom {
    static void loadItemsToRegistry(final List<ConverterItem> items, DesignDocument document) {
        final DescriptorRegistry registry = document.getDescriptorRegistry();
        final HashSet unresolved = new HashSet();
        registry.readAccess(new Runnable(){

            @Override
            public void run() {
                for (ConverterItem item : items) {
                    String string;
                    if (!ConverterCustom.isClassComponent(item) || registry.getComponentDescriptor(new TypeID(TypeID.Kind.COMPONENT, string = item.getTypeID())) != null) continue;
                    unresolved.add(string);
                }
            }
        });
        if (!unresolved.isEmpty()) {
            Map found = ComponentInstaller.search((Project)ProjectUtils.getProject((DesignDocument)document));
            ArrayList<ComponentInstaller.Item> install = new ArrayList<ComponentInstaller.Item>();
            for (String s : unresolved) {
                ComponentInstaller.Item item = (ComponentInstaller.Item)found.get(s);
                if (item == null) continue;
                install.add(item);
            }
            ComponentInstaller.install((Map)found, install);
        }
    }

    static boolean isClassComponent(ConverterItem item) {
        return Utilities.isJavaIdentifier((String)item.getID()) && MidpTypes.isValidFQNClassName((String)item.getTypeID());
    }

    static void convertCustom(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignDocument document) {
        TypeID typeID = new TypeID(TypeID.Kind.COMPONENT, item.getTypeID());
        ComponentProducer producer = DocumentSupport.getComponentProducer((DesignDocument)document, (String)typeID.toString());
        if (producer == null) {
            return;
        }
        DesignComponent component = document.createComponent(producer.getMainComponentTypeID());
        producer.postInitialize(document, component);
        ConverterCustom.convertCustomProperties(id2item, item, component, component.getComponentDescriptor());
    }

    private static void convertCustomProperties(HashMap<String, ConverterItem> id2item, ConverterItem item, DesignComponent component, ComponentDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        TypeID typeID = descriptor.getTypeDescriptor().getThisType();
        if (DisplayableCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertDisplayable(id2item, item, component);
        } else if (CanvasCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertCanvas(id2item, item, component);
        } else if (ScreenCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertScreen(id2item, item, component);
        } else if (AlertCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertAlertCore(id2item, item, component);
        } else if (FormCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertFormCore(id2item, item, component);
        } else if (ListCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertListCore(id2item, item, component);
        } else if (TextBoxCD.TYPEID.equals((Object)typeID)) {
            ConverterDisplayables.convertTextBoxCore(id2item, item, component);
        } else if (ItemCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertItem(id2item, item, component);
        } else if (CustomItemCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertCustomItem(id2item, item, component);
        } else if (DateFieldCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertDateFieldCore(id2item, item, component);
        } else if (ChoiceGroupCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertChoiceGroupCore(id2item, item, component);
        } else if (GaugeCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertGaugeCore(id2item, item, component);
        } else if (ImageItemCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertImageItemCore(id2item, item, component);
        } else if (SpacerCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertSpacerCore(id2item, item, component);
        } else if (StringItemCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertStringItemCore(id2item, item, component);
        } else if (TextFieldCD.TYPEID.equals((Object)typeID)) {
            ConverterItems.convertTextFieldCore(id2item, item, component);
        } else if (AbstractInfoScreenCD.TYPEID.equals((Object)typeID)) {
            ConverterBuilt.convertAbstractInfoScreen(id2item, item, component);
        } else if (SimpleCancellableTaskCD.TYPEID.equals((Object)typeID)) {
            ConverterBuilt.convertSimpleCancellableTask(id2item, item, component.getDocument());
        } else if (SimpleTableModelCD.TYPEID.equals((Object)typeID)) {
            ConverterBuilt.convertSimpleTableModel(id2item, item, component.getDocument());
        } else if (SplashScreenCD.TYPEID.equals((Object)typeID)) {
            ConverterBuilt.convertSplashScreen(id2item, item, component.getDocument());
        } else if (TableItemCD.TYPEID.equals((Object)typeID)) {
            ConverterBuilt.convertTableItem(id2item, item, component.getDocument());
        } else if (WaitScreenCD.TYPEID.equals((Object)typeID)) {
            ConverterBuilt.convertWaitScreen(id2item, item, component.getDocument());
        } else if (CommandCD.TYPEID.equals((Object)typeID)) {
            ConverterResources.convertCommand(item, component.getDocument());
        } else if (TickerCD.TYPEID.equals((Object)typeID)) {
            ConverterResources.convertTicker(item, component.getDocument());
        } else if (SVGImageCD.TYPEID.equals((Object)typeID)) {
            ConverterSVG.convertImage(id2item, item, component.getDocument());
        } else if (SVGAnimatorWrapperCD.TYPEID.equals((Object)typeID)) {
            ConverterSVG.convertPlayer(id2item, item, component.getDocument());
        } else if (SVGMenuCD.TYPEID.equals((Object)typeID)) {
            ConverterSVG.convertMenu(id2item, item, component.getDocument());
        } else if (SVGSplashScreenCD.TYPEID.equals((Object)typeID)) {
            ConverterSVG.convertSplashScreen(id2item, item, component.getDocument());
        } else if (SVGWaitScreenCD.TYPEID.equals((Object)typeID)) {
            ConverterSVG.convertWaitScreen(id2item, item, component.getDocument());
        } else {
            ConverterCustom.convertCustomProperties(id2item, item, component, descriptor.getSuperDescriptor());
            String fqn = MidpTypes.getFQNClassName((TypeID)typeID);
            for (PropertyDescriptor property : descriptor.getPropertyDescriptors()) {
                String prefix = fqn + "#";
                String name = property.getName();
                if (!name.startsWith(prefix)) continue;
                int index = (name = name.substring(prefix.length())).indexOf(35);
                if (index >= 0) {
                    prefix = "%%" + name.substring(0, index) + "_" + name.substring(index + 1) + "_";
                    String found = null;
                    for (String s : item.getPropertyNames()) {
                        if (!s.startsWith(prefix)) continue;
                        found = s;
                        break;
                    }
                    if (found == null) continue;
                    ConverterUtil.convertToPropertyValue(component, property.getName(), property.getType(), item.getPropertyValue(found));
                    continue;
                }
                if (!name.startsWith("set")) continue;
                name = name.substring("set".length());
                if (item.isPropertyValueSet("%" + name)) {
                    ConverterUtil.convertToPropertyValue(component, property.getName(), property.getType(), item.getPropertyValue("%" + name));
                    continue;
                }
                if (name.length() <= 0) continue;
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                if (!item.isPropertyValueSet("%" + name)) continue;
                ConverterUtil.convertToPropertyValue(component, property.getName(), property.getType(), item.getPropertyValue("%" + name));
            }
        }
    }
}

