/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.VisualUpdate;

final class ViewReplace<V extends EditorBoxView<CV>, CV extends EditorView> {
    private static final Logger LOG = Logger.getLogger(ViewReplace.class.getName());
    final V view;
    int index;
    int removeCount;
    List<CV> added;

    ViewReplace(V view, int index) {
        assert (view != null);
        this.view = view;
        this.index = index;
    }

    void add(CV view) {
        if (this.added == null) {
            this.added = new ArrayList<CV>();
        }
        this.added.add(view);
    }

    int removeEndIndex() {
        return this.index + this.removeCount;
    }

    void removeTillEnd() {
        this.removeCount = ((EditorBoxView)this.view).getViewCount() - this.index;
    }

    private EditorView[] addedViews() {
        EditorView[] views;
        if (this.added != null) {
            views = new EditorView[this.added.size()];
            this.added.toArray(views);
        } else {
            views = new EditorView[]{};
        }
        return views;
    }

    EditorView childViewAtIndex() {
        return ((EditorBoxView)this.view).getEditorView(this.index);
    }

    void retainSpans() {
        if (this.added != null && this.removeCount == this.added.size()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("RetainSpans: index=" + this.index + ", count=" + this.removeCount + '\n');
            }
            for (int i = 0; i < this.removeCount; ++i) {
                Object v = ((EditorBoxView)this.view).getEditorView(this.index + i);
                ParagraphView pv = (ParagraphView)v;
                float height = pv.getMinorAxisSpan();
                ParagraphView npv = (ParagraphView)this.added.get(i);
                npv.setMinorAxisSpan(height);
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("RetainSpans: [" + (this.index + i) + "]: " + height + '\n');
            }
            LOG.fine("RetainSpans: -----------\n");
        }
    }

    VisualUpdate replaceViews(int offsetDelta) {
        if (this.removeCount > 0 || this.added != null) {
            return ((EditorBoxView)this.view).replace(this.index, this.removeCount, this.addedViews(), offsetDelta);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("viewId=").append(((EditorView)this.view).getDumpId());
        sb.append(": index=").append(this.index);
        sb.append(", removeCount=").append(this.removeCount);
        EditorView[] addedViews = this.addedViews();
        sb.append(", addedCount=").append(addedViews.length);
        if (addedViews.length > 0) {
            sb.append(", Added:\n");
            int maxDigitCount = ArrayUtilities.digitCount((int)addedViews.length);
            for (int i = 0; i < addedViews.length; ++i) {
                sb.append("    ");
                ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)maxDigitCount);
                sb.append(addedViews[i].toString());
                sb.append('\n');
            }
        } else {
            sb.append("\n");
        }
        return sb.toString();
    }
}

