/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.HighlightsView;
import org.netbeans.modules.editor.lib2.view.HighlightsViewPart;
import org.netbeans.modules.editor.lib2.view.PaintState;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.TextLayoutCache;
import org.netbeans.modules.editor.lib2.view.TextLayoutPart;
import org.netbeans.modules.editor.lib2.view.TextLayoutUtils;
import org.netbeans.modules.editor.lib2.view.TextLayoutWrapper;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.modules.editor.lib2.view.VisualUpdate;

public class HighlightsViewUtils {
    private static final Logger LOG = Logger.getLogger(HighlightsViewUtils.class.getName());

    private HighlightsViewUtils() {
    }

    static <V extends EditorView> int findAffectedLayoutIndex(EditorBoxView<V> boxView, VisualUpdate<V> visualUpdate, int index) {
        assert (boxView instanceof ParagraphView) : "Not ParagraphView instance";
        ParagraphView pView = (ParagraphView)boxView;
        DocumentView docView = pView.getDocumentView();
        assert (docView != null) : "docView==null for pView=" + pView;
        TextLayoutCache textLayoutCache = docView.getTextLayoutCache();
        assert (textLayoutCache != null) : "textLayoutCache is null for pView=" + pView;
        boolean inTLCache = textLayoutCache.contains(pView);
        if (!inTLCache) {
            return 0;
        }
        visualUpdate.markInCache();
        if (index > 0) {
            V view;
            Font defaultFont = docView.getTextComponent().getFont();
            V prevView = boxView.getEditorView(index - 1);
            if (!(prevView instanceof HighlightsView)) {
                return index;
            }
            HighlightsView prevHView = (HighlightsView)prevView;
            Object prevLayout = prevHView.layoutRaw();
            assert (prevLayout != null) : "Null prevLayout";
            boolean prevRebuild = prevLayout instanceof TextLayoutPart ? !((TextLayoutPart)prevLayout).isLast() : false;
            int viewCount = boxView.getViewCount();
            if (!prevRebuild && index != viewCount && (view = boxView.getEditorView(index)) instanceof HighlightsView) {
                AttributeSet attrs = ((HighlightsView)view).getAttributes();
                AttributeSet prevAttrs = prevHView.getAttributes();
                Font font = ViewUtils.getFont(attrs, defaultFont);
                Font prevFont = ViewUtils.getFont(prevAttrs, defaultFont);
                boolean bl = prevRebuild = prevFont.equals(font) && HighlightsViewUtils.colorsEqual(HighlightsViewUtils.foreColor(attrs), HighlightsViewUtils.foreColor(prevAttrs)) && HighlightsViewUtils.strikeThroughEqual(HighlightsViewUtils.strikeThrough(attrs), HighlightsViewUtils.strikeThrough(prevAttrs));
            }
            if (prevRebuild) {
                --index;
                prevHView.setLayout(null);
                if (prevLayout instanceof TextLayoutPart) {
                    while (((TextLayoutPart)prevLayout).index() != 0) {
                        prevHView = (HighlightsView)boxView.getEditorView(--index);
                        prevLayout = prevHView.layoutRaw();
                        prevHView.setLayout(null);
                    }
                }
            }
        }
        return index;
    }

    private static Color foreColor(AttributeSet attrs) {
        return attrs != null ? (Color)attrs.getAttribute(StyleConstants.Foreground) : null;
    }

    private static Color validForeColor(AttributeSet attrs, JTextComponent textComponent) {
        Color foreColor = HighlightsViewUtils.foreColor(attrs);
        if (foreColor == null) {
            foreColor = textComponent.getForeground();
        }
        return foreColor;
    }

    private static Color backColor(AttributeSet attrs) {
        return attrs != null ? (Color)attrs.getAttribute(StyleConstants.Background) : null;
    }

    private static Color validBackColor(AttributeSet attrs, JTextComponent textComponent) {
        Color backColor = HighlightsViewUtils.backColor(attrs);
        if (backColor == null) {
            backColor = textComponent.getBackground();
        }
        return backColor;
    }

    private static boolean colorsEqual(Color color1, Color color2) {
        return color1 != null ? color1.equals(color2) : color2 == null;
    }

    private static Boolean strikeThrough(AttributeSet attrs) {
        return attrs != null ? (Boolean)attrs.getAttribute(StyleConstants.StrikeThrough) : null;
    }

    private static boolean strikeThroughEqual(Boolean strikeThrough1, Boolean strikeThrough2) {
        return strikeThrough1 != null ? strikeThrough1.equals(strikeThrough2) : strikeThrough2 == null;
    }

    static <V extends EditorView> void fixLayouts(EditorBoxView<V> boxView, VisualUpdate<V> visualUpdate) {
        int i;
        ParagraphView pView = (ParagraphView)boxView;
        DocumentView docView = pView.getDocumentView();
        Document doc = docView.getDocument();
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        JTextComponent textComponent = docView.getTextComponent();
        Font defaultFont = textComponent.getFont();
        int groupStartIndex = -1;
        HighlightsView hViewFirst = null;
        Font fontFirst = null;
        Color foreColorFirst = null;
        Color backColorFirst = null;
        int viewCount = boxView.getViewCount();
        if (!visualUpdate.isInCache()) {
            assert (visualUpdate.visualIndex == 0);
            visualUpdate.endVisualIndex = viewCount;
            docView.getTextLayoutCache().activate(pView);
        }
        for (i = visualUpdate.visualIndex; i < viewCount; ++i) {
            Object layout;
            V view = boxView.getEditorView(i);
            if (view instanceof HighlightsView) {
                AttributeSet attrs = ((View)view).getAttributes();
                Font font = ViewUtils.getFont(attrs, defaultFont);
                docView.notifyFontUse(font);
                Color foreColor = HighlightsViewUtils.validForeColor(attrs, textComponent);
                Color backColor = HighlightsViewUtils.validBackColor(attrs, textComponent);
                assert (font != null) : "Null font";
                if (hViewFirst == null) {
                    groupStartIndex = i;
                    hViewFirst = (HighlightsView)view;
                    fontFirst = font;
                    foreColorFirst = foreColor;
                    backColorFirst = backColor;
                } else if (!font.equals(fontFirst)) {
                    HighlightsViewUtils.fixLayoutViewGroup(pView, docView, groupStartIndex, i, hViewFirst, docText, fontFirst, foreColorFirst, backColorFirst);
                    groupStartIndex = i;
                    hViewFirst = (HighlightsView)view;
                    fontFirst = font;
                    foreColorFirst = foreColor;
                    backColorFirst = backColor;
                }
            } else if (hViewFirst != null) {
                HighlightsViewUtils.fixLayoutViewGroup(pView, docView, groupStartIndex, i, hViewFirst, docText, fontFirst, foreColorFirst, backColorFirst);
                groupStartIndex = -1;
                hViewFirst = null;
            }
            if (i < visualUpdate.endVisualIndex || hViewFirst != null || i + 1 < viewCount && (view = boxView.getEditorView(i + 1)) instanceof HighlightsView && (layout = ((HighlightsView)view).layoutRaw()) instanceof TextLayoutPart && ((TextLayoutPart)layout).index() != 0) continue;
            visualUpdate.endVisualIndex = i;
            return;
        }
        if (hViewFirst != null) {
            assert (i == viewCount);
            HighlightsViewUtils.fixLayoutViewGroup(pView, docView, groupStartIndex, i, hViewFirst, docText, fontFirst, foreColorFirst, backColorFirst);
        }
        visualUpdate.endVisualIndex = viewCount;
    }

    private static void fixLayoutViewGroup(ParagraphView pView, DocumentView docView, int groupStartIndex, int groupEndIndex, HighlightsView hViewFirst, CharSequence docText, Font fontFirst, Color foreColorFirst, Color backColorFirst) {
        int startOffset = hViewFirst.getStartOffset();
        int groupLength = groupEndIndex - groupStartIndex;
        assert (groupLength > 0) : "groupLength=" + groupLength;
        int textLength = groupLength == 1 ? hViewFirst.getLength() : ((View)pView.getEditorView(groupEndIndex - 1)).getEndOffset() - startOffset;
        String text = ((Object)docText.subSequence(startOffset, startOffset + textLength)).toString();
        TextLayout textLayout = docView.createTextLayout(text, fontFirst);
        if (groupLength == 1) {
            hViewFirst.setLayout(textLayout);
        } else {
            TextLayoutWrapper wrapper = new TextLayoutWrapper(textLayout, groupLength, foreColorFirst, backColorFirst);
            TextLayoutPart textLayoutPart = new TextLayoutPart(wrapper, 0, 0, null, null);
            hViewFirst.setLayout(textLayoutPart);
            int len = hViewFirst.getLength();
            JTextComponent textComponent = docView.getTextComponent();
            float lastX = 0.0f;
            for (int i = groupStartIndex + 1; i < groupEndIndex; ++i) {
                float x;
                Color backColor;
                HighlightsView view = (HighlightsView)pView.getEditorView(i);
                AttributeSet attrs = view.getAttributes();
                Color foreColor = HighlightsViewUtils.validForeColor(attrs, textComponent);
                if (HighlightsViewUtils.colorsEqual(foreColor, foreColorFirst)) {
                    foreColor = null;
                }
                if (HighlightsViewUtils.colorsEqual(backColor = HighlightsViewUtils.validBackColor(attrs, textComponent), backColorFirst)) {
                    backColor = null;
                }
                if ((x = TextLayoutUtils.index2X(textLayout, len)) < lastX) {
                    pView.markRTL();
                }
                textLayoutPart = new TextLayoutPart(wrapper, i - groupStartIndex, len, foreColor, backColor);
                view.setLayout(textLayoutPart);
                len += view.getLength();
            }
        }
    }

    static String findLayoutIntegrityError(EditorBoxView boxView) {
        String err = null;
        int viewCount = boxView.getViewCount();
        int partCount = -1;
        int lastPartIndex = -1;
        for (int i = 0; i < viewCount; ++i) {
            Object child = boxView.getEditorView(i);
            if (child instanceof HighlightsView) {
                Object layout = ((HighlightsView)child).layoutRaw();
                if (layout instanceof TextLayoutPart) {
                    TextLayoutPart part = (TextLayoutPart)layout;
                    if (partCount != -1) {
                        if (part.index() != ++lastPartIndex) {
                            err = "part.index()=" + part.index() + " != (lastPartIndex+1)=" + lastPartIndex;
                        }
                        if (lastPartIndex == part.viewCount() - 1) {
                            partCount = -1;
                        }
                    } else {
                        partCount = part.viewCount();
                        if (partCount <= 1) {
                            err = "partCount=" + partCount + " <= 1";
                        }
                        if (err == null && part.index() != 0) {
                            err = "part.index()=" + part.index() + " != 0";
                        }
                        lastPartIndex = 0;
                    }
                } else if (partCount != -1) {
                    err = "HV: Unterminated layout parts: partCount=" + partCount;
                }
            } else if (partCount != -1) {
                err = "Non-HV: Unterminated layout parts: partCount=" + partCount;
            }
            if (err == null) continue;
            err = "=" + boxView.getDumpId() + "[" + i + "]=" + ((EditorView)child).getDumpId() + ": " + err;
            break;
        }
        return err;
    }

    static Shape indexToView(TextLayout textLayout, Rectangle2D textLayoutBounds, int index, Position.Bias bias, int maxIndex, Shape alloc) {
        TextHitInfo endHit;
        TextHitInfo startHit;
        if (textLayout == null) {
            return alloc;
        }
        assert (textLayout.getCharacterCount() >= maxIndex) : "textLayout.getCharacterCount()=" + textLayout.getCharacterCount() + " < maxIndex=" + maxIndex;
        int charIndex = Math.min(index, maxIndex);
        charIndex = Math.max(charIndex, 0);
        if (bias == Position.Bias.Forward) {
            startHit = TextHitInfo.leading(charIndex);
            endHit = TextHitInfo.trailing(charIndex);
        } else {
            startHit = TextHitInfo.trailing(charIndex - 1);
            endHit = TextHitInfo.trailing(charIndex);
        }
        if (textLayoutBounds == null) {
            textLayoutBounds = ViewUtils.shapeAsRect(alloc);
        }
        return TextLayoutUtils.getRealAlloc(textLayout, textLayoutBounds, startHit, endHit);
    }

    static int viewToIndex(TextLayout textLayout, double x, Shape alloc, Position.Bias[] biasReturn) {
        Rectangle2D bounds = ViewUtils.shapeAsRect(alloc);
        TextHitInfo hitInfo = HighlightsViewUtils.x2Index(textLayout, (float)(x - bounds.getX()));
        if (biasReturn != null) {
            biasReturn[0] = hitInfo.isLeadingEdge() ? Position.Bias.Forward : Position.Bias.Backward;
        }
        return hitInfo.getInsertionIndex();
    }

    static TextHitInfo x2Index(TextLayout textLayout, float x) {
        TextHitInfo hit = textLayout.hitTestChar(x, 0.0f);
        if (!hit.isLeadingEdge()) {
            hit = TextHitInfo.leading(hit.getInsertionIndex());
        }
        return hit;
    }

    static int getNextVisualPosition(int offset, Position.Bias bias, Shape alloc, int direction, Position.Bias[] biasRet, TextLayout textLayout, int textLayoutOffset, int viewStartOffset, int viewLength, DocumentView docView) {
        int retOffset = -1;
        boolean viewIsLeftToRight = false;
        switch (direction) {
            case 3: {
                if (offset == -1) {
                    if (viewIsLeftToRight) {
                        biasRet[0] = Position.Bias.Forward;
                        return viewStartOffset;
                    }
                    biasRet[0] = Position.Bias.Backward;
                    return viewStartOffset + viewLength;
                }
                TextHitInfo currentHit = bias == Position.Bias.Forward ? TextHitInfo.afterOffset(offset - viewStartOffset) : TextHitInfo.beforeOffset(offset - viewStartOffset);
                TextHitInfo nextHit = textLayout.getNextRightHit(currentHit);
                if (nextHit == null) break;
                if (viewIsLeftToRight != textLayout.isLeftToRight()) {
                    nextHit = textLayout.getVisualOtherHit(nextHit);
                }
                biasRet[0] = nextHit.getInsertionIndex() == viewLength ? Position.Bias.Backward : Position.Bias.Forward;
                retOffset = viewStartOffset + nextHit.getInsertionIndex();
                break;
            }
            case 7: {
                if (offset == -1) {
                    if (viewIsLeftToRight) {
                        biasRet[0] = Position.Bias.Backward;
                        return viewStartOffset + viewLength;
                    }
                    biasRet[0] = Position.Bias.Forward;
                    return viewStartOffset;
                }
                TextHitInfo currentHit = bias == Position.Bias.Forward ? TextHitInfo.afterOffset(offset - viewStartOffset) : TextHitInfo.beforeOffset(offset - viewStartOffset);
                TextHitInfo nextHit = textLayout.getNextLeftHit(currentHit);
                if (nextHit == null) break;
                if (viewIsLeftToRight != textLayout.isLeftToRight()) {
                    nextHit = textLayout.getVisualOtherHit(nextHit);
                }
                if (nextHit.getInsertionIndex() == viewLength) {
                    biasRet[0] = Position.Bias.Backward;
                    break;
                }
                biasRet[0] = Position.Bias.Forward;
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return retOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void paint(Graphics2D g, Shape alloc, Rectangle clipBounds, HighlightsView view, TextLayout textLayout, int shift, int len) {
        Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds(alloc);
        DocumentView docView = view.getDocumentView();
        if (docView != null && allocBounds.intersects(clipBounds) && docView != null) {
            PaintState paintState = PaintState.save(g);
            try {
                AttributeSet attrs = view.getAttributes();
                HighlightsViewUtils.paintBackground(g, allocBounds, attrs, docView);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest(view.getDumpId() + ":paint-bkg: " + ViewUtils.toString(g.getColor()) + ", bounds=" + ViewUtils.toString(allocBounds) + '\n');
                }
                if (textLayout != null) {
                    HighlightsViewUtils.paintForeground(g, allocBounds, textLayout, attrs, docView);
                    if (LOG.isLoggable(Level.FINEST)) {
                        int startOffset = view.getStartOffset() + shift;
                        Document doc = docView.getDocument();
                        CharSequence text = DocumentUtilities.getText((Document)doc).subSequence(startOffset, startOffset + len);
                        LOG.finest(view.getDumpId() + ":paint-txt: \"" + CharSequenceUtilities.debugText((CharSequence)text) + "\", XY[" + ViewUtils.toStringPrec1(allocBounds.getX()) + ";" + ViewUtils.toStringPrec1(allocBounds.getY()) + "(B" + ViewUtils.toStringPrec1(docView.getDefaultAscent()) + ")], color=" + ViewUtils.toString(g.getColor()) + '\n');
                    }
                }
            }
            finally {
                paintState.restore();
            }
        }
    }

    static void paintBackground(Graphics2D g, Shape alloc, AttributeSet attrs, DocumentView docView) {
        Rectangle2D allocBounds = ViewUtils.shapeAsRect(alloc);
        JTextComponent textComponent = docView.getTextComponent();
        Color componentBackground = textComponent.getBackground();
        ViewUtils.applyBackgroundAttributes(attrs, componentBackground, g);
        if (!componentBackground.equals(g.getColor())) {
            g.fill(alloc);
        }
        HighlightsViewUtils.paintBackgroundExtras(g, allocBounds, attrs, docView);
    }

    static void partPaintBackground(Graphics2D g, Shape alloc, TextLayoutPart textLayoutPart, Shape textLayoutAlloc, AttributeSet attrs, DocumentView docView) {
        Rectangle2D allocBounds = ViewUtils.shapeAsRect(alloc);
        JTextComponent textComponent = docView.getTextComponent();
        Color componentBackground = textComponent.getBackground();
        ViewUtils.applyBackgroundAttributes(attrs, componentBackground, g);
        if (!componentBackground.equals(g.getColor()) || textLayoutPart.foreground() != null) {
            g.fill(alloc);
        }
        HighlightsViewUtils.paintBackgroundExtras(g, allocBounds, attrs, docView);
    }

    static void paintBackgroundExtras(Graphics2D g, Rectangle2D allocBounds, AttributeSet attrs, DocumentView docView) {
        if (attrs != null) {
            Color underlineColor;
            Object underlineValue;
            Color waveUnderlineColor;
            int lineX;
            int xInt = (int)allocBounds.getX();
            int yInt = (int)allocBounds.getY();
            int endXInt = (int)(allocBounds.getX() + allocBounds.getWidth() - 1.0);
            int endYInt = (int)(allocBounds.getY() + allocBounds.getHeight() - 1.0);
            Color leftBorderLineColor = (Color)attrs.getAttribute(EditorStyleConstants.LeftBorderLineColor);
            Color rightBorderLineColor = (Color)attrs.getAttribute(EditorStyleConstants.RightBorderLineColor);
            Color topBorderLineColor = (Color)attrs.getAttribute(EditorStyleConstants.TopBorderLineColor);
            Color bottomBorderLineColor = (Color)attrs.getAttribute(EditorStyleConstants.BottomBorderLineColor);
            Color textLimitLineColor = docView.getTextLimitLineColor();
            boolean drawTextLimitLine = docView.isTextLimitLineDrawn();
            int textLimitWidth = docView.getTextLimitWidth();
            float defaultCharWidth = docView.getDefaultCharWidth();
            if (drawTextLimitLine && textLimitWidth > 0 && (lineX = (int)((float)textLimitWidth * defaultCharWidth)) >= xInt && lineX <= endXInt) {
                g.setColor(textLimitLineColor);
                g.drawLine(lineX, yInt, lineX, endYInt);
            }
            if (leftBorderLineColor != null) {
                g.setColor(leftBorderLineColor);
                g.drawLine(xInt, yInt, xInt, endYInt);
            }
            if (rightBorderLineColor != null) {
                g.setColor(rightBorderLineColor);
                g.drawLine(endXInt, yInt, endXInt, endYInt);
            }
            if (topBorderLineColor != null) {
                g.setColor(topBorderLineColor);
                g.drawLine(xInt, yInt, endXInt, yInt);
            }
            if (bottomBorderLineColor != null) {
                g.setColor(bottomBorderLineColor);
                g.drawLine(xInt, endYInt, endXInt, endYInt);
            }
            if ((waveUnderlineColor = (Color)attrs.getAttribute(EditorStyleConstants.WaveUnderlineColor)) != null && bottomBorderLineColor == null) {
                g.setColor(waveUnderlineColor);
                float ascent = docView.getDefaultAscent();
                Font font = ViewUtils.getFont(attrs, docView.getTextComponent().getFont());
                float[] underlineAndStrike = docView.getUnderlineAndStrike(font);
                int y = (int)(allocBounds.getY() + (double)underlineAndStrike[0] + (double)ascent + 0.5);
                int wavePixelCount = (int)allocBounds.getWidth() + 1;
                if (wavePixelCount > 0) {
                    int[] waveForm = new int[]{0, 0, -1, -1};
                    int[] xArray = new int[wavePixelCount];
                    int[] yArray = new int[wavePixelCount];
                    int waveFormIndex = xInt % 4;
                    for (int i = 0; i < wavePixelCount; ++i) {
                        xArray[i] = xInt + i;
                        yArray[i] = y + waveForm[waveFormIndex];
                        ++waveFormIndex;
                        waveFormIndex &= 3;
                    }
                    g.drawPolyline(xArray, yArray, wavePixelCount - 1);
                }
            }
            if ((underlineValue = attrs.getAttribute(StyleConstants.Underline)) != null && (underlineColor = underlineValue instanceof Boolean ? (Boolean.TRUE.equals(underlineValue) ? docView.getTextComponent().getForeground() : null) : (Color)underlineValue) != null) {
                g.setColor(underlineColor);
                Font font = ViewUtils.getFont(attrs, docView.getTextComponent().getFont());
                float[] underlineAndStrike = docView.getUnderlineAndStrike(font);
                g.fillRect((int)allocBounds.getX(), (int)(allocBounds.getY() + (double)docView.getDefaultAscent() + (double)underlineAndStrike[0]), (int)allocBounds.getWidth(), Math.max(1, Math.round(underlineAndStrike[1])));
            }
        }
    }

    static void paintForeground(Graphics2D g, Shape alloc, TextLayout textLayout, AttributeSet attrs, DocumentView docView) {
        Color strikeThroughColor;
        Object strikeThroughValue;
        JTextComponent textComponent = docView.getTextComponent();
        ViewUtils.applyForegroundAttributes(attrs, textComponent.getFont(), textComponent.getForeground(), g);
        Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds(alloc);
        HighlightsViewUtils.paintTextLayout(g, allocBounds, textLayout, docView);
        if (attrs != null && (strikeThroughValue = attrs.getAttribute(StyleConstants.StrikeThrough)) != null && (strikeThroughColor = strikeThroughValue instanceof Boolean ? (Boolean.TRUE.equals(strikeThroughValue) ? textComponent.getForeground() : null) : (Color)strikeThroughValue) != null) {
            g.setColor(strikeThroughColor);
            Font font = ViewUtils.getFont(attrs, docView.getTextComponent().getFont());
            float[] underlineAndStrike = docView.getUnderlineAndStrike(font);
            g.fillRect((int)allocBounds.getX(), (int)(allocBounds.getY() + (double)docView.getDefaultAscent() + (double)underlineAndStrike[2]), (int)Math.abs(TextLayoutUtils.getWidth(textLayout)), Math.max(1, Math.round(underlineAndStrike[3])));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void partPaintForeground(Graphics2D g, Shape alloc, TextLayoutPart textLayoutPart, Shape textLayoutAlloc, AttributeSet attrs, DocumentView docView) {
        if (attrs == null) {
            return;
        }
        JTextComponent textComponent = docView.getTextComponent();
        Color origColor = null;
        try {
            Object strikeThroughValue;
            if (textLayoutPart.foreground() != null) {
                origColor = g.getColor();
                Shape origClip = g.getClip();
                g.clip(alloc);
                g.setColor(textLayoutPart.foreground());
                Rectangle2D textLayoutBounds = ViewUtils.shapeAsRect(textLayoutAlloc);
                TextLayout textLayout = textLayoutPart.textLayout();
                float x = (float)textLayoutBounds.getX();
                float ascentedY = (float)(textLayoutBounds.getY() + (double)docView.getDefaultAscent());
                textLayout.draw(g, x, ascentedY);
                g.setClip(origClip);
            }
            if (attrs != null && (strikeThroughValue = attrs.getAttribute(StyleConstants.StrikeThrough)) != null) {
                Color strikeThroughColor = null;
                if (strikeThroughValue instanceof Boolean) {
                    if (Boolean.TRUE.equals(strikeThroughValue) && (strikeThroughColor = textLayoutPart.foreground()) == null) {
                        strikeThroughColor = textComponent.getForeground();
                    }
                } else {
                    strikeThroughColor = (Color)strikeThroughValue;
                }
                if (strikeThroughColor != null) {
                    if (origColor == null) {
                        origColor = g.getColor();
                    }
                    Rectangle2D allocBounds = ViewUtils.shapeAsRect(alloc);
                    g.setColor(strikeThroughColor);
                    Font font = ViewUtils.getFont(attrs, docView.getTextComponent().getFont());
                    float[] underlineAndStrike = docView.getUnderlineAndStrike(font);
                    g.fillRect((int)allocBounds.getX(), (int)(allocBounds.getY() + (double)docView.getDefaultAscent() + (double)underlineAndStrike[2]), (int)allocBounds.getWidth(), Math.max(1, Math.round(underlineAndStrike[3])));
                }
            }
        }
        finally {
            if (origColor == null) {
                g.setColor(origColor);
            }
        }
    }

    static void paintTextLayout(Graphics2D g, Rectangle2D bounds, TextLayout textLayout, DocumentView docView) {
        float x = (float)bounds.getX();
        float ascentedY = (float)(bounds.getY() + (double)docView.getDefaultAscent());
        textLayout.draw(g, x, ascentedY);
    }

    static View breakView(int axis, int breakPartStartOffset, float x, float len, HighlightsView fullView, int partShift, int partLength, TextLayout textLayout, int textLayoutIndex) {
        DocumentView docView;
        if (axis == 0 && (docView = fullView.getDocumentView()) != null && textLayout != null && partLength > 1) {
            boolean breakFailed;
            float breakCharIndexX;
            int fullViewStartOffset = fullView.getStartOffset();
            int partStartOffset = fullViewStartOffset + partShift;
            if (breakPartStartOffset - partStartOffset < 0 || breakPartStartOffset - partStartOffset > partLength) {
                throw new IllegalArgumentException("offset=" + breakPartStartOffset + "partStartOffset=" + partStartOffset + ", partLength=" + partLength);
            }
            int breakCharIndex = breakPartStartOffset - partStartOffset;
            assert (breakCharIndex >= 0);
            if (breakCharIndex != 0) {
                TextHitInfo hit = TextHitInfo.afterOffset(textLayoutIndex + breakCharIndex);
                float[] locs = textLayout.getCaretInfo(hit);
                breakCharIndexX = locs[0];
            } else {
                breakCharIndexX = 0.0f;
            }
            TextHitInfo hitInfo = HighlightsViewUtils.x2Index(textLayout, breakCharIndexX + len);
            int breakPartEndOffset = partStartOffset + hitInfo.getCharIndex();
            if (docView.getLineWrapType() == DocumentView.LineWrapType.WORD_BOUND) {
                CharSequence docText = DocumentUtilities.getText((Document)docView.getDocument());
                if (breakPartEndOffset > breakPartStartOffset) {
                    boolean searchNonLetterForward = false;
                    char ch = docText.charAt(breakPartEndOffset - 1);
                    if (Character.isLetterOrDigit(ch) && breakPartEndOffset < docText.length() && Character.isLetterOrDigit(docText.charAt(breakPartEndOffset))) {
                        int offset;
                        for (offset = breakPartEndOffset - 1; offset >= breakPartStartOffset && Character.isLetterOrDigit(docText.charAt(offset)); --offset) {
                        }
                        if (++offset == breakPartStartOffset) {
                            searchNonLetterForward = true;
                        } else {
                            breakPartEndOffset = offset;
                        }
                    }
                    if (searchNonLetterForward) {
                        ++breakPartEndOffset;
                        while (breakPartEndOffset < partStartOffset + partLength && Character.isLetterOrDigit(docText.charAt(breakPartEndOffset))) {
                            ++breakPartEndOffset;
                        }
                    }
                }
            }
            boolean bl = breakFailed = breakPartEndOffset - breakPartStartOffset == 0 || breakPartEndOffset - breakPartStartOffset >= partLength;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("HV.breakView(): <" + partStartOffset + "," + (partStartOffset + partLength) + "> => <" + breakPartStartOffset + "," + (partStartOffset + breakPartEndOffset) + ">, x=" + x + ", len=" + len + ", textLayoutIndex=" + textLayoutIndex + ", charIndexX=" + breakCharIndexX + "\n");
            }
            if (breakFailed) {
                return null;
            }
            return new HighlightsViewPart(fullView, breakPartStartOffset - fullViewStartOffset, breakPartEndOffset - breakPartStartOffset);
        }
        return null;
    }
}

