/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.options;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbPreferences;

public class MavenSettings {
    public static final String PROP_DEFAULT_OPTIONS = "defaultOptions";
    public static final String PROP_SYNCH_PROXY = "synchronizeProxySettings";
    public static final String PROP_COMMANDLINE_PATH = "commandLineMavenPath";
    public static final String PROP_SHOW_RUN_DIALOG = "showRunDialog";
    public static final String PROP_SOURCE_DOWNLOAD = "sourceDownload";
    public static final String PROP_JAVADOC_DOWNLOAD = "javadocDownload";
    public static final String PROP_BINARY_DOWNLOAD = "binaryDownload";
    public static final String PROP_LAST_ARCHETYPE_GROUPID = "lastArchetypeGroupId";
    public static final String PROP_CUSTOM_LOCAL_REPOSITORY = "localRepository";
    public static final String PROP_SKIP_TESTS = "skipTests";
    public static final String PROP_MAVEN_RUNTIMES = "mavenRuntimes";
    private static final String PROP_DEBUG = "showDebug";
    private static final String PROP_ERRORS = "showErrors";
    private static final String PROP_CHECKSUM_POLICY = "checksumPolicy";
    private static final String PROP_PLUGIN_POLICY = "pluginUpdatePolicy";
    private static final String PROP_FAILURE_BEHAVIOUR = "failureBehaviour";
    private static final String PROP_USE_REGISTRY = "usePluginRegistry";
    private static final MavenSettings INSTANCE = new MavenSettings();

    public static MavenSettings getDefault() {
        return INSTANCE;
    }

    public boolean isInteractive() {
        return !this.hasOption("--batch", "-B");
    }

    public Boolean isOffline() {
        if (this.hasOption("--offline", "-o")) {
            return Boolean.TRUE;
        }
        return null;
    }

    public boolean isShowDebug() {
        return this.hasOption("--debug", "-X");
    }

    public boolean isShowErrors() {
        return this.hasOption("--errors", "-e");
    }

    public boolean isUpdateSnapshots() {
        return this.hasOption("--update-snapshots", "-U");
    }

    public boolean hasOption(String longName, String shortName) {
        String defOpts = this.getDefaultOptions();
        if (defOpts != null) {
            try {
                String[] strs;
                for (String s : strs = CommandLineUtils.translateCommandline((String)defOpts)) {
                    if (!(s = s.trim()).startsWith(shortName) && !s.startsWith(longName)) continue;
                    return true;
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MavenSettings.class.getName()).fine("Error parsing global options:" + defOpts);
                return defOpts.contains(longName) || defOpts.contains(shortName);
            }
        }
        return false;
    }

    protected final Preferences getPreferences() {
        return NbPreferences.forModule(MavenSettings.class);
    }

    protected final String putProperty(String key, String value) {
        String retval = this.getProperty(key);
        if (value != null) {
            this.getPreferences().put(key, value);
        } else {
            this.getPreferences().remove(key);
        }
        return retval;
    }

    protected final String getProperty(String key) {
        return this.getPreferences().get(key, null);
    }

    private MavenSettings() {
        String defOpts = this.getPreferences().get(PROP_DEFAULT_OPTIONS, null);
        if (defOpts == null) {
            String registry;
            String pluginUpdate;
            String fail;
            String checksum;
            String error;
            defOpts = "";
            String debug = this.getPreferences().get(PROP_DEBUG, null);
            if (debug != null) {
                boolean val = Boolean.parseBoolean(debug);
                if (val) {
                    defOpts = defOpts + " --debug";
                }
                this.getPreferences().remove(PROP_DEBUG);
            }
            if ((error = this.getPreferences().get(PROP_ERRORS, null)) != null) {
                boolean val = Boolean.parseBoolean(error);
                if (val) {
                    defOpts = defOpts + " --errors";
                }
                this.getPreferences().remove(PROP_ERRORS);
            }
            if ((checksum = this.getPreferences().get(PROP_CHECKSUM_POLICY, null)) != null) {
                if ("fail".equals(checksum)) {
                    defOpts = defOpts + " --strict-checksums";
                } else if ("warn".equals(checksum)) {
                    defOpts = defOpts + " --lax-checksums";
                }
                this.getPreferences().remove(PROP_CHECKSUM_POLICY);
            }
            if ((fail = this.getPreferences().get(PROP_FAILURE_BEHAVIOUR, null)) != null) {
                if ("FAIL_NEVER".equals(fail)) {
                    defOpts = defOpts + " --fail-never";
                } else if ("FAIL_FAST".equals(fail)) {
                    defOpts = defOpts + " --fail-fast";
                } else if ("FAIL_AT_END".equals(fail)) {
                    defOpts = defOpts + " --fail-at-end";
                }
                this.getPreferences().remove(PROP_FAILURE_BEHAVIOUR);
            }
            if ((pluginUpdate = this.getPreferences().get(PROP_PLUGIN_POLICY, null)) != null) {
                defOpts = Boolean.parseBoolean(pluginUpdate) ? defOpts + " --check-plugin-updates" : defOpts + " --no-plugin-updates";
                this.getPreferences().remove(PROP_PLUGIN_POLICY);
            }
            if ((registry = this.getPreferences().get(PROP_USE_REGISTRY, null)) != null) {
                if (!Boolean.parseBoolean(registry)) {
                    defOpts = defOpts + " --no-plugin-registry";
                }
                this.getPreferences().remove(PROP_USE_REGISTRY);
            }
            this.setDefaultOptions(defOpts);
            try {
                this.getPreferences().flush();
            }
            catch (BackingStoreException ex) {
                // empty catch block
            }
        }
    }

    public String getDefaultOptions() {
        return this.getPreferences().get(PROP_DEFAULT_OPTIONS, "");
    }

    public void setDefaultOptions(String options) {
        this.putProperty(PROP_DEFAULT_OPTIONS, options);
    }

    public String getLastArchetypeGroupId() {
        return this.getPreferences().get(PROP_LAST_ARCHETYPE_GROUPID, Boolean.getBoolean("netbeans.full.hack") ? "test" : "com.mycompany");
    }

    public void setLastArchetypeGroupId(String groupId) {
        this.putProperty(PROP_LAST_ARCHETYPE_GROUPID, groupId);
    }

    public void setSynchronizeProxy(boolean sync) {
        this.getPreferences().putBoolean(PROP_SYNCH_PROXY, sync);
    }

    public boolean isSynchronizeProxy() {
        return this.getPreferences().getBoolean(PROP_SYNCH_PROXY, true);
    }

    public void setCustomLocalRepository(String text) {
        if (text != null && text.trim().length() == 0) {
            text = null;
        }
        String oldText = this.getCustomLocalRepository();
        this.putProperty(PROP_CUSTOM_LOCAL_REPOSITORY, text);
        if (!StringUtils.equals((String)oldText, (String)text)) {
            EmbedderFactory.resetProjectEmbedder();
        }
    }

    public String getCustomLocalRepository() {
        return this.getPreferences().get(PROP_CUSTOM_LOCAL_REPOSITORY, null);
    }

    public static File getDefaultMavenHome() {
        return InstalledFileLocator.getDefault().locate("maven", "org.netbeans.modules.maven.embedder", false);
    }

    public File getMavenHome() {
        String str = this.getPreferences().get(PROP_COMMANDLINE_PATH, null);
        if (str != null) {
            return FileUtil.normalizeFile((File)new File(str));
        }
        return MavenSettings.getDefaultMavenHome();
    }

    public void setMavenHome(File path) {
        if (path == null || path.equals(MavenSettings.getDefaultMavenHome())) {
            this.getPreferences().remove(PROP_COMMANDLINE_PATH);
        } else {
            this.putProperty(PROP_COMMANDLINE_PATH, FileUtil.normalizeFile((File)path).getAbsolutePath());
        }
    }

    public boolean isShowRunDialog() {
        return this.getPreferences().getBoolean(PROP_SHOW_RUN_DIALOG, false);
    }

    public void setShowRunDialog(boolean b) {
        this.getPreferences().putBoolean(PROP_SHOW_RUN_DIALOG, b);
    }

    public boolean isSkipTests() {
        return this.getPreferences().getBoolean(PROP_SKIP_TESTS, false);
    }

    public void setSkipTests(boolean skipped) {
        this.getPreferences().putBoolean(PROP_SKIP_TESTS, skipped);
    }

    public DownloadStrategy getSourceDownloadStrategy() {
        String val = this.getPreferences().get(PROP_SOURCE_DOWNLOAD, DownloadStrategy.NEVER.name());
        try {
            return DownloadStrategy.valueOf(val);
        }
        catch (IllegalArgumentException ex) {
            return DownloadStrategy.NEVER;
        }
    }

    public void setSourceDownloadStrategy(DownloadStrategy ds) {
        if (ds != null) {
            this.getPreferences().put(PROP_SOURCE_DOWNLOAD, ds.name());
        } else {
            this.getPreferences().remove(PROP_SOURCE_DOWNLOAD);
        }
    }

    public DownloadStrategy getJavadocDownloadStrategy() {
        String val = this.getPreferences().get(PROP_JAVADOC_DOWNLOAD, DownloadStrategy.NEVER.name());
        try {
            return DownloadStrategy.valueOf(val);
        }
        catch (IllegalArgumentException ex) {
            return DownloadStrategy.NEVER;
        }
    }

    public void setJavadocDownloadStrategy(DownloadStrategy ds) {
        if (ds != null) {
            this.getPreferences().put(PROP_JAVADOC_DOWNLOAD, ds.name());
        } else {
            this.getPreferences().remove(PROP_JAVADOC_DOWNLOAD);
        }
    }

    public DownloadStrategy getBinaryDownloadStrategy() {
        String val = this.getPreferences().get(PROP_BINARY_DOWNLOAD, DownloadStrategy.NEVER.name());
        try {
            return DownloadStrategy.valueOf(val);
        }
        catch (IllegalArgumentException ex) {
            return DownloadStrategy.NEVER;
        }
    }

    public void setBinaryDownloadStrategy(DownloadStrategy ds) {
        if (ds != null) {
            this.getPreferences().put(PROP_BINARY_DOWNLOAD, ds.name());
        } else {
            this.getPreferences().remove(PROP_BINARY_DOWNLOAD);
        }
    }

    public static String getCommandLineMavenVersion() {
        return MavenSettings.getCommandLineMavenVersion(MavenSettings.getDefault().getMavenHome());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCommandLineMavenVersion(File mavenHome) {
        File[] jars = new File(mavenHome, "lib").listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (jars == null) {
            return null;
        }
        for (File jar : jars) {
            String string;
            FileObject entry = URLMapper.findFileObject((URL)new URL(FileUtil.urlForArchiveOrDir((File)jar), "META-INF/maven/org.apache.maven/maven-core/pom.properties"));
            if (entry == null) continue;
            InputStream is = entry.getInputStream();
            try {
                Properties properties = new Properties();
                properties.load(is);
                string = properties.getProperty("version");
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException x) {
                    // empty catch block
                }
            }
            is.close();
            return string;
        }
        return null;
    }

    private static List<String> searchMavenRuntimes(String[] paths, boolean stopOnFirstValid) {
        ArrayList<String> runtimes = new ArrayList<String>();
        for (String path : paths) {
            File file = new File(path);
            String version = MavenSettings.getCommandLineMavenVersion(new File(path = FileUtil.normalizeFile((File)file).getAbsolutePath()));
            if (version == null) continue;
            runtimes.add(path);
            if (stopOnFirstValid) break;
        }
        return runtimes;
    }

    public static String getDefaultExternalMavenRuntime() {
        List<String> runtimes;
        String paths = System.getenv("PATH");
        String mavenHome = System.getenv("MAVEN_HOME");
        String m2Home = System.getenv("M2_HOME");
        ArrayList<String> mavenEnvDirs = new ArrayList<String>();
        if (mavenHome != null) {
            mavenEnvDirs.add(mavenHome);
        }
        if (m2Home != null) {
            mavenEnvDirs.add(m2Home);
        }
        if (paths != null) {
            for (String path : paths.split(File.pathSeparator)) {
                if (!path.endsWith("bin")) continue;
                mavenEnvDirs.add(path.substring(0, path.length() - "bin".length() - File.pathSeparator.length()));
            }
        }
        return !(runtimes = MavenSettings.searchMavenRuntimes(mavenEnvDirs.toArray(new String[0]), true)).isEmpty() ? runtimes.get(0) : null;
    }

    public List<String> getUserDefinedMavenRuntimes() {
        ArrayList<String> runtimes = new ArrayList<String>();
        String defaultRuntimePath = MavenSettings.getDefaultExternalMavenRuntime();
        String runtimesPref = this.getPreferences().get(PROP_MAVEN_RUNTIMES, null);
        if (runtimesPref != null) {
            for (String runtimePath : runtimesPref.split(File.pathSeparator)) {
                if ("".equals(runtimePath) || runtimePath.equals(defaultRuntimePath)) continue;
                runtimes.add(runtimePath);
            }
        }
        return Collections.unmodifiableList(runtimes);
    }

    public void setMavenRuntimes(List<String> runtimes) {
        if (runtimes == null) {
            this.getPreferences().remove(PROP_MAVEN_RUNTIMES);
        } else {
            String runtimesPref = "";
            for (String path : runtimes) {
                runtimesPref = runtimesPref + path + File.pathSeparator;
            }
            if (runtimesPref.endsWith(File.pathSeparator)) {
                runtimesPref = runtimesPref.substring(0, runtimesPref.length() - 1);
            }
            this.putProperty(PROP_MAVEN_RUNTIMES, runtimesPref);
        }
    }

    public static enum DownloadStrategy {
        NEVER,
        FIRST_OPEN,
        EVERY_OPEN;

    }
}

