/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

public class MavenProjectNode
extends AbstractNode {
    static final String BADGE_ICON = "org/netbeans/modules/maven/brokenProjectBadge.png";
    private static String toolTipBroken = "<img src=\"" + MavenProjectNode.class.getClassLoader().getResource("org/netbeans/modules/maven/brokenProjectBadge.png") + "\">&nbsp;" + NbBundle.getMessage(MavenProjectNode.class, (String)"ICON_BrokenProjectBadge");
    private NbMavenProjectImpl project;
    private ProjectInformation info;
    private ProblemReporterImpl reporter;

    public MavenProjectNode(Lookup lookup, NbMavenProjectImpl proj) {
        super(NodeFactorySupport.createCompositeChildren((Project)proj, (String)"Projects/org-netbeans-modules-maven/Nodes"), lookup);
        this.project = proj;
        this.info = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        NbMavenProject.addPropertyChangeListener(this.project, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("MavenProject".equals(event.getPropertyName())) {
                    MavenProjectNode.this.fireNameChange(null, MavenProjectNode.this.getName());
                    MavenProjectNode.this.fireDisplayNameChange(null, MavenProjectNode.this.getDisplayName());
                    MavenProjectNode.this.fireIconChange();
                }
            }
        });
        this.reporter = (ProblemReporterImpl)proj.getLookup().lookup(ProblemReporterImpl.class);
        this.reporter.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MavenProjectNode.this.fireIconChange();
                        MavenProjectNode.this.fireOpenedIconChange();
                        MavenProjectNode.this.fireNameChange(null, MavenProjectNode.this.getName());
                        MavenProjectNode.this.fireDisplayNameChange(null, MavenProjectNode.this.getDisplayName());
                        MavenProjectNode.this.fireShortDescriptionChange(null, MavenProjectNode.this.getShortDescription());
                    }
                });
            }
        });
    }

    public String getName() {
        return this.project.getName();
    }

    public String getDisplayName() {
        return this.project.getDisplayName();
    }

    public String getHtmlDisplayName() {
        String packaging = this.project.getOriginalMavenProject().getPackaging();
        if (NbMavenProjectImpl.getIconPath(packaging) != null) {
            return null;
        }
        try {
            return XMLUtil.toElementContent((String)this.getDisplayName()) + " <font color='!controlShadow'>" + packaging + "</font>";
        }
        catch (CharConversionException x) {
            return null;
        }
    }

    public Image getIcon(int param) {
        Image img = ImageUtilities.icon2Image((Icon)this.info.getIcon());
        if (this.reporter.getReports().size() > 0) {
            Image ann = ImageUtilities.loadImage((String)BADGE_ICON);
            ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipBroken);
            img = ImageUtilities.mergeImages((Image)img, (Image)ann, (int)8, (int)0);
        }
        return img;
    }

    public Image getOpenedIcon(int param) {
        Image img = ImageUtilities.icon2Image((Icon)this.info.getIcon());
        if (this.reporter.getReports().size() > 0) {
            Image ann = ImageUtilities.loadImage((String)BADGE_ICON);
            ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipBroken);
            img = ImageUtilities.mergeImages((Image)img, (Image)ann, (int)8, (int)0);
        }
        return img;
    }

    public Action[] getActions(boolean param) {
        return CommonProjectActions.forType((String)"org-netbeans-modules-maven");
    }

    public String getShortDescription() {
        StringBuffer buf = new StringBuffer();
        String desc = this.project.isErrorPom(this.project.getOriginalMavenProject()) ? NbBundle.getMessage(MavenProjectNode.class, (String)"TXT_FailedProjectLoadingDesc") : this.project.getShortDescription();
        buf.append("<html><i>").append(NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project1")).append("</i><b> ").append(FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory())).append("</b><br><i>");
        buf.append(NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project2")).append("</i><b> ").append(this.project.getOriginalMavenProject().getGroupId()).append("</b><br><i>");
        buf.append(NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project3")).append("</i><b> ").append(this.project.getOriginalMavenProject().getArtifactId()).append("</b><br><i>");
        buf.append(NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project4")).append("</i><b> ").append(this.project.getOriginalMavenProject().getVersion()).append("</b><br><i>");
        buf.append(NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project5")).append("</i><b> ").append(this.project.getOriginalMavenProject().getPackaging()).append("</b><br><i>");
        buf.append(NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project6")).append("</i> ").append(this.breakPerLine(desc, NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project5").length()));
        if (this.reporter.getReports().size() > 0) {
            buf.append("<br><b>").append(NbBundle.getMessage(MavenProjectNode.class, (String)"DESC_Project7")).append("</b><br><ul>");
            for (ProblemReport elem : this.reporter.getReports()) {
                buf.append("<li>" + elem.getShortDescription() + "</li>");
            }
            buf.append("</ul>");
        }
        return buf.toString();
    }

    private String breakPerLine(String string, int start) {
        StringBuffer buf = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(string, " ", true);
        int charCount = start;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if ((charCount += token.length()) > 50) {
                charCount = 0;
                buf.append("<br>");
            }
            buf.append(token);
        }
        return buf.toString();
    }
}

