/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api.customizer.support;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.openide.util.NbBundle;

public abstract class CheckBoxUpdater
implements ItemListener,
AncestorListener {
    private JCheckBox component;
    private boolean inherited = false;

    public CheckBoxUpdater(JCheckBox comp) {
        this.component = comp;
        this.component.addAncestorListener(this);
    }

    public abstract Boolean getValue();

    public abstract boolean getDefaultValue();

    public abstract void setValue(Boolean var1);

    private void setModelValue() {
        if (this.inherited) {
            this.inherited = false;
            this.component.setFont(this.component.getFont().deriveFont(1));
            this.component.setToolTipText(null);
        } else {
            this.component.setToolTipText(NbBundle.getMessage(CheckBoxUpdater.class, (String)"MSG_Value_Inherited"));
            this.inherited = true;
            this.component.setFont(this.component.getFont().deriveFont(0));
        }
        boolean val = this.component.isSelected();
        this.setValue(val == this.getDefaultValue() ? null : Boolean.valueOf(val));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setModelValue();
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.setCheckBoxValue(this.getValue(), this.getDefaultValue(), this.component);
        this.component.addItemListener(this);
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
        this.component.removeItemListener(this);
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    private void setCheckBoxValue(Boolean value, boolean defValue, JCheckBox component) {
        if (value != null) {
            component.setSelected(value);
            component.setToolTipText(null);
            this.inherited = false;
            component.setFont(component.getFont().deriveFont(1));
        } else {
            component.setSelected(defValue);
            component.setToolTipText(NbBundle.getMessage(CheckBoxUpdater.class, (String)"MSG_Value_Inherited"));
            this.inherited = true;
            component.setFont(component.getFont().deriveFont(0));
        }
    }
}

