/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import org.netbeans.modules.cnd.debugger.common2.debugger.remote.Platform;

public class GdbVersionPeculiarity {
    private final double version;
    private final Platform platform;
    private static final boolean DISABLE_PENDING = Boolean.getBoolean("gdb.breakpoints.pending.disabled");

    private GdbVersionPeculiarity(double version, Platform platform) {
        this.version = version;
        this.platform = platform;
    }

    public static GdbVersionPeculiarity create(double version, Platform platform) {
        return new GdbVersionPeculiarity(version, platform);
    }

    public String environmentDirectoryCommand() {
        if (this.version > 6.3 || this.platform == Platform.MacOSX_x86) {
            return "-environment-directory";
        }
        return "directory";
    }

    public String environmentCdCommand() {
        if (this.version > 6.3) {
            return "-environment-cd";
        }
        return "cd";
    }

    public String execAbortCommand() {
        if (this.version > 6.6) {
            return "-exec-abort";
        }
        return "kill";
    }

    public String breakPendingFlag() {
        if (!DISABLE_PENDING && (this.version >= 6.8 || this.platform == Platform.MacOSX_x86)) {
            return " -f";
        }
        return "";
    }

    public boolean isSupported() {
        return this.version >= 6.8 || this.platform == Platform.MacOSX_x86 && this.version >= 6.3;
    }
}

