/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.debugger.common2.debugger.Frame;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerImpl;
import org.netbeans.modules.cnd.debugger.gdb2.GdbLocal;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GdbFrame
extends Frame {
    private MITList MIframe;
    private final List<GdbLocal> argsArray = new ArrayList<GdbLocal>();
    private String fullname;

    public GdbFrame(GdbDebuggerImpl debugger, MIValue frame, MIResult frameargs) {
        super((NativeDebugger)debugger);
        MIValue fromv;
        MIValue linenov;
        if (frame == null) {
            return;
        }
        this.MIframe = frame.asTuple();
        if (this.MIframe == null) {
            return;
        }
        MIValue framenov = this.MIframe.valueOf("level");
        this.frameno = framenov != null ? framenov.asConst().value() : "";
        MIValue pcv = this.MIframe.valueOf("addr");
        this.pc = pcv != null ? pcv.asConst().value() : "";
        MIValue funcv = this.MIframe.valueOf("func");
        this.func = funcv != null ? funcv.asConst().value() : "";
        MITList args_list = (MITList)this.MIframe.valueOf("args");
        if (args_list != null && frameargs != null) {
            System.out.println("GdbFrame Impossible ");
        }
        this.lineno = (linenov = this.MIframe.valueOf("line")) != null ? linenov.asConst().value() : "";
        MIValue sourcev = this.MIframe.valueOf("file");
        this.source = sourcev != null ? sourcev.asConst().value() : ((fromv = this.MIframe.valueOf("from")) != null ? fromv.asConst().value() : "");
        MIValue fn = this.MIframe.valueOf("fullname");
        if (fn != null) {
            this.fullname = fn.asConst().value();
        }
        if (frameargs != null) {
            args_list = (MITList)frameargs.value().asTuple().valueOf("args");
        }
        if (args_list != null) {
            this.args = " (";
            if (debugger.getVerboseStack()) {
                int args_count = args_list.size();
                for (int vx = 0; vx < args_count; ++vx) {
                    MIValue arg = (MIValue)args_list.get(vx);
                    if (vx != 0) {
                        this.args = this.args + ", ";
                    }
                    this.args = this.args + arg.asTuple().valueOf("name").asConst().value();
                    MIValue value = arg.asTuple().valueOf("value");
                    if (value == null) continue;
                    this.argsArray.add(new GdbLocal(arg));
                    this.args = this.args + "=";
                    this.args = this.args + value.asConst().value();
                }
            }
            this.args = this.args + ")";
        }
        this.range_of_hidden = false;
        this.current = false;
        this.optimized = false;
        this.attr_user_call = false;
        this.attr_sig = 0;
        this.attr_signame = "";
    }

    public MITList getMIframe() {
        return this.MIframe;
    }

    public List<GdbLocal> getArgsList() {
        return this.argsArray;
    }

    public String getFullPath() {
        return this.debugger.remoteToLocal("Gdb frame", this.debugger.fmap().engineToWorld(this.fullname));
    }

    public String getEngineFullName() {
        return this.fullname;
    }

    void varUpdated(String name, String value) {
        for (GdbLocal var : this.argsArray) {
            if (!var.getName().equals(name)) continue;
            var.setValue(value);
        }
    }
}

