/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.swingapp;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.modules.form.ResourcePanel;
import org.netbeans.modules.form.ResourceService;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.properties.LocalePanel;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.Util;
import org.netbeans.modules.swingapp.AppFrameworkSupport;
import org.netbeans.modules.swingapp.DesignResourceMap;
import org.netbeans.modules.swingapp.ProxyAction;
import org.netbeans.modules.swingapp.ResourcePanelImpl;
import org.netbeans.modules.swingapp.ResourceUtils;
import org.netbeans.modules.swingapp.ResourceValueImpl;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ResourceServiceImpl
implements ResourceService {
    private static boolean appframeworkUsedLogged = false;

    public void prepareNew(FileObject srcFile) {
        try {
            ResourceUtils.createResourcesFolder(srcFile);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public ResourceValue get(String key, Class type, String localeSuffix, FileObject srcFile) {
        DesignResourceMap resMap = ResourceUtils.getDesignResourceMap(srcFile, true);
        resMap.setLocalization(localeSuffix);
        return resMap.getResourceValue(key, type);
    }

    public Collection<String> findKeys(String keyRegex, FileObject srcFile) {
        return ResourceUtils.getDesignResourceMap(srcFile, true).collectKeys(keyRegex, true);
    }

    public ResourceValue create(String key, Class type, Object value, String stringValue, FileObject srcFile) {
        return new ResourceValueImpl(key, type, value, null, stringValue, type == String.class, 2, srcFile);
    }

    public ResourceValue changeKey(ResourceValue resource, String newKey) {
        ResourceValueImpl resValue = (ResourceValueImpl)resource;
        if (!"#auto".equals(resource.getKey())) {
            resValue = new ResourceValueImpl(resValue);
        }
        resValue.setKey(newKey);
        return resValue;
    }

    public ResourceValue changeValue(ResourceValue resource, Object newValue, String newStringValue) {
        ResourceValueImpl resValue = (ResourceValueImpl)resource;
        return new ResourceValueImpl(resValue.getKey(), resValue.getValueType(), newValue, null, newStringValue, resValue.isInternationalized(), resValue.getStorageLevel(), resValue.getSourceFile());
    }

    public ResourceValue switchLocale(ResourceValue resource, String localeSuffix) {
        if (resource instanceof ResourceValueImpl) {
            ResourceValueImpl resValue = (ResourceValueImpl)resource;
            DesignResourceMap resMap = ResourceUtils.getDesignResourceMap(resValue.getSourceFile(), true);
            resMap.setLocalization(localeSuffix);
            return resMap.getResourceValue(resValue.getKey(), resValue.getValueType());
        }
        if (resource instanceof ProxyAction) {
            ProxyAction action = (ProxyAction)resource;
            DesignResourceMap resMap = action.getResourceMap();
            resMap.setLocalization(localeSuffix);
            action = new ProxyAction(action);
            action.loadFromResourceMap();
            return action;
        }
        return resource;
    }

    public String[][] getAvailableLocales(FileObject srcFile) {
        HashSet<String> localeSet = new HashSet<String>();
        HashMap<String, MultiDataObject.Entry> entries = new HashMap<String, MultiDataObject.Entry>();
        for (MultiDataObject.Entry locEntry : ResourceUtils.getDesignResourceMap(srcFile, true).collectLocaleEntries()) {
            String locale = Util.getLocaleSuffix((MultiDataObject.Entry)locEntry);
            if (localeSet.contains(locale)) continue;
            localeSet.add(locale);
            entries.put(locale, locEntry);
        }
        Object[] locales = new String[localeSet.size()];
        localeSet.toArray(locales);
        Arrays.sort(locales);
        String[] displays = new String[locales.length];
        for (int i = 0; i < locales.length; ++i) {
            displays[i] = Util.getLocaleLabel((MultiDataObject.Entry)((MultiDataObject.Entry)entries.get(locales[i])));
        }
        return new String[][]{locales, displays};
    }

    public Component getCreateLocaleComponent(final PropertyEditor prEd, FileObject srcFile) {
        DesignResourceMap resMap = ResourceUtils.getDesignResourceMap(srcFile, true);
        String bundleName = resMap.getBundleNames().get(0);
        PropertiesDataObject dobj = resMap.getRepresentativeDataObject();
        if (dobj == null) {
            try {
                dobj = ResourceUtils.createPropertiesDataObject(srcFile, bundleName);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return null;
            }
        }
        final PropertiesDataObject propertiesDO = dobj;
        final Dialog[] dialog = new Dialog[1];
        final LocalePanel localePanel = new LocalePanel();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)localePanel, NbBundle.getBundle(PropertiesDataObject.class).getString("CTL_NewLocaleTitle"), true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == DialogDescriptor.OK_OPTION) {
                    String locale = localePanel.getLocale().toString();
                    Util.createLocaleFile((PropertiesDataObject)propertiesDO, (String)locale, (boolean)false);
                    prEd.setValue("_" + locale);
                }
                dialog[0].setVisible(false);
                dialog[0].dispose();
            }
        });
        dialog[0] = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        return dialog[0];
    }

    public void update(ResourceValue oldValue, ResourceValue newValue, FileObject srcFile, String localeSuffix) throws IOException {
        if (oldValue != null && oldValue.getKey() == null || newValue != null && newValue.getKey() == null) {
            return;
        }
        ResourceValueImpl oldRes = (ResourceValueImpl)oldValue;
        ResourceValueImpl newRes = (ResourceValueImpl)newValue;
        if (!(oldRes == null || newRes != null && oldRes.getKey().equals(newRes.getKey()) && oldRes.getStorageLevel() == newRes.getStorageLevel())) {
            ResourceUtils.getDesignResourceMap(oldRes.getSourceFile(), true).removeResourceValue(oldRes);
        }
        if (newRes != null) {
            DesignResourceMap resMap = ResourceUtils.getDesignResourceMap(newRes.getSourceFile(), true);
            resMap.setLocalization(localeSuffix);
            resMap.addResourceValue(newRes);
        }
        if (!appframeworkUsedLogged) {
            Logger logger = Logger.getLogger("org.netbeans.ui.metrics.swingapp");
            LogRecord rec = new LogRecord(Level.INFO, "USG_FORM_APPFRAMEWORK_USED");
            rec.setLoggerName(logger.getName());
            logger.log(rec);
            appframeworkUsedLogged = true;
        }
    }

    public void autoSave(FileObject srcFile) {
        DesignResourceMap resMap = ResourceUtils.getDesignResourceMap(srcFile, false);
        if (resMap != null) {
            resMap.save();
        }
    }

    public void close(FileObject srcFile) {
        DesignResourceMap resMap = ResourceUtils.unregisterDesignResourceMap(srcFile);
        if (resMap != null) {
            resMap.revertChanges();
        }
        AppFrameworkSupport.fileClosed(srcFile);
    }

    public boolean projectWantsUseResources(FileObject fileInProject) {
        return AppFrameworkSupport.isFrameworkEnabledProject(fileInProject);
    }

    public boolean projectUsesResources(FileObject fileInProject) {
        return AppFrameworkSupport.isFrameworkLibAvailable(fileInProject);
    }

    public boolean isExcludedProperty(Class componentType, String propName) {
        return Component.class.isAssignableFrom(componentType) && "name".equals(propName);
    }

    public String getInjectionCode(Object bean, String variableName, FileObject srcFile) {
        Component component;
        if (bean instanceof Component && (component = (Component)bean).getParent() == null) {
            return ResourceUtils.getResourceMapCode(srcFile) + "*/\n\\0" + ".injectComponents(" + variableName + ");";
        }
        return null;
    }

    public ResourcePanel createResourcePanel(Class valueType, FileObject srcFile) {
        return new ResourcePanelImpl(ResourceUtils.getDesignResourceMap(srcFile, true), valueType);
    }

    public List<URL> getResourceFiles(FileObject srcFile) {
        PropertiesDataObject dobj = ResourceUtils.getPropertiesDataObject(srcFile);
        if (dobj != null) {
            try {
                ArrayList<URL> list = new ArrayList<URL>();
                list.add(dobj.getPrimaryEntry().getFile().getURL());
                for (MultiDataObject.Entry e : dobj.secondaryEntries()) {
                    list.add(e.getFile().getURL());
                }
                return list;
            }
            catch (IOException ex) {
                Logger.getLogger(ResourceServiceImpl.class.getName()).log(Level.INFO, null, ex);
            }
        }
        return Collections.emptyList();
    }
}

