/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.ui.ClassDialog;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.StoreFileFilter;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class TruststorePanel
extends JPanel {
    private static final String PKCS12 = "PKCS12";
    private static final String JKS = "JKS";
    private static final String DEFAULT_PASSWORD = "changeit";
    private WSDLComponent comp;
    private String storeType = "JKS";
    private boolean jsr109 = false;
    private Project project = null;
    private String profile = null;
    private boolean inSync = false;
    private ConfigVersion cfgVersion = null;
    private boolean client;
    String storeLocation = null;
    String ksType = null;
    String storePassword = null;
    String certSelector = null;
    private JButton certSelectorButton;
    private JTextField certSelectorField;
    private JLabel certSelectorLbl;
    private JComboBox keyAliasCombo;
    private JLabel keyAliasLabel;
    private JButton loadkeysButton;
    private JButton storeLocationButton;
    private JLabel storeLocationLabel;
    private JTextField storeLocationTextField;
    private JPasswordField storePasswordField;
    private JLabel storePasswordLabel;

    public TruststorePanel(WSDLComponent comp, Project p, boolean jsr109, String profile, boolean client, ConfigVersion cfgVersion) {
        this.comp = comp;
        this.jsr109 = jsr109;
        this.project = p;
        this.profile = profile;
        this.client = client;
        this.cfgVersion = cfgVersion;
        this.initComponents();
        this.keyAliasCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.keyAliasLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.storeLocationLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.storeLocationTextField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.storePasswordLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.storePasswordField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.certSelectorLbl.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.certSelectorButton.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.certSelectorField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.sync();
    }

    private String getPeerAlias() {
        return (String)this.keyAliasCombo.getSelectedItem();
    }

    private void setPeerAlias(String alias) {
        this.keyAliasCombo.setSelectedItem(alias);
    }

    private char[] getCharStorePassword() {
        return this.storePasswordField.getPassword();
    }

    private String getStorePassword() {
        return String.valueOf(this.storePasswordField.getPassword());
    }

    private void setStorePassword(String password) {
        this.storePasswordField.setText(password);
    }

    private void setStoreLocation(String path) {
        this.storeLocationTextField.setText(path);
    }

    private String getStoreLocation() {
        String path = this.storeLocationTextField.getText();
        if ("".equals(path) || path == null) {
            return null;
        }
        return path;
    }

    private void setStoreType(String type) {
        this.storeType = type;
    }

    private String getSelector() {
        String path = this.certSelectorField.getText();
        if ("".equals(path) || path == null) {
            return null;
        }
        return path;
    }

    private void setSelector(String selector) {
        this.certSelectorField.setText(selector);
    }

    public void sync() {
        this.inSync = true;
        this.storeLocation = ProprietarySecurityPolicyModelHelper.getStoreLocation(this.comp, true);
        if (this.storeLocation != null) {
            this.setStoreLocation(this.storeLocation);
        } else if (this.jsr109) {
            this.setStoreLocation(ServerUtils.getStoreLocation(this.project, true, this.client));
        }
        this.ksType = ProprietarySecurityPolicyModelHelper.getStoreType(this.comp, true);
        if (this.ksType != null) {
            this.setStoreType(this.ksType);
        }
        this.storePassword = ProprietarySecurityPolicyModelHelper.getStorePassword(this.comp, true);
        if (this.storePassword != null) {
            this.setStorePassword(this.storePassword);
            this.reloadAliases();
        } else if (this.jsr109) {
            this.storePassword = DEFAULT_PASSWORD;
            this.setStorePassword(DEFAULT_PASSWORD);
            if (!this.reloadAliases()) {
                String adminPassword;
                this.storePassword = adminPassword = Util.getPassword(this.project);
                this.setStorePassword(this.storePassword);
            }
            if (!this.reloadAliases()) {
                this.storePassword = "";
                this.setStorePassword("");
            }
        }
        String peerAlias = ProprietarySecurityPolicyModelHelper.getTrustPeerAlias(this.comp);
        this.setPeerAlias(peerAlias);
        this.certSelector = ProprietarySecurityPolicyModelHelper.getCertSelector(this.comp);
        if (this.certSelector != null) {
            this.setSelector(this.certSelector);
        }
        this.enableDisable();
        this.inSync = false;
    }

    private void enableDisable() {
        if (!this.client) {
            boolean aliasRequired = true;
            if (ComboConstants.PROF_USERNAME.equals(this.profile) || ComboConstants.PROF_ENDORSCERT.equals(this.profile) || ComboConstants.PROF_SAMLSENDER.equals(this.profile) || ComboConstants.PROF_SAMLHOLDER.equals(this.profile) || ComboConstants.PROF_STSISSUED.equals(this.profile) || ComboConstants.PROF_STSISSUEDCERT.equals(this.profile) || ComboConstants.PROF_STSISSUEDENDORSE.equals(this.profile) || ComboConstants.PROF_STSISSUEDSUPPORTING.equals(this.profile) || ComboConstants.PROF_MUTUALCERT.equals(this.profile)) {
                aliasRequired = false;
            }
            this.keyAliasCombo.setEnabled(aliasRequired);
            this.keyAliasLabel.setEnabled(aliasRequired);
            this.loadkeysButton.setEnabled(aliasRequired);
        }
    }

    private void initComponents() {
        this.storeLocationLabel = new JLabel();
        this.storePasswordLabel = new JLabel();
        this.storeLocationTextField = new JTextField();
        this.storeLocationButton = new JButton();
        this.keyAliasLabel = new JLabel();
        this.keyAliasCombo = new JComboBox();
        this.storePasswordField = new JPasswordField();
        this.loadkeysButton = new JButton();
        this.certSelectorLbl = new JLabel();
        this.certSelectorField = new JTextField();
        this.certSelectorButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.storeLocationLabel, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_KeyStorePanel_LocationLabel"));
        Mnemonics.setLocalizedText((JLabel)this.storePasswordLabel, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_TruststorePanel_TruststorePassword"));
        Mnemonics.setLocalizedText((AbstractButton)this.storeLocationButton, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_TruststorePanel_Browse"));
        this.storeLocationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TruststorePanel.this.storeLocationButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.keyAliasLabel, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_KeyStorePanel_KeyAliasLabel"));
        this.keyAliasCombo.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.loadkeysButton, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_LoadKeys"));
        this.loadkeysButton.setActionCommand("&Load Aliases");
        this.loadkeysButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TruststorePanel.this.loadkeysButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.certSelectorLbl, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_Truststore_AliasSelectorLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.certSelectorButton, (String)NbBundle.getMessage(TruststorePanel.class, (String)"LBL_TruststorePanel_Browse"));
        this.certSelectorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TruststorePanel.this.certSelectorButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.storeLocationLabel).add((Component)this.storePasswordLabel).add((Component)this.keyAliasLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.keyAliasCombo, 0, 164, Short.MAX_VALUE).add((Component)this.storePasswordField, -1, 164, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.loadkeysButton).addPreferredGap(0, 84, Short.MAX_VALUE)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.certSelectorField, -1, 355, Short.MAX_VALUE).add((Component)this.storeLocationTextField, -1, 355, Short.MAX_VALUE)).addPreferredGap(0)))).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.certSelectorLbl).add(384, 384, 384))).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.storeLocationButton).add((Component)this.certSelectorButton)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.storeLocationLabel).add((Component)this.storeLocationButton).add((Component)this.storeLocationTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.storePasswordLabel).add((Component)this.storePasswordField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.keyAliasLabel).add((Component)this.keyAliasCombo, -2, -1, -2).add((Component)this.loadkeysButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.certSelectorLbl).add((Component)this.certSelectorField, -2, -1, -2).add((Component)this.certSelectorButton)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.certSelectorField, this.keyAliasCombo, this.storeLocationTextField, this.storePasswordField}, 2);
    }

    private void loadkeysButtonActionPerformed(ActionEvent evt) {
        boolean success = this.reloadAliases();
        if (!success) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(TruststorePanel.class, (String)"MSG_WrongPassword")));
        }
    }

    private void storeLocationButtonActionPerformed(ActionEvent evt) {
        File file;
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setDialogTitle(NbBundle.getMessage(TruststorePanel.class, (String)"LBL_TruststoreBrowse_Title"));
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new StoreFileFilter());
        File f = new File(this.storeLocationTextField.getText());
        if (f != null && f.exists()) {
            if (f.isDirectory()) {
                chooser.setCurrentDirectory(f);
            } else {
                chooser.setCurrentDirectory(f.getParentFile());
            }
        }
        if (chooser.showOpenDialog(this) == 0 && (file = chooser.getSelectedFile()) != null) {
            this.setStoreLocation(file.getPath());
            String extension = FileUtil.getExtension((String)file.getName());
            this.storeType = "jks".equals(extension) ? JKS : PKCS12;
        }
    }

    private void certSelectorButtonActionPerformed(ActionEvent evt) {
        block1: {
            Set<String> selectedClasses;
            Iterator<String> i$;
            if (this.project == null) break block1;
            ClassDialog classDialog = new ClassDialog(this.project, "java.security.cert.CertSelector");
            classDialog.show();
            if (classDialog.okButtonPressed() && (i$ = (selectedClasses = classDialog.getSelectedClasses()).iterator()).hasNext()) {
                String selectedClass = i$.next();
                this.setSelector(selectedClass);
                ProprietarySecurityPolicyModelHelper.setCertSelector(this.comp, selectedClass, this.client);
            }
        }
    }

    public void storeState() {
        String peerAlias = this.getPeerAlias();
        if (peerAlias != null && peerAlias.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setTrustPeerAlias(this.comp, null, this.client);
        } else {
            ProprietarySecurityPolicyModelHelper.setTrustPeerAlias(this.comp, peerAlias, this.client);
        }
        String storePasswd = this.getStorePassword();
        String storeLoc = this.getStoreLocation();
        if (storePasswd != null && storePasswd.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setStorePassword(this.comp, null, true, this.client);
        } else {
            ProprietarySecurityPolicyModelHelper.setStorePassword(this.comp, storePasswd, true, this.client);
        }
        ProprietarySecurityPolicyModelHelper.setStoreType(this.comp, this.storeType, true, this.client);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(this.comp, storeLoc, true, this.client);
        String selector = this.getSelector();
        ProprietarySecurityPolicyModelHelper.setCertSelector(this.comp, selector, this.client);
    }

    private boolean reloadAliases() {
        List<String> aliasList;
        try {
            aliasList = Util.getAliases(this.getStoreLocation(), this.getCharStorePassword(), this.storeType);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
        this.keyAliasCombo.removeAllItems();
        if (aliasList != null) {
            this.keyAliasCombo.addItem("");
            for (String alias : aliasList) {
                this.keyAliasCombo.addItem(alias);
            }
            if (this.keyAliasCombo.getItemCount() > 1) {
                this.keyAliasCombo.setSelectedIndex(1);
            }
        }
        return true;
    }
}

