/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Dialog;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.wsitconf.spi.features.AdvancedSecurityFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ClientDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ServiceDefaultsFeature;
import org.netbeans.modules.websvc.wsitconf.spi.features.ValidatorsFeature;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBase;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.SAMLAuthorizationOverSSL;
import org.netbeans.modules.websvc.wsitconf.util.UndoCounter;
import org.netbeans.modules.websvc.wsitconf.wizard.SamlCallbackCreator;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;

public class SAMLAuthorizationOverSSLProfile
extends ProfileBase
implements ClientDefaultsFeature,
ServiceDefaultsFeature,
ValidatorsFeature,
AdvancedSecurityFeature {
    private static final String PKGNAME = "samlcb";

    @Override
    public int getId() {
        return 50;
    }

    @Override
    public String getDisplayName() {
        return ComboConstants.PROF_SAMLSSL;
    }

    @Override
    public String getDescription() {
        return ComboConstants.PROF_SAMLSSL_INFO;
    }

    @Override
    public boolean isCurrentProfile(WSDLComponent component) {
        return this.getDisplayName().equals(ProfilesModelHelper.getWSITSecurityProfile(component));
    }

    @Override
    public void displayConfig(WSDLComponent component, UndoManager undoManager) {
        UndoCounter undoCounter = new UndoCounter();
        WSDLModel model = component.getModel();
        model.addUndoableEditListener((UndoableEditListener)undoCounter);
        SAMLAuthorizationOverSSL profConfigPanel = new SAMLAuthorizationOverSSL(component, this);
        DialogDescriptor dlgDesc = new DialogDescriptor((Object)profConfigPanel, this.getDisplayName());
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dlgDesc);
        dlg.setVisible(true);
        if (dlgDesc.getValue() == DialogDescriptor.CANCEL_OPTION) {
            for (int i = 0; i < undoCounter.getCounter(); ++i) {
                if (!undoManager.canUndo()) continue;
                undoManager.undo();
            }
        }
        model.removeUndoableEditListener((UndoableEditListener)undoCounter);
    }

    @Override
    public boolean isProfileSupported(Project p, WSDLComponent component, boolean sts) {
        return true;
    }

    @Override
    public void setClientDefaults(WSDLComponent component, WSDLComponent serviceBinding, Project p) {
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, false, true);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, true, true);
        ProprietarySecurityPolicyModelHelper.removeCallbackHandlerConfiguration((Binding)component);
        FileObject targetFolder = null;
        Sources sources = ProjectUtils.getSources((Project)p);
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        if (sourceGroups != null && sourceGroups.length > 0) {
            targetFolder = sourceGroups[0].getRootFolder();
        }
        SamlCallbackCreator samlCreator = new SamlCallbackCreator();
        String samlVersion = this.getSamlVersion((Binding)serviceBinding);
        String cbName = "SamlCallbackHandler";
        if (targetFolder != null) {
            if (targetFolder.getFileObject(PKGNAME) == null) {
                try {
                    targetFolder = targetFolder.createFolder(PKGNAME);
                }
                catch (IOException ex) {
                    Logger.getLogger("global").log(Level.SEVERE, null, ex);
                }
            } else {
                targetFolder = targetFolder.getFileObject(PKGNAME);
            }
            if (ComboConstants.SAML_V2011.equals(samlVersion)) {
                cbName = "Saml20SVCallbackHandler";
                if (targetFolder.getFileObject(cbName, "java") == null) {
                    samlCreator.generateSamlCBHandler(targetFolder, cbName, "sv", "20");
                }
            } else {
                cbName = "Saml11SVCallbackHandler";
                if (targetFolder.getFileObject(cbName, "java") == null) {
                    samlCreator.generateSamlCBHandler(targetFolder, cbName, "sv", "11");
                }
            }
        }
        ProprietarySecurityPolicyModelHelper.setCallbackHandler((Binding)component, "samlHandler", "samlcb." + cbName, null, true);
    }

    @Override
    public void setServiceDefaults(WSDLComponent component, Project p) {
        ProprietarySecurityPolicyModelHelper.clearValidators(component);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, false, false);
        ProprietarySecurityPolicyModelHelper.setStoreLocation(component, null, true, false);
    }

    @Override
    public boolean isServiceDefaultSetupUsed(WSDLComponent component, Project p) {
        return !ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(component);
    }

    @Override
    public boolean isClientDefaultSetupUsed(WSDLComponent component, Binding serviceBinding, Project p) {
        if (ProprietarySecurityPolicyModelHelper.isAnyValidatorSet(component)) {
            return false;
        }
        String samlVersion = this.getSamlVersion(serviceBinding);
        String cbName = null;
        cbName = ComboConstants.SAML_V2011.equals(samlVersion) ? "Saml20SVCallbackHandler" : "Saml11SVCallbackHandler";
        String cbHandler = ProprietarySecurityPolicyModelHelper.getCallbackHandler((Binding)component, "samlHandler");
        return ("samlcb." + cbName).equals(cbHandler);
    }

    private String getSamlVersion(Binding serviceBinding) {
        WSDLComponent tokenKind = SecurityTokensModelHelper.getSupportingToken((WSDLComponent)serviceBinding, 1);
        WSDLComponent token = SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
        return SecurityTokensModelHelper.getTokenProfileVersion(token);
    }

    @Override
    public boolean isValidatorSupported(ConfigVersion cfgVersion, String validatorType) {
        return true;
    }
}

