/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.hints.infrastructure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mozilla.nb.javascript.Node;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.hints.StrictWarning;
import org.netbeans.modules.javascript.hints.infrastructure.JsAstRule;
import org.netbeans.modules.javascript.hints.infrastructure.JsErrorRule;
import org.netbeans.modules.javascript.hints.infrastructure.JsRuleContext;
import org.netbeans.modules.javascript.hints.infrastructure.JsSelectionRule;
import org.netbeans.modules.parsing.spi.Parser;

public class JsHintsProvider
implements HintsProvider {
    private boolean cancelled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeErrors(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, List<Error> list2) {
        ParserResult parserResult = ruleContext.parserResult;
        if (parserResult == null) {
            return;
        }
        List list3 = parserResult.getDiagnostics();
        if (list3 == null || list3.size() == 0) {
            return;
        }
        this.cancelled = false;
        Map map = hintsManager.getErrors();
        if (map.isEmpty() || this.isCancelled()) {
            list2.addAll(list3);
            return;
        }
        try {
            ruleContext.doc.readLock();
            for (Error error : list3) {
                if (this.applyErrorRules(hintsManager, ruleContext, error, map, list)) continue;
                list2.add(error);
            }
        }
        finally {
            ruleContext.doc.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeSelectionHints(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, int n, int n2) {
        this.cancelled = false;
        if (ruleContext.parserResult == null) {
            return;
        }
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)ruleContext.parserResult);
        if (jsParseResult.getRootNode() == null) {
            return;
        }
        List list2 = hintsManager.getSelectionHints();
        if (list2.isEmpty()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        try {
            ruleContext.doc.readLock();
            this.applySelectionRules(hintsManager, ruleContext, list2, list);
        }
        finally {
            ruleContext.doc.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeHints(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list) {
        this.cancelled = false;
        if (ruleContext.parserResult == null) {
            return;
        }
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)ruleContext.parserResult);
        if (jsParseResult.getRootNode() == null) {
            return;
        }
        Map map = hintsManager.getHints(false, ruleContext);
        if (map.isEmpty()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        AstPath astPath = new AstPath();
        astPath.descend(jsParseResult.getRootNode());
        ruleContext.doc.readLock();
        try {
            this.applyHints(hintsManager, ruleContext, -1, jsParseResult.getRootNode(), astPath, map, list);
            this.scan(hintsManager, ruleContext, jsParseResult.getRootNode(), astPath, map, list);
        }
        finally {
            ruleContext.doc.readUnlock();
        }
        astPath.ascend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeSuggestions(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<Hint> list, int n) {
        Node node;
        Object object;
        this.cancelled = false;
        if (ruleContext.parserResult == null) {
            return;
        }
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)ruleContext.parserResult);
        if (jsParseResult.getRootNode() == null) {
            return;
        }
        HashMap<Integer, List<JsAstRule>> hashMap = new HashMap<Integer, List<JsAstRule>>();
        hashMap.putAll(hintsManager.getHints(true, ruleContext));
        Set set = hintsManager.getSuggestions().entrySet();
        for (Map.Entry astPath : set) {
            object = (List)hashMap.get(astPath.getKey());
            if (object != null) {
                node = new LinkedList();
                node.addAll(object);
                node.addAll((Collection)astPath.getValue());
                hashMap.put((Integer)astPath.getKey(), (List<JsAstRule>)node);
                continue;
            }
            hashMap.put((Integer)astPath.getKey(), (List<JsAstRule>)astPath.getValue());
        }
        if (hashMap.isEmpty()) {
            return;
        }
        if (this.isCancelled()) {
            return;
        }
        ruleContext.doc.readLock();
        try {
            int n2 = AstUtilities.getAstOffset((Parser.Result)jsParseResult, (int)n);
            AstPath astPath = new AstPath(jsParseResult.getRootNode(), n2);
            object = astPath.leafToRoot();
            while (object.hasNext()) {
                if (this.isCancelled()) {
                    return;
                }
                node = (Node)object.next();
                this.applyHints(hintsManager, ruleContext, node.getType(), node, astPath, hashMap, list);
            }
        }
        finally {
            ruleContext.doc.readUnlock();
        }
    }

    private void applyHints(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, int n, Node node, AstPath astPath, Map<Integer, List<JsAstRule>> map, List<Hint> list) {
        List<JsAstRule> list2 = map.get(n);
        if (list2 != null) {
            JsRuleContext jsRuleContext = (JsRuleContext)ruleContext;
            jsRuleContext.node = node;
            jsRuleContext.path = astPath;
            for (JsAstRule jsAstRule : list2) {
                if (!hintsManager.isEnabled((Rule.UserConfigurableRule)jsAstRule)) continue;
                jsAstRule.run(jsRuleContext, list);
            }
        }
    }

    private boolean applyErrorRules(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, Error error, Map<String, List<JsErrorRule>> map, List<Hint> list) {
        List<JsErrorRule> list2;
        String string = error.getKey();
        if (string != null && (list2 = map.get(string)) != null) {
            int n = list.size();
            boolean bl = false;
            for (JsErrorRule jsErrorRule : list2) {
                if (!hintsManager.isEnabled((Rule.UserConfigurableRule)jsErrorRule)) {
                    bl = true;
                    continue;
                }
                if (!jsErrorRule.appliesTo(ruleContext)) continue;
                jsErrorRule.run(ruleContext, error, list);
            }
            Object object = ruleContext instanceof JsRuleContext ? (JsRuleContext)ruleContext : null;
            boolean bl2 = object != null ? ((JsRuleContext)((Object)object)).remove : false;
            return bl || n < list.size() || bl2;
        }
        return false;
    }

    private void applySelectionRules(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, List<JsSelectionRule> list, List<Hint> list2) {
        for (JsSelectionRule jsSelectionRule : list) {
            if (!jsSelectionRule.appliesTo(ruleContext) || !hintsManager.isEnabled((Rule.UserConfigurableRule)jsSelectionRule)) continue;
            jsSelectionRule.run(ruleContext, list2);
        }
    }

    private void scan(HintsProvider.HintsManager hintsManager, RuleContext ruleContext, Node node, AstPath astPath, Map<Integer, List<JsAstRule>> map, List<Hint> list) {
        this.applyHints(hintsManager, ruleContext, node.getType(), node, astPath, map, list);
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (this.isCancelled()) {
                return;
            }
            astPath.descend(node2);
            this.scan(hintsManager, ruleContext, node2, astPath, map, list);
            astPath.ascend();
        }
    }

    public void cancel() {
        this.cancelled = true;
    }

    private boolean isCancelled() {
        return this.cancelled;
    }

    public RuleContext createRuleContext() {
        return new JsRuleContext();
    }

    public List<Rule> getBuiltinRules() {
        ArrayList<Rule> arrayList = new ArrayList<Rule>(StrictWarning.KNOWN_STRICT_ERROR_KEYS.length);
        for (String string : StrictWarning.KNOWN_STRICT_ERROR_KEYS) {
            StrictWarning strictWarning = new StrictWarning(string);
            if ("msg.reserved.keyword".equals(string) || "msg.trailing.comma".equals(string)) {
                strictWarning.setDefaultSeverity(HintSeverity.ERROR);
            }
            arrayList.add((Rule)strictWarning);
        }
        return arrayList;
    }
}

