/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.syncview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsFileTableModel;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.CvsSynchronizeTopComponent;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncFileNode;
import org.netbeans.modules.versioning.system.cvss.ui.syncview.SyncTable;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.LifecycleManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class SynchronizePanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
PreferenceChangeListener,
VersioningListener,
ActionListener {
    private ExplorerManager explorerManager;
    private final CvsSynchronizeTopComponent parentTopComponent;
    private final CvsVersioningSystem cvs;
    private Context context;
    private int displayStatuses;
    private boolean pendingRefresh;
    private SyncTable syncTable;
    private RequestProcessor.Task refreshViewTask;
    private ExecutorGroup refreshCommandGroup;
    private static final RequestProcessor rp = new RequestProcessor("CVS-VersioningView", 1);
    private final NoContentPanel noContentComponent = new NoContentPanel();
    private JButton btnCommit;
    private JButton btnDiff;
    private JButton btnRefresh;
    private JButton btnUpdate;
    private JToolBar jPanel2;
    private JPanel jPanel3;
    private JSeparator jSeparator1;
    private JToggleButton tgbAll;
    private JToggleButton tgbLocal;
    private JToggleButton tgbRemote;

    public SynchronizePanel(CvsSynchronizeTopComponent parent) {
        this.parentTopComponent = parent;
        this.cvs = CvsVersioningSystem.getInstance();
        this.refreshViewTask = rp.create((Runnable)new RefreshViewTask());
        this.explorerManager = new ExplorerManager();
        this.displayStatuses = 8180;
        this.noContentComponent.setLabel(NbBundle.getMessage(SynchronizePanel.class, (String)"MSG_No_Changes_All"));
        this.syncTable = new SyncTable();
        this.initComponents();
        this.setComponentsState();
        this.setVersioningComponent(this.syncTable.getComponent());
        this.reScheduleRefresh(0);
        this.jPanel2.setFloatable(false);
        this.jPanel2.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.jPanel2.setLayout(new ToolbarLayout());
        parent.getInputMap(1).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        parent.getInputMap(0).put(KeyStroke.getKeyStroke(37, 9), "prevInnerView");
        parent.getInputMap(1).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        parent.getInputMap(0).put(KeyStroke.getKeyStroke(39, 9), "nextInnerView");
        this.parentTopComponent.getActionMap().put("NextViewAction", new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynchronizePanel.this.onNextInnerView();
            }
        });
        this.parentTopComponent.getActionMap().put("PreviousViewAction", new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                SynchronizePanel.this.onPrevInnerView();
            }
        });
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            Color color = UIManager.getColor("NbExplorerView.background");
            this.setBackground(color);
            this.jPanel2.setBackground(color);
        }
    }

    private void onPrevInnerView() {
        if (this.tgbLocal.isSelected()) {
            this.tgbRemote.setSelected(true);
        } else if (this.tgbRemote.isSelected()) {
            this.tgbAll.setSelected(true);
        } else {
            this.tgbLocal.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    private void onNextInnerView() {
        if (this.tgbLocal.isSelected()) {
            this.tgbAll.setSelected(true);
        } else if (this.tgbRemote.isSelected()) {
            this.tgbLocal.setSelected(true);
        } else {
            this.tgbRemote.setSelected(true);
        }
        this.onDisplayedStatusChanged();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (tc == null) {
                return;
            }
            tc.setActivatedNodes((Node[])evt.getNewValue());
        }
    }

    CvsVersioningSystem getCvs() {
        return this.cvs;
    }

    void setContext(Context ctx) {
        this.context = ctx;
        this.reScheduleRefresh(0);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        CvsModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.cvs.getStatusCache().addVersioningListener(this);
        this.cvs.addVersioningListener(this);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.cvs.addVersioningListener(this.syncTable);
        this.reScheduleRefresh(0);
    }

    @Override
    public void removeNotify() {
        CvsModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        this.cvs.getStatusCache().removeVersioningListener(this);
        this.cvs.removeVersioningListener(this);
        this.cvs.addVersioningListener(this.syncTable);
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    private void setVersioningComponent(JComponent component) {
        Component[] children = this.getComponents();
        for (int i = 0; i < children.length; ++i) {
            Component child = children[i];
            if (child == this.jPanel2) continue;
            if (child == component) {
                return;
            }
            this.remove(child);
            break;
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 0;
        gbc.gridheight = 1;
        gbc.anchor = 23;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)component, gbc);
        this.revalidate();
        this.repaint();
    }

    private void setComponentsState() {
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.tgbLocal);
        grp.add(this.tgbRemote);
        grp.add(this.tgbAll);
        if (this.displayStatuses == 6612) {
            this.tgbLocal.setSelected(true);
        } else if (this.displayStatuses == 1696) {
            this.tgbRemote.setSelected(true);
        } else {
            this.tgbAll.setSelected(true);
        }
    }

    /*
     * Exception decompiling
     */
    private void setupModels() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[FORLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SyncFileNode[] getNodes(CvsFileTableModel model) {
        CvsFileNode[] fnodes = model.getNodes();
        SyncFileNode[] nodes = new SyncFileNode[fnodes.length];
        for (int i = 0; i < fnodes.length; ++i) {
            if (Thread.interrupted()) {
                return null;
            }
            CvsFileNode fnode = fnodes[i];
            nodes[i] = new SyncFileNode(fnode);
        }
        return nodes;
    }

    private void onCommitAction() {
        LifecycleManager.getDefault().saveAll();
        CommitAction.invokeCommit(this.parentTopComponent.getContentTitle(), this.context, null);
    }

    private void onUpdateAction() {
        this.executeUpdateCommand(false);
    }

    private void onRefreshAction() {
        LifecycleManager.getDefault().saveAll();
        this.refreshStatuses();
    }

    void performRefreshAction() {
        this.refreshStatuses();
    }

    private void refreshStatuses() {
        this.executeUpdateCommand(true);
        this.reScheduleRefresh(1000);
    }

    private void onDiffAction() {
        ExecutorGroup group = new ExecutorGroup(NbBundle.getMessage(SynchronizePanel.class, (String)"BK0003"));
        group.progress(NbBundle.getMessage(SynchronizePanel.class, (String)"BK0004"));
        DiffExecutor exec = new DiffExecutor(this.context, this.parentTopComponent.getContentTitle());
        if (this.displayStatuses == 6612) {
            LifecycleManager.getDefault().saveAll();
            CvsModuleConfig.getDefault().setLastUsedModificationContext(0);
            exec.showDiff(group, 0);
        } else if (this.displayStatuses == 1696) {
            CvsModuleConfig.getDefault().setLastUsedModificationContext(1);
            exec.showDiff(group, 1);
        } else {
            LifecycleManager.getDefault().saveAll();
            CvsModuleConfig.getDefault().setLastUsedModificationContext(2);
            exec.showDiff(group, 2);
        }
    }

    private void executeUpdateCommand(boolean doNoChanges) {
        if (this.context == null || this.context.getRootFiles().length == 0) {
            return;
        }
        UpdateCommand cmd = new UpdateCommand();
        String msg = doNoChanges ? NbBundle.getMessage(SynchronizePanel.class, (String)"BK0001") : NbBundle.getMessage(SynchronizePanel.class, (String)"BK0002");
        cmd.setDisplayName(msg);
        GlobalOptions options = CvsVersioningSystem.createGlobalOptions();
        if (this.context.getExclusions().size() > 0) {
            options.setExclusions(this.context.getExclusions().toArray(new File[this.context.getExclusions().size()]));
        }
        cmd.setFiles(this.context.getRootFiles());
        cmd.setBuildDirectories(true);
        cmd.setPruneDirectories(true);
        options.setDoNoChanges(doNoChanges);
        this.refreshCommandGroup = new ExecutorGroup(msg);
        this.refreshCommandGroup.addExecutors(UpdateExecutor.splitCommand(cmd, this.cvs, options, this.parentTopComponent.getContentTitle()));
        final long timestamp = System.currentTimeMillis();
        this.refreshCommandGroup.addBarrier(new Runnable(){

            @Override
            public void run() {
                if (!SynchronizePanel.this.refreshCommandGroup.isFailed()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SynchronizePanel.this.parentTopComponent.contentRefreshed(timestamp);
                        }
                    });
                }
            }
        });
        final ExecutorGroup grp = this.refreshCommandGroup;
        CvsVersioningSystem.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                grp.execute();
            }
        });
    }

    private void onDisplayedStatusChanged() {
        if (this.tgbLocal.isSelected()) {
            this.setDisplayStatuses(6612);
            CvsModuleConfig.getDefault().setLastUsedModificationContext(0);
            this.noContentComponent.setLabel(NbBundle.getMessage(SynchronizePanel.class, (String)"MSG_No_Changes_Local"));
        } else if (this.tgbRemote.isSelected()) {
            this.setDisplayStatuses(1696);
            CvsModuleConfig.getDefault().setLastUsedModificationContext(1);
            this.noContentComponent.setLabel(NbBundle.getMessage(SynchronizePanel.class, (String)"MSG_No_Changes_Remote"));
        } else if (this.tgbAll.isSelected()) {
            this.setDisplayStatuses(8180);
            CvsModuleConfig.getDefault().setLastUsedModificationContext(2);
            this.noContentComponent.setLabel(NbBundle.getMessage(SynchronizePanel.class, (String)"MSG_No_Changes_All"));
        }
    }

    private void setDisplayStatuses(int displayStatuses) {
        this.displayStatuses = displayStatuses;
        this.reScheduleRefresh(0);
    }

    public void versioningEvent(VersioningEvent event) {
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            if (!this.affectsView(event)) {
                return;
            }
            if (this.cvs.getParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) != null) {
                this.reScheduleRefresh(1000);
            } else {
                this.reScheduleRefresh(200);
            }
        } else if (event.getId() == CvsVersioningSystem.EVENT_PARAM_CHANGED && this.pendingRefresh && event.getParams()[0].equals(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) && this.cvs.getParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) == null) {
            this.pendingRefresh = false;
            this.reScheduleRefresh(0);
        }
    }

    private boolean affectsView(VersioningEvent event) {
        File file = (File)event.getParams()[0];
        FileInformation oldInfo = (FileInformation)event.getParams()[1];
        FileInformation newInfo = (FileInformation)event.getParams()[2];
        if (oldInfo == null ? (newInfo.getStatus() & this.displayStatuses) == 0 : (oldInfo.getStatus() & this.displayStatuses) + (newInfo.getStatus() & this.displayStatuses) == 0) {
            return false;
        }
        if (this.context != null) {
            return this.context.contains(file);
        }
        return false;
    }

    private void reScheduleRefresh(int delayMillis) {
        this.refreshViewTask.schedule(delayMillis);
    }

    void deserialize() {
        if (this.syncTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SynchronizePanel.this.syncTable.setDefaultColumnSizes();
                }
            });
        }
    }

    void focus() {
        this.syncTable.focus();
    }

    public void cancelRefresh() {
        if (this.refreshCommandGroup != null) {
            this.refreshCommandGroup.cancel();
        }
        this.refreshViewTask.cancel();
    }

    private void initComponents() {
        this.jPanel2 = new JToolBar();
        this.tgbAll = new JToggleButton();
        this.tgbLocal = new JToggleButton();
        this.tgbRemote = new JToggleButton();
        this.jSeparator1 = new JSeparator();
        this.btnRefresh = new JButton();
        this.btnDiff = new JButton();
        this.jPanel3 = new JPanel();
        this.btnUpdate = new JButton();
        this.btnCommit = new JButton();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/syncview/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.tgbAll, (String)bundle.getString("CTL_Synchronize_Action_All_Label"));
        this.tgbAll.setToolTipText(bundle.getString("CTL_Synchronize_Action_All_Tooltip"));
        this.tgbAll.addActionListener(this);
        this.jPanel2.add(this.tgbAll);
        Mnemonics.setLocalizedText((AbstractButton)this.tgbLocal, (String)bundle.getString("CTL_Synchronize_Action_Local_Label"));
        this.tgbLocal.setToolTipText(bundle.getString("CTL_Synchronize_Action_Local_Tooltip"));
        this.tgbLocal.addActionListener(this);
        this.jPanel2.add(this.tgbLocal);
        Mnemonics.setLocalizedText((AbstractButton)this.tgbRemote, (String)bundle.getString("CTL_Synchronize_Action_Remote_Label"));
        this.tgbRemote.setToolTipText(bundle.getString("CTL_Synchronize_Action_Remote_Tooltip"));
        this.tgbRemote.addActionListener(this);
        this.jPanel2.add(this.tgbRemote);
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setPreferredSize(new Dimension(2, 20));
        this.jPanel2.add(this.jSeparator1);
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/refresh.png")));
        this.btnRefresh.setToolTipText(bundle.getString("CTL_Synchronize_Action_Refresh_Tooltip"));
        this.btnRefresh.setActionCommand(bundle.getString("CTL_Synchronize_TopComponent_Title"));
        this.btnRefresh.setPreferredSize(new Dimension(22, 23));
        this.btnRefresh.addActionListener(this);
        this.jPanel2.add(this.btnRefresh);
        this.btnDiff.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff.png")));
        this.btnDiff.setToolTipText(bundle.getString("CTL_Synchronize_Action_Diff_Tooltip"));
        this.btnDiff.setPreferredSize(new Dimension(22, 25));
        this.btnDiff.addActionListener(this);
        this.jPanel2.add(this.btnDiff);
        this.jPanel3.setOpaque(false);
        this.jPanel2.add(this.jPanel3);
        this.btnUpdate.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/update.png")));
        this.btnUpdate.setToolTipText(bundle.getString("CTL_Synchronize_Action_Update_Tooltip"));
        this.btnUpdate.setActionCommand(bundle.getString("CTL_Synchronize_TopComponent_Title"));
        this.btnUpdate.setPreferredSize(new Dimension(22, 25));
        this.btnUpdate.addActionListener(this);
        this.jPanel2.add(this.btnUpdate);
        this.btnCommit.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/commit.png")));
        this.btnCommit.setToolTipText(bundle.getString("CTL_CommitForm_Action_Commit_Tooltip"));
        this.btnCommit.setPreferredSize(new Dimension(22, 25));
        this.btnCommit.addActionListener(this);
        this.jPanel2.add(this.btnCommit);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.tgbAll) {
            this.tgbAllActionPerformed(evt);
        } else if (evt.getSource() == this.tgbLocal) {
            this.tgbLocalActionPerformed(evt);
        } else if (evt.getSource() == this.tgbRemote) {
            this.tgbRemoteActionPerformed(evt);
        } else if (evt.getSource() == this.btnRefresh) {
            this.btnRefreshActionPerformed(evt);
        } else if (evt.getSource() == this.btnDiff) {
            this.btnDiffActionPerformed(evt);
        } else if (evt.getSource() == this.btnUpdate) {
            this.btnUpdateActionPerformed(evt);
        } else if (evt.getSource() == this.btnCommit) {
            this.btnCommitActionPerformed(evt);
        }
    }

    private void btnDiffActionPerformed(ActionEvent evt) {
        this.onDiffAction();
    }

    private void tgbAllActionPerformed(ActionEvent evt) {
        this.onDisplayedStatusChanged();
    }

    private void btnUpdateActionPerformed(ActionEvent evt) {
        this.onUpdateAction();
    }

    private void tgbRemoteActionPerformed(ActionEvent evt) {
        this.onDisplayedStatusChanged();
    }

    private void tgbLocalActionPerformed(ActionEvent evt) {
        this.onDisplayedStatusChanged();
    }

    private void btnCommitActionPerformed(ActionEvent evt) {
        this.onCommitAction();
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.onRefreshAction();
    }

    private class ToolbarLayout
    implements LayoutManager {
        private int TOOLBAR_HEIGHT_ADJUSTMENT = 4;
        private int TOOLBAR_SEPARATOR_MIN_WIDTH = 12;
        private int toolbarHeight = -1;
        private Dimension parentSize;
        private Set adjusted = new HashSet();

        private ToolbarLayout() {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension dim = SynchronizePanel.this.getSize();
            Dimension max = parent.getSize();
            int reminder = max.width - this.minimumLayoutSize((Container)parent).width;
            int components = parent.getComponentCount();
            int horizont = 0;
            for (int i = 0; i < components; ++i) {
                JComponent comp = (JComponent)parent.getComponent(i);
                if (!comp.isVisible()) continue;
                comp.setLocation(horizont, 0);
                Dimension pref = comp.getPreferredSize();
                int width = pref.width;
                if (comp instanceof JSeparator && dim.height - dim.width <= 0) {
                    width = Math.max(width, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                }
                if (comp instanceof JProgressBar && reminder > 0) {
                    width += reminder;
                }
                int height = this.getToolbarHeight(dim) - 1;
                comp.setSize(width, height);
                horizont += width;
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = SynchronizePanel.this.getSize();
            int height = this.getToolbarHeight(dim);
            int components = parent.getComponentCount();
            int horizont = 0;
            for (int i = 0; i < components; ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible()) continue;
                if (comp instanceof AbstractButton) {
                    this.adjustToobarButton((AbstractButton)comp);
                } else {
                    this.adjustToolbarComponentSize((JComponent)comp);
                }
                Dimension pref = comp.getPreferredSize();
                int width = pref.width;
                if (comp instanceof JSeparator && dim.height - dim.width <= 0) {
                    width = Math.max(width, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                }
                horizont += width;
            }
            return new Dimension(horizont, height);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension dim = SynchronizePanel.this.getSize();
            int height = this.getToolbarHeight(dim);
            return new Dimension(Integer.MAX_VALUE, height);
        }

        private int getToolbarHeight(Dimension parent) {
            if (this.parentSize == null || !this.parentSize.equals(parent)) {
                this.parentSize = parent;
                this.toolbarHeight = -1;
            }
            if (this.toolbarHeight == -1) {
                BufferedImage image = new BufferedImage(1, 1, 10);
                Graphics2D g = image.createGraphics();
                UIDefaults def = UIManager.getLookAndFeelDefaults();
                int height = 0;
                String[] fonts = new String[]{"Label.font", "Button.font", "ToggleButton.font"};
                for (int i = 0; i < fonts.length; ++i) {
                    Font f = def.getFont(fonts[i]);
                    FontMetrics fm = g.getFontMetrics(f);
                    height = Math.max(height, fm.getHeight());
                }
                this.toolbarHeight = height + this.TOOLBAR_HEIGHT_ADJUSTMENT;
                if (parent.height - parent.width > 0) {
                    this.toolbarHeight += this.TOOLBAR_HEIGHT_ADJUSTMENT;
                }
            }
            return this.toolbarHeight;
        }

        private void adjustToobarButton(final AbstractButton button) {
            if (this.adjusted.contains(button)) {
                return;
            }
            if (!(button instanceof JToggleButton)) {
                button.setContentAreaFilled(false);
                button.setMargin(new Insets(0, 3, 0, 3));
                button.setBorderPainted(false);
                button.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        button.setContentAreaFilled(true);
                        button.setBorderPainted(true);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        button.setContentAreaFilled(false);
                        button.setBorderPainted(false);
                    }
                });
            }
            this.adjustToolbarComponentSize(button);
        }

        private void adjustToolbarComponentSize(JComponent button) {
            if (this.adjusted.contains(button)) {
                return;
            }
            if (button.getBorder() instanceof CompoundBorder) {
                Dimension pref = button.getPreferredSize();
                if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                    pref.width += 9;
                }
                button.setPreferredSize(pref);
            }
            this.adjusted.add(button);
        }
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        @Override
        public void run() {
            SynchronizePanel.this.setupModels();
        }
    }
}

