/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.common.dd.DDHelper;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.CreateCapability;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WelcomeFileList;
import org.netbeans.modules.spring.api.SpringUtilities;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.ConfigFileManager;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.webmvc.SpringConfigPanelVisual;
import org.netbeans.modules.spring.webmvc.SpringWebFrameworkProvider;
import org.netbeans.modules.spring.webmvc.utils.SpringWebFrameworkUtils;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

public class SpringWebModuleExtender
extends WebModuleExtender
implements ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(SpringWebModuleExtender.class.getName());
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final SpringWebFrameworkProvider framework;
    private final ExtenderController controller;
    private final boolean customizer;
    private final WebModule webModule;
    private SpringConfigPanelVisual component;
    private String dispatcherName = "dispatcher";
    private String dispatcherMapping = "*.htm";
    private boolean includeJstl = true;

    public SpringWebModuleExtender(SpringWebFrameworkProvider framework, ExtenderController controller, WebModule webModule, boolean customizer) {
        this.framework = framework;
        this.controller = controller;
        this.webModule = webModule;
        this.customizer = customizer;
    }

    public ExtenderController getController() {
        return this.controller;
    }

    public String getDispatcherName() {
        return this.dispatcherName;
    }

    public String getDispatcherMapping() {
        return this.dispatcherMapping;
    }

    public boolean getIncludeJstl() {
        return this.includeJstl;
    }

    public SpringConfigPanelVisual getComponent() {
        if (this.component == null) {
            this.component = new SpringConfigPanelVisual(this);
            this.component.setEnabled(!this.customizer);
        }
        return this.component;
    }

    public boolean isValid() {
        if (this.dispatcherName == null || this.dispatcherName.trim().length() == 0) {
            this.controller.setErrorMessage(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"MSG_DispatcherNameIsEmpty"));
            return false;
        }
        if (!SpringWebFrameworkUtils.isDispatcherServletConfigFilenameValid(this.dispatcherName)) {
            this.controller.setErrorMessage(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"MSG_DispatcherServletConfigFilenameIsNotValid"));
            return false;
        }
        if (this.dispatcherMapping == null || this.dispatcherMapping.trim().length() == 0) {
            this.controller.setErrorMessage(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"MSG_DispatcherMappingPatternIsEmpty"));
            return false;
        }
        if (!SpringWebFrameworkUtils.isDispatcherMappingPatternValid(this.dispatcherMapping)) {
            this.controller.setErrorMessage(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"MSG_DispatcherMappingPatternIsNotValid"));
            return false;
        }
        if (this.webModule != null && !this.isWebXmlValid(this.webModule)) {
            this.controller.setErrorMessage(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"MSG_WebXmlIsNotValid"));
            return false;
        }
        this.controller.setErrorMessage(null);
        return true;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(SpringWebModuleExtender.class);
    }

    public final void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.dispatcherName = this.getComponent().getDispatcherName();
        this.dispatcherMapping = this.getComponent().getDispatcherMapping();
        this.includeJstl = this.getComponent().getIncludeJstl();
        this.changeSupport.fireChange();
    }

    public void update() {
    }

    public Set<FileObject> extend(WebModule webModule) {
        CreateSpringConfig createSpringConfig = new CreateSpringConfig(webModule);
        FileObject webInf = webModule.getWebInf();
        if (webInf == null) {
            try {
                webInf = FileUtil.createFolder((FileObject)webModule.getDocumentBase(), (String)"WEB-INF");
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Exception during creating WEB-INF directory", ex);
            }
        }
        if (webInf != null) {
            try {
                FileSystem fs = webInf.getFileSystem();
                fs.runAtomicAction((FileSystem.AtomicAction)createSpringConfig);
            }
            catch (IOException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
                return null;
            }
        }
        return createSpringConfig.getFilesToOpen();
    }

    private boolean isWebXmlValid(WebModule webModule) {
        FileObject webXml = webModule.getDeploymentDescriptor();
        if (webXml == null) {
            return true;
        }
        WebApp webApp = null;
        try {
            webApp = DDProvider.getDefault().getDDRoot(webXml);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Can't read web.xml file: " + webXml.getPath(), ex);
        }
        return webApp != null && webApp.getStatus() == 0;
    }

    private class CreateSpringConfig
    implements FileSystem.AtomicAction {
        public static final String CONTEXT_LOADER = "org.springframework.web.context.ContextLoaderListener";
        public static final String DISPATCHER_SERVLET = "org.springframework.web.servlet.DispatcherServlet";
        public static final String ENCODING = "UTF-8";
        private final Set<FileObject> filesToOpen = new LinkedHashSet<FileObject>();
        private final WebModule webModule;

        public CreateSpringConfig(WebModule webModule) {
            this.webModule = webModule;
        }

        public void run() throws IOException {
            FileObject dd = this.webModule.getDeploymentDescriptor();
            if (dd == null) {
                dd = DDHelper.createWebXml((Profile)this.webModule.getJ2eeProfile(), (FileObject)this.webModule.getWebInf());
            }
            if (dd != null) {
                WebApp ddRoot = DDProvider.getDefault().getDDRoot(dd);
                this.addContextParam(ddRoot, "contextConfigLocation", "/WEB-INF/applicationContext.xml");
                this.addListener(ddRoot, CONTEXT_LOADER);
                this.addServlet(ddRoot, SpringWebModuleExtender.this.getComponent().getDispatcherName(), DISPATCHER_SERVLET, SpringWebModuleExtender.this.getComponent().getDispatcherMapping(), "2");
                WelcomeFileList welcomeFiles = ddRoot.getSingleWelcomeFileList();
                if (welcomeFiles == null) {
                    try {
                        welcomeFiles = (WelcomeFileList)ddRoot.createBean("WelcomeFileList");
                        ddRoot.setWelcomeFileList(welcomeFiles);
                    }
                    catch (ClassNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (welcomeFiles.sizeWelcomeFile() == 0) {
                    welcomeFiles.addWelcomeFile("redirect.jsp");
                }
                ddRoot.write(dd);
            }
            ArrayList<Library> libraries = new ArrayList<Library>(3);
            Library springLibrary = SpringWebModuleExtender.this.component.getSpringLibrary();
            String version = SpringWebModuleExtender.this.component.getSpringLibraryVersion();
            Library webMVCLibrary = null;
            if (springLibrary != null) {
                libraries.add(springLibrary);
                if (SpringUtilities.isSpringWebMVCLibrary((Library)springLibrary)) {
                    webMVCLibrary = springLibrary;
                }
            } else {
                LOGGER.log(Level.WARNING, null, new Error("No Spring Framework library found."));
            }
            if (webMVCLibrary == null) {
                webMVCLibrary = SpringUtilities.findSpringWebMVCLibrary((String)version);
                if (webMVCLibrary != null) {
                    libraries.add(webMVCLibrary);
                } else {
                    LOGGER.log(Level.WARNING, null, new Error("No Spring Web MVC library with version " + version + " found."));
                }
            }
            if (SpringWebModuleExtender.this.includeJstl) {
                Library jstlLibrary = SpringUtilities.findJSTLibrary();
                if (jstlLibrary != null) {
                    libraries.add(jstlLibrary);
                } else {
                    LOGGER.log(Level.WARNING, null, new Error("No JSTL library found."));
                }
            }
            if (!libraries.isEmpty()) {
                this.addLibrariesToWebModule(libraries, this.webModule);
            }
            FileObject webInf = this.webModule.getWebInf();
            FileObject jsp = FileUtil.createFolder((FileObject)webInf, (String)"jsp");
            DataFolder webInfDO = DataFolder.findFolder((FileObject)webInf);
            final ArrayList<File> newConfigFiles = new ArrayList<File>(2);
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (version.startsWith("3.0")) {
                params.put("springVersion3", Boolean.TRUE);
            }
            FileObject configFile = this.createFromTemplate("applicationContext.xml", webInfDO, "applicationContext", params);
            this.addFileToOpen(configFile);
            newConfigFiles.add(FileUtil.toFile((FileObject)configFile));
            String fullIndexUrl = SpringWebFrameworkUtils.instantiateDispatcherMapping(SpringWebModuleExtender.this.dispatcherMapping, "index");
            String simpleIndexUrl = SpringWebFrameworkUtils.getSimpleDispatcherURL(fullIndexUrl);
            Map<String, Map<String, String>> indexUrlParams = Collections.singletonMap("index", Collections.singletonMap("url", simpleIndexUrl));
            params.putAll(indexUrlParams);
            configFile = this.createFromTemplate("dispatcher-servlet.xml", webInfDO, SpringWebModuleExtender.this.getComponent().getDispatcherName() + "-servlet", params);
            this.addFileToOpen(configFile);
            newConfigFiles.add(FileUtil.toFile((FileObject)configFile));
            this.addFileToOpen(this.createFromTemplate("index.jsp", DataFolder.findFolder((FileObject)jsp), "index"));
            indexUrlParams = Collections.singletonMap("index", Collections.singletonMap("url", fullIndexUrl));
            FileObject documentBase = this.webModule.getDocumentBase();
            FileObject redirectJsp = documentBase.getFileObject("redirect.jsp");
            if (redirectJsp != null) {
                redirectJsp.delete();
            }
            DataFolder documentBaseDO = DataFolder.findFolder((FileObject)documentBase);
            this.addFileToOpen(this.createFromTemplate("redirect.jsp", documentBaseDO, "redirect", indexUrlParams));
            SpringScope scope = SpringScope.getSpringScope((FileObject)configFile);
            if (scope != null) {
                final ConfigFileManager manager = scope.getConfigFileManager();
                try {
                    manager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws IOException {
                            List files = manager.getConfigFiles();
                            files.addAll(newConfigFiles);
                            List groups = manager.getConfigFileGroups();
                            String groupName = NbBundle.getMessage(SpringWebModuleExtender.class, (String)"LBL_DefaultGroup");
                            ConfigFileGroup newGroup = ConfigFileGroup.create((String)groupName, (List)newConfigFiles);
                            groups.add(newGroup);
                            manager.putConfigFilesAndGroups(files, groups);
                            manager.save();
                            return null;
                        }
                    });
                }
                catch (MutexException e) {
                    throw (IOException)e.getException();
                }
            } else {
                LOGGER.log(Level.WARNING, "Could not find a SpringScope for file {0}", configFile);
            }
        }

        public void addFileToOpen(FileObject file) {
            this.filesToOpen.add(file);
        }

        public Set<FileObject> getFilesToOpen() {
            return this.filesToOpen;
        }

        private FileObject createFromTemplate(String templateName, DataFolder targetDO, String fileName, Map<String, ?> params) throws IOException {
            FileObject templateFO = FileUtil.getConfigFile((String)("SpringFramework/Templates/" + templateName));
            DataObject templateDO = DataObject.find((FileObject)templateFO);
            return templateDO.createFromTemplate(targetDO, fileName, params).getPrimaryFile();
        }

        private FileObject createFromTemplate(String templateName, DataFolder targetDO, String fileName) throws IOException {
            FileObject templateFO = FileUtil.getConfigFile((String)("SpringFramework/Templates/" + templateName));
            DataObject templateDO = DataObject.find((FileObject)templateFO);
            return templateDO.createFromTemplate(targetDO, fileName).getPrimaryFile();
        }

        protected boolean addLibrariesToWebModule(List<Library> libraries, WebModule webModule) throws IOException, UnsupportedOperationException {
            FileObject fileObject = webModule.getDocumentBase();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) {
                return false;
            }
            boolean addLibraryResult = false;
            try {
                SourceGroup[] groups = SourceGroups.getJavaSourceGroups((Project)project);
                if (groups.length == 0) {
                    return false;
                }
                addLibraryResult = ProjectClassPathModifier.addLibraries((Library[])libraries.toArray(new Library[libraries.size()]), (FileObject)groups[0].getRootFolder(), (String)"classpath/compile");
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Libraries required for the Spring MVC project not added", e);
            }
            catch (UnsupportedOperationException uoe) {
                LOGGER.log(Level.WARNING, "This project does not support adding these types of libraries to the classpath", uoe);
            }
            return addLibraryResult;
        }

        protected Listener addListener(WebApp webApp, String classname) throws IOException {
            Listener listener = (Listener)this.createBean((CreateCapability)webApp, "Listener");
            listener.setListenerClass(classname);
            webApp.addListener(listener);
            return listener;
        }

        protected Servlet addServlet(WebApp webApp, String name, String classname, String pattern, String loadOnStartup) throws IOException {
            Servlet servlet = (Servlet)this.createBean((CreateCapability)webApp, "Servlet");
            servlet.setServletName(name);
            servlet.setServletClass(classname);
            if (loadOnStartup != null) {
                servlet.setLoadOnStartup(new BigInteger(loadOnStartup));
            }
            webApp.addServlet(servlet);
            if (pattern != null) {
                this.addServletMapping(webApp, name, pattern);
            }
            return servlet;
        }

        protected ServletMapping addServletMapping(WebApp webApp, String name, String pattern) throws IOException {
            ServletMapping mapping = (ServletMapping)this.createBean((CreateCapability)webApp, "ServletMapping");
            mapping.setServletName(name);
            mapping.setUrlPattern(pattern);
            webApp.addServletMapping(mapping);
            return mapping;
        }

        protected InitParam addContextParam(WebApp webApp, String name, String value) throws IOException {
            InitParam initParam = (InitParam)this.createBean((CreateCapability)webApp, "InitParam");
            initParam.setParamName(name);
            initParam.setParamValue(value);
            webApp.addContextParam(initParam);
            return initParam;
        }

        protected CommonDDBean createBean(CreateCapability creator, String beanName) throws IOException {
            CommonDDBean bean = null;
            try {
                bean = creator.createBean(beanName);
            }
            catch (ClassNotFoundException ex) {
                ErrorManager.getDefault().notify(4096, (Throwable)ex);
                throw new IOException("Error creating bean with name:" + beanName);
            }
            return bean;
        }
    }
}

