/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.repository;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.maven.artifact.Artifact;
import org.netbeans.modules.maven.api.CommonArtifactActions;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryUtil;
import org.netbeans.modules.maven.indexer.api.ui.ArtifactViewer;
import org.netbeans.modules.maven.repository.dependency.AddAsDependencyAction;
import org.openide.actions.CopyAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;

public class VersionNode
extends AbstractNode {
    private static final String JAVADOC_BADGE_ICON = "org/netbeans/modules/maven/repository/DependencyJavadocIncluded.png";
    private static final String SOURCE_BADGE_ICON = "org/netbeans/modules/maven/repository/DependencySrcIncluded.png";
    private NBVersionInfo record;
    private boolean hasJavadoc;
    private boolean hasSources;
    private RepositoryInfo info;
    private static String toolTipJavadoc = "<img src=\"" + VersionNode.class.getClassLoader().getResource("org/netbeans/modules/maven/repository/DependencyJavadocIncluded.png") + "\">&nbsp;" + NbBundle.getMessage(VersionNode.class, (String)"ICON_JavadocBadge");
    private static String toolTipSource = "<img src=\"" + VersionNode.class.getClassLoader().getResource("org/netbeans/modules/maven/repository/DependencySrcIncluded.png") + "\">&nbsp;" + NbBundle.getMessage(VersionNode.class, (String)"ICON_SourceBadge");

    public static Children createChildren(RepositoryInfo info, NBVersionInfo record) {
        if (info.isLocal() && !"pom".equals(record.getType())) {
            try {
                Artifact art = RepositoryUtil.createArtifact((NBVersionInfo)record);
                FileObject fo = FileUtil.toFileObject((File)FileUtilities.convertArtifactToLocalRepositoryFile((Artifact)art));
                if (fo != null) {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    return new FilterNode.Children(dobj.getNodeDelegate().cloneNode());
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return Children.LEAF;
    }

    public VersionNode(RepositoryInfo info, NBVersionInfo versionInfo, boolean javadoc, boolean source, boolean dispNameShort) {
        super(VersionNode.createChildren(info, versionInfo));
        this.info = info;
        this.hasJavadoc = javadoc;
        this.hasSources = source;
        this.record = versionInfo;
        if (dispNameShort) {
            this.setName(versionInfo.getVersion());
            this.setDisplayName(versionInfo.getVersion() + " [ " + (versionInfo.getType() != null ? versionInfo.getType() : "jar") + (versionInfo.getClassifier() != null ? "," + versionInfo.getClassifier() : "") + " ]");
        } else {
            this.setName(versionInfo.getGroupId() + ":" + versionInfo.getArtifactId() + ":" + versionInfo.getVersion());
        }
        this.setIconBaseWithExtension("org/netbeans/modules/maven/repository/DependencyJar.gif");
    }

    public boolean canCopy() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable deflt = super.clipboardCopy();
        ExTransferable enriched = ExTransferable.create((Transferable)deflt);
        ExTransferable.Single ex = new ExTransferable.Single(DataFlavor.stringFlavor){

            protected Object getData() {
                return "<dependency>\n  <groupId>" + VersionNode.this.record.getGroupId() + "</groupId>\n" + "  <artifactId>" + VersionNode.this.record.getArtifactId() + "</artifactId>\n" + "  <version>" + VersionNode.this.record.getVersion() + "</version>\n" + "</dependency>";
            }
        };
        enriched.put(ex);
        return enriched;
    }

    public Action[] getActions(boolean context) {
        Artifact artifact = RepositoryUtil.createArtifact((NBVersionInfo)this.record);
        Action[] retValue = this.info.isRemoteDownloadable() ? new Action[]{new ShowArtifactAction(this.record), new AddAsDependencyAction(artifact), CommonArtifactActions.createFindUsages((Artifact)artifact), null, CopyAction.get(CopyAction.class)} : new Action[]{new ShowArtifactAction(this.record), new AddAsDependencyAction(artifact), CommonArtifactActions.createFindUsages((Artifact)artifact), CommonArtifactActions.createViewJavadocAction((Artifact)artifact), null, CopyAction.get(CopyAction.class)};
        return retValue;
    }

    public Action getPreferredAction() {
        return new ShowArtifactAction(this.record);
    }

    public Image getIcon(int param) {
        Image ann;
        Image retValue = super.getIcon(param);
        if (this.hasJavadoc) {
            ann = ImageUtilities.loadImage((String)JAVADOC_BADGE_ICON);
            ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipJavadoc);
            retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ann, (int)12, (int)0);
        }
        if (this.hasSources) {
            ann = ImageUtilities.loadImage((String)SOURCE_BADGE_ICON);
            ann = ImageUtilities.addToolTipToImage((Image)ann, (String)toolTipSource);
            retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ann, (int)12, (int)8);
        }
        return retValue;
    }

    public Image getOpenedIcon(int param) {
        return this.getIcon(param);
    }

    public String getShortDescription() {
        StringBuffer buffer = new StringBuffer();
        if (this.record != null) {
            buffer.append("<html>").append(NbBundle.getMessage(VersionNode.class, (String)"TXT_GroupId")).append("<b>").append(this.record.getGroupId()).append("</b><p>");
            buffer.append(NbBundle.getMessage(VersionNode.class, (String)"TXT_ArtifactId")).append("<b>").append(this.record.getArtifactId()).append("</b><p>");
            buffer.append(NbBundle.getMessage(VersionNode.class, (String)"TXT_Version")).append("<b>").append(this.record.getVersion().toString()).append("</b><p>");
            buffer.append(NbBundle.getMessage(VersionNode.class, (String)"TXT_Packaging")).append("<b>").append(this.record.getPackaging()).append("</b><p>");
            buffer.append(NbBundle.getMessage(VersionNode.class, (String)"TXT_Name")).append(this.record.getProjectName()).append("<p>");
        }
        return buffer.toString();
    }

    private static class ShowArtifactAction
    extends AbstractAction {
        private NBVersionInfo info;

        ShowArtifactAction(NBVersionInfo info) {
            this.info = info;
            this.putValue("Name", NbBundle.getMessage(VersionNode.class, (String)"ACT_View_Details"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ArtifactViewer.showArtifactViewer((NBVersionInfo)this.info);
        }
    }
}

