/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.types.Time;

public final class LineParser {
    private final List<DataTableMetadata.Column> columns;

    public LineParser(List<DataTableMetadata.Column> columns) {
        this.columns = columns;
    }

    public List<Object> parse(String line, Logger log) {
        ArrayList<Object> data = new ArrayList<Object>(this.columns.size());
        StringScanner scanner = new StringScanner(line);
        try {
            for (int i = 0; i < this.columns.size(); ++i) {
                String stringValue = scanner.next();
                if (stringValue == null && log != null && log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, "Line \"{0}\" was split into {1} values while {2} expected", new Object[]{line, i, this.columns.size()});
                    return null;
                }
                Class columnClass = this.columns.get(i).getColumnClass();
                Object value = columnClass == Long.class || columnClass == Time.class ? Long.valueOf(stringValue) : (columnClass == Integer.class ? Integer.valueOf(stringValue) : (columnClass == Short.class ? Short.valueOf(stringValue) : (columnClass == Byte.class ? Byte.valueOf(stringValue) : (columnClass == Double.class ? Double.valueOf(stringValue) : (columnClass == Float.class ? Float.valueOf(stringValue) : stringValue)))));
                data.add(value);
            }
        }
        catch (NumberFormatException ex) {
            if (log != null) {
                log.log(Level.WARNING, "Failed to parse number in line: " + line, ex);
            }
            return null;
        }
        return data;
    }

    private static class StringScanner {
        private final String str;
        private int pos;

        private StringScanner(String string) {
            this.str = string;
            this.pos = 0;
        }

        private String next() {
            block4: while (this.pos < this.str.length()) {
                char c = this.str.charAt(this.pos);
                switch (c) {
                    case '\"': 
                    case '\'': {
                        ++this.pos;
                        return this.next(c);
                    }
                    case '\t': 
                    case ' ': {
                        ++this.pos;
                        continue block4;
                    }
                }
                return this.next(' ');
            }
            return null;
        }

        private String next(char barrier) {
            char c;
            StringBuilder buf = new StringBuilder(16);
            while (!(this.pos >= this.str.length() || (c = this.str.charAt(this.pos++)) == barrier || barrier == ' ' && Character.isWhitespace(c))) {
                if (c == '\\' && this.pos < this.str.length()) {
                    char c2 = this.str.charAt(this.pos++);
                    int r = -1;
                    switch (c2) {
                        case 'r': {
                            r = 13;
                            break;
                        }
                        case 'n': {
                            r = 10;
                            break;
                        }
                        case 't': {
                            r = 9;
                            break;
                        }
                        case '0': {
                            break;
                        }
                        default: {
                            r = c2;
                        }
                    }
                    if (0 >= r) continue;
                    buf.append((char)r);
                    continue;
                }
                buf.append(c);
            }
            return buf.toString();
        }
    }
}

