/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.updater;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.maven.index.context.IndexingContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexDataWriter {
    static final int VERSION = 1;
    static final int F_INDEXED = 1;
    static final int F_TOKENIZED = 2;
    static final int F_STORED = 4;
    static final int F_COMPRESSED = 8;
    private DataOutputStream dos;
    private GZIPOutputStream gos;
    private BufferedOutputStream bos;

    public IndexDataWriter(OutputStream os) throws IOException {
        this.bos = new BufferedOutputStream(os, 8192);
        this.gos = new GZIPOutputStream((OutputStream)this.bos, 2048);
        this.dos = new DataOutputStream(this.gos);
    }

    public int write(IndexingContext context, List<Integer> docIndexes) throws IOException {
        this.writeHeader(context);
        int n = this.writeDocuments(context.getIndexReader(), docIndexes);
        this.close();
        return n;
    }

    public void close() throws IOException {
        this.dos.flush();
        this.gos.flush();
        this.gos.finish();
        this.bos.flush();
    }

    public void writeHeader(IndexingContext context) throws IOException {
        this.dos.writeByte(1);
        Date timestamp = context.getTimestamp();
        this.dos.writeLong(timestamp == null ? -1L : timestamp.getTime());
    }

    public int writeDocuments(IndexReader r, List<Integer> docIndexes) throws IOException {
        int n = 0;
        if (docIndexes == null) {
            for (int i = 0; i < r.maxDoc(); ++i) {
                if (r.isDeleted(i)) continue;
                this.writeDocument(r.document(i));
                ++n;
            }
        } else {
            for (int i : docIndexes) {
                if (r.isDeleted(i)) continue;
                this.writeDocument(r.document(i));
                ++n;
            }
        }
        return n;
    }

    public void writeDocument(Document document) throws IOException {
        List fields = document.getFields();
        int fieldCount = 0;
        for (Fieldable field : fields) {
            if (!field.isStored()) continue;
            ++fieldCount;
        }
        this.dos.writeInt(fieldCount);
        for (Fieldable field : fields) {
            if (!field.isStored()) continue;
            this.writeField(field);
        }
    }

    public void writeField(Fieldable field) throws IOException {
        int flags = (field.isIndexed() ? 1 : 0) + (field.isTokenized() ? 2 : 0) + (field.isStored() ? 4 : 0);
        String name = field.name();
        String value = field.stringValue();
        this.dos.write(flags);
        this.dos.writeUTF(name);
        IndexDataWriter.writeUTF(value, this.dos);
    }

    private static final void writeUTF(String str, DataOutput out) throws IOException {
        int i;
        char c;
        int strlen = str.length();
        int utflen = 0;
        for (int i2 = 0; i2 < strlen; ++i2) {
            c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        out.writeInt(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        out.write(bytearr, 0, utflen);
    }
}

