/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.hints;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.apisupport.hints.Bundle;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class UseNbBundleMessages
extends AbstractHint {
    public UseNbBundleMessages() {
        super(true, true, AbstractHint.HintSeverity.CURRENT_LINE_WARNING, new String[0]);
    }

    public String getId() {
        return UseNbBundleMessages.class.getName();
    }

    public String getDisplayName() {
        return Bundle.UseNbBundleMessages_displayName();
    }

    public String getDescription() {
        return Bundle.UseNbBundleMessages_description();
    }

    public Set<Tree.Kind> getTreeKinds() {
        return Collections.singleton(Tree.Kind.METHOD_INVOCATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ErrorDescription> run(CompilationInfo compilationInfo, final TreePath treePath) {
        final MethodInvocationTree mit = (MethodInvocationTree)treePath.getLeaf();
        ExpressionTree methodSelect = mit.getMethodSelect();
        if (methodSelect.getKind() != Tree.Kind.MEMBER_SELECT) {
            return null;
        }
        MemberSelectTree mst = (MemberSelectTree)methodSelect;
        if (!mst.getIdentifier().contentEquals("getMessage")) {
            return null;
        }
        TypeMirror invoker = compilationInfo.getTrees().getTypeMirror(new TreePath(treePath, mst.getExpression()));
        if (!String.valueOf(invoker).equals("org.openide.util.NbBundle")) {
            return null;
        }
        if (compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE).findResource("org/openide/util/NbBundle$Messages.class") == null) {
            return null;
        }
        int[] span = compilationInfo.getTreeUtilities().findNameSpan(mst);
        if (span == null) {
            return null;
        }
        final List<? extends ExpressionTree> args = mit.getArguments();
        if (args.size() < 2) {
            return null;
        }
        if (args.get(0).getKind() != Tree.Kind.MEMBER_SELECT) {
            return this.warning(Bundle.UseNbBundleMessages_only_class_const(), span, compilationInfo);
        }
        MemberSelectTree thisClassMST = (MemberSelectTree)args.get(0);
        if (!thisClassMST.getIdentifier().contentEquals("class")) {
            return this.warning(Bundle.UseNbBundleMessages_only_class_const(), span, compilationInfo);
        }
        if (thisClassMST.getExpression().getKind() != Tree.Kind.IDENTIFIER) {
            return this.warning(Bundle.UseNbBundleMessages_only_class_const(), span, compilationInfo);
        }
        final FileObject src = compilationInfo.getFileObject();
        if (!((IdentifierTree)thisClassMST.getExpression()).getName().contentEquals(src.getName())) {
            return this.warning(Bundle.UseNbBundleMessages_wrong_class_name(src.getName()), span, compilationInfo);
        }
        if (args.get(1).getKind() != Tree.Kind.STRING_LITERAL) {
            return this.warning(Bundle.UseNbBundleMessages_only_string_const(), span, compilationInfo);
        }
        final String key = ((LiteralTree)args.get(1)).getValue().toString();
        String bundleResource = compilationInfo.getCompilationUnit().getPackageName().toString().replace('.', '/') + "/Bundle.properties";
        final FileObject bundleProperties = compilationInfo.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).findResource(bundleResource);
        if (bundleProperties == null) {
            return this.warning(Bundle.UseNbBundleMessages_no_such_bundle(bundleResource), span, compilationInfo);
        }
        final EditableProperties ep = new EditableProperties(true);
        try {
            if (DataObject.find((FileObject)bundleProperties).isModified()) {
                return this.warning(Bundle.UseNbBundleMessages_save_bundle(), span, compilationInfo);
            }
            InputStream is = bundleProperties.getInputStream();
            try {
                ep.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException x) {
            Exceptions.printStackTrace((Throwable)x);
            return null;
        }
        if (!ep.containsKey((Object)key)) {
            return this.warning(Bundle.UseNbBundleMessages_no_such_key(key), span, compilationInfo);
        }
        return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)Bundle.UseNbBundleMessages_error_text(), Collections.singletonList(new Fix(){

            public String getText() {
                return Bundle.UseNbBundleMessages_displayName();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ChangeInfo implement() throws Exception {
                JavaSource js = JavaSource.forFileObject((FileObject)src);
                if (js == null) {
                    throw new Exception("No source info for " + src);
                }
                js.runModificationTask((Task)new Task<WorkingCopy>(){

                    public void run(WorkingCopy wc) throws Exception {
                        wc.toPhase(JavaSource.Phase.RESOLVED);
                        TreeMaker make = wc.getTreeMaker();
                        CompilationUnitTree cut = wc.getCompilationUnit();
                        boolean imported = false;
                        String importBundleStar = cut.getPackageName() + ".Bundle.*";
                        for (ImportTree importTree : cut.getImports()) {
                            if (!importTree.isStatic() || !importTree.getQualifiedIdentifier().toString().equals(importBundleStar)) continue;
                            imported = true;
                            break;
                        }
                        if (!imported) {
                            wc.rewrite((Tree)cut, (Tree)make.addCompUnitImport(cut, make.Import((Tree)make.Identifier((CharSequence)importBundleStar), true)));
                        }
                        List<Object> params = args.size() == 3 && ((ExpressionTree)args.get(2)).getKind() == Tree.Kind.NEW_ARRAY ? ((NewArrayTree)args.get(2)).getInitializers() : args.subList(2, args.size());
                        wc.rewrite((Tree)mit, (Tree)make.MethodInvocation(Collections.emptyList(), (ExpressionTree)make.Identifier((CharSequence)UseNbBundleMessages.this.toIdentifier(key)), params));
                        Tree tree = this.findEnclosingElement(wc, treePath);
                        ModifiersTree modifiers = tree.getKind() == Tree.Kind.METHOD ? ((MethodTree)tree).getModifiers() : ((ClassTree)tree).getModifiers();
                        ArrayList<ExpressionTree> lines = new ArrayList<ExpressionTree>();
                        for (String comment : ep.getComment(key)) {
                            lines.add(make.Literal((Object)comment));
                        }
                        lines.add(make.Literal((Object)(key + '=' + (String)ep.remove((Object)key))));
                        wc.rewrite((Tree)modifiers, (Tree)this.addMessage(wc, modifiers, lines));
                    }

                    private ModifiersTree addMessage(WorkingCopy wc, ModifiersTree original, List<ExpressionTree> lines) throws Exception {
                        TreeMaker make = wc.getTreeMaker();
                        List<? extends AnnotationTree> anns = original.getAnnotations();
                        for (int i = 0; i < anns.size(); ++i) {
                            NewArrayTree arr;
                            AnnotationTree ann = anns.get(i);
                            Tree annotationType = ann.getAnnotationType();
                            if (!annotationType.toString().matches("((org[.]openide[.]util[.])?NbBundle[.])?Messages")) continue;
                            List<? extends ExpressionTree> args = ann.getArguments();
                            if (args.size() != 1) {
                                throw new Exception("expecting just one arg for @Messages");
                            }
                            AssignmentTree assign = (AssignmentTree)args.get(0);
                            if (!assign.getVariable().toString().equals("value")) {
                                throw new Exception("expected value=... for @Messages");
                            }
                            ExpressionTree arg = assign.getExpression();
                            if (arg.getKind() == Tree.Kind.STRING_LITERAL) {
                                arr = make.NewArray(null, Collections.emptyList(), Collections.singletonList(arg));
                            } else if (arg.getKind() == Tree.Kind.NEW_ARRAY) {
                                arr = (NewArrayTree)arg;
                            } else {
                                throw new Exception("unknown arg kind " + (Object)((Object)arg.getKind()) + ": " + arg);
                            }
                            for (ExpressionTree line : lines) {
                                arr = make.addNewArrayInitializer(arr, line);
                            }
                            ann = make.Annotation(annotationType, Collections.singletonList(arr));
                            return make.insertModifiersAnnotation(make.removeModifiersAnnotation(original, i), i, ann);
                        }
                        List<ExpressionTree> values = lines.size() > 1 ? Collections.singletonList(make.NewArray(null, Collections.emptyList(), lines)) : lines;
                        return (ModifiersTree)GeneratorUtilities.get((WorkingCopy)wc).importFQNs((Tree)make.addModifiersAnnotation(original, make.Annotation((Tree)make.QualIdent("org.openide.util.NbBundle.Messages"), values)));
                    }

                    private Tree findEnclosingElement(WorkingCopy wc, TreePath treePath) {
                        Tree leaf = treePath.getLeaf();
                        Tree.Kind kind = leaf.getKind();
                        switch (kind) {
                            case CLASS: 
                            case ENUM: 
                            case INTERFACE: 
                            case ANNOTATION_TYPE: 
                            case METHOD: {
                                TypeElement type;
                                Element e = wc.getTrees().getElement(treePath);
                                if (e == null) break;
                                TypeElement typeElement = type = kind == Tree.Kind.METHOD ? wc.getElementUtilities().enclosingTypeElement(e) : (TypeElement)e;
                                if (type != null && wc.getElementUtilities().isLocal((Element)type)) break;
                                return leaf;
                            }
                        }
                        TreePath parentPath = treePath.getParentPath();
                        if (parentPath == null) {
                            return null;
                        }
                        return this.findEnclosingElement(wc, parentPath);
                    }
                }).commit();
                OutputStream os = bundleProperties.getOutputStream();
                try {
                    ep.store(os);
                }
                finally {
                    os.close();
                }
                return null;
            }
        }), (FileObject)compilationInfo.getFileObject(), (int)span[0], (int)span[1]));
    }

    private List<ErrorDescription> warning(String text, int[] span, CompilationInfo compilationInfo) {
        return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)text, Collections.emptyList(), (FileObject)compilationInfo.getFileObject(), (int)span[0], (int)span[1]));
    }

    public void cancel() {
    }

    private String toIdentifier(String key) {
        if (Utilities.isJavaIdentifier((String)key)) {
            return key;
        }
        String i = key.replaceAll("[^\\p{javaJavaIdentifierPart}]+", "_");
        if (Utilities.isJavaIdentifier((String)i)) {
            return i;
        }
        return "_" + i;
    }
}

