/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.netbeans.modules.dlight.core.stack.storage.impl.MetricsCache;
import org.netbeans.modules.dlight.spi.support.SQLRequest;
import org.netbeans.modules.dlight.spi.support.SQLStatementsCache;

final class SQLStackRequestsProvider {
    private static final int MAX_STRING_LENGTH = 16384;
    private final SQLStatementsCache cache;
    private final MetricsCache metricsCache;

    public SQLStackRequestsProvider(SQLStatementsCache cache, MetricsCache metricsCache) {
        this.cache = cache;
        this.metricsCache = metricsCache;
    }

    public SQLRequest addSourceFileInfo(long id, CharSequence sourceFile) {
        return new AddSourceFileInfo(id, sourceFile);
    }

    public AddNodeRequest addNode(Long nodeId, long callerId, long funcId, long offset, int lineNumber) {
        return new AddNodeRequest(nodeId, callerId, funcId, offset, lineNumber);
    }

    public AddFunctionRequest addFunction(Long funcId, String funcName, int source_file_index, int line_number, long context_id) {
        return new AddFunctionRequest(funcId, funcName, source_file_index, line_number, context_id);
    }

    public SQLRequest updateNodeMetrics(long id, long bucket) {
        return new UpdateMetricsRequest(true, id, bucket);
    }

    public SQLRequest updateFunctionMetrics(long id, long bucket) {
        return new UpdateMetricsRequest(false, id, bucket);
    }

    private static String truncateString(String str) {
        if (str.length() <= 16384) {
            return str;
        }
        return str.substring(0, 16381) + "...";
    }

    public class UpdateMetricsRequest
    implements SQLRequest {
        public final boolean funcOrNode;
        public final long objId;
        public final long bucketId;

        public UpdateMetricsRequest(boolean funcOrNode, long objId, long bucketId) {
            this.funcOrNode = funcOrNode;
            this.objId = objId;
            this.bucketId = bucketId;
        }

        public void execute() throws SQLException {
            if (this.funcOrNode) {
                this.executeNode();
            } else {
                this.executeFunc();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void executeFunc() throws SQLException {
            MetricsCache.Metrics metrics = SQLStackRequestsProvider.this.metricsCache.getAndResetFunctionMetrics(this.objId, this.bucketId);
            if (metrics == null) {
                return;
            }
            PreparedStatement stmt = SQLStackRequestsProvider.this.cache.getPreparedStatement("SELECT func_id, bucket_id, time_incl, time_excl FROM FuncMetricAggr WHERE func_id = ? AND bucket_id = ? FOR UPDATE");
            stmt.setLong(1, this.objId);
            stmt.setLong(2, this.bucketId);
            ResultSet rs = stmt.executeQuery();
            try {
                if (rs.next()) {
                    rs.updateLong(3, rs.getLong(3) + metrics.incl);
                    rs.updateLong(4, rs.getLong(4) + metrics.excl);
                    rs.updateRow();
                } else {
                    rs.moveToInsertRow();
                    rs.updateLong(1, this.objId);
                    rs.updateLong(2, this.bucketId);
                    rs.updateLong(3, metrics.incl);
                    rs.updateLong(4, metrics.excl);
                    rs.insertRow();
                }
            }
            finally {
                rs.close();
            }
        }

        private void executeNode() throws SQLException {
            MetricsCache.Metrics metrics = SQLStackRequestsProvider.this.metricsCache.getAndResetNodeMetrics(this.objId, this.bucketId);
            if (metrics == null) {
                return;
            }
            PreparedStatement stmt = SQLStackRequestsProvider.this.cache.getPreparedStatement("UPDATE Node SET time_incl = time_incl + ?, time_excl = time_excl + ? WHERE node_id = ?");
            stmt.setLong(1, metrics.incl);
            stmt.setLong(2, metrics.excl);
            stmt.setLong(3, this.objId);
            stmt.executeUpdate();
        }
    }

    public class AddSourceFileInfo
    implements SQLRequest {
        public final long id;
        public final CharSequence sourceFile;

        public AddSourceFileInfo(long id, CharSequence sourceFile) {
            this.id = id;
            this.sourceFile = sourceFile;
        }

        public void execute() throws SQLException {
            PreparedStatement stmt = SQLStackRequestsProvider.this.cache.getPreparedStatement("INSERT INTO SourceFiles (source_file) VALUES ( ?)");
            stmt.setString(1, SQLStackRequestsProvider.truncateString(((Object)this.sourceFile).toString()));
            stmt.executeUpdate();
        }
    }

    public class AddFunctionRequest
    implements SQLRequest {
        public final long id;
        public final CharSequence name;
        public final int sourceFileIndex;
        public final int line_number;
        public final long context_id;

        public AddFunctionRequest(long id, CharSequence name, int sourceFileIndex, int line_number, long context_id) {
            this.id = id;
            this.name = name;
            this.sourceFileIndex = sourceFileIndex;
            this.line_number = line_number;
            this.context_id = context_id;
        }

        public void execute() throws SQLException {
            PreparedStatement stmt = SQLStackRequestsProvider.this.cache.getPreparedStatement("INSERT INTO Func (func_id, func_name, func_source_file_id, line_number, context_id) VALUES (?, ?, ?, ?, ?)");
            stmt.setLong(1, this.id);
            stmt.setString(2, SQLStackRequestsProvider.truncateString(((Object)this.name).toString()));
            stmt.setInt(3, this.sourceFileIndex);
            stmt.setLong(4, this.line_number);
            stmt.setLong(5, this.context_id);
            stmt.executeUpdate();
        }
    }

    public class AddNodeRequest
    implements SQLRequest {
        public final long id;
        public final long callerId;
        public final long funcId;
        public final long offset;
        public final int lineNumber;

        public AddNodeRequest(long id, long callerId, long funcId, long offset, int lineNumber) {
            this.id = id;
            this.callerId = callerId;
            this.funcId = funcId;
            this.offset = offset;
            this.lineNumber = lineNumber;
        }

        public void execute() throws SQLException {
            PreparedStatement stmt = SQLStackRequestsProvider.this.cache.getPreparedStatement("INSERT INTO Node (node_id, caller_id, func_id, offset, time_incl, time_excl, line_number) VALUES (?, ?, ?, ?, ?, ?, ?)");
            stmt.setLong(1, this.id);
            stmt.setLong(2, this.callerId);
            stmt.setLong(3, this.funcId);
            stmt.setLong(4, this.offset);
            stmt.setInt(5, this.lineNumber);
            stmt.setLong(5, 0L);
            stmt.setLong(6, 0L);
            stmt.setInt(7, this.lineNumber);
            stmt.executeUpdate();
        }
    }
}

