/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.ExtIcon;
import org.netbeans.modules.project.ui.Hacks;
import org.netbeans.modules.project.ui.LazyProject;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.OpeningProjectPanel;
import org.netbeans.modules.project.ui.ProjectInfoAccessor;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.ProjectsRootNode;
import org.netbeans.modules.project.ui.api.UnloadedProjectInformation;
import org.netbeans.modules.project.uiapi.ProjectOpenedTrampoline;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.ModuleInfo;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.WindowManager;

public final class OpenProjectList {
    public static final String PROPERTY_OPEN_PROJECTS = "OpenProjects";
    public static final String PROPERTY_MAIN_PROJECT = "MainProject";
    public static final String PROPERTY_RECENT_PROJECTS = "RecentProjects";
    public static final String PROPERTY_REPLACE = "ReplaceProject";
    private static OpenProjectList INSTANCE;
    private static final int NUM_TEMPLATES = 15;
    public static final RequestProcessor OPENING_RP;
    static final Logger LOGGER;
    private List<Project> openProjects;
    private final HashMap<ModuleInfo, List<Project>> openProjectsModuleInfos;
    private Project mainProject;
    private final RecentProjectList recentProjects;
    private final List<String> recentTemplates;
    private final PropertyChangeSupport pchSupport;
    private ProjectDeletionListener deleteListener = new ProjectDeletionListener();
    private NbProjectDeletionListener nbprojectDeleteListener = new NbProjectDeletionListener();
    private PropertyChangeListener infoListener;
    private final LoadOpenProjects LOAD = new LoadOpenProjects(0);

    public static Comparator<Project> projectByDisplayName() {
        return new ProjectByDisplayNameComparator();
    }

    static void log(LogRecord r) {
        LOGGER.log(r);
    }

    static void log(Level l, String msg, Object ... params) {
        LOGGER.log(l, msg, params);
    }

    static void log(Level l, String msg, Throwable e) {
        LOGGER.log(l, msg, e);
    }

    OpenProjectList() {
        this.openProjects = new ArrayList<Project>();
        this.openProjectsModuleInfos = new HashMap();
        this.infoListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evn) {
                if ("enabled".equals(evn.getPropertyName())) {
                    OpenProjectList.this.checkModuleInfo((ModuleInfo)evn.getSource());
                }
            }
        };
        this.pchSupport = new PropertyChangeSupport(this);
        this.recentProjects = new RecentProjectList(10);
        this.recentTemplates = new ArrayList<String>();
    }

    public static OpenProjectList getDefault() {
        return (OpenProjectList)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<OpenProjectList>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public OpenProjectList run() {
                Class<OpenProjectList> clazz = OpenProjectList.class;
                synchronized (OpenProjectList.class) {
                    if (INSTANCE == null) {
                        INSTANCE = new OpenProjectList();
                        INSTANCE.openProjects = OpenProjectList.loadProjectList();
                        INSTANCE.recentProjects.load();
                        WindowManager.getDefault().invokeWhenUIReady((Runnable)INSTANCE.LOAD);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return INSTANCE;
                }
            }
        });
    }

    static void waitProjectsFullyOpen() {
        OpenProjectList.getDefault().LOAD.waitFinished();
    }

    static void preferredProject(Project lazyP) {
        if (lazyP != null) {
            OpenProjectList.getDefault().LOAD.preferredProject(Collections.singleton(lazyP.getProjectDirectory()));
        }
    }

    Future<Project[]> openProjectsAPI() {
        return this.LOAD;
    }

    final Project unwrapProject(Project wrap) {
        Project[] now = this.getOpenProjects();
        if (wrap instanceof LazyProject) {
            LazyProject lp = (LazyProject)wrap;
            for (Project p : now) {
                if (!lp.getProjectDirectory().equals(p.getProjectDirectory())) continue;
                return p;
            }
        }
        return wrap;
    }

    private List<String> getRecentTemplates() {
        assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
        return this.recentTemplates;
    }

    public void open(Project p) {
        this.open(new Project[]{p}, false);
    }

    public void open(Project p, boolean openSubprojects) {
        this.open(new Project[]{p}, openSubprojects);
    }

    public void open(Project[] projects, boolean openSubprojects) {
        this.open(projects, openSubprojects, false);
    }

    public void open(Project[] projects, boolean openSubprojects, boolean asynchronously) {
        this.open(projects, openSubprojects, asynchronously, null);
    }

    public void open(final Project[] projects, final boolean openSubprojects, final boolean asynchronously, final Project mainProject) {
        if (projects.length == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        if (asynchronously) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OpenProjectList.this.open(projects, openSubprojects, asynchronously, mainProject);
                    }
                });
                return;
            }
            final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(OpenProjectList.class, (String)"CAP_Opening_Projects"));
            Frame mainWindow = WindowManager.getDefault().getMainWindow();
            final JDialog dialog = new JDialog(mainWindow, NbBundle.getMessage(OpenProjectList.class, (String)"LBL_Opening_Projects_Progress"), true);
            final OpeningProjectPanel panel = new OpeningProjectPanel(handle);
            dialog.getContentPane().add(panel);
            dialog.setDefaultCloseOperation(0);
            dialog.pack();
            Rectangle bounds = mainWindow.getBounds();
            int middleX = bounds.x + bounds.width / 2;
            int middleY = bounds.y + bounds.height / 2;
            Dimension size = dialog.getPreferredSize();
            dialog.setBounds(middleX - size.width / 2, middleY - size.height / 2, size.width, size.height);
            OPENING_RP.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        OpenProjectList.this.doOpen(projects, openSubprojects, handle, panel);
                        if (mainProject != null && Arrays.asList(projects).contains(mainProject) && OpenProjectList.this.openProjects.contains(mainProject)) {
                            OpenProjectList.this.setMainProject(mainProject);
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(50L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                dialog.setVisible(false);
                                dialog.dispose();
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            dialog.setVisible(true);
        } else {
            this.doOpen(projects, openSubprojects, null, null);
            if (mainProject != null && Arrays.asList(projects).contains(mainProject) && this.openProjects.contains(mainProject)) {
                this.setMainProject(mainProject);
            }
        }
        long end = System.currentTimeMillis();
        if (LOGGER.isLoggable(Level.FINE)) {
            OpenProjectList.log(Level.FINE, "opening projects took: " + (end - start) + "ms", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOpen(Project[] projects, boolean openSubprojects, ProgressHandle handle, OpeningProjectPanel panel) {
        assert (!Arrays.asList(projects).contains(null)) : "Projects can't be null";
        this.LOAD.waitFinished();
        try {
            this.LOAD.enter();
            boolean recentProjectsChanged = false;
            int maxWork = 1000;
            int workForSubprojects = maxWork / 2;
            double currentWork = 0.0;
            LinkedHashSet<Project> projectsToOpen = new LinkedHashSet<Project>();
            if (handle != null) {
                handle.start(maxWork);
                handle.progress(0);
            }
            if (panel != null) {
                assert (projects.length > 0) : "at least one project to open";
                panel.setProjectName(ProjectUtils.getInformation((Project)projects[0]).getDisplayName());
            }
            HashMap<Project, Set> subprojectsCache = new HashMap<Project, Set>();
            LinkedList<Project> toHandle = new LinkedList<Project>(Arrays.asList(projects));
            while (!toHandle.isEmpty()) {
                Set subprojects;
                Project p = (Project)toHandle.remove(0);
                assert (p != null);
                Set set = subprojects = openSubprojects ? (Set)subprojectsCache.get(p) : Collections.emptySet();
                if (subprojects == null) {
                    SubprojectProvider spp = (SubprojectProvider)p.getLookup().lookup(SubprojectProvider.class);
                    subprojects = spp != null ? spp.getSubprojects() : Collections.emptySet();
                    subprojectsCache.put(p, subprojects);
                }
                projectsToOpen.add(p);
                for (Project sub : subprojects) {
                    assert (sub != null);
                    if (projectsToOpen.contains(sub) || toHandle.contains(sub)) continue;
                    toHandle.add(sub);
                }
                double workPerOneProject = ((double)workForSubprojects - currentWork) / (double)(toHandle.size() + 1);
                int lastState = (int)currentWork;
                if (handle == null || lastState >= (int)(currentWork += workPerOneProject)) continue;
                handle.progress((int)currentWork);
            }
            double workPerProject = (maxWork - workForSubprojects) / projectsToOpen.size();
            final ArrayList oldprjs = new ArrayList();
            final ArrayList newprjs = new ArrayList();
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    oldprjs.addAll(OpenProjectList.this.openProjects);
                    return null;
                }
            });
            for (Project p : projectsToOpen) {
                if (panel != null) {
                    panel.setProjectName(ProjectUtils.getInformation((Project)p).getDisplayName());
                }
                recentProjectsChanged |= this.doOpenProject(p);
                int lastState = (int)currentWork;
                if (handle == null || lastState >= (int)(currentWork += workPerProject)) continue;
                handle.progress((int)currentWork);
            }
            final boolean _recentProjectsChanged = recentProjectsChanged;
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    newprjs.addAll(OpenProjectList.this.openProjects);
                    OpenProjectList.saveProjectList(OpenProjectList.this.openProjects);
                    if (_recentProjectsChanged) {
                        OpenProjectList.this.recentProjects.save();
                    }
                    return null;
                }
            });
            if (handle != null) {
                handle.finish();
            }
            final boolean recentProjectsChangedCopy = recentProjectsChanged;
            LogRecord[] addedRec = OpenProjectList.createRecord("UI_OPEN_PROJECTS", projectsToOpen.toArray(new Project[0]));
            OpenProjectList.log(addedRec, "org.netbeans.ui.projects");
            addedRec = OpenProjectList.createRecordMetrics("USG_PROJECT_OPEN", projectsToOpen.toArray(new Project[0]));
            OpenProjectList.log(addedRec, "org.netbeans.ui.metrics.projects");
            Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_OPEN_PROJECTS, oldprjs.toArray(new Project[oldprjs.size()]), newprjs.toArray(new Project[newprjs.size()]));
                    if (recentProjectsChangedCopy) {
                        OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_RECENT_PROJECTS, null, null);
                    }
                    return null;
                }
            });
        }
        finally {
            this.LOAD.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Project[] someProjects, boolean notifyUI) {
        boolean doSave = false;
        if (!this.LOAD.closeBeforeOpen(someProjects)) {
            doSave = true;
            this.LOAD.waitFinished();
        }
        final Project[] projects = new Project[someProjects.length];
        for (int i = 0; i < someProjects.length; ++i) {
            projects[i] = this.unwrapProject(someProjects[i]);
        }
        if (!ProjectUtilities.closeAllDocuments(projects, notifyUI)) {
            return;
        }
        try {
            this.LOAD.enter();
            ProjectUtilities.WaitCursor.show();
            OpenProjectList.logProjects("close(): closing project: ", projects);
            final AtomicBoolean mainClosed = new AtomicBoolean();
            final AtomicBoolean someClosed = new AtomicBoolean();
            final ArrayList oldprjs = new ArrayList();
            final ArrayList newprjs = new ArrayList();
            final ArrayList notifyList = new ArrayList();
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    oldprjs.addAll(OpenProjectList.this.openProjects);
                    for (Project p : projects) {
                        Iterator it = OpenProjectList.this.openProjects.iterator();
                        boolean found = false;
                        while (it.hasNext()) {
                            if (!((Project)it.next()).equals(p)) continue;
                            found = true;
                            break;
                        }
                        if (!found) continue;
                        if (!mainClosed.get()) {
                            mainClosed.set(OpenProjectList.this.isMainProject(p));
                        }
                        it.remove();
                        OpenProjectList.this.removeModuleInfo(p);
                        p.getProjectDirectory().removeFileChangeListener((FileChangeListener)OpenProjectList.this.deleteListener);
                        notifyList.add(p);
                        someClosed.set(true);
                    }
                    if (someClosed.get()) {
                        newprjs.addAll(OpenProjectList.this.openProjects);
                        OpenProjectList.saveProjectList(OpenProjectList.this.openProjects);
                    }
                    if (mainClosed.get()) {
                        OpenProjectList.this.mainProject = null;
                        OpenProjectList.saveMainProject(OpenProjectList.this.mainProject);
                    }
                    return null;
                }
            });
            if (!notifyList.isEmpty()) {
                for (Project p : notifyList) {
                    this.recentProjects.add(p);
                    this.recentProjects.save();
                }
            }
            OPENING_RP.post(new Runnable(){

                @Override
                public void run() {
                    for (Project closed : notifyList) {
                        OpenProjectList.notifyClosed(closed);
                    }
                }
            });
            OpenProjectList.logProjects("close(): openProjects == ", this.openProjects.toArray(new Project[0]));
            if (someClosed.get()) {
                this.pchSupport.firePropertyChange(PROPERTY_OPEN_PROJECTS, oldprjs.toArray(new Project[oldprjs.size()]), newprjs.toArray(new Project[newprjs.size()]));
            }
            if (mainClosed.get()) {
                this.pchSupport.firePropertyChange(PROPERTY_MAIN_PROJECT, null, null);
            }
            if (someClosed.get()) {
                this.pchSupport.firePropertyChange(PROPERTY_RECENT_PROJECTS, null, null);
            }
            if (doSave) {
                for (int i = 0; i < projects.length; ++i) {
                    if (projects[i] instanceof LazyProject) continue;
                    try {
                        ProjectManager.getDefault().saveProject(projects[i]);
                        continue;
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
            }
            LogRecord[] removedRec = OpenProjectList.createRecord("UI_CLOSED_PROJECTS", projects);
            OpenProjectList.log(removedRec, "org.netbeans.ui.projects");
            removedRec = OpenProjectList.createRecordMetrics("USG_PROJECT_CLOSE", projects);
            OpenProjectList.log(removedRec, "org.netbeans.ui.metrics.projects");
        }
        finally {
            ProjectUtilities.WaitCursor.hide();
            this.LOAD.exit();
        }
    }

    public Project[] getOpenProjects() {
        return (Project[])ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Project[]>(){

            public Project[] run() {
                return OpenProjectList.this.openProjects.toArray(new Project[OpenProjectList.this.openProjects.size()]);
            }
        });
    }

    public boolean isOpen(final Project p) {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                for (Project cp : OpenProjectList.this.openProjects) {
                    if (!p.getProjectDirectory().equals(cp.getProjectDirectory())) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public boolean isMainProject(final Project p) {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                if (OpenProjectList.this.mainProject != null && p != null && OpenProjectList.this.mainProject.getProjectDirectory().equals(p.getProjectDirectory())) {
                    return true;
                }
                return false;
            }
        });
    }

    public Project getMainProject() {
        return (Project)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Project>(){

            public Project run() {
                return OpenProjectList.this.mainProject;
            }
        });
    }

    public void setMainProject(final Project mainProject) {
        LOGGER.finer("Setting main project: " + mainProject);
        OpenProjectList.logProjects("setMainProject(): openProjects == ", this.openProjects.toArray(new Project[0]));
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                Project main = mainProject;
                if (main != null && !OpenProjectList.this.openProjects.contains(main)) {
                    try {
                        main = ProjectManager.getDefault().findProject(main.getProjectDirectory());
                        if (main != null) {
                            boolean fail = true;
                            for (Project p : OpenProjectList.this.openProjects) {
                                if (p.equals(main)) {
                                    fail = false;
                                    break;
                                }
                                if (!(p instanceof LazyProject) || !p.getProjectDirectory().equals(main.getProjectDirectory())) continue;
                                main = p;
                                fail = false;
                                break;
                            }
                            if (fail) {
                                OpenProjectList.logProjects("setMainProject(): openProjects == ", OpenProjectList.this.openProjects.toArray(new Project[0]));
                                IllegalArgumentException x = new IllegalArgumentException("Project " + ProjectUtils.getInformation((Project)mainProject).getDisplayName() + " is not open and cannot be set as main.");
                                Exceptions.attachSeverity((Throwable)x, (Level)Level.INFO);
                                throw x;
                            }
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                OpenProjectList.this.mainProject = main;
                OpenProjectList.saveMainProject(main);
                return null;
            }
        });
        this.pchSupport.firePropertyChange(PROPERTY_MAIN_PROJECT, null, null);
    }

    public List<Project> getRecentProjects() {
        return (List)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<List<Project>>(){

            public List<Project> run() {
                return OpenProjectList.this.recentProjects.getProjects();
            }
        });
    }

    public boolean isRecentProjectsEmpty() {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                return OpenProjectList.this.recentProjects.isEmpty();
            }
        });
    }

    public List<UnloadedProjectInformation> getRecentProjectsInformation() {
        return (List)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<List<UnloadedProjectInformation>>(){

            public List<UnloadedProjectInformation> run() {
                return OpenProjectList.this.recentProjects.getRecentProjectsInfo();
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pchSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pchSupport.removePropertyChangeListener(l);
    }

    public List<DataObject> getTemplatesLRU(Project project, PrivilegedTemplates priv) {
        ArrayList<FileObject> pLRU = this.getTemplateNamesLRU(project, priv);
        ArrayList<DataObject> templates = new ArrayList<DataObject>();
        Iterator it = pLRU.iterator();
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            if (fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    templates.add(dobj);
                }
                catch (DataObjectNotFoundException e) {
                    it.remove();
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                continue;
            }
            it.remove();
        }
        return templates;
    }

    public void updateTemplatesLRU(final FileObject template) {
        ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

            public Void run() {
                String templateName = template.getPath();
                if (OpenProjectList.this.getRecentTemplates().contains(templateName)) {
                    OpenProjectList.this.getRecentTemplates().remove(templateName);
                }
                OpenProjectList.this.getRecentTemplates().add(0, templateName);
                if (OpenProjectList.this.getRecentTemplates().size() > 100) {
                    OpenProjectList.this.getRecentTemplates().remove(100);
                }
                OpenProjectListSettings.getInstance().setRecentTemplates(new ArrayList<String>(OpenProjectList.this.getRecentTemplates()));
                return null;
            }
        });
    }

    static void shutdown() {
        if (INSTANCE != null) {
            for (Project p : OpenProjectList.INSTANCE.openProjects) {
                OpenProjectList.notifyClosed(p);
            }
        }
    }

    public static Project fileToProject(File projectDir) {
        try {
            FileObject fo = FileUtil.toFileObject((File)projectDir);
            if (fo != null && fo.isFolder()) {
                return ProjectManager.getDefault().findProject(fo);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static LinkedList<Project> URLs2Projects(Collection<URL> URLs) {
        LinkedList<Project> result = new LinkedList<Project>();
        for (URL url : URLs) {
            FileObject dir = URLMapper.findFileObject((URL)url);
            if (dir == null || !dir.isFolder()) continue;
            try {
                Project p = ProjectManager.getDefault().findProject(dir);
                if (p == null) continue;
                result.add(p);
            }
            catch (Throwable t) {
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                ErrorManager.getDefault().notify(1, t);
            }
        }
        return result;
    }

    private static List<URL> projects2URLs(Collection<Project> projects) {
        ArrayList<URL> URLs = new ArrayList<URL>(projects.size());
        for (Project p : projects) {
            try {
                URL root = p.getProjectDirectory().getURL();
                if (root == null) continue;
                URLs.add(root);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return URLs;
    }

    private static boolean notifyOpened(Project p) {
        boolean ok = true;
        for (ProjectOpenedHook hook : p.getLookup().lookupAll(ProjectOpenedHook.class)) {
            try {
                ProjectOpenedTrampoline.DEFAULT.projectOpened(hook);
            }
            catch (RuntimeException e) {
                OpenProjectList.log(Level.WARNING, null, e);
                OpenProjectList.INSTANCE.openProjects.remove(p);
                INSTANCE.removeModuleInfo(p);
                ok = false;
            }
            catch (Error e) {
                OpenProjectList.log(Level.WARNING, null, e);
                OpenProjectList.INSTANCE.openProjects.remove(p);
                INSTANCE.removeModuleInfo(p);
                ok = false;
            }
        }
        if (System.getProperty("test.whitelist.stage") == null) {
            OpenProjectList.prepareTemplates(null, null, null, null, p, p.getLookup());
        }
        return ok;
    }

    private static void notifyClosed(Project p) {
        for (ProjectOpenedHook hook : p.getLookup().lookupAll(ProjectOpenedHook.class)) {
            try {
                ProjectOpenedTrampoline.DEFAULT.projectClosed(hook);
            }
            catch (RuntimeException e) {
                OpenProjectList.log(Level.WARNING, null, e);
            }
            catch (Error e) {
                OpenProjectList.log(Level.WARNING, null, e);
            }
        }
    }

    public static boolean prepareTemplates(JMenu menuItem, ActionListener menuListener, MessageFormat templateName, String propertyName, Project project, Lookup lookup) {
        PrivilegedTemplates privs = (PrivilegedTemplates)lookup.lookup(PrivilegedTemplates.class);
        boolean itemAdded = false;
        for (DataObject template : OpenProjectList.getDefault().getTemplatesLRU(project, privs)) {
            Node delegate = template.getNodeDelegate();
            Icon icon = ImageUtilities.image2Icon((Image)delegate.getIcon(1));
            String displayName = delegate.getDisplayName();
            if (templateName != null) {
                JMenuItem item = new JMenuItem(templateName.format(new Object[]{displayName}), icon);
                item.addActionListener(menuListener);
                item.putClientProperty(propertyName, template);
                menuItem.add(item);
            }
            itemAdded = true;
        }
        return itemAdded;
    }

    private boolean doOpenProject(final @NonNull Project p) {
        LOGGER.log(Level.FINER, "doOpenProject: {0}", p);
        final AtomicBoolean alreadyOpen = new AtomicBoolean();
        boolean recentProjectsChanged = (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                OpenProjectList.log(Level.FINER, "already opened: {0} ", OpenProjectList.this.openProjects);
                for (Project existing : OpenProjectList.this.openProjects) {
                    if (!p.equals(existing) && !existing.equals(p)) continue;
                    alreadyOpen.set(true);
                    return false;
                }
                OpenProjectList.this.openProjects.add(p);
                OpenProjectList.this.addModuleInfo(p);
                p.getProjectDirectory().addFileChangeListener((FileChangeListener)OpenProjectList.this.deleteListener);
                p.getProjectDirectory().addFileChangeListener((FileChangeListener)OpenProjectList.this.nbprojectDeleteListener);
                return OpenProjectList.this.recentProjects.remove(p);
            }
        });
        if (alreadyOpen.get()) {
            return false;
        }
        OpenProjectList.logProjects("doOpenProject(): openProjects == ", this.openProjects.toArray(new Project[0]));
        OpenProjectList.notifyOpened(p);
        OPENING_RP.post(new Runnable(){

            @Override
            public void run() {
                ProjectUtilities.openProjectFiles(p);
            }
        });
        return recentProjectsChanged;
    }

    private static List<Project> loadProjectList() {
        List<URL> URLs = OpenProjectListSettings.getInstance().getOpenProjectsURLs();
        List<String> names = OpenProjectListSettings.getInstance().getOpenProjectsDisplayNames();
        List<ExtIcon> icons = OpenProjectListSettings.getInstance().getOpenProjectsIcons();
        ArrayList<Project> projects = new ArrayList<Project>();
        Iterator<URL> urlIt = URLs.iterator();
        Iterator<String> namesIt = names.iterator();
        Iterator<ExtIcon> iconIt = icons.iterator();
        while (urlIt.hasNext() && namesIt.hasNext() && iconIt.hasNext()) {
            projects.add(new LazyProject(urlIt.next(), namesIt.next(), iconIt.next()));
        }
        return projects;
    }

    private static void saveProjectList(List<Project> projects) {
        List<URL> URLs = OpenProjectList.projects2URLs(projects);
        OpenProjectListSettings.getInstance().setOpenProjectsURLs(URLs);
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<ExtIcon> icons = new ArrayList<ExtIcon>();
        for (Project p : projects) {
            ProjectInformation prjInfo = ProjectUtils.getInformation((Project)p);
            names.add(prjInfo.getDisplayName());
            ExtIcon extIcon = new ExtIcon();
            extIcon.setIcon(prjInfo.getIcon());
            icons.add(extIcon);
        }
        OpenProjectListSettings.getInstance().setOpenProjectsDisplayNames(names);
        OpenProjectListSettings.getInstance().setOpenProjectsIcons(icons);
    }

    private static void saveMainProject(Project mainProject) {
        try {
            URL mainRoot = mainProject == null ? null : mainProject.getProjectDirectory().getURL();
            OpenProjectListSettings.getInstance().setMainProjectURL(mainRoot);
        }
        catch (FileStateInvalidException e) {
            OpenProjectListSettings.getInstance().setMainProjectURL(null);
        }
    }

    private ArrayList<FileObject> getTemplateNamesLRU(final Project project, PrivilegedTemplates priv) {
        final ArrayList<FileObject> result = new ArrayList<FileObject>(15);
        RecommendedTemplates rt = (RecommendedTemplates)project.getLookup().lookup(RecommendedTemplates.class);
        String[] rtNames = rt == null ? new String[]{} : rt.getRecommendedTypes();
        PrivilegedTemplates pt = priv != null ? priv : (PrivilegedTemplates)project.getLookup().lookup(PrivilegedTemplates.class);
        String[] ptNames = pt == null ? null : pt.getPrivilegedTemplates();
        final ArrayList<String> privilegedTemplates = new ArrayList<String>(Arrays.asList(pt == null ? new String[]{} : ptNames));
        if (priv == null) {
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    Iterator it = OpenProjectList.this.getRecentTemplates().iterator();
                    for (int i = 0; i < 15 && it.hasNext(); ++i) {
                        String templateName = (String)it.next();
                        FileObject fo = FileUtil.getConfigFile((String)templateName);
                        if (fo == null) {
                            it.remove();
                            continue;
                        }
                        if (!OpenProjectList.isRecommended(project, fo)) continue;
                        result.add(fo);
                        privilegedTemplates.remove(templateName);
                    }
                    return null;
                }
            });
        }
        Iterator<String> it = privilegedTemplates.iterator();
        for (int i = result.size(); i < 15 && it.hasNext(); ++i) {
            String path = it.next();
            FileObject fo = FileUtil.getConfigFile((String)path);
            if (fo == null) continue;
            result.add(fo);
        }
        return result;
    }

    static boolean isRecommended(Project p, FileObject primaryFile) {
        if (OpenProjectList.getRecommendedTypes(p) == null || OpenProjectList.getRecommendedTypes(p).length == 0) {
            return true;
        }
        Object o = primaryFile.getAttribute("templateCategory");
        if (o != null) {
            assert (o instanceof String) : primaryFile + " attr templateCategory = " + o;
            boolean ok = false;
            for (String category : OpenProjectList.getCategories((String)o)) {
                if (!Arrays.asList(OpenProjectList.getRecommendedTypes(p)).contains(category)) continue;
                ok = true;
                break;
            }
            return ok;
        }
        return true;
    }

    private static String[] getRecommendedTypes(Project project) {
        if (project == null) {
            return null;
        }
        RecommendedTemplates rt = (RecommendedTemplates)project.getLookup().lookup(RecommendedTemplates.class);
        return rt == null ? null : rt.getRecommendedTypes();
    }

    private static List<String> getCategories(String source) {
        ArrayList<String> categories = new ArrayList<String>();
        StringTokenizer cattok = new StringTokenizer(source, ",");
        while (cattok.hasMoreTokens()) {
            categories.add(cattok.nextToken().trim());
        }
        return categories;
    }

    private static ModuleInfo findModuleForProject(Project prj) {
        Collection instances = Lookup.getDefault().lookupAll(ModuleInfo.class);
        ModuleInfo info = null;
        for (ModuleInfo cur : instances) {
            if (!cur.isEnabled() || cur.getClassLoader() != prj.getClass().getClassLoader()) continue;
            info = cur;
            break;
        }
        return info;
    }

    private void addModuleInfo(final Project prj) {
        final ModuleInfo info = OpenProjectList.findModuleForProject(prj);
        if (info != null) {
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    if (!OpenProjectList.this.openProjectsModuleInfos.containsKey(info)) {
                        OpenProjectList.this.openProjectsModuleInfos.put(info, new ArrayList());
                        info.addPropertyChangeListener(OpenProjectList.this.infoListener);
                    }
                    ((List)OpenProjectList.this.openProjectsModuleInfos.get(info)).add(prj);
                    return null;
                }
            });
        }
    }

    private void removeModuleInfo(Project prj) {
        ModuleInfo info = OpenProjectList.findModuleForProject(prj);
        this.removeModuleInfo(prj, info);
    }

    private void removeModuleInfo(final Project prj, final ModuleInfo info) {
        if (info != null) {
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    List prjlist = (List)OpenProjectList.this.openProjectsModuleInfos.get(info);
                    if (prjlist != null) {
                        prjlist.remove(prj);
                        if (prjlist.isEmpty()) {
                            info.removePropertyChangeListener(OpenProjectList.this.infoListener);
                            OpenProjectList.this.openProjectsModuleInfos.remove(info);
                        }
                    }
                    return null;
                }
            });
        }
    }

    private void checkModuleInfo(ModuleInfo info) {
        if (info.isEnabled()) {
            return;
        }
        ArrayList toRemove = new ArrayList(this.openProjectsModuleInfos.get(info));
        if (toRemove != null && toRemove.size() > 0) {
            for (Project prj : toRemove) {
                this.removeModuleInfo(prj, info);
            }
            this.close(toRemove.toArray(new Project[toRemove.size()]), false);
        }
    }

    private static LogRecord[] createRecord(String msg, Project[] projects) {
        if (projects.length == 0) {
            return null;
        }
        HashMap<String, int[]> counts = new HashMap<String, int[]>();
        for (Project p : projects) {
            String n = p.getClass().getName();
            int[] cnt = (int[])counts.get(n);
            if (cnt == null) {
                cnt = new int[1];
                counts.put(n, cnt);
            }
            cnt[0] = cnt[0] + 1;
        }
        Logger logger = Logger.getLogger("org.netbeans.ui.projects");
        LogRecord[] arr = new LogRecord[counts.size()];
        int i = 0;
        for (Map.Entry entry : counts.entrySet()) {
            LogRecord rec = new LogRecord(Level.CONFIG, msg);
            rec.setParameters(new Object[]{entry.getKey(), OpenProjectList.afterLastDot((String)entry.getKey()), ((int[])entry.getValue())[0]});
            rec.setLoggerName(logger.getName());
            rec.setResourceBundle(NbBundle.getBundle(OpenProjectList.class));
            rec.setResourceBundleName(OpenProjectList.class.getPackage().getName() + ".Bundle");
            arr[i++] = rec;
        }
        return arr;
    }

    private static LogRecord[] createRecordMetrics(String msg, Project[] projects) {
        if (projects.length == 0) {
            return null;
        }
        Logger logger = Logger.getLogger("org.netbeans.ui.metrics.projects");
        LogRecord[] arr = new LogRecord[projects.length];
        int i = 0;
        for (Project p : projects) {
            LogRecord rec = new LogRecord(Level.INFO, msg);
            rec.setParameters(new Object[]{p.getClass().getName()});
            rec.setLoggerName(logger.getName());
            arr[i++] = rec;
        }
        return arr;
    }

    private static void log(LogRecord[] arr, String loggerName) {
        if (arr == null) {
            return;
        }
        Logger logger = Logger.getLogger(loggerName);
        for (LogRecord r : arr) {
            logger.log(r);
        }
    }

    private static String afterLastDot(String s) {
        int index = s.lastIndexOf(46);
        if (index == -1) {
            return s;
        }
        return s.substring(index + 1);
    }

    private static void logProjects(String message, Project[] projects) {
        if (projects.length == 0) {
            return;
        }
        for (Project p : projects) {
            LOGGER.log(Level.FINER, "{0} {1}", new Object[]{message, p == null ? null : p.toString()});
        }
    }

    static {
        OPENING_RP = new RequestProcessor("Opening projects", 1);
        LOGGER = Logger.getLogger(OpenProjectList.class.getName());
    }

    private final class ProjectDeletionListener
    extends FileChangeAdapter {
        public void fileDeleted(final FileEvent fe) {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    Project fRemove;
                    Project toRemove = null;
                    for (Project prj : OpenProjectList.this.openProjects) {
                        if (!fe.getFile().equals(prj.getProjectDirectory())) continue;
                        toRemove = prj;
                        break;
                    }
                    if ((fRemove = toRemove) != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                OpenProjectList.this.close(new Project[]{fRemove}, false);
                            }
                        });
                    }
                    return null;
                }
            });
        }
    }

    private final class NbProjectDeletionListener
    extends FileChangeAdapter {
        public void fileDeleted(FileEvent fe) {
            OpenProjectList.this.recentProjects.refresh();
        }
    }

    private static class ProjectByDisplayNameComparator
    implements Comparator<Project> {
        private static Comparator<Object> COLLATOR = Collator.getInstance();
        private final Map<Project, String> names = new HashMap<Project, String>();

        private ProjectByDisplayNameComparator() {
        }

        private String getDisplayName(Project p) {
            String n = this.names.get(p);
            if (n == null) {
                n = ProjectUtils.getInformation((Project)p).getDisplayName();
                this.names.put(p, n);
            }
            return n;
        }

        @Override
        public int compare(Project p1, Project p2) {
            String n1 = this.getDisplayName(p1);
            String n2 = this.getDisplayName(p2);
            if (n1 != null && n2 != null) {
                return COLLATOR.compare(n1, n2);
            }
            if (n1 == null && n2 != null) {
                OpenProjectList.log(Level.WARNING, p1 + ": ProjectInformation.getDisplayName() should not return null!", new Object[0]);
                return -1;
            }
            if (n1 != null && n2 == null) {
                OpenProjectList.log(Level.WARNING, p2 + ": ProjectInformation.getDisplayName() should not return null!", new Object[0]);
                return 1;
            }
            return 0;
        }
    }

    private class RecentProjectList {
        private List<ProjectReference> recentProjects;
        private List<UnloadedProjectInformation> recentProjectsInfos;
        private int size;

        public RecentProjectList(int size) {
            this.size = size;
            this.recentProjects = new ArrayList<ProjectReference>(size);
            this.recentProjectsInfos = new ArrayList<UnloadedProjectInformation>(size);
            if (LOGGER.isLoggable(Level.FINE)) {
                OpenProjectList.log(Level.FINE, "created a RecentProjectList: size=" + size, new Object[0]);
            }
        }

        public void add(final Project p) {
            UnloadedProjectInformation projectInfo;
            try {
                projectInfo = ProjectInfoAccessor.DEFAULT.getProjectInfo(ProjectUtils.getInformation((Project)p).getDisplayName(), ProjectUtils.getInformation((Project)p).getIcon(), p.getProjectDirectory().getURL());
            }
            catch (FileStateInvalidException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
                return;
            }
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    int index = RecentProjectList.this.getIndex(p);
                    if (index == -1) {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            OpenProjectList.log(Level.FINE, "add new recent project: " + p, new Object[0]);
                        }
                        if (RecentProjectList.this.recentProjects.size() == RecentProjectList.this.size) {
                            RecentProjectList.this.recentProjects.remove(RecentProjectList.this.size - 1);
                            RecentProjectList.this.recentProjectsInfos.remove(RecentProjectList.this.size - 1);
                        }
                    } else {
                        LOGGER.log(Level.FINE, "re-add recent project: {0} @{1}", new Object[]{p, index});
                        RecentProjectList.this.recentProjects.remove(index);
                        RecentProjectList.this.recentProjectsInfos.remove(index);
                    }
                    RecentProjectList.this.recentProjects.add(0, new ProjectReference(p));
                    RecentProjectList.this.recentProjectsInfos.add(0, projectInfo);
                    return null;
                }
            });
        }

        public boolean remove(final Project p) {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

                public Boolean run() {
                    int index = RecentProjectList.this.getIndex(p);
                    if (index != -1) {
                        LOGGER.log(Level.FINE, "remove recent project: {0} @{1}", new Object[]{p, index});
                        RecentProjectList.this.recentProjects.remove(index);
                        RecentProjectList.this.recentProjectsInfos.remove(index);
                        return true;
                    }
                    return false;
                }
            });
        }

        public void refresh() {
            ProjectManager.mutex().writeAccess(new Runnable(){

                @Override
                public void run() {
                    assert (RecentProjectList.this.recentProjects.size() == RecentProjectList.this.recentProjectsInfos.size());
                    boolean refresh = false;
                    Iterator recentProjectsIter = RecentProjectList.this.recentProjects.iterator();
                    Iterator recentProjectsInfosIter = RecentProjectList.this.recentProjectsInfos.iterator();
                    while (recentProjectsIter.hasNext() && recentProjectsInfosIter.hasNext()) {
                        ProjectReference prjRef = (ProjectReference)recentProjectsIter.next();
                        recentProjectsInfosIter.next();
                        URL url = prjRef.getURL();
                        FileObject prjDir = null;
                        try {
                            File file = FileUtil.normalizeFile((File)new File(url.toURI()));
                            prjDir = FileUtil.toFileObject((File)file);
                        }
                        catch (URISyntaxException use) {
                            // empty catch block
                        }
                        Project prj = null;
                        if (prjDir != null && prjDir.isFolder()) {
                            try {
                                prj = ProjectManager.getDefault().findProject(prjDir);
                            }
                            catch (IOException ioEx) {
                                // empty catch block
                            }
                        }
                        if (prj != null) continue;
                        refresh = true;
                        if (prjDir != null && prjDir.isFolder()) {
                            prjDir.removeFileChangeListener((FileChangeListener)OpenProjectList.this.nbprojectDeleteListener);
                        }
                        recentProjectsIter.remove();
                        recentProjectsInfosIter.remove();
                    }
                    if (refresh) {
                        OpenProjectList.this.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_RECENT_PROJECTS, null, null);
                        RecentProjectList.this.save();
                    }
                }
            });
        }

        public List<Project> getProjects() {
            ArrayList<Project> result = new ArrayList<Project>(this.recentProjects.size());
            ArrayList<ProjectReference> references = new ArrayList<ProjectReference>(this.recentProjects);
            for (ProjectReference pRef : references) {
                Project p = pRef.getProject();
                if (p == null || !p.getProjectDirectory().isValid()) {
                    this.remove(p);
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    OpenProjectList.log(Level.FINE, "removing dead recent project: " + p, new Object[0]);
                    continue;
                }
                result.add(p);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                OpenProjectList.log(Level.FINE, "recent projects: " + result, new Object[0]);
            }
            return result;
        }

        public boolean isEmpty() {
            boolean empty = this.recentProjects.isEmpty();
            if (LOGGER.isLoggable(Level.FINE)) {
                OpenProjectList.log(Level.FINE, "recent projects empty? " + empty, new Object[0]);
            }
            return empty;
        }

        public void load() {
            ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    List<URL> URLs = OpenProjectListSettings.getInstance().getRecentProjectsURLs();
                    List<String> names = OpenProjectListSettings.getInstance().getRecentProjectsDisplayNames();
                    List<ExtIcon> icons = OpenProjectListSettings.getInstance().getRecentProjectsIcons();
                    if (LOGGER.isLoggable(Level.FINE)) {
                        OpenProjectList.log(Level.FINE, "recent project list load: " + URLs, new Object[0]);
                    }
                    RecentProjectList.this.recentProjects.clear();
                    for (URL url : URLs) {
                        RecentProjectList.this.recentProjects.add(new ProjectReference(url));
                    }
                    RecentProjectList.this.recentProjectsInfos.clear();
                    Iterator<String> iterNames = names.iterator();
                    Iterator<URL> iterURLs = URLs.iterator();
                    Iterator<ExtIcon> iterIcons = icons.iterator();
                    while (iterNames.hasNext() && iterURLs.hasNext() && iterIcons.hasNext()) {
                        String name = iterNames.next();
                        URL url = iterURLs.next();
                        Icon icon = iterIcons.next().getIcon();
                        RecentProjectList.this.recentProjectsInfos.add(ProjectInfoAccessor.DEFAULT.getProjectInfo(name, icon, url));
                    }
                    if (RecentProjectList.this.recentProjects.size() != RecentProjectList.this.recentProjectsInfos.size()) {
                        RecentProjectList.this.recentProjects.clear();
                        RecentProjectList.this.recentProjectsInfos.clear();
                    }
                    for (Project p : OpenProjectList.this.openProjects) {
                        assert (p != null) : "There is null in " + OpenProjectList.access$300(OpenProjectList.this);
                        assert (p.getProjectDirectory() != null) : "Project " + p + " has null project directory";
                        p.getProjectDirectory().addFileChangeListener((FileChangeListener)OpenProjectList.this.nbprojectDeleteListener);
                    }
                    return null;
                }
            });
        }

        public void save() {
            ArrayList<URL> URLs = new ArrayList<URL>(this.recentProjects.size());
            for (ProjectReference pRef : this.recentProjects) {
                URL pURL = pRef.getURL();
                if (pURL == null) continue;
                URLs.add(pURL);
            }
            List<UnloadedProjectInformation> _recentProjectsInfos = this.getRecentProjectsInfo();
            LOGGER.log(Level.FINE, "save recent project list: recentProjects={0} recentProjectsInfos={1} URLs={2}", new Object[]{this.recentProjects, _recentProjectsInfos, URLs});
            OpenProjectListSettings.getInstance().setRecentProjectsURLs(URLs);
            int listSize = _recentProjectsInfos.size();
            ArrayList<String> names = new ArrayList<String>(listSize);
            ArrayList<ExtIcon> icons = new ArrayList<ExtIcon>(listSize);
            for (UnloadedProjectInformation prjInfo : _recentProjectsInfos) {
                names.add(prjInfo.getDisplayName());
                ExtIcon extIcon = new ExtIcon();
                extIcon.setIcon(prjInfo.getIcon());
                icons.add(extIcon);
            }
            OpenProjectListSettings.getInstance().setRecentProjectsDisplayNames(names);
            OpenProjectListSettings.getInstance().setRecentProjectsIcons(icons);
        }

        private int getIndex(Project p) {
            URL pURL;
            try {
                if (p == null || p.getProjectDirectory() == null) {
                    return -1;
                }
                pURL = p.getProjectDirectory().getURL();
            }
            catch (FileStateInvalidException e) {
                return -1;
            }
            int i = 0;
            for (ProjectReference pRef : this.recentProjects) {
                URL p2URL = pRef.getURL();
                if (pURL.equals(p2URL)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private List<UnloadedProjectInformation> getRecentProjectsInfo() {
            return (List)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<List<UnloadedProjectInformation>>(){

                public List<UnloadedProjectInformation> run() {
                    return new ArrayList<UnloadedProjectInformation>(RecentProjectList.this.recentProjectsInfos);
                }
            });
        }

        private class ProjectReference {
            private WeakReference<Project> projectReference;
            private URL projectURL;

            public ProjectReference(URL url) {
                this.projectURL = url;
            }

            public ProjectReference(Project p) {
                block2: {
                    this.projectReference = new WeakReference<Project>(p);
                    try {
                        this.projectURL = p.getProjectDirectory().getURL();
                    }
                    catch (FileStateInvalidException e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block2;
                        OpenProjectList.log(Level.FINE, "FSIE getting URL for project: " + p.getProjectDirectory(), new Object[0]);
                    }
                }
            }

            public Project getProject() {
                block9: {
                    FileObject dir;
                    Project p = null;
                    if (this.projectReference != null && (p = (Project)this.projectReference.get()) != null) {
                        if (ProjectManager.getDefault().isValid(p)) {
                            return p;
                        }
                        return null;
                    }
                    if (LOGGER.isLoggable(Level.FINE)) {
                        OpenProjectList.log(Level.FINE, "no active project reference for " + this.projectURL, new Object[0]);
                    }
                    if (this.projectURL != null && (dir = URLMapper.findFileObject((URL)this.projectURL)) != null && dir.isFolder()) {
                        try {
                            p = ProjectManager.getDefault().findProject(dir);
                            if (p != null) {
                                this.projectReference = new WeakReference<Project>(p);
                                if (LOGGER.isLoggable(Level.FINE)) {
                                    OpenProjectList.log(Level.FINE, "found " + p, new Object[0]);
                                }
                                return p;
                            }
                        }
                        catch (IOException e) {
                            if (!LOGGER.isLoggable(Level.FINE)) break block9;
                            OpenProjectList.log(Level.FINE, "could not load recent project from " + this.projectURL, new Object[0]);
                        }
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    OpenProjectList.log(Level.FINE, "no recent project in " + this.projectURL, new Object[0]);
                }
                return null;
            }

            public URL getURL() {
                return this.projectURL;
            }

            public String toString() {
                return this.projectURL.toString();
            }
        }
    }

    private final class LoadOpenProjects
    implements Runnable,
    LookupListener,
    Future<Project[]> {
        final RequestProcessor RP = new RequestProcessor("Load Open Projects");
        final RequestProcessor.Task TASK = this.RP.create((Runnable)this);
        private int action;
        private final LinkedList<Project> toOpenProjects = new LinkedList();
        private List<Project> lazilyOpenedProjects;
        private List<String> recentTemplates;
        private Project lazyMainProject;
        private Lookup.Result<FileObject> currentFiles;
        private int entered;
        private final Lock enteredGuard = new ReentrantLock();
        private final Condition enteredZeroed = this.enteredGuard.newCondition();
        private final ProgressHandle progress;

        public LoadOpenProjects(int a) {
            this.action = a;
            this.currentFiles = Utilities.actionsGlobalContext().lookupResult(FileObject.class);
            this.currentFiles.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.currentFiles));
            this.progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(OpenProjectList.class, (String)"CAP_Opening_Projects"));
        }

        final void waitFinished() {
            OpenProjectList.log(Level.FINER, "waitFinished, action {0}", this.action);
            if (this.action == 0) {
                this.run();
            }
            OpenProjectList.log(Level.FINER, "waitFinished, before wait", new Object[0]);
            this.TASK.waitFinished();
            OpenProjectList.log(Level.FINER, "waitFinished, after wait", new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            OpenProjectList.log(Level.FINE, "LoadOpenProjects.run: {0}", this.action);
            switch (this.action) {
                case 0: {
                    this.action = 1;
                    this.TASK.schedule(0);
                    this.resultChanged(null);
                    return;
                }
                case 1: {
                    if (!this.RP.isRequestProcessorThread()) {
                        return;
                    }
                    this.action = 2;
                    try {
                        this.progress.start();
                        this.loadOnBackground();
                    }
                    finally {
                        this.progress.finish();
                    }
                    this.updateGlobalState();
                    ProjectsRootNode.checkNoLazyNode();
                    return;
                }
                case 2: {
                    return;
                }
            }
            throw new IllegalStateException("unknown action: " + this.action);
        }

        final void preferredProject(final Set<FileObject> lazyPDirs) {
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    for (Project p : new ArrayList(LoadOpenProjects.this.toOpenProjects)) {
                        FileObject dir = p.getProjectDirectory();
                        assert (dir != null) : "Project has real directory " + p;
                        if (!lazyPDirs.contains(dir)) continue;
                        LoadOpenProjects.this.toOpenProjects.remove(p);
                        LoadOpenProjects.this.toOpenProjects.addFirst(p);
                        return null;
                    }
                    return null;
                }
            });
        }

        private void updateGlobalState() {
            OpenProjectList.log(Level.FINER, "updateGlobalState", new Object[0]);
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    INSTANCE.openProjects = LoadOpenProjects.this.lazilyOpenedProjects;
                    OpenProjectList.log(Level.FINER, "openProjects changed: {0}", LoadOpenProjects.this.lazilyOpenedProjects);
                    if (LoadOpenProjects.this.lazyMainProject != null) {
                        INSTANCE.mainProject = LoadOpenProjects.this.lazyMainProject;
                    }
                    INSTANCE.mainProject = OpenProjectList.this.unwrapProject(INSTANCE.mainProject);
                    INSTANCE.getRecentTemplates().addAll(LoadOpenProjects.this.recentTemplates);
                    OpenProjectList.log(Level.FINER, "updateGlobalState, applied", new Object[0]);
                    return null;
                }
            });
            INSTANCE.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_OPEN_PROJECTS, new Project[0], this.lazilyOpenedProjects.toArray(new Project[0]));
            INSTANCE.pchSupport.firePropertyChange(OpenProjectList.PROPERTY_MAIN_PROJECT, null, INSTANCE.mainProject);
            OpenProjectList.log(Level.FINER, "updateGlobalState, done, notified", new Object[0]);
        }

        boolean closeBeforeOpen(final Project[] arr) {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Boolean>(){

                public Boolean run() {
                    for (Project p : arr) {
                        Iterator it;
                        block2: {
                            FileObject dir = p.getProjectDirectory();
                            it = LoadOpenProjects.this.toOpenProjects.iterator();
                            while (it.hasNext()) {
                                if (!dir.equals(((Project)it.next()).getProjectDirectory())) continue;
                                break block2;
                            }
                            return false;
                        }
                        it.remove();
                    }
                    return true;
                }
            });
        }

        private void loadOnBackground() {
            this.lazilyOpenedProjects = new ArrayList<Project>();
            List<URL> URLs = OpenProjectListSettings.getInstance().getOpenProjectsURLs();
            final ArrayList initial = new ArrayList();
            final LinkedList projects = OpenProjectList.URLs2Projects(URLs);
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    LoadOpenProjects.this.toOpenProjects.addAll(projects);
                    OpenProjectList.log(Level.FINER, "loadOnBackground {0}", LoadOpenProjects.this.toOpenProjects);
                    initial.addAll(LoadOpenProjects.this.toOpenProjects);
                    return null;
                }
            });
            this.recentTemplates = new ArrayList<String>(OpenProjectListSettings.getInstance().getRecentTemplates());
            final URL mainProjectURL = OpenProjectListSettings.getInstance().getMainProjectURL();
            int max = (Integer)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Integer>(){

                public Integer run() {
                    for (Project p : LoadOpenProjects.this.toOpenProjects) {
                        INSTANCE.addModuleInfo(p);
                        try {
                            if (mainProjectURL == null || !mainProjectURL.equals(p.getProjectDirectory().getURL())) continue;
                            LoadOpenProjects.this.lazyMainProject = p;
                        }
                        catch (FileStateInvalidException fileStateInvalidException) {}
                    }
                    return LoadOpenProjects.this.toOpenProjects.size();
                }
            });
            this.progress.switchToDeterminate(max);
            while (true) {
                final AtomicInteger openPrjSize = new AtomicInteger();
                Project p = (Project)ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Project>(){

                    public Project run() {
                        if (LoadOpenProjects.this.toOpenProjects.isEmpty()) {
                            return null;
                        }
                        Project p = (Project)LoadOpenProjects.this.toOpenProjects.remove();
                        OpenProjectList.log(Level.FINER, "after remove {0}", LoadOpenProjects.this.toOpenProjects);
                        openPrjSize.set(LoadOpenProjects.this.toOpenProjects.size());
                        return p;
                    }
                });
                if (p == null) break;
                OpenProjectList.log(Level.FINE, "about to open a project {0}", p);
                if (OpenProjectList.notifyOpened(p)) {
                    this.lazilyOpenedProjects.add(p);
                    OpenProjectList.log(Level.FINE, "notify opened {0}", p);
                    PropertyChangeEvent ev = new PropertyChangeEvent(this, OpenProjectList.PROPERTY_REPLACE, null, p);
                    try {
                        OpenProjectList.this.pchSupport.firePropertyChange(ev);
                    }
                    catch (Throwable t) {
                        OpenProjectList.log(Level.WARNING, "broken node for {0}", t);
                    }
                    OpenProjectList.log(Level.FINE, "property change notified {0}", p);
                } else if (this.lazyMainProject == p) {
                    this.lazyMainProject = null;
                }
                this.progress.progress(max - openPrjSize.get());
            }
            if (initial != null) {
                Project[] initialA = initial.toArray(new Project[initial.size()]);
                OpenProjectList.log(OpenProjectList.createRecord("UI_INIT_PROJECTS", initialA), "org.netbeans.ui.projects");
                OpenProjectList.log(OpenProjectList.createRecordMetrics("USG_PROJECT_OPEN", initialA), "org.netbeans.ui.metrics.projects");
            }
        }

        public void resultChanged(LookupEvent ev) {
            final HashSet<FileObject> lazyPDirs = new HashSet<FileObject>();
            for (FileObject fileObject : this.currentFiles.allInstances()) {
                Project p = FileOwnerQuery.getOwner((FileObject)fileObject);
                if (p == null) continue;
                lazyPDirs.add(p.getProjectDirectory());
            }
            if (!lazyPDirs.isEmpty()) {
                Hacks.RP.post(new Runnable(){

                    @Override
                    public void run() {
                        OpenProjectList.getDefault().LOAD.preferredProject(lazyPDirs);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void enter() {
            try {
                this.enteredGuard.lock();
                ++this.entered;
            }
            finally {
                this.enteredGuard.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void exit() {
            try {
                this.enteredGuard.lock();
                if (--this.entered == 0) {
                    this.enteredZeroed.signalAll();
                }
            }
            finally {
                this.enteredGuard.unlock();
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return this.TASK.isFinished() && this.entered == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Project[] get() throws InterruptedException, ExecutionException {
            this.TASK.waitFinished();
            try {
                this.enteredGuard.lock();
                while (this.entered > 0) {
                    this.enteredZeroed.await();
                }
            }
            finally {
                this.enteredGuard.unlock();
            }
            return OpenProjectList.getDefault().getOpenProjects();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Project[] get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            long ms = unit.convert(timeout, TimeUnit.MILLISECONDS);
            if (!this.TASK.waitFinished(timeout)) {
                throw new TimeoutException();
            }
            try {
                this.enteredGuard.lock();
                if (this.entered > 0 && !this.enteredZeroed.await(ms, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException();
                }
            }
            finally {
                this.enteredGuard.unlock();
            }
            return OpenProjectList.getDefault().getOpenProjects();
        }
    }
}

