/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.tomcat;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.apache.catalina.loader.ResourceEntry;
import org.apache.catalina.loader.WebappClassLoader;
import org.springframework.instrument.classloading.WeavingTransformer;

public class TomcatInstrumentableClassLoader
extends WebappClassLoader {
    private final WeavingTransformer weavingTransformer = new WeavingTransformer((ClassLoader)((Object)this));

    public TomcatInstrumentableClassLoader() {
    }

    public TomcatInstrumentableClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.weavingTransformer.addTransformer(transformer);
    }

    public ClassLoader getThrowawayClassLoader() {
        WebappClassLoader tempLoader = new WebappClassLoader();
        TomcatInstrumentableClassLoader.shallowCopyFieldState((Object)this, tempLoader);
        return tempLoader;
    }

    protected ResourceEntry findResourceInternal(String name, String path) {
        ResourceEntry entry = super.findResourceInternal(name, path);
        if (entry != null && entry.binaryContent != null && path.endsWith(".class")) {
            byte[] transformed = this.weavingTransformer.transformIfNecessary(name, entry.binaryContent);
            entry.binaryContent = transformed;
        }
        return entry;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getName());
        sb.append("\r\n");
        sb.append(super.toString());
        return sb.toString();
    }

    private static void shallowCopyFieldState(Object src, Object dest) throws IllegalArgumentException {
        if (src == null) {
            throw new IllegalArgumentException("Source for field copy cannot be null");
        }
        if (dest == null) {
            throw new IllegalArgumentException("Destination for field copy cannot be null");
        }
        Class targetClass = TomcatInstrumentableClassLoader.findCommonAncestor(src.getClass(), dest.getClass());
        do {
            Field[] fields = targetClass.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                if (!(Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || field.getName().equals("resourceEntries"))) {
                    try {
                        field.setAccessible(true);
                        Object srcValue = field.get(src);
                        field.set(dest, srcValue);
                    }
                    catch (IllegalAccessException ex) {
                        throw new IllegalStateException("Shouldn't be illegal to access field '" + fields[i].getName() + "': " + ex);
                    }
                }
                ++i;
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    private static Class findCommonAncestor(Class one, Class two) throws IllegalArgumentException {
        Class ancestor = one;
        while (ancestor != Object.class || ancestor != null) {
            if (ancestor.isAssignableFrom(two)) {
                return ancestor;
            }
            ancestor = ancestor.getSuperclass();
        }
        ancestor = two;
        while (ancestor != Object.class || ancestor != null) {
            if (ancestor.isAssignableFrom(one)) {
                return ancestor;
            }
            ancestor = ancestor.getSuperclass();
        }
        return null;
    }
}

