/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;

public class HintsUtils {
    public static ErrorDescription createProblem(Element subject, CompilationInfo cinfo, String description) {
        return HintsUtils.createProblem(subject, cinfo, description, Severity.ERROR, Collections.<Fix>emptyList());
    }

    public static ErrorDescription createProblem(Element subject, CompilationInfo cinfo, String description, Severity severity) {
        return HintsUtils.createProblem(subject, cinfo, description, severity, Collections.<Fix>emptyList());
    }

    public static ErrorDescription createProblem(Element subject, CompilationInfo cinfo, String description, Severity severity, Fix fix) {
        return HintsUtils.createProblem(subject, cinfo, description, severity, Collections.singletonList(fix));
    }

    public static ErrorDescription createProblem(Element subject, CompilationInfo cinfo, String description, Fix fix) {
        return HintsUtils.createProblem(subject, cinfo, description, Severity.ERROR, Collections.singletonList(fix));
    }

    public static ErrorDescription createProblem(Element subject, CompilationInfo cinfo, String description, Severity severity, List<Fix> fixes) {
        ErrorDescription err = null;
        List<Object> fixList = fixes == null ? Collections.emptyList() : fixes;
        Tree elementTree = cinfo.getTrees().getTree(subject);
        if (elementTree != null) {
            TextSpan underlineSpan = HintsUtils.getUnderlineSpan(cinfo, elementTree);
            err = ErrorDescriptionFactory.createErrorDescription((Severity)severity, (String)description, fixList, (FileObject)cinfo.getFileObject(), (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset());
        }
        return err;
    }

    public static TextSpan getUnderlineSpan(CompilationInfo info, Tree tree) {
        SourcePositions srcPos = info.getTrees().getSourcePositions();
        int startOffset = (int)srcPos.getStartPosition(info.getCompilationUnit(), tree);
        int endOffset = (int)srcPos.getEndPosition(info.getCompilationUnit(), tree);
        Tree startSearchingForNameIndentifierBehindThisTree = null;
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
            startSearchingForNameIndentifierBehindThisTree = ((ClassTree)tree).getModifiers();
        } else if (tree.getKind() == Tree.Kind.METHOD) {
            startSearchingForNameIndentifierBehindThisTree = ((MethodTree)tree).getReturnType();
        } else if (tree.getKind() == Tree.Kind.VARIABLE) {
            startSearchingForNameIndentifierBehindThisTree = ((VariableTree)tree).getType();
        }
        if (startSearchingForNameIndentifierBehindThisTree != null) {
            int searchStart = (int)srcPos.getEndPosition(info.getCompilationUnit(), startSearchingForNameIndentifierBehindThisTree);
            TokenSequence tokenSequence = info.getTreeUtilities().tokensFor(tree);
            if (tokenSequence != null) {
                boolean eob = false;
                tokenSequence.move(searchStart);
                do {
                    boolean bl = eob = !tokenSequence.moveNext();
                } while (!eob && tokenSequence.token().id() != JavaTokenId.IDENTIFIER);
                if (!eob) {
                    Token identifier = tokenSequence.token();
                    startOffset = identifier.offset(info.getTokenHierarchy());
                    endOffset = startOffset + identifier.length();
                }
            }
        }
        return new TextSpan(startOffset, endOffset);
    }

    public static class TextSpan {
        private int startOffset;
        private int endOffset;

        public TextSpan(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

