/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.discovery.api.FolderProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.discovery.wizard.api.FileConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.FolderConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.api.ProjectConfiguration;
import org.netbeans.modules.cnd.discovery.wizard.tree.FileConfigurationImpl;
import org.netbeans.modules.cnd.discovery.wizard.tree.FolderConfigurationImpl;
import org.netbeans.modules.cnd.discovery.wizard.tree.ProjectConfigurationImpl;

public final class ConfigurationFactory {
    private ConfigurationFactory() {
    }

    public static ProjectConfiguration makeRoot(ProjectProperties project, String rootFolder) {
        FolderConfigurationImpl r;
        List<FolderProperties> folders = project.getConfiguredFolders();
        FolderConfigurationImpl root = new FolderConfigurationImpl("");
        for (FolderProperties folder : folders) {
            FolderConfigurationImpl fo = ConfigurationFactory.addChild(folder.getItemPath(), root);
            for (SourceFileProperties file : folder.getFiles()) {
                FileConfigurationImpl fi = new FileConfigurationImpl(file);
                fo.addFile(fi);
            }
        }
        StringTokenizer st = new StringTokenizer(rootFolder, "/\\");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        while ((r = root.cut()) != null) {
            root = r;
            String name = r.getFolderName();
            if (list.size() <= 0 || !((String)list.get(list.size() - 1)).equals(name)) continue;
            break;
        }
        return new ProjectConfigurationImpl(project, root);
    }

    private static FolderConfigurationImpl addChild(String child, FolderConfiguration folder) {
        FolderConfigurationImpl current = (FolderConfigurationImpl)folder;
        StringTokenizer st = new StringTokenizer(child, "/\\");
        StringBuilder currentName = new StringBuilder();
        boolean first = true;
        while (st.hasMoreTokens()) {
            String segment = st.nextToken();
            if (!first || child.startsWith("/")) {
                currentName.append("/");
            }
            first = false;
            currentName.append(segment);
            FolderConfigurationImpl found = current.getChild(segment);
            if (found == null) {
                found = new FolderConfigurationImpl(currentName.toString());
                current.addChild(found);
            }
            current = found;
        }
        return current;
    }

    public static void consolidateProject(ProjectConfiguration project) {
        FolderConfigurationImpl root = (FolderConfigurationImpl)project.getRoot();
        LinkedHashSet<String> userIncludes = new LinkedHashSet<String>();
        HashMap<String, String> userMacros = new HashMap<String, String>();
        ConfigurationFactory.consolidateProject(root, userIncludes, userMacros);
        root.setOverrideIncludes(false);
        root.setOverrideMacros(false);
        root.setUserInludePaths(null);
        root.setUserMacros(null);
        ((ProjectConfigurationImpl)project).setUserInludePaths(userIncludes);
        ((ProjectConfigurationImpl)project).setUserMacros(userMacros);
    }

    private static void consolidateProject(FolderConfigurationImpl folder, Set<String> userIncludes, Map<String, String> userMacros) {
        for (FolderConfiguration folderConfiguration : folder.getFolders()) {
            FolderConfigurationImpl sub = (FolderConfigurationImpl)folderConfiguration;
            ConfigurationFactory.consolidateProject(sub, userIncludes, userMacros);
            sub.setOverrideIncludes(false);
            sub.setOverrideMacros(false);
            sub.setUserInludePaths(null);
            sub.setUserMacros(null);
        }
        for (FileConfiguration fileConfiguration : folder.getFiles()) {
            FileConfigurationImpl file = (FileConfigurationImpl)fileConfiguration;
            userIncludes.addAll(file.getUserInludePaths());
            userMacros.putAll(file.getUserMacros());
            file.setOverrideIncludes(false);
            file.setOverrideMacros(false);
            file.setUserInludePaths(null);
            file.setUserMacros(null);
        }
    }

    public static void consolidateFolder(ProjectConfiguration project) {
        FolderConfigurationImpl root = (FolderConfigurationImpl)project.getRoot();
        ConfigurationFactory.consolidateFolder(root);
        ((ProjectConfigurationImpl)project).setUserInludePaths(null);
        ((ProjectConfigurationImpl)project).setUserMacros(null);
    }

    private static void consolidateFolder(FolderConfigurationImpl folder) {
        for (FolderConfiguration f : folder.getFolders()) {
            FolderConfigurationImpl sub = (FolderConfigurationImpl)f;
            ConfigurationFactory.consolidateFolder(sub);
        }
        LinkedHashSet<String> userIncludes = new LinkedHashSet<String>();
        HashMap<String, String> userMacros = new HashMap<String, String>();
        boolean hasFiles = false;
        for (FileConfiguration f : folder.getFiles()) {
            hasFiles = true;
            FileConfigurationImpl file = (FileConfigurationImpl)f;
            userIncludes.addAll(file.getUserInludePaths());
            userMacros.putAll(file.getUserMacros());
            file.setOverrideIncludes(false);
            file.setOverrideMacros(false);
            file.setUserInludePaths(null);
            file.setUserMacros(null);
        }
        if (hasFiles) {
            folder.setOverrideIncludes(true);
            folder.setOverrideMacros(true);
            folder.setUserInludePaths(userIncludes);
            folder.setUserMacros(userMacros);
        } else {
            folder.setOverrideIncludes(false);
            folder.setOverrideMacros(false);
            folder.setUserInludePaths(null);
            folder.setUserMacros(null);
        }
    }

    public static void consolidateFile(ProjectConfiguration project) {
        FolderConfigurationImpl root = (FolderConfigurationImpl)project.getRoot();
        ConfigurationFactory.consolidateFile(root);
        ((ProjectConfigurationImpl)project).setUserInludePaths(root.getUserInludePaths(false));
        ((ProjectConfigurationImpl)project).setUserMacros(root.getUserMacros(false));
    }

    private static void consolidateFile(FolderConfigurationImpl folder) {
        HashSet<String> commonFoldersIncludes = new HashSet<String>();
        HashMap<String, String> commonFoldersMacros = new HashMap<String, String>();
        boolean haveSubFolders = false;
        for (FolderConfiguration f : folder.getFolders()) {
            FolderConfigurationImpl subFolder = (FolderConfigurationImpl)f;
            ConfigurationFactory.consolidateFile(subFolder);
            if (!haveSubFolders) {
                commonFoldersIncludes.addAll(subFolder.getUserInludePaths(false));
                commonFoldersMacros.putAll(subFolder.getUserMacros(false));
                haveSubFolders = true;
                continue;
            }
            if (commonFoldersIncludes.size() > 0) {
                commonFoldersIncludes.retainAll(subFolder.getUserInludePaths(false));
            }
            if (commonFoldersMacros.size() <= 0) continue;
            Set intersection = commonFoldersMacros.keySet();
            intersection.retainAll(subFolder.getUserMacros(false).keySet());
            HashMap<String, String> newcommonFoldersMacros = new HashMap<String, String>();
            for (String key : intersection) {
                String value1 = (String)commonFoldersMacros.get(key);
                String value2 = subFolder.getUserMacros(false).get(key);
                if ((value1 != null || value2 != null) && (value1 == null || !value1.equals(value2))) continue;
                newcommonFoldersMacros.put(key, value1);
            }
            commonFoldersMacros = newcommonFoldersMacros;
        }
        HashSet<String> commonFilesIncludes = new HashSet<String>();
        HashMap<String, String> commonFilesMacros = new HashMap<String, String>();
        boolean first = true;
        if (haveSubFolders) {
            commonFilesIncludes = new HashSet(commonFoldersIncludes);
            commonFilesMacros = new HashMap(commonFoldersMacros);
            first = false;
        }
        for (FileConfiguration f : folder.getFiles()) {
            FileConfigurationImpl file = (FileConfigurationImpl)f;
            file.setOverrideIncludes(false);
            file.setOverrideMacros(false);
            if (first) {
                commonFilesIncludes.addAll(file.getUserInludePaths());
                commonFilesMacros.putAll(file.getUserMacros());
                first = false;
            } else {
                if (commonFilesIncludes.size() > 0) {
                    commonFilesIncludes.retainAll(file.getUserInludePaths());
                }
                if (commonFilesMacros.size() > 0) {
                    Set intersection = commonFilesMacros.keySet();
                    intersection.retainAll(file.getUserMacros().keySet());
                    HashMap<String, String> newCommonMacros = new HashMap<String, String>();
                    for (String key : intersection) {
                        String value1 = (String)commonFilesMacros.get(key);
                        String value2 = file.getUserMacros().get(key);
                        if ((value1 != null || value2 != null) && (value1 == null || !value1.equals(value2))) continue;
                        newCommonMacros.put(key, value1);
                    }
                    commonFilesMacros = newCommonMacros;
                }
            }
            file.setUserInludePaths(file.getUserInludePaths());
            file.setUserMacros(file.getUserMacros());
        }
        folder.setOverrideIncludes(false);
        folder.setOverrideMacros(false);
        if (commonFilesIncludes.size() > 0) {
            folder.setUserInludePaths(commonFilesIncludes);
        } else {
            folder.setUserInludePaths(null);
        }
        if (commonFilesMacros.size() > 0) {
            folder.setUserMacros(commonFilesMacros);
        } else {
            folder.setUserMacros(null);
        }
    }
}

