/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.wizard.ConsolidationStrategyWizard;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardIterator;
import org.netbeans.modules.cnd.discovery.wizard.SelectConfigurationWizard;
import org.netbeans.modules.cnd.discovery.wizard.SelectModeWizard;
import org.netbeans.modules.cnd.discovery.wizard.SelectObjectFilesWizard;
import org.netbeans.modules.cnd.discovery.wizard.SelectProviderWizard;
import org.netbeans.modules.cnd.discovery.wizard.SimpleConfigurationWizard;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;

public final class DiscoveryWizardAction
extends NodeAction {
    public static final String HELP_CONTEXT_SELECT_MODE = "CodeAssistanceWizardP1";
    public static final String HELP_CONTEXT_SIMPLE_CONFIGURATION = "CodeAssistanceWizardP6";
    public static final String HELP_CONTEXT_SELECT_PROVIDER = "CodeAssistanceWizardP2";
    public static final String HELP_CONTEXT_SELECT_OBJECT_FILES = "CodeAssistanceWizardP3";
    public static final String HELP_CONTEXT_CONSOLIDATION_STRATEGY = "CodeAssistanceWizardP4";
    public static final String HELP_CONTEXT_SELECT_CONFIGURATION = "CodeAssistanceWizardP5";

    public DiscoveryWizardAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected void performAction(Node[] activatedNodes) {
        Collection<Project> projects = this.getMakeProjects(activatedNodes);
        if (projects == null || projects.size() != 1) {
            return;
        }
        this.invokeWizard(projects.iterator().next());
    }

    protected boolean enable(Node[] activatedNodes) {
        Collection<Project> projects = this.getMakeProjects(activatedNodes);
        return projects != null && projects.size() == 1;
    }

    private void invokeWizard(Project project) {
        boolean cancelled;
        DiscoveryWizardDescriptor wizardDescriptor = new DiscoveryWizardDescriptor((WizardDescriptor.Iterator)this.getPanels());
        wizardDescriptor.setProject(project);
        wizardDescriptor.setRootFolder(DiscoveryWizardAction.findSourceRoot(project));
        wizardDescriptor.setBuildResult(DiscoveryWizardAction.findBuildResult(project));
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(this.getString("WIZARD_TITLE_TXT"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            // empty if block
        }
        dialog.dispose();
    }

    static String findBuildResult(Project project) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp == null || !pdp.gotDescriptor()) {
            return null;
        }
        MakeConfigurationDescriptor make = pdp.getConfigurationDescriptor();
        MakeConfiguration conf = make.getActiveConfiguration();
        if (conf != null) {
            String output = conf.getMakefileConfiguration().getOutput().getValue();
            if (output == null || output.length() == 0) {
                return null;
            }
            if (new File(output).isAbsolute()) {
                return output;
            }
            String base = DiscoveryWizardAction.getProjectDirectoryPath(project);
            output = CndFileUtils.normalizeFile((File)new File(base + '/' + output)).getAbsolutePath();
            return output;
        }
        return null;
    }

    static String getProjectDirectoryPath(Project project) {
        String base = project.getProjectDirectory().getPath();
        if (Utilities.isWindows()) {
            base = base.replace('\\', '/');
        } else if (!base.startsWith(File.separator)) {
            base = File.separator + base;
        }
        return base;
    }

    static String findSourceRoot(Project project) {
        String base = DiscoveryWizardAction.getProjectDirectoryPath(project);
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp != null && pdp.gotDescriptor()) {
            MakeConfigurationDescriptor make = pdp.getConfigurationDescriptor();
            Folder folder = make.getLogicalFolders();
            List sources = folder.getFolders();
            List roots = make.getAbsoluteSourceRoots();
            if (roots.size() > 0) {
                return (String)roots.get(0);
            }
            for (Folder o : sources) {
                Folder sub = o;
                if (!sub.isProjectFiles()) continue;
                if ("SourceFiles".equals(sub.getName())) {
                    List v = sub.getFolders();
                    for (Folder e : v) {
                        Folder s = e;
                        if (!s.isProjectFiles()) continue;
                        roots.add(s.getName());
                    }
                    continue;
                }
                if ("HeaderFiles".equals(sub.getName()) || "ResourceFiles".equals(sub.getName())) continue;
                roots.add(sub.getName());
            }
            if (roots.size() > 0) {
                String rootName = (String)roots.get(0);
                Item[] items = make.getProjectItems();
                if (items.length > 0) {
                    String path = items[0].getAbsPath();
                    StringBuilder newBase = null;
                    newBase = path.startsWith("..") ? new StringBuilder(base) : new StringBuilder();
                    StringTokenizer st = new StringTokenizer(path, "/\\");
                    while (st.hasMoreTokens()) {
                        String segment = st.nextToken();
                        newBase.append(File.separator);
                        newBase.append(segment);
                        if (!rootName.equals(segment) || !st.hasMoreTokens()) continue;
                        return CndFileUtils.normalizeFile((File)new File(newBase.toString())).getAbsolutePath();
                    }
                }
            }
        }
        return base;
    }

    private Collection<Project> getMakeProjects(Node[] nodes) {
        ArrayList<Project> projects = new ArrayList<Project>();
        for (int i = 0; i < nodes.length; ++i) {
            Project project = (Project)nodes[i].getLookup().lookup(Project.class);
            if (project == null) {
                return null;
            }
            ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (pdp == null || !pdp.gotDescriptor()) {
                return null;
            }
            MakeConfigurationDescriptor make = pdp.getConfigurationDescriptor();
            if (make == null) {
                return null;
            }
            MakeConfiguration conf = make.getActiveConfiguration();
            if (conf == null || !conf.isMakefileConfiguration()) {
                return null;
            }
            projects.add(project);
        }
        return projects;
    }

    private WizardDescriptor.InstantiatingIterator getPanels() {
        WizardDescriptor.Panel[] panels = new WizardDescriptor.Panel[]{new SelectModeWizard(), new SelectProviderWizard(), new SelectObjectFilesWizard(), new ConsolidationStrategyWizard(), new SelectConfigurationWizard()};
        WizardDescriptor.Panel[] simplepanels = new WizardDescriptor.Panel[]{panels[0], new SimpleConfigurationWizard()};
        String[] steps = new String[panels.length];
        String[] simple = new String[simplepanels.length];
        String[] advanced = new String[]{panels[0].getComponent().getName(), "..."};
        for (int i = 0; i < panels.length; ++i) {
            Component c = panels[i].getComponent();
            steps[i] = c.getName();
            DiscoveryWizardAction.setupComponent(steps, advanced, i, c);
            if (i >= simple.length) continue;
            c = simplepanels[i].getComponent();
            simple[i] = c.getName();
            if (i <= 0 || i >= simple.length) continue;
            DiscoveryWizardAction.setupComponent(simple, null, i, c);
        }
        return new DiscoveryWizardIterator(panels, simplepanels);
    }

    static void setupComponent(String[] steps, String[] advanced, int i, Component c) {
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            if (i == 0) {
                jc.putClientProperty("WizardPanel_contentData", advanced);
            } else {
                jc.putClientProperty("WizardPanel_contentData", steps);
            }
            jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
        }
    }

    public String getName() {
        return this.getString("ACTION_TITLE_TXT");
    }

    public String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private String getString(String key) {
        return NbBundle.getBundle(DiscoveryWizardAction.class).getString(key);
    }
}

