/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.discovery.wizard.ConsolidationStrategyWizard;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ConsolidationStrategyPanel
extends JPanel {
    private ConsolidationStrategyWizard wizard;
    private String level = "file";
    private ButtonGroup consolidationGroup;
    private JRadioButton fileConsolidation;
    private JRadioButton folderConsolidation;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JLabel jLabel1;
    private JRadioButton projectConsolidation;

    public ConsolidationStrategyPanel(ConsolidationStrategyWizard wizard) {
        this.wizard = wizard;
        this.initComponents();
        this.addListeners();
        this.fileConsolidation.setSelected(true);
        this.update("file");
    }

    private void addListeners() {
        this.fileConsolidation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsolidationStrategyPanel.this.update("file");
            }
        });
        this.folderConsolidation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsolidationStrategyPanel.this.update("folder");
            }
        });
        this.projectConsolidation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsolidationStrategyPanel.this.update("project");
            }
        });
    }

    void read(DiscoveryDescriptor wizardDescriptor) {
    }

    void store(DiscoveryDescriptor wizardDescriptor) {
        wizardDescriptor.setLevel(this.level);
    }

    boolean valid(DiscoveryDescriptor settings) {
        return true;
    }

    private void update(String level) {
        this.level = level;
        this.wizard.stateChanged(null);
        String description = NbBundle.getMessage(ConsolidationStrategyPanel.class, (String)("ConsolidationDescription_" + level));
        this.instructionsTextArea.setText(description);
    }

    private void initComponents() {
        this.consolidationGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.projectConsolidation = new JRadioButton();
        this.folderConsolidation = new JRadioButton();
        this.fileConsolidation = new JRadioButton();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.projectConsolidation);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/discovery/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)bundle.getString("ConsolidationLevelText"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.consolidationGroup.add(this.projectConsolidation);
        Mnemonics.setLocalizedText((AbstractButton)this.projectConsolidation, (String)bundle.getString("ConsolidateToProjectLabel"));
        this.projectConsolidation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projectConsolidation.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.projectConsolidation, gridBagConstraints);
        this.consolidationGroup.add(this.folderConsolidation);
        Mnemonics.setLocalizedText((AbstractButton)this.folderConsolidation, (String)bundle.getString("ConsolidateToFolderLabel"));
        this.folderConsolidation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.folderConsolidation.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.folderConsolidation, gridBagConstraints);
        this.consolidationGroup.add(this.fileConsolidation);
        Mnemonics.setLocalizedText((AbstractButton)this.fileConsolidation, (String)bundle.getString("FileConsolidateLabel"));
        this.fileConsolidation.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.fileConsolidation.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.fileConsolidation, gridBagConstraints);
        this.instructionPanel.setVerifyInputWhenFocusTarget(false);
        this.instructionPanel.setLayout(new BorderLayout());
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        this.instructionsTextArea.setOpaque(false);
        this.instructionPanel.add((Component)this.instructionsTextArea, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
    }
}

