/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.projectimport.ImportExecutable;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryExtension;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.api.wizards.CommonUtilities;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateDependencies
implements PropertyChangeListener {
    private static final boolean TRACE = true;
    private static final RequestProcessor RP = new RequestProcessor(ImportExecutable.class.getName(), 1);
    private final Project mainProject;
    private final List<String> dependencies;
    private List<String> paths;
    private final List<String> searchPaths;
    private final String binary;
    private final Map<Project, String> createdProjects = new HashMap<Project, String>();
    private MakeConfigurationDescriptor mainConfigurationDescriptor;

    public CreateDependencies(Project project, List<String> list, List<String> list2, List<String> list3, String string) {
        this.mainProject = project;
        this.dependencies = list;
        this.paths = list2;
        this.searchPaths = list3;
        this.binary = string;
    }

    public void create() {
        Object object;
        Project[] projectArray;
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)this.mainProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (!configurationDescriptorProvider.gotDescriptor()) {
            return;
        }
        this.mainConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor();
        if (this.paths == null) {
            if (this.dependencies == null || this.dependencies.isEmpty()) {
                return;
            }
            projectArray = new HashMap();
            String string = ImportExecutable.findFolderPath(this.mainConfigurationDescriptor, ImportExecutable.getRoot(this.mainConfigurationDescriptor));
            if (string != null) {
                object = this.mainConfigurationDescriptor.getActiveConfiguration();
                String string2 = CommonUtilities.getLdLibraryPath((MakeConfiguration)object);
                string2 = CommonUtilities.addSearchPaths((String)string2, this.searchPaths, (String)this.binary);
                boolean bl = false;
                for (String string3 : this.dependencies) {
                    String string4 = ImportExecutable.findLocation(string3, string2);
                    if (string4 != null) {
                        projectArray.put(string3, string4);
                        continue;
                    }
                    bl = true;
                    projectArray.put(string3, null);
                }
                if (bl && string.length() > 1) {
                    ImportExecutable.gatherSubFolders(new File(string), new HashSet<String>(), (Map<String, String>)projectArray);
                }
            }
            this.paths = new ArrayList<String>();
            for (Map.Entry entry : projectArray.entrySet()) {
                if (entry.getValue() == null || !ImportExecutable.isMyDll((String)entry.getValue(), string)) continue;
                this.paths.add((String)entry.getValue());
            }
        }
        for (String string : this.paths) {
            try {
                object = CreateDependencies.createProject(string, "", "", "");
                this.createdProjects.put((Project)object, string);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (!this.createdProjects.isEmpty()) {
            OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            projectArray = new Project[this.createdProjects.size()];
            int n = 0;
            object = this.createdProjects.keySet().iterator();
            while (object.hasNext()) {
                Project project;
                projectArray[n] = project = (Project)object.next();
                ++n;
            }
            OpenProjects.getDefault().open(projectArray, false);
        }
    }

    private static void updateRunProfile(String string, RunProfile runProfile, String string2, String string3, String string4) {
        runProfile.setArgs(string2);
        String string5 = string3;
        string5 = CndPathUtilitities.toRelativePath((String)string, (String)string5);
        string5 = CndPathUtilitities.normalizeSlashes((String)string5);
        runProfile.setRunDirectory(string5);
        Env env = runProfile.getEnvironment();
        env.removeAll();
        env.decode(string4);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("openProjects") && propertyChangeEvent.getNewValue() instanceof Project[]) {
            Project[] projectArray = (Project[])propertyChangeEvent.getNewValue();
            if (projectArray.length == 0) {
                return;
            }
            for (Project project : projectArray) {
                if (!this.createdProjects.containsKey(project)) continue;
                this.addReqProject(project);
            }
            ImportExecutable.saveMakeConfigurationDescriptor(this.mainProject);
            for (Project project : projectArray) {
                String string = null;
                if (!this.createdProjects.containsKey(project)) continue;
                string = this.createdProjects.get(project);
                this.createdProjects.remove(project);
                IteratorExtension iteratorExtension = (IteratorExtension)Lookup.getDefault().lookup(IteratorExtension.class);
                if (iteratorExtension == null) continue;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("DW:buildResult", string);
                hashMap.put("DW:consolidationLevel", "file");
                hashMap.put("DW:rootFolder", project.getProjectDirectory().getPath());
                this.process((DiscoveryExtension)iteratorExtension, project, hashMap);
            }
            if (this.createdProjects.isEmpty()) {
                OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    private void addReqProject(Project project) {
        ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor(true);
        this.mainConfigurationDescriptor.getActiveConfiguration().getRequiredProjectsConfiguration().add((Object)new LibraryItem.ProjectItem(new MakeArtifact(makeConfigurationDescriptor, makeConfigurationDescriptor.getActiveConfiguration())));
    }

    public void process(final DiscoveryExtension discoveryExtension, final Project project, final Map<String, Object> map) {
        ImportExecutable.switchModel(false, project);
        RequestProcessor.Task task = RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getBundle(ImportExecutable.class).getString("ImportExecutable.Progress"));
                progressHandle.start();
                try {
                    ConfigurationDescriptorProvider configurationDescriptorProvider = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
                    MakeConfigurationDescriptor makeConfigurationDescriptor = configurationDescriptorProvider.getConfigurationDescriptor(true);
                    DiscoveryExtensionInterface.Applicable applicable = discoveryExtension.isApplicable(map, project);
                    if (applicable.isApplicable()) {
                        ImportExecutable.resetCompilerSet(makeConfigurationDescriptor.getActiveConfiguration(), applicable);
                        if (discoveryExtension.canApply(map, project)) {
                            try {
                                discoveryExtension.apply(map, project);
                                ImportExecutable.saveMakeConfigurationDescriptor(project);
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                    ImportExecutable.switchModel(true, project);
                }
                catch (Throwable throwable) {
                    Exceptions.printStackTrace((Throwable)throwable);
                }
                finally {
                    progressHandle.finish();
                }
            }
        });
    }

    private static Project createProject(String string, String string2, String string3, String string4) throws IOException {
        String string5 = ProjectGenerator.getDefaultProjectFolder();
        String string6 = ProjectGenerator.getValidProjectName((String)string5, (String)new File(string).getName());
        String string7 = string5 + File.separator + string6;
        MakeConfiguration makeConfiguration = new MakeConfiguration(string7, "Default", 0);
        String string8 = new File(string).getParentFile().getPath();
        string8 = CndPathUtilitities.toRelativePath((String)string7, (String)string8);
        string8 = CndPathUtilitities.normalizeSlashes((String)string8);
        makeConfiguration.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(string8);
        String string9 = string;
        string9 = CndPathUtilitities.toRelativePath((String)string7, (String)string9);
        string9 = CndPathUtilitities.normalizeSlashes((String)string9);
        makeConfiguration.getMakefileConfiguration().getOutput().setValue(string9);
        CreateDependencies.updateRunProfile(string7, makeConfiguration.getProfile(), string2, string3, string4);
        ProjectGenerator.ProjectParameters projectParameters = new ProjectGenerator.ProjectParameters(string6, string5);
        projectParameters.setOpenFlag(false).setConfiguration(makeConfiguration).setImportantFiles(Collections.singletonList(string9).iterator());
        Project project = ProjectGenerator.createBlankProject((ProjectGenerator.ProjectParameters)projectParameters);
        return project;
    }
}

