/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.makeproject.ui.wizards.RemoteProjectImportWizardIterator;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class RemoteProjectImportWizard {
    public static final String PROPERTY_REMOTE_PROJECTS = "RemoteImportedProjects";
    private boolean cancelled;
    private final RemoteProjectImportWizardIterator iterator = new RemoteProjectImportWizardIterator();

    public static void showImportWizard() {
        RemoteProjectImportWizard wizard = new RemoteProjectImportWizard();
        wizard.importProjects();
    }

    private void importProjects() {
        final WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.iterator);
        this.iterator.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", RemoteProjectImportWizard.this.iterator.getErrorMessage());
            }
        });
        wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        wizardDescriptor.setTitle(NbBundle.getMessage(RemoteProjectImportWizard.class, (String)"RemoteProjectImportWizard.title"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = this.cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!this.cancelled) {
            // empty if block
        }
    }

    private boolean isCancelled() {
        return this.cancelled;
    }

    private List<ImportedProject> getProjectsToImport() {
        return this.iterator.getProjects();
    }

    public static final class ImportedProject {
        private final String remoteProjectFolder;
        private final ExecutionEnvironment remoteEnv;
        private final String localProjectFolder;

        public ImportedProject(ExecutionEnvironment env, String remotePrjFolder, String localPrjFolder) {
            assert (env != null);
            this.remoteEnv = env;
            assert (remotePrjFolder != null);
            this.remoteProjectFolder = remotePrjFolder;
            assert (localPrjFolder != null);
            this.localProjectFolder = localPrjFolder;
        }

        public ExecutionEnvironment getRemoteEnvironment() {
            return this.remoteEnv;
        }

        public String getRemoteProjectFolder() {
            return this.remoteProjectFolder;
        }

        public String getLocalProjectDestinationFolder() {
            return this.localProjectFolder;
        }

        public String toString() {
            return "ImportedProject{remoteProjectFolder=" + this.remoteProjectFolder + ", remoteEnv=" + this.remoteEnv + ", localProjectFolder=" + this.localProjectFolder + '}';
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ImportedProject other = (ImportedProject)obj;
            if (!(this.remoteProjectFolder == other.remoteProjectFolder || this.remoteProjectFolder != null && this.remoteProjectFolder.equals(other.remoteProjectFolder))) {
                return false;
            }
            if (!(this.remoteEnv == other.remoteEnv || this.remoteEnv != null && this.remoteEnv.equals(other.remoteEnv))) {
                return false;
            }
            return this.localProjectFolder == other.localProjectFolder || this.localProjectFolder != null && this.localProjectFolder.equals(other.localProjectFolder);
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.remoteProjectFolder != null ? this.remoteProjectFolder.hashCode() : 0);
            hash = 47 * hash + (this.remoteEnv != null ? this.remoteEnv.hashCode() : 0);
            hash = 47 * hash + (this.localProjectFolder != null ? this.localProjectFolder.hashCode() : 0);
            return hash;
        }
    }
}

