/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.utils.DirectoryChooserPanel;
import org.netbeans.modules.cnd.utils.ui.ListEditorPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class StringListPanel
extends JPanel
implements HelpCtx.Provider,
PropertyChangeListener {
    private MyListEditorPanel myListEditorPanel;
    private boolean addPathPanel;
    private BooleanConfiguration inheritValues;
    private PropertyEditorSupport editor;
    private HelpCtx helpCtx;
    private JCheckBox inheritCheckBox;
    private JLabel inheritLabel;
    private JPanel inheritPanel;
    private JTextArea inheritTextArea;
    private JPanel listPanel;
    private JPanel panel;
    private JScrollPane scrollPanel;

    public StringListPanel(String label, List<String> data, boolean addPathPanel, BooleanConfiguration inheritValues, String inheritText, PropertyEditorSupport editor, PropertyEnv env, HelpCtx helpCtx) {
        this.addPathPanel = addPathPanel;
        this.inheritValues = inheritValues;
        this.editor = editor;
        this.helpCtx = helpCtx;
        this.initComponents();
        this.myListEditorPanel = new MyListEditorPanel(label, data);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.listPanel.add((Component)((Object)this.myListEditorPanel), gridBagConstraints);
        if (inheritValues != null) {
            this.inheritTextArea.setBackground(this.inheritPanel.getBackground());
            this.inheritTextArea.setText(inheritText);
            this.setPreferredSize(new Dimension(450, 330));
            this.inheritCheckBox.setSelected(inheritValues.getValue());
        } else {
            this.remove(this.inheritPanel);
            this.setPreferredSize(new Dimension(450, 220));
        }
        env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
        env.addPropertyChangeListener((PropertyChangeListener)this);
        this.inheritCheckBox.getAccessibleContext().setAccessibleDescription(StringListPanel.getString("INHERIT_CHECKBOX_AD"));
    }

    public void setInstructionsText(String txt) {
    }

    private List<String> getListData() {
        return this.myListEditorPanel.getListData();
    }

    private Object getPropertyValue() throws IllegalStateException {
        return new ArrayList<String>(this.getListData());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    public HelpCtx getHelpCtx() {
        return this.helpCtx;
    }

    private void initComponents() {
        this.listPanel = new JPanel();
        this.inheritPanel = new JPanel();
        this.scrollPanel = new JScrollPane();
        this.panel = new JPanel();
        this.inheritLabel = new JLabel();
        this.inheritTextArea = new JTextArea();
        this.inheritCheckBox = new JCheckBox();
        this.setPreferredSize(new Dimension(323, 223));
        this.setLayout(new GridBagLayout());
        this.listPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.listPanel, gridBagConstraints);
        this.inheritPanel.setLayout(new GridBagLayout());
        this.scrollPanel.setBorder(null);
        this.panel.setLayout(new GridBagLayout());
        this.inheritLabel.setLabelFor(this.inheritTextArea);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/utils/Bundle");
        this.inheritLabel.setText(bundle.getString("INHERITED_VALUES_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.panel.add((Component)this.inheritLabel, gridBagConstraints);
        this.inheritTextArea.setEditable(false);
        this.inheritTextArea.setLineWrap(true);
        this.inheritTextArea.setWrapStyleWord(true);
        this.inheritTextArea.setBorder(BorderFactory.createEtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panel.add((Component)this.inheritTextArea, gridBagConstraints);
        this.inheritTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(StringListPanel.class, (String)"INHERITED_VALUES_AN"));
        this.inheritTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(StringListPanel.class, (String)"INHERITED_VALUES_AD"));
        this.inheritCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.inheritCheckBox, (String)bundle.getString("INHERIT_CHECKBOX_LBL"));
        this.inheritCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StringListPanel.this.inheritCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.panel.add((Component)this.inheritCheckBox, gridBagConstraints);
        this.scrollPanel.setViewportView(this.panel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.inheritPanel.add((Component)this.scrollPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.inheritPanel, gridBagConstraints);
    }

    private void inheritCheckBoxActionPerformed(ActionEvent evt) {
        this.inheritValues.setValue(this.inheritCheckBox.isSelected());
    }

    private static String getString(String key) {
        return NbBundle.getMessage(DirectoryChooserPanel.class, (String)key);
    }

    private static class MyListEditorPanel
    extends ListEditorPanel<String> {
        public MyListEditorPanel(String listLabel, List<String> objects) {
            super(objects);
            Mnemonics.setLocalizedText((JLabel)this.getListLabel(), (String)listLabel);
            this.getDefaultButton().setVisible(false);
        }

        public String addAction() {
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(StringListPanel.getString("ADD_DIALOG_LABEL_TXT"), StringListPanel.getString("EDIT_DIALOG_TITLE_TXT"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return null;
            }
            String newS = notifyDescriptor.getInputText().trim();
            if (newS.length() == 0) {
                return null;
            }
            return newS;
        }

        public String getAddButtonText() {
            return StringListPanel.getString("ADD_BUTTON_TXT");
        }

        public char getAddButtonMnemonics() {
            return StringListPanel.getString("ADD_BUTTON_MN").charAt(0);
        }

        public String getRenameButtonText() {
            return StringListPanel.getString("EDIT_BUTTON_TXT");
        }

        public char getRenameButtonMnemonics() {
            return StringListPanel.getString("EDIT_BUTTON_MN").charAt(0);
        }

        public String getDownButtonText() {
            return StringListPanel.getString("DOWN_BUTTON_TXT");
        }

        public char getDownButtonMnemonics() {
            return StringListPanel.getString("DOWN_BUTTON_MN").charAt(0);
        }

        public String copyAction(String o) {
            return o;
        }

        public void editAction(String o) {
            String s = o;
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(StringListPanel.getString("EDIT_DIALOG_LABEL_TXT"), StringListPanel.getString("EDIT_DIALOG_TITLE_TXT"));
            notifyDescriptor.setInputText(s);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String newS = notifyDescriptor.getInputText();
            this.replaceElement(o, newS);
        }
    }
}

