/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemNode;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.datatransfer.PasteType;

final class ViewItemPasteType
extends PasteType {
    private final Folder toFolder;
    private final ViewItemNode viewItemNode;
    private final int type;
    private final MakeLogicalViewProvider provider;

    public ViewItemPasteType(Folder toFolder, ViewItemNode viewItemNode, int type, MakeLogicalViewProvider provider) {
        this.toFolder = toFolder;
        this.viewItemNode = viewItemNode;
        this.type = type;
        this.provider = provider;
    }

    private void copyItemConfigurations(ItemConfiguration[] newConfigurations, ItemConfiguration[] oldConfigurations) {
        if (newConfigurations == null || oldConfigurations == null) {
            return;
        }
        assert (newConfigurations.length == oldConfigurations.length);
        for (int i = 0; i < newConfigurations.length; ++i) {
            newConfigurations[i].assignValues(oldConfigurations[i]);
        }
    }

    public Transferable paste() throws IOException {
        if (!this.provider.gotMakeConfigurationDescriptor() || !this.provider.getMakeConfigurationDescriptor().okToChange()) {
            return null;
        }
        Item item = this.viewItemNode.getItem();
        ItemConfiguration[] oldConfigurations = item.getItemConfigurations();
        if (this.type == 2) {
            if (this.toFolder.getProject() == this.viewItemNode.getFolder().getProject()) {
                if (this.toFolder.isDiskFolder()) {
                    FileObject itemFO = item.getFileObject();
                    String toFolderPath = CndPathUtilitities.toAbsolutePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)this.toFolder.getRootPath());
                    FileObject toFolderFO = CndFileUtils.toFileObject((CharSequence)toFolderPath);
                    String newName = CndPathUtilitities.createUniqueFileName((String)toFolderPath, (String)itemFO.getName(), (String)itemFO.getExt());
                    FileObject movedFileFO = FileUtil.moveFile((FileObject)itemFO, (FileObject)toFolderFO, (String)newName);
                    File movedFileFile = FileUtil.toFile((FileObject)movedFileFO);
                    String itemPath = movedFileFile.getPath();
                    itemPath = CndPathUtilitities.toRelativePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)itemPath);
                    Item movedItem = this.toFolder.findItemByPath(itemPath = CndPathUtilitities.normalizeSlashes((String)itemPath));
                    if (movedItem != null) {
                        this.copyItemConfigurations(movedItem.getItemConfigurations(), oldConfigurations);
                    }
                } else if (this.viewItemNode.getFolder().removeItem(item)) {
                    this.toFolder.addItem(item);
                    this.copyItemConfigurations(item.getItemConfigurations(), oldConfigurations);
                }
            } else if (this.toFolder.isDiskFolder()) {
                FileObject itemFO = item.getFileObject();
                String toFolderPath = CndPathUtilitities.toAbsolutePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)this.toFolder.getRootPath());
                FileObject toFolderFO = CndFileUtils.toFileObject((CharSequence)toFolderPath);
                String newName = CndPathUtilitities.createUniqueFileName((String)toFolderPath, (String)itemFO.getName(), (String)itemFO.getExt());
                FileObject movedFileFO = FileUtil.moveFile((FileObject)itemFO, (FileObject)toFolderFO, (String)newName);
            } else if (CndPathUtilitities.isPathAbsolute((CharSequence)item.getPath())) {
                if (this.viewItemNode.getFolder().removeItem(item)) {
                    this.toFolder.addItem(item);
                }
            } else if (item.getPath().startsWith("..")) {
                String originalFilePath = FileUtil.toFile((FileObject)this.viewItemNode.getFolder().getProject().getProjectDirectory()).getPath();
                String newFilePath = FileUtil.toFile((FileObject)this.toFolder.getProject().getProjectDirectory()).getPath();
                String fromNewToOriginal = CndPathUtilitities.getRelativePath((String)newFilePath, (String)originalFilePath) + "/";
                fromNewToOriginal = CndPathUtilitities.normalizeSlashes((String)fromNewToOriginal);
                String newPath = fromNewToOriginal + item.getPath();
                newPath = CndPathUtilitities.trimDotDot((String)newPath);
                if (this.viewItemNode.getFolder().removeItemAction(item)) {
                    this.toFolder.addItemAction(new Item(CndPathUtilitities.normalizeSlashes((String)newPath)));
                }
            } else {
                Project toProject = this.toFolder.getProject();
                FileObject fo = item.getFileObject();
                String toFolderPath = FileUtil.toFile((FileObject)toProject.getProjectDirectory()).getAbsolutePath();
                String newName = CndPathUtilitities.createUniqueFileName((String)toFolderPath, (String)fo.getName(), (String)fo.getExt());
                FileObject copy = fo.copy(toProject.getProjectDirectory(), newName, fo.getExt());
                String newPath = CndPathUtilitities.toRelativePath((String)FileUtil.toFile((FileObject)toProject.getProjectDirectory()).getPath(), (String)FileUtil.toFile((FileObject)copy).getPath());
                if (this.viewItemNode.getFolder().removeItemAction(item)) {
                    fo.delete();
                    this.toFolder.addItemAction(new Item(CndPathUtilitities.normalizeSlashes((String)newPath)));
                }
            }
        } else if (this.type == 1 || this.type == 0) {
            if (this.toFolder.getProject() == this.viewItemNode.getFolder().getProject()) {
                if ((CndPathUtilitities.isPathAbsolute((CharSequence)item.getPath()) || item.getPath().startsWith("..")) && !this.toFolder.isDiskFolder()) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    FileObject fo = item.getFileObject();
                    String ext = fo.getExt();
                    if (this.toFolder.isDiskFolder()) {
                        String toFolderPath = CndPathUtilitities.toAbsolutePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)this.toFolder.getRootPath());
                        FileObject toFolderFO = CndFileUtils.toFileObject((CharSequence)toFolderPath);
                        String newName = CndPathUtilitities.createUniqueFileName((String)toFolderPath, (String)fo.getName(), (String)ext);
                        FileObject copiedFileObject = fo.copy(toFolderFO, newName, ext);
                        File copiedFileFile = FileUtil.toFile((FileObject)copiedFileObject);
                        String itemPath = copiedFileFile.getPath();
                        itemPath = CndPathUtilitities.toRelativePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)itemPath);
                        Item copiedItemItem = this.toFolder.findItemByPath(itemPath = CndPathUtilitities.normalizeSlashes((String)itemPath));
                        if (copiedItemItem != null) {
                            this.copyItemConfigurations(copiedItemItem.getItemConfigurations(), oldConfigurations);
                        }
                    } else {
                        String parent = FileUtil.toFile((FileObject)fo.getParent()).getPath();
                        String newName = CndPathUtilitities.createUniqueFileName((String)parent, (String)fo.getName(), (String)ext);
                        fo.copy(fo.getParent(), newName, ext);
                        String newPath = parent + "/" + newName;
                        if (ext.length() > 0) {
                            newPath = newPath + "." + ext;
                        }
                        newPath = CndPathUtilitities.toRelativePath((String)FileUtil.toFile((FileObject)this.viewItemNode.getFolder().getProject().getProjectDirectory()).getPath(), (String)newPath);
                        Item newItem = new Item(CndPathUtilitities.normalizeSlashes((String)newPath));
                        this.toFolder.addItemAction(newItem);
                        this.copyItemConfigurations(newItem.getItemConfigurations(), oldConfigurations);
                    }
                }
            } else if (this.toFolder.isDiskFolder()) {
                FileObject fo = item.getFileObject();
                String ext = fo.getExt();
                String toFolderPath = CndPathUtilitities.toAbsolutePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)this.toFolder.getRootPath());
                FileObject toFolderFO = CndFileUtils.toFileObject((CharSequence)toFolderPath);
                String newName = CndPathUtilitities.createUniqueFileName((String)toFolderPath, (String)fo.getName(), (String)ext);
                fo.copy(toFolderFO, newName, ext);
            } else if (CndPathUtilitities.isPathAbsolute((CharSequence)item.getPath())) {
                this.toFolder.addItem(new Item(item.getPath()));
            } else if (item.getPath().startsWith("..")) {
                String originalFilePath = FileUtil.toFile((FileObject)this.viewItemNode.getFolder().getProject().getProjectDirectory()).getPath();
                String newFilePath = FileUtil.toFile((FileObject)this.toFolder.getProject().getProjectDirectory()).getPath();
                String fromNewToOriginal = CndPathUtilitities.getRelativePath((String)newFilePath, (String)originalFilePath) + "/";
                fromNewToOriginal = CndPathUtilitities.normalizeSlashes((String)fromNewToOriginal);
                String newPath = fromNewToOriginal + item.getPath();
                newPath = CndPathUtilitities.trimDotDot((String)newPath);
                this.toFolder.addItemAction(new Item(CndPathUtilitities.normalizeSlashes((String)newPath)));
            } else {
                Project toProject = this.toFolder.getProject();
                String parent = FileUtil.toFile((FileObject)toProject.getProjectDirectory()).getPath();
                FileObject fo = item.getFileObject();
                String ext = fo.getExt();
                String newName = CndPathUtilitities.createUniqueFileName((String)parent, (String)fo.getName(), (String)ext);
                fo.copy(toProject.getProjectDirectory(), newName, ext);
                String newPath = newName;
                if (ext.length() > 0) {
                    newPath = newPath + "." + ext;
                }
                this.toFolder.addItemAction(new Item(CndPathUtilitities.normalizeSlashes((String)newPath)));
            }
        }
        return null;
    }
}

