/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ArrayList;
import java.util.List;

public class VectorConfiguration<E> {
    private VectorConfiguration<E> master;
    private List<E> value;
    private boolean dirty = false;

    public VectorConfiguration(VectorConfiguration<E> master) {
        this.master = master;
        this.value = new ArrayList(0);
        this.reset();
    }

    public VectorConfiguration<E> getMaster() {
        return this.master;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public void add(E o) {
        this.getValue().add(o);
    }

    public void setValue(List<E> l) {
        if (l == null) {
            return;
        }
        this.value = l;
    }

    public List<E> getValue() {
        return this.value;
    }

    public boolean getModified() {
        return !this.value.isEmpty();
    }

    public final void reset() {
        this.value = new ArrayList(0);
    }

    public void assign(VectorConfiguration<E> conf) {
        if (conf == null) {
            return;
        }
        this.setDirty(!this.equals(conf));
        this.reset();
        this.getValue().addAll(conf.getValue());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VectorConfiguration)) {
            return false;
        }
        VectorConfiguration conf = (VectorConfiguration)obj;
        List<E> list1 = this.getValue();
        List<E> list2 = conf.getValue();
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 != null && list2 != null) {
            if (list1.size() != list2.size()) {
                return false;
            }
            for (int i = 0; i < list1.size(); ++i) {
                if (list1.get(i).equals(list2.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int code = 3;
        for (E obj : this.getValue()) {
            code = 17 * code + obj.hashCode();
        }
        return code;
    }

    public VectorConfiguration<E> clone() {
        VectorConfiguration<E> clone = new VectorConfiguration<E>(this.master);
        clone.setValue(new ArrayList<E>(this.getValue()));
        return clone;
    }

    public String toString(ToString<E> visitor) {
        StringBuilder buf = new StringBuilder();
        List<E> list = this.getValue();
        for (E item : list) {
            String s = visitor.toString(item);
            if (s == null || 0 >= s.length()) continue;
            buf.append(s).append(' ');
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (E e : this.value) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(e);
        }
        return "{value=[" + sb + "] dirty=" + this.dirty + '}';
    }

    public static interface ToString<E> {
        public String toString(E var1);
    }
}

