/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.makeproject.ConfirmExtensions;
import org.netbeans.modules.cnd.makeproject.MakeActionProvider;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.MakeProjectConfigurationProvider;
import org.netbeans.modules.cnd.makeproject.MakeProjectEncodingQueryImpl;
import org.netbeans.modules.cnd.makeproject.MakeProjectFileProviderFactory;
import org.netbeans.modules.cnd.makeproject.MakeProjectOperations;
import org.netbeans.modules.cnd.makeproject.MakeProjectType;
import org.netbeans.modules.cnd.makeproject.MakeSharabilityQuery;
import org.netbeans.modules.cnd.makeproject.MakeSources;
import org.netbeans.modules.cnd.makeproject.MakeTemplateListener;
import org.netbeans.modules.cnd.makeproject.NativeProjectProvider;
import org.netbeans.modules.cnd.makeproject.NativeProjectSettingsImpl;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifactProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.toolchain.ToolchainProject;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.MIMEExtensions;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.FilteringPathResourceImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.LookupProviderSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.project.ui.support.UILookupMergerSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.OperationListener;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openidex.search.SearchInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class MakeProject
implements Project,
AntProjectListener,
Runnable {
    public static final String REMOTE_MODE = "remote-sources-mode";
    public static final String REMOTE_FILESYSTEM_HOST = "remote-filesystem-host";
    public static final String REMOTE_FILESYSTEM_BASE_DIR = "remote-filesystem-base-dir";
    private static final boolean UNIT_TEST_MODE = CndUtils.isUnitTestMode();
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private static final String HEADER_EXTENSIONS = "header-extensions";
    private static final String C_EXTENSIONS = "c-extensions";
    private static final String CPP_EXTENSIONS = "cpp-extensions";
    private static final RequestProcessor RP = new RequestProcessor("Open project", 4);
    private static MakeTemplateListener templateListener = null;
    private final MakeProjectType kind;
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final ReferenceHelper refHelper;
    private final NativeProjectProvider nativeProjectProvider;
    private final Lookup lookup;
    private ConfigurationDescriptorProvider projectDescriptorProvider;
    private Set<String> headerExtensions = MakeProject.createExtensionSet();
    private Set<String> cExtensions = MakeProject.createExtensionSet();
    private Set<String> cppExtensions = MakeProject.createExtensionSet();
    private String sourceEncoding = null;
    private boolean isOpenHookDone = false;
    private AtomicBoolean isDeleted = new AtomicBoolean(false);
    private AtomicBoolean isDeleting = new AtomicBoolean(false);
    private final MakeSources sources;
    private final MutableCP sourcepath;
    private final PropertyChangeListener indexerListener = new IndexerOptionsListener();
    private RemoteProject.Mode remoteMode;
    private final String remoteBaseDir;
    private ExecutionEnvironment remoteFileSystemHost;
    private static final String PROJECT_NAME_WITH_HIDDEN_PATHS = System.getProperty("cnd.project.name.hidden.paths");
    private static final int PROJECT_NAME_NUM_SHOWN_FOLDERS = Integer.getInteger("cnd.project.name.folders.num", 1);
    private List<Runnable> openedTasks;

    public MakeProject(AntProjectHelper helper) throws IOException {
        LOGGER.log(Level.FINE, "Start of creation MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), helper.getProjectDirectory().getNameExt()});
        this.kind = new MakeProjectType();
        this.helper = helper;
        this.eval = this.createEvaluator();
        AuxiliaryConfiguration aux = helper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(helper, aux, this.eval);
        this.projectDescriptorProvider = new ConfigurationDescriptorProvider(this, helper.getProjectDirectory());
        LOGGER.log(Level.FINE, "Create ConfigurationDescriptorProvider@{0} for MakeProject@{1} {2}", new Object[]{System.identityHashCode(this.projectDescriptorProvider), System.identityHashCode(this), helper.getProjectDirectory().getNameExt()});
        this.sources = new MakeSources(this, helper);
        this.sourcepath = new MutableCP(this.sources);
        this.nativeProjectProvider = new NativeProjectProvider(this, this.projectDescriptorProvider);
        this.lookup = this.createLookup(aux);
        Element data = helper.getPrimaryConfigurationData(true);
        this.remoteMode = RemoteProject.DEFAULT_MODE;
        NodeList remoteModeNodeList = data.getElementsByTagName(REMOTE_MODE);
        if (remoteModeNodeList.getLength() == 1) {
            remoteModeNodeList = remoteModeNodeList.item(0).getChildNodes();
            String t = remoteModeNodeList.item(0).getNodeValue();
            RemoteProject.Mode mode = RemoteProject.Mode.valueOf((String)t);
            CndUtils.assertNotNull((Object)mode, (String)("can not restore remote mode " + t));
            if (mode != null) {
                this.remoteMode = mode;
            }
        } else if (remoteModeNodeList.getLength() > 0) {
            CndUtils.assertTrueInConsole((boolean)false, (String)"Wrong project.xml structure");
        }
        this.remoteFileSystemHost = ExecutionEnvironmentFactory.getLocal();
        NodeList remoteFSHostNodeList = data.getElementsByTagName(REMOTE_FILESYSTEM_HOST);
        if (remoteFSHostNodeList.getLength() == 1) {
            remoteFSHostNodeList = remoteFSHostNodeList.item(0).getChildNodes();
            String hostID = remoteFSHostNodeList.item(0).getNodeValue();
            this.remoteFileSystemHost = ExecutionEnvironmentFactory.fromUniqueID((String)hostID);
        } else if (remoteFSHostNodeList.getLength() > 0) {
            CndUtils.assertTrueInConsole((boolean)false, (String)"Wrong project.xml structure");
        }
        NodeList remoteFSMountPoint = data.getElementsByTagName(REMOTE_FILESYSTEM_BASE_DIR);
        if (remoteFSMountPoint.getLength() > 0) {
            this.remoteBaseDir = remoteFSMountPoint.item(0).getTextContent();
            CndUtils.assertTrueInConsole((remoteFSMountPoint.getLength() == 1 ? 1 : 0) != 0, (String)("Wrong project.xml structure: too many remote base dirs " + remoteFSMountPoint));
        } else {
            this.remoteBaseDir = null;
        }
        this.readProjectExtension(data, HEADER_EXTENSIONS, this.headerExtensions);
        this.readProjectExtension(data, C_EXTENSIONS, this.cExtensions);
        this.readProjectExtension(data, CPP_EXTENSIONS, this.cppExtensions);
        this.sourceEncoding = this.getSourceEncodingFromProjectXml();
        if (templateListener == null) {
            templateListener = new MakeTemplateListener();
            DataLoaderPool.getDefault().addOperationListener((OperationListener)templateListener);
        }
        LOGGER.log(Level.FINE, "End of creation MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), helper.getProjectDirectory().getNameExt()});
    }

    private void readProjectExtension(Element data, String key, Set<String> set) {
        NodeList nl = data.getElementsByTagName(key);
        if (nl.getLength() == 1 && (nl = nl.item(0).getChildNodes()).getLength() == 1) {
            String extensions = nl.item(0).getNodeValue();
            set.addAll(Arrays.asList(extensions.split(",")));
        }
    }

    void setRemoteMode(RemoteProject.Mode mode) {
        this.remoteMode = mode;
    }

    public RemoteProject.Mode getRemoteMode() {
        return this.remoteMode;
    }

    public ExecutionEnvironment getRemoteFileSystemHost() {
        return this.remoteFileSystemHost;
    }

    private FileSystem getSourceFileSystem() {
        if (this.remoteFileSystemHost == null || this.remoteFileSystemHost.isLocal()) {
            return CndFileUtils.getLocalFileSystem();
        }
        return FileSystemProvider.getFileSystem((ExecutionEnvironment)this.remoteFileSystemHost);
    }

    void setRemoteFileSystemHost(ExecutionEnvironment remoteFileSystemHost) {
        this.remoteFileSystemHost = remoteFileSystemHost;
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public String toString() {
        return "MakeProject[" + this.getProjectDirectory() + "]";
    }

    private PropertyEvaluator createEvaluator() {
        return this.helper.getStandardPropertyEvaluator();
    }

    PropertyEvaluator evaluator() {
        return this.eval;
    }

    ReferenceHelper getReferenceHelper() {
        return this.refHelper;
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private Lookup createLookup(AuxiliaryConfiguration aux) {
        MakeSubprojectProvider spp = new MakeSubprojectProvider();
        Info info = new Info();
        Lookup lkp = Lookups.fixed((Object[])new Object[]{info, aux, this.helper.createCacheDirectoryProvider(), spp, new MakeActionProvider(this), new MakeLogicalViewProvider(this), new MakeCustomizerProvider(this, this.projectDescriptorProvider), new MakeArtifactProviderImpl(), new ProjectXmlSavedHookImpl(), UILookupMergerSupport.createProjectOpenHookMerger((ProjectOpenedHook)new ProjectOpenedHookImpl()), new MakeSharabilityQuery(this.projectDescriptorProvider, FileUtil.toFile((FileObject)this.getProjectDirectory())), this.sources, this.helper, this.projectDescriptorProvider, new MakeProjectConfigurationProvider(this, this.projectDescriptorProvider, info), this.nativeProjectProvider, new NativeProjectSettingsImpl(this, this.kind.getPrimaryConfigurationDataElementNamespace(false), false), new RecommendedTemplatesImpl(this.projectDescriptorProvider), new MakeProjectOperations(this), new FolderSearchInfo(this.projectDescriptorProvider), this.kind, new MakeProjectEncodingQueryImpl(this), new RemoteProjectImpl(), new ToolchainProjectImpl(), new CPPImpl(this.sources)});
        return LookupProviderSupport.createCompositeLookup((Lookup)lkp, (String)this.kind.getLookupMergerPath());
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        if (ev.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    public boolean addAdditionalHeaderExtensions(Collection<String> needAdd) {
        Set<String> headerExtension = MakeProject.getHeaderSuffixes();
        Set<String> sourceExtension = MakeProject.getSourceSuffixes();
        Set<String> usedExtension = MakeProject.createExtensionSet();
        for (String extension : needAdd) {
            if (extension.length() <= 0 || headerExtension.contains(extension) || sourceExtension.contains(extension)) continue;
            usedExtension.add(extension);
        }
        if (usedExtension.size() > 0) {
            this.addMIMETypeExtensions(usedExtension, "text/x-h");
            this.headerExtensions.addAll(usedExtension);
            this.saveAdditionalExtensions();
            return true;
        }
        return false;
    }

    private void addMIMETypeExtensions(Collection<String> extensions, String mime) {
        MIMEExtensions exts = MIMEExtensions.get((String)mime);
        for (String ext : extensions) {
            exts.addExtension(ext);
        }
        CndFileVisibilityQuery.getDefault().stateChanged(null);
    }

    private Set<String> getUnknownExtensions(Set<String> inLoader, Set<String> inProject) {
        Set<String> unknown = MakeProject.createExtensionSet();
        for (String extension : inProject) {
            if (extension.length() <= 0 || inLoader.contains(extension)) continue;
            unknown.add(extension);
        }
        return unknown;
    }

    private void checkNeededExtensions() {
        if (UNIT_TEST_MODE) {
            return;
        }
        Set<String> unknownC = this.getUnknownExtensions(MakeProject.getCSuffixes(), this.cExtensions);
        Set<String> unknownCpp = this.getUnknownExtensions(MakeProject.getCppSuffixes(), this.cppExtensions);
        Set<String> unknownH = this.getUnknownExtensions(MakeProject.getHeaderSuffixes(), this.headerExtensions);
        if (!unknownC.isEmpty() && unknownCpp.isEmpty() && unknownH.isEmpty()) {
            if (unknownC.size() > 0 && this.addNewExtensionDialog(unknownC, "C")) {
                this.addMIMETypeExtensions(unknownC, "text/x-c");
            }
        } else if (unknownC.isEmpty() && !unknownCpp.isEmpty() && unknownH.isEmpty()) {
            if (this.addNewExtensionDialog(unknownCpp, "CPP")) {
                this.addMIMETypeExtensions(unknownCpp, "text/x-c++");
            }
        } else if (unknownC.isEmpty() && unknownCpp.isEmpty() && !unknownH.isEmpty()) {
            if (this.addNewExtensionDialog(unknownH, "H")) {
                this.addMIMETypeExtensions(unknownH, "text/x-h");
            }
        } else if (!(unknownC.isEmpty() && unknownCpp.isEmpty() && unknownH.isEmpty())) {
            ConfirmExtensions panel = new ConfirmExtensions(unknownC, unknownCpp, unknownH);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, MakeProject.getString("ConfirmExtensions.dialog.title"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                if (panel.isC()) {
                    this.addMIMETypeExtensions(unknownC, "text/x-c");
                }
                if (panel.isCpp()) {
                    this.addMIMETypeExtensions(unknownCpp, "text/x-c++");
                }
                if (panel.isHeader()) {
                    this.addMIMETypeExtensions(unknownH, "text/x-h");
                }
            }
        }
    }

    public void updateExtensions(Set<String> cSet, Set<String> cppSet, Set<String> hSet) {
        this.cExtensions.clear();
        this.cExtensions.addAll(cSet);
        this.cppExtensions.clear();
        this.cppExtensions.addAll(cppSet);
        this.headerExtensions.clear();
        this.headerExtensions.addAll(hSet);
        this.saveAdditionalExtensions();
    }

    private synchronized void registerClassPath(boolean register) {
        if (this.isOpenHookDone) {
            if (register) {
                GlobalPathRegistry.getDefault().register("org.netbeans.modules.cnd.makeproject/SOURCES", this.sourcepath.getClassPath());
            } else {
                try {
                    GlobalPathRegistry.getDefault().unregister("org.netbeans.modules.cnd.makeproject/SOURCES", this.sourcepath.getClassPath());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void saveAdditionalExtensions() {
        Element data = this.helper.getPrimaryConfigurationData(true);
        this.saveAdditionalHeaderExtensions(data, C_EXTENSIONS, this.cExtensions);
        this.saveAdditionalHeaderExtensions(data, CPP_EXTENSIONS, this.cppExtensions);
        this.saveAdditionalHeaderExtensions(data, HEADER_EXTENSIONS, this.headerExtensions);
        this.helper.putPrimaryConfigurationData(data, true);
    }

    private void saveAdditionalHeaderExtensions(Element data, String key, Set<String> set) {
        Element element;
        NodeList nodeList = data.getElementsByTagName(key);
        if (nodeList.getLength() == 1) {
            element = (Element)nodeList.item(0);
            NodeList deadKids = element.getChildNodes();
            while (deadKids.getLength() > 0) {
                element.removeChild(deadKids.item(0));
            }
        } else {
            element = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/make-project/1", key);
            data.appendChild(element);
        }
        StringBuilder buf = new StringBuilder();
        for (String e : set) {
            if (buf.length() > 0) {
                buf.append(',');
            }
            buf.append(e);
        }
        element.appendChild(data.getOwnerDocument().createTextNode(buf.toString()));
    }

    private boolean addNewExtensionDialog(Set<String> usedExtension, String type) {
        if (UNIT_TEST_MODE) {
            return true;
        }
        String message = MakeProject.getString("ADD_EXTENSION_QUESTION" + type + (usedExtension.size() == 1 ? "" : "S"));
        StringBuilder extensions = new StringBuilder();
        for (String ext : usedExtension) {
            if (extensions.length() > 0) {
                extensions.append(',');
            }
            extensions.append(ext);
        }
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)MessageFormat.format(message, extensions.toString()), MakeProject.getString("ADD_EXTENSION_DIALOG_TITLE" + type + (usedExtension.size() == 1 ? "" : "S")), 0);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION;
    }

    public static Set<String> createExtensionSet() {
        if (CndFileUtils.isSystemCaseSensitive()) {
            return new TreeSet<String>();
        }
        return new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    }

    private static Set<String> getSourceSuffixes() {
        Set<String> suffixes = MakeProject.createExtensionSet();
        suffixes.addAll(MIMEExtensions.get((String)"text/x-c++").getValues());
        suffixes.addAll(MIMEExtensions.get((String)"text/x-c").getValues());
        return suffixes;
    }

    private static Set<String> getCSuffixes() {
        Set<String> suffixes = MakeProject.createExtensionSet();
        suffixes.addAll(MIMEExtensions.get((String)"text/x-c").getValues());
        return suffixes;
    }

    private static Set<String> getCppSuffixes() {
        Set<String> suffixes = MakeProject.createExtensionSet();
        suffixes.addAll(MIMEExtensions.get((String)"text/x-c++").getValues());
        return suffixes;
    }

    private static Set<String> getHeaderSuffixes() {
        Set<String> suffixes = MakeProject.createExtensionSet();
        suffixes.addAll(MIMEExtensions.get((String)"text/x-h").getValues());
        return suffixes;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(MakeProject.class, (String)s);
    }

    public String getSourceEncodingFromProjectXml() {
        int i;
        Element data = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = data.getElementsByTagName("sourceEncoding");
        if (nodeList != null && nodeList.getLength() > 0 && (i = 0) < nodeList.getLength()) {
            Node node = nodeList.item(i);
            return node.getTextContent();
        }
        return null;
    }

    public String getSourceEncoding() {
        if (this.sourceEncoding == null && !this.projectDescriptorProvider.gotDescriptor()) {
            return FileEncodingQuery.getDefaultEncoding().name();
        }
        if (this.sourceEncoding == null) {
            this.sourceEncoding = FileEncodingQuery.getDefaultEncoding().name();
        }
        return this.sourceEncoding;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    private int getActiveConfigurationType() {
        int type = -1;
        MakeConfiguration makeConfiguration = this.getActiveConfiguration();
        if (makeConfiguration != null) {
            return makeConfiguration.getConfigurationType().getValue();
        }
        type = this.getActiveConfigurationTypeFromPrivateXML();
        if (type >= 0) {
            return type;
        }
        type = this.getActiveConfigurationTypeFromProjectXML();
        if (type >= 0) {
            return type;
        }
        return type;
    }

    private int getActiveConfigurationTypeFromProjectXML() {
        Node typeNode;
        Element data = this.helper.getPrimaryConfigurationData(true);
        data = this.helper.getPrimaryConfigurationData(true);
        NodeList nodeList = data.getElementsByTagName("type");
        if (nodeList != null && nodeList.getLength() > 0 && (typeNode = nodeList.item(0).getFirstChild()) != null) {
            String type = typeNode.getNodeValue();
            try {
                return new Integer(type);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return -1;
    }

    private int getActiveConfigurationTypeFromPrivateXML() {
        int i;
        Element data = this.helper.getPrimaryConfigurationData(false);
        NodeList nodeList = data.getElementsByTagName("activeConfTypeElem");
        if (nodeList != null && nodeList.getLength() > 0 && (i = 0) < nodeList.getLength()) {
            Node node = nodeList.item(i);
            return new Integer(node.getTextContent());
        }
        return -1;
    }

    public int getActiveConfigurationIndexFromPrivateXML() {
        int i;
        Element data = this.helper.getPrimaryConfigurationData(false);
        NodeList nodeList = data.getElementsByTagName("activeConfIndexElem");
        if (nodeList != null && nodeList.getLength() > 0 && (i = 0) < nodeList.getLength()) {
            Node node = nodeList.item(i);
            return new Integer(node.getTextContent());
        }
        return -1;
    }

    public MakeConfiguration getActiveConfiguration() {
        MakeConfigurationDescriptor projectDescriptor;
        if (this.projectDescriptorProvider.gotDescriptor() && (projectDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor()) != null) {
            return projectDescriptor.getActiveConfiguration();
        }
        return null;
    }

    public void addOpenedTask(Runnable task) {
        if (this.openedTasks == null) {
            this.openedTasks = new ArrayList<Runnable>();
        }
        this.openedTasks.add(task);
    }

    @Override
    public void run() {
        this.onProjectOpened();
    }

    private synchronized void onProjectOpened() {
        if (!this.isOpenHookDone) {
            this.helper.addAntProjectListener((AntProjectListener)this);
            this.checkNeededExtensions();
            if (this.openedTasks != null) {
                for (Runnable runnable : this.openedTasks) {
                    runnable.run();
                }
                this.openedTasks.clear();
                this.openedTasks = null;
            }
            this.isOpenHookDone = true;
            if (MakeOptions.getInstance().isFullFileIndexer()) {
                this.registerClassPath(true);
            }
            MakeOptions.getInstance().addPropertyChangeListener(this.indexerListener);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor(true);
                    NativeProjectRegistry.getDefault().register((NativeProject)MakeProject.this.nativeProjectProvider);
                }
            });
        }
    }

    void setDeleted() {
        LOGGER.log(Level.FINE, "set deleted MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), this.helper.getProjectDirectory().getNameExt()});
        this.isDeleted.set(true);
    }

    void setDeleting(boolean value) {
        LOGGER.log(Level.FINE, "set deleting MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), this.helper.getProjectDirectory().getNameExt()});
        this.isDeleting.set(value);
    }

    private synchronized void onProjectClosed() {
        LOGGER.log(Level.FINE, "on project close MakeProject@{0} {1}", new Object[]{System.identityHashCode(this), this.helper.getProjectDirectory().getNameExt()});
        this.helper.removeAntProjectListener((AntProjectListener)this);
        this.save();
        if (this.projectDescriptorProvider.getConfigurationDescriptor() != null) {
            this.projectDescriptorProvider.getConfigurationDescriptor().closed();
        }
        MakeOptions.getInstance().removePropertyChangeListener(this.indexerListener);
        if (this.isOpenHookDone) {
            this.registerClassPath(false);
            this.isOpenHookDone = false;
        }
        MakeProjectFileProviderFactory.removeSearchBase(this);
        NativeProjectRegistry.getDefault().unregister((NativeProject)this.nativeProjectProvider);
    }

    public synchronized void save() {
        if (!this.isDeleted.get() && !this.isDeleting.get() && this.projectDescriptorProvider.getConfigurationDescriptor() != null) {
            this.projectDescriptorProvider.getConfigurationDescriptor().save();
        }
    }

    public DevelopmentHostConfiguration getDevelopmentHostConfiguration() {
        MakeConfiguration conf = this.getActiveConfiguration();
        if (conf != null) {
            return conf.getDevelopmentHost();
        }
        return null;
    }

    public ExecutionEnvironment getDevelopmentHostExecutionEnvironment() {
        DevelopmentHostConfiguration dc = this.getDevelopmentHostConfiguration();
        return dc == null ? null : dc.getExecutionEnvironment();
    }

    private final class IndexerOptionsListener
    implements PropertyChangeListener {
        private IndexerOptionsListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("fullFileIndexer".equals(evt.getPropertyName())) {
                MakeProject.this.registerClassPath(Boolean.TRUE.equals(evt.getNewValue()));
            }
        }
    }

    private static final class CPPImpl
    implements ClassPathProvider {
        private final MakeSources sources;

        public CPPImpl(MakeSources sources) {
            this.sources = sources;
        }

        public ClassPath findClassPath(FileObject file, String type) {
            if ("org.netbeans.modules.cnd.makeproject/SOURCES".equals(type)) {
                for (SourceGroup sg : this.sources.getSourceGroups("generic")) {
                    if (!sg.getRootFolder().equals(file)) continue;
                    try {
                        return ClassPathSupport.createClassPath(Arrays.asList(new PathResourceImpl(ClassPathSupport.createResource((URL)file.getURL()))));
                    }
                    catch (FileStateInvalidException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            return null;
        }
    }

    private static final class PathResourceImpl
    implements FilteringPathResourceImplementation,
    PropertyChangeListener {
        private final PathResourceImplementation delegate;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public PathResourceImpl(PathResourceImplementation delegate) {
            this.delegate = delegate;
            this.delegate.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public boolean includes(URL root, String resource) {
            return !CndFileVisibilityQuery.getDefault().isIgnored(resource);
        }

        public URL[] getRoots() {
            return this.delegate.getRoots();
        }

        public ClassPathImplementation getContent() {
            return this.delegate.getContent();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.pcs.firePropertyChange(new PropertyChangeEvent(this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
        }
    }

    private static final class MutableCP
    implements ClassPathImplementation,
    ChangeListener {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final MakeSources sources;
        private List<PathResourceImplementation> resources = null;
        private long eventId = 0L;
        private ClassPath[] classpath = null;

        public MutableCP(MakeSources sources) {
            this.sources = sources;
            this.sources.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.sources));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<? extends PathResourceImplementation> getResources() {
            SourceGroup[] groups;
            long currentEventId;
            MutableCP mutableCP = this;
            synchronized (mutableCP) {
                if (this.resources != null) {
                    return this.resources;
                }
                currentEventId = this.eventId;
            }
            LinkedList<PathResourceImplementation> list = new LinkedList<PathResourceImplementation>();
            for (SourceGroup g : groups = this.sources.getSourceGroups("generic")) {
                try {
                    FileObject rootFolder = g.getRootFolder();
                    URL url = rootFolder.getURL();
                    if (rootFolder.isFolder() && !url.toExternalForm().endsWith("/")) {
                        try {
                            URL url2 = new URL(url.toExternalForm() + '/');
                            FileObject fo = URLMapper.findFileObject((URL)url2);
                            if (fo != null && fo.equals(rootFolder)) {
                                url = url2;
                            }
                        }
                        catch (MalformedURLException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    list.add((PathResourceImplementation)new PathResourceImpl(ClassPathSupport.createResource((URL)url)));
                }
                catch (FileStateInvalidException ex) {
                    Logger.getLogger(MakeProject.class.getName()).log(Level.WARNING, null, ex);
                }
            }
            MutableCP mutableCP2 = this;
            synchronized (mutableCP2) {
                if (currentEventId == this.eventId) {
                    this.resources = list;
                }
            }
            return list;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            MutableCP mutableCP = this;
            synchronized (mutableCP) {
                this.resources = null;
                ++this.eventId;
            }
            this.pcs.firePropertyChange("resources", null, null);
        }

        public synchronized ClassPath[] getClassPath() {
            if (this.classpath == null) {
                this.classpath = new ClassPath[]{ClassPathFactory.createClassPath((ClassPathImplementation)this)};
            }
            return this.classpath;
        }
    }

    private class ToolchainProjectImpl
    implements ToolchainProject {
        private ToolchainProjectImpl() {
        }

        public CompilerSet getCompilerSet() {
            MakeConfiguration conf = MakeProject.this.getActiveConfiguration();
            if (conf != null) {
                return conf.getCompilerSet().getCompilerSet();
            }
            return null;
        }
    }

    private class RemoteProjectImpl
    implements RemoteProject {
        private RemoteProjectImpl() {
        }

        public ExecutionEnvironment getDevelopmentHost() {
            DevelopmentHostConfiguration devHost = MakeProject.this.getDevelopmentHostConfiguration();
            return devHost == null ? null : devHost.getExecutionEnvironment();
        }

        public ExecutionEnvironment getSourceFileSystemHost() {
            if (MakeProject.this.remoteMode == RemoteProject.Mode.REMOTE_SOURCES) {
                return MakeProject.this.remoteFileSystemHost;
            }
            return ExecutionEnvironmentFactory.getLocal();
        }

        public RemoteProject.Mode getRemoteMode() {
            return MakeProject.this.remoteMode;
        }

        public RemoteSyncFactory getSyncFactory() {
            switch (MakeProject.this.remoteMode) {
                case LOCAL_SOURCES: {
                    MakeConfiguration activeConfiguration = MakeProject.this.getActiveConfiguration();
                    if (activeConfiguration != null) {
                        return activeConfiguration.getRemoteSyncFactory();
                    }
                    return null;
                }
                case REMOTE_SOURCES: {
                    return RemoteSyncFactory.fromID((String)"full");
                }
            }
            CndUtils.assertTrue((boolean)false, (String)("Unexpected remote mode " + MakeProject.this.remoteMode));
            MakeConfiguration activeConfiguration = MakeProject.this.getActiveConfiguration();
            if (activeConfiguration != null) {
                return MakeProject.this.getActiveConfiguration().getRemoteSyncFactory();
            }
            return null;
        }

        public String getSourceBaseDir() {
            return MakeProject.this.remoteBaseDir == null ? MakeProject.this.helper.getProjectDirectory().getPath() : MakeProject.this.remoteBaseDir;
        }

        public FileObject getSourceBaseDirFileObject() {
            if (MakeProject.this.remoteMode == RemoteProject.Mode.REMOTE_SOURCES) {
                CndUtils.assertNotNull((Object)MakeProject.this.remoteBaseDir, (String)"Null remote base directory");
                if (MakeProject.this.remoteBaseDir != null) {
                    return FileSystemProvider.getFileObject((ExecutionEnvironment)MakeProject.this.remoteFileSystemHost, (String)MakeProject.this.remoteBaseDir);
                }
            }
            return MakeProject.this.getProjectDirectory();
        }

        public String resolveRelativeRemotePath(String path) {
            if (!CndPathUtilitities.isPathAbsolute((CharSequence)path) && MakeProject.this.remoteMode == RemoteProject.Mode.REMOTE_SOURCES && MakeProject.this.remoteBaseDir != null && !MakeProject.this.remoteBaseDir.isEmpty()) {
                String resolved = MakeProject.this.remoteBaseDir;
                if (!resolved.endsWith("/")) {
                    resolved = resolved + "/";
                }
                resolved = resolved + path;
                return CndFileUtils.normalizeAbsolutePath((FileSystem)MakeProject.this.getSourceFileSystem(), (String)resolved);
            }
            return path;
        }
    }

    private static class FolderSearchInfo
    implements SearchInfo {
        private ConfigurationDescriptorProvider projectDescriptorProvider;

        FolderSearchInfo(ConfigurationDescriptorProvider projectDescriptorProvider) {
            this.projectDescriptorProvider = projectDescriptorProvider;
        }

        public boolean canSearch() {
            return true;
        }

        public Iterator<DataObject> objectsToSearch() {
            MakeConfigurationDescriptor projectDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor();
            Folder rootFolder = projectDescriptor.getLogicalFolders();
            Set<DataObject> res = rootFolder.getAllItemsAsDataObjectSet(false, "text/");
            FileObject baseDirFileObject = this.projectDescriptorProvider.getConfigurationDescriptor().getBaseDirFileObject();
            this.addFolder(res, baseDirFileObject.getFileObject("nbproject"));
            this.addFolder(res, baseDirFileObject.getFileObject("nbproject/private"));
            return res.iterator();
        }

        private void addFolder(Set<DataObject> res, FileObject fo) {
            if (fo != null && fo.isFolder() && fo.isValid()) {
                for (FileObject f : fo.getChildren()) {
                    try {
                        DataObject dataObject = DataObject.find((FileObject)f);
                        if (dataObject == null) continue;
                        res.add(dataObject);
                    }
                    catch (DataObjectNotFoundException ex) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private final class MakeArtifactProviderImpl
    implements MakeArtifactProvider {
        private MakeArtifactProviderImpl() {
        }

        @Override
        public MakeArtifact[] getBuildArtifacts() {
            ArrayList<MakeArtifact> artifacts = new ArrayList<MakeArtifact>();
            MakeConfigurationDescriptor projectDescriptor = MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor();
            if (projectDescriptor != null) {
                Configuration[] confs = projectDescriptor.getConfs().toArray();
                for (int i = 0; i < confs.length; ++i) {
                    MakeConfiguration makeConfiguration = (MakeConfiguration)confs[i];
                    artifacts.add(new MakeArtifact(projectDescriptor, makeConfiguration));
                }
            }
            return artifacts.toArray(new MakeArtifact[artifacts.size()]);
        }
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            MakeProject.this.onProjectOpened();
        }

        protected void projectClosed() {
            MakeProject.this.onProjectClosed();
        }
    }

    private static final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        private ProjectXmlSavedHookImpl() {
        }

        protected void projectXmlSaved() throws IOException {
        }
    }

    private final class Info
    implements InfoInterface {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private String name;

        Info() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("activeConfiguration".equals(evt.getPropertyName())) {
                this.firePropertyChange("icon");
            }
        }

        @Override
        public void firePropertyChange(String prop) {
            if ("name".equals(prop)) {
                this.name = null;
            }
            this.pcs.firePropertyChange(prop, null, null);
        }

        public String getName() {
            return PropertyUtils.getUsablePropertyName((String)this._getName());
        }

        private String _getName() {
            if (this.name == null) {
                this.name = this.getNameImpl();
            }
            return this.name;
        }

        private String getNameImpl() {
            return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    NodeList nl;
                    Element data = MakeProject.this.helper.getPrimaryConfigurationData(true);
                    Element nameEl = Info.this.getNameElement(data);
                    if (nameEl != null && (nl = nameEl.getChildNodes()).getLength() == 1 && nl.item(0).getNodeType() == 3) {
                        return ((Text)nl.item(0)).getNodeValue();
                    }
                    FileObject fo = MakeProject.this.getProjectDirectory();
                    if (fo != null && fo.isValid()) {
                        return fo.getNameExt();
                    }
                    return "???";
                }
            });
        }

        @Override
        public void setName(final String name) {
            ProjectManager.mutex().writeAccess((Mutex.Action)new Mutex.Action<Void>(){

                public Void run() {
                    Element data = MakeProject.this.helper.getPrimaryConfigurationData(true);
                    Element nameEl = Info.this.getNameElement(data);
                    if (nameEl != null) {
                        NodeList deadKids = nameEl.getChildNodes();
                        while (deadKids.getLength() > 0) {
                            nameEl.removeChild(deadKids.item(0));
                        }
                    } else {
                        nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/make-project/1", "name");
                        data.insertBefore(nameEl, data.getChildNodes().item(0));
                    }
                    nameEl.appendChild(data.getOwnerDocument().createTextNode(name));
                    MakeProject.this.helper.putPrimaryConfigurationData(data, true);
                    return null;
                }
            });
            this._getName();
        }

        private Element getNameElement(Element data) {
            NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/make-project/1", "name");
            if (nl.getLength() > 0) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element e;
                    Node parentNode;
                    if (!(nl.item(i) instanceof Element) || (parentNode = (e = (Element)nl.item(i)).getParentNode()) == null || !parentNode.getLocalName().equals("data")) continue;
                    return e;
                }
            }
            return null;
        }

        public String getDisplayName() {
            FileObject fo;
            String aName = this._getName();
            if (PROJECT_NAME_WITH_HIDDEN_PATHS != null && (fo = MakeProject.this.getProjectDirectory()) != null && fo.isValid()) {
                String[] split;
                String prjDirDispName = FileUtil.getFileDisplayName((FileObject)fo);
                for (String skipPath : split = PROJECT_NAME_WITH_HIDDEN_PATHS.split(":")) {
                    if (!prjDirDispName.startsWith(skipPath)) continue;
                    prjDirDispName = prjDirDispName.substring(skipPath.length());
                    break;
                }
                if (prjDirDispName.startsWith("/") || prjDirDispName.startsWith("\\")) {
                    prjDirDispName = prjDirDispName.substring(1);
                }
                int sep = 0;
                for (int i = 0; i < PROJECT_NAME_NUM_SHOWN_FOLDERS; ++i) {
                    int nextSep = prjDirDispName.indexOf(92, sep);
                    int n = nextSep = nextSep == -1 ? prjDirDispName.indexOf(47, sep) : nextSep;
                    if (nextSep <= 0) {
                        sep = prjDirDispName.length();
                        break;
                    }
                    sep = nextSep + 1;
                }
                if (sep > 0) {
                    prjDirDispName = prjDirDispName.substring(0, sep);
                }
                if (prjDirDispName.length() > 0) {
                    if (prjDirDispName.endsWith("/") || prjDirDispName.endsWith("\\")) {
                        prjDirDispName = prjDirDispName.substring(0, prjDirDispName.length() - 1);
                    }
                    aName = NbBundle.getMessage(this.getClass(), (String)"PRJ_DISPLAY_NAME_WITH_FOLDER", (Object)aName, (Object)prjDirDispName);
                }
            }
            return aName;
        }

        private int getProjectType() {
            int aProjectType = MakeProject.this.getActiveConfigurationType();
            if (aProjectType != -1) {
                return aProjectType;
            }
            return -1;
        }

        public Icon getIcon() {
            int type = this.getProjectType();
            Icon icon = MakeConfigurationDescriptor.MAKEFILE_ICON;
            switch (type) {
                case 0: {
                    MakeConfiguration activeConfiguration = MakeProject.this.getActiveConfiguration();
                    if (activeConfiguration == null) break;
                    String outputValue = activeConfiguration.getOutputValue();
                    if (outputValue != null) {
                        if (outputValue.endsWith(".so") || outputValue.endsWith(".dll") || outputValue.endsWith(".dylib")) {
                            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-unmanaged-dynamic.png", (boolean)false);
                            break;
                        }
                        if (outputValue.endsWith(".a")) {
                            icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-unmanaged-static.png", (boolean)false);
                            break;
                        }
                        icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-unmanaged.png", (boolean)false);
                        break;
                    }
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-unmanaged.png", (boolean)false);
                    break;
                }
                case 1: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-managed.png", (boolean)false);
                    break;
                }
                case 7: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-database.png", (boolean)false);
                    break;
                }
                case 2: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-managed-dynamic.png", (boolean)false);
                    break;
                }
                case 3: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-managed-static.png", (boolean)false);
                    break;
                }
                case 4: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-Qt.png", (boolean)false);
                    break;
                }
                case 5: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-Qt-dynamic.png", (boolean)false);
                    break;
                }
                case 6: {
                    icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/projects-Qt-static.png", (boolean)false);
                }
            }
            return icon;
        }

        public Project getProject() {
            return MakeProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcs.removePropertyChangeListener(listener);
        }
    }

    static interface InfoInterface
    extends ProjectInformation,
    PropertyChangeListener {
        public void firePropertyChange(String var1);

        public void setName(String var1);
    }

    private class MakeSubprojectProvider
    implements SubprojectProvider {
        private MakeSubprojectProvider() {
        }

        public void addChangeListener(ChangeListener listener) {
        }

        public Set<Project> getSubprojects() {
            HashSet<Project> subProjects = new HashSet<Project>();
            Set<Object> subProjectLocations = new HashSet();
            Element data = MakeProject.this.helper.getPrimaryConfigurationData(true);
            if (!MakeProject.this.projectDescriptorProvider.gotDescriptor() && data.getElementsByTagName("make-dep-projects").getLength() > 0) {
                NodeList nl4 = data.getElementsByTagName("make-dep-project");
                if (nl4.getLength() > 0) {
                    for (int i = 0; i < nl4.getLength(); ++i) {
                        Node node = nl4.item(i);
                        NodeList nl2 = node.getChildNodes();
                        for (int j = 0; j < nl2.getLength(); ++j) {
                            String typeTxt = nl2.item(j).getNodeValue();
                            subProjectLocations.add(typeTxt);
                        }
                    }
                }
            } else {
                MakeConfigurationDescriptor projectDescriptor = MakeProject.this.projectDescriptorProvider.getConfigurationDescriptor();
                if (projectDescriptor == null) {
                    return subProjects;
                }
                subProjectLocations = projectDescriptor.getSubprojectLocations();
            }
            String baseDir = FileUtil.toFile((FileObject)MakeProject.this.getProjectDirectory()).getPath();
            for (String string : subProjectLocations) {
                String location = CndPathUtilitities.toAbsolutePath((String)baseDir, (String)string);
                try {
                    FileObject fo = CndFileUtils.toFileObject((CharSequence)CndFileUtils.getCanonicalPath((CharSequence)location));
                    Project project = ProjectManager.getDefault().findProject(fo);
                    if (project == null) continue;
                    subProjects.add(project);
                }
                catch (Exception e) {
                    System.err.println("Cannot find subproject in '" + location + "' " + e);
                }
            }
            return subProjects;
        }

        public void removeChangeListener(ChangeListener listener) {
        }
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] RECOMMENDED_TYPES = new String[]{"c-types", "cpp-types", "shell-types", "makefile-types", "simple-files", "fortran-types", "asm-types", "qt-types", "cncpp-test-types"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/cFiles/main.c", "Templates/cFiles/file.c", "Templates/cFiles/file.h", "Templates/cppFiles/class.cc", "Templates/cppFiles/main.cc", "Templates/cppFiles/file.cc", "Templates/cppFiles/file.h", "Templates/fortranFiles/fortranFreeFormatFile.f90", "Templates/MakeTemplates/ComplexMakefile", "Templates/MakeTemplates/SimpleMakefile/ExecutableMakefile", "Templates/MakeTemplates/SimpleMakefile/SharedLibMakefile", "Templates/MakeTemplates/SimpleMakefile/StaticLibMakefile"};
        private static final String[] PRIVILEGED_NAMES_QT = new String[]{"Templates/qtFiles/main.cc", "Templates/qtFiles/form.ui", "Templates/qtFiles/resource.qrc", "Templates/qtFiles/translation.ts", "Templates/cFiles/main.c", "Templates/cFiles/file.c", "Templates/cFiles/file.h", "Templates/cppFiles/class.cc", "Templates/cppFiles/main.cc", "Templates/cppFiles/file.cc", "Templates/cppFiles/file.h", "Templates/fortranFiles/fortranFreeFormatFile.f90", "Templates/MakeTemplates/ComplexMakefile", "Templates/MakeTemplates/SimpleMakefile/ExecutableMakefile", "Templates/MakeTemplates/SimpleMakefile/SharedLibMakefile", "Templates/MakeTemplates/SimpleMakefile/StaticLibMakefile"};
        private final ConfigurationDescriptorProvider configurationProvider;

        public RecommendedTemplatesImpl(ConfigurationDescriptorProvider configurationProvider) {
            this.configurationProvider = configurationProvider;
        }

        public String[] getRecommendedTypes() {
            return RECOMMENDED_TYPES;
        }

        public String[] getPrivilegedTemplates() {
            MakeConfiguration conf;
            MakeConfigurationDescriptor configurationDescriptor = this.configurationProvider.getConfigurationDescriptor(false);
            if (configurationDescriptor != null && (conf = configurationDescriptor.getActiveConfiguration()) != null && conf.isQmakeConfiguration()) {
                return PRIVILEGED_NAMES_QT;
            }
            return PRIVILEGED_NAMES;
        }
    }
}

