/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.netbeans.upgrade.AutoUpgradePanel;
import org.netbeans.upgrade.Copy;
import org.netbeans.upgrade.CopyFiles;
import org.netbeans.upgrade.IncludeExclude;
import org.netbeans.upgrade.PathTransformation;
import org.netbeans.upgrade.systemoptions.Importer;
import org.netbeans.util.Util;
import org.openide.ErrorManager;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.MultiFileSystem;
import org.openide.filesystems.XMLFileSystem;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.xml.sax.SAXException;

public final class AutoUpgrade {
    private static final Logger LOGGER = Logger.getLogger(AutoUpgrade.class.getName());
    private static final List<String> VERSION_TO_CHECK = Arrays.asList(".netbeans/6.9", ".netbeans/6.8", ".netbeans/6.7", ".netbeans/6.5", ".netbeans/6.1", ".netbeans/6.0", ".netbeans/5.5.1", ".netbeans/5.5");

    public static void main(String[] args) throws Exception {
        String[] version = new String[1];
        File sourceFolder = AutoUpgrade.checkPrevious(version, VERSION_TO_CHECK);
        if (sourceFolder != null) {
            if (!AutoUpgrade.showUpgradeDialog(sourceFolder)) {
                throw new UserCancelException();
            }
            if (version[0].compareTo("6.5") < 0) {
                AutoUpgrade.doUpgrade(sourceFolder, version[0]);
                AutoUpgrade.doNonStandardUpgrade(sourceFolder, version[0]);
                AutoUpgrade.upgradeBuildProperties(sourceFolder, version);
                Importer.doImport();
            } else {
                AutoUpgrade.copyToUserdir(sourceFolder);
                Importer.doImport();
            }
        }
    }

    private static void upgradeBuildProperties(File sourceFolder, String[] version) throws IOException {
        File userdir = new File(System.getProperty("netbeans.user", ""));
        String[] regexForSelection = new String[]{"^nbplatform[.](?!default[.]netbeans[.]dest[.]dir).+[.].+=.+$", "^var[.].*"};
        Copy.appendSelectedLines(new File(sourceFolder, "build.properties"), userdir, regexForSelection);
    }

    private static File checkPrevious(String[] version, List<String> versionsToCheck) {
        String userHome = System.getProperty("user.home");
        File sourceFolder = null;
        if (userHome != null) {
            File userHomeFile = new File(userHome);
            Iterator<String> it = versionsToCheck.iterator();
            while (it.hasNext() && sourceFolder == null) {
                String ver = it.next();
                sourceFolder = new File(userHomeFile.getAbsolutePath(), ver);
                if (sourceFolder.isDirectory()) {
                    version[0] = sourceFolder.getName();
                    break;
                }
                sourceFolder = null;
            }
            return sourceFolder;
        }
        return null;
    }

    private static boolean showUpgradeDialog(File source) {
        Util.setDefaultLookAndFeel();
        JOptionPane p = new JOptionPane(new AutoUpgradePanel(source.getAbsolutePath()), 3, 0);
        JDialog d = Util.createJOptionDialog(p, NbBundle.getMessage(AutoUpgrade.class, (String)"MSG_Confirmation_Title"));
        d.setVisible(true);
        return new Integer(0).equals(p.getValue());
    }

    static void doUpgrade(File source, String oldVersion) throws IOException, PropertyVetoException {
        IncludeExclude includeExclude;
        File userdir = new File(System.getProperty("netbeans.user", ""));
        try {
            InputStreamReader r = new InputStreamReader(AutoUpgrade.class.getResourceAsStream("copy" + oldVersion), "utf-8");
            includeExclude = IncludeExclude.create(r);
            ((Reader)r).close();
        }
        catch (IOException ex) {
            throw new IOException("Cannot import from version: " + oldVersion, ex);
        }
        ErrorManager.getDefault().log(256, "Import: Old version: " + oldVersion + ". Importing from " + source + " to " + userdir);
        File oldConfig = new File(source, "config");
        LocalFileSystem lfs = new LocalFileSystem();
        lfs.setRootDirectory(oldConfig);
        XMLFileSystem xmlfs = null;
        try {
            URL url = AutoUpgrade.class.getResource("layer" + oldVersion + ".xml");
            xmlfs = url != null ? new XMLFileSystem(url) : null;
        }
        catch (SAXException ex) {
            throw new IOException("Cannot import from version: " + oldVersion, ex);
        }
        LocalFileSystem old = xmlfs != null ? AutoUpgrade.createLayeredSystem(lfs, xmlfs) : lfs;
        Copy.copyDeep(old.getRoot(), FileUtil.getConfigRoot(), includeExclude, PathTransformation.getInstance(oldVersion));
    }

    private static void doNonStandardUpgrade(File source, String oldVersion) throws IOException, PropertyVetoException {
        IncludeExclude includeExclude;
        File userdir = new File(System.getProperty("netbeans.user", ""));
        try {
            InputStream is = AutoUpgrade.class.getResourceAsStream("nonstandard" + oldVersion);
            if (is == null) {
                return;
            }
            InputStreamReader r = new InputStreamReader(is, "utf-8");
            includeExclude = IncludeExclude.create(r);
            ((Reader)r).close();
        }
        catch (IOException ex) {
            throw new IOException("Cannot import from version: " + oldVersion + "nonstandard", ex);
        }
        ErrorManager.getDefault().log(256, "Import: Old version: " + oldVersion + "nonstandard" + ". Importing from " + source + " to " + userdir);
        LocalFileSystem old = new LocalFileSystem();
        old.setRootDirectory(source);
        LocalFileSystem nfs = new LocalFileSystem();
        nfs.setRootDirectory(userdir);
        Copy.copyDeep(old.getRoot(), nfs.getRoot(), includeExclude, PathTransformation.getInstance(oldVersion));
    }

    static MultiFileSystem createLayeredSystem(LocalFileSystem lfs, XMLFileSystem xmlfs) {
        MultiFileSystem old = new MultiFileSystem(new FileSystem[]{lfs, xmlfs}){
            {
                this.setPropagateMasks(true);
            }
        };
        return old;
    }

    private static void copyToUserdir(File source) throws IOException, PropertyVetoException {
        File userdir = new File(System.getProperty("netbeans.user", ""));
        File netBeansDir = InstalledFileLocator.getDefault().locate("modules", null, false).getParentFile().getParentFile();
        File importFile = new File(netBeansDir, "etc/netbeans.import");
        LOGGER.fine("Import file: " + importFile);
        LOGGER.info("Importing from " + source + " to " + userdir);
        CopyFiles.copyDeep(source, userdir, importFile);
    }
}

