/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteLinkBase;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public class RemoteFileSystemUtils {
    private static final int MAXSYMLINKS;
    private static final boolean TRUE_CASE_SENSITIVE_SYSTEM;
    private static boolean isWindows;
    private static final char[][] windowsReservedChars;
    private static final char windowsReservedNameChar = 'R';

    public static boolean isSystemCaseSensitive() {
        return TRUE_CASE_SENSITIVE_SYSTEM;
    }

    private RemoteFileSystemUtils() {
    }

    public static ExecutionEnvironment getExecutionEnvironment(String hostName, int port) {
        ExecutionEnvironment result = null;
        for (ExecutionEnvironment env : ConnectionManager.getInstance().getRecentConnections()) {
            if (!hostName.equals(env.getHost()) || port != 0 && port != env.getSSHPort()) continue;
            result = env;
            if (!ConnectionManager.getInstance().isConnectedTo(env)) continue;
            break;
        }
        return result;
    }

    public static String escapeFileName(String name) {
        char c;
        if (name.startsWith(".rfs_")) {
            name = "._rfs_" + name.substring(".rfs_".length());
        }
        if (!isWindows) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        if ((name.startsWith("CON") || name.startsWith("PRN") || name.startsWith("AUX") || name.startsWith("NUL")) && (name.length() == 3 || name.charAt(3) == '.')) {
            sb.append('_').append('R').append(name);
            return sb.toString();
        }
        if ((name.startsWith("COM") || name.startsWith("LPT")) && name.length() > 3 && '1' <= (c = name.charAt(3)) && c <= '9' && (name.length() == 4 || name.charAt(4) == '.')) {
            sb.append('_').append('R').append(name);
            return sb.toString();
        }
        if (!RemoteFileSystemUtils.containsReservedCharacters(name) && name.indexOf(95) < 0) {
            return name;
        }
        for (int i = 0; i < name.length(); ++i) {
            char c2 = name.charAt(i);
            if (c2 == '_') {
                sb.append("__");
                continue;
            }
            boolean added = false;
            for (int j = 0; j < windowsReservedChars.length; ++j) {
                if (c2 != windowsReservedChars[j][0]) continue;
                sb.append('_').append(windowsReservedChars[j][1]);
                added = true;
            }
            if (added) continue;
            sb.append(c2);
        }
        return sb.toString();
    }

    private char unescapeChar(char c) {
        for (int j = 0; j < windowsReservedChars.length; ++j) {
            if (c != windowsReservedChars[j][1]) continue;
            return windowsReservedChars[j][0];
        }
        return '\u0000';
    }

    public static String unescapeFileName(String name) {
        if (!isWindows) {
            return name;
        }
        if (name.length() < 2 || name.indexOf(95) < 0) {
            return name;
        }
        if (name.charAt(0) == '_' && name.charAt(1) == 'R') {
            return name.substring(2);
        }
        StringBuilder sb = new StringBuilder();
        boolean escape = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (escape) {
                escape = false;
                if (c == '_') {
                    sb.append('_');
                    continue;
                }
                boolean added = false;
                for (int j = 0; j < windowsReservedChars.length; ++j) {
                    if (c != windowsReservedChars[j][1]) continue;
                    sb.append(windowsReservedChars[j][0]);
                    added = true;
                    break;
                }
                if (added) continue;
                RemoteLogger.getInstance().log(Level.SEVERE, "Incorrect name to unescape: ''{0}''", name);
                continue;
            }
            if (c == '_') {
                escape = true;
                if (i + 1 != name.length()) continue;
                RemoteLogger.getInstance().log(Level.SEVERE, "Incorrect name to unescape: ''{0}''", name);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean containsReservedCharacters(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            for (int j = 0; j < windowsReservedChars.length; ++j) {
                if (c != windowsReservedChars[j][0]) continue;
                return true;
            }
        }
        return false;
    }

    static void testSetWindows(boolean isWin) {
        isWindows = isWin;
    }

    public static String normalize(String absPath) {
        return absPath;
    }

    public static FileObject getCanonicalFileObject(FileObject fileObject) throws IOException {
        int level = 0;
        while (fileObject instanceof RemoteLinkBase) {
            if (++level > MAXSYMLINKS) {
                throw new IOException("Number of symbolic links encountered during path name traversal exceeds MAXSYMLINKS");
            }
            RemoteFileObjectBase delegate = ((RemoteLinkBase)fileObject).getDelegate();
            if (delegate == null) {
                throw new FileNotFoundException("Null delegate for remote link " + fileObject);
            }
            fileObject = delegate;
        }
        return fileObject;
    }

    public static RemoteDirectory getCanonicalParent(RemoteFileObjectBase fo) throws IOException {
        RemoteFileObjectBase parent = fo.getParent();
        if (parent == null) {
            return null;
        }
        if (parent instanceof RemoteDirectory) {
            return (RemoteDirectory)parent;
        }
        RemoteLogger.assertTrueInConsole(parent instanceof RemoteLinkBase, "Unexpected parent class, should be RemoteLinkBase: " + parent.getClass().getName());
        FileObject canonical = RemoteFileSystemUtils.getCanonicalFileObject(parent);
        if (canonical instanceof RemoteDirectory) {
            return (RemoteDirectory)canonical;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void delete(ExecutionEnvironment execEnv, String path, boolean directory) throws IOException {
        StringWriter writer = new StringWriter();
        Future task = directory ? CommonTasksSupport.rmDir((ExecutionEnvironment)execEnv, (String)path, (boolean)true, (Writer)writer) : CommonTasksSupport.rmFile((ExecutionEnvironment)execEnv, (String)path, (Writer)writer);
        try {
            if ((Integer)task.get() == 0) return;
        }
        catch (InterruptedException ex) {
            throw new InterruptedIOException();
        }
        catch (ExecutionException ex) {
            String errorText = writer.getBuffer().toString();
            throw new IOException("Error removing " + path + ": " + errorText, ex);
        }
    }

    public static boolean isPathAbsolute(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        if (path.charAt(0) == '\\') {
            return true;
        }
        return path.indexOf(58) == 1 && isWindows;
    }

    public static InputStream createDummyInputStream() {
        return new DummyInputStream();
    }

    static {
        boolean caseSenstive;
        MAXSYMLINKS = Integer.getInteger("remote.max.sym.links", 20);
        isWindows = Utilities.isWindows();
        windowsReservedChars = new char[][]{{'<', 'L'}, {'>', 'M'}, {':', 'C'}, {'\"', 'D'}, {'/', 'F'}, {'\\', 'B'}, {'|', 'P'}, {'?', 'Q'}, {'*', 'A'}};
        try {
            File tmpFile = File.createTempFile("CaseSensitiveFile", ".check");
            String absPath = tmpFile.getAbsolutePath();
            absPath = absPath.toUpperCase();
            caseSenstive = !new File(absPath).exists();
            tmpFile.delete();
        }
        catch (IOException ex) {
            caseSenstive = Utilities.isUnix() && !Utilities.isMac();
        }
        TRUE_CASE_SENSITIVE_SYSTEM = caseSenstive;
    }

    private static class DummyInputStream
    extends InputStream {
        private DummyInputStream() {
        }

        public int read() throws IOException {
            return -1;
        }
    }
}

