/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.remote.impl.fs.RefreshManager;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectFactory;
import org.netbeans.modules.remote.impl.fs.RemoteFileSupport;
import org.netbeans.modules.remote.spi.FileSystemCacheProvider;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.io.NbObjectInputStream;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressWarnings(value={"Se"})
public final class RemoteFileSystem
extends FileSystem
implements ConnectionListener {
    private static final SystemAction[] NO_SYSTEM_ACTIONS = new SystemAction[0];
    public static final String ATTRIBUTES_FILE_NAME = ".rfs_attr";
    public static final String CACHE_FILE_NAME = ".rfs_cache";
    public static final String RESERVED_PREFIX = ".rfs_";
    public static final String RESERVED_PREFIX_ESCAPED = "._rfs_";
    private static final String READONLY_ATTRIBUTES = "readOnlyAttrs";
    private final ExecutionEnvironment execEnv;
    private final String filePrefix;
    private final RootFileObject root;
    private final RemoteFileSupport remoteFileSupport;
    private final RefreshManager refreshManager;
    private final File cache;
    private final RemoteFileObjectFactory factory;
    private static int fileCopyCount;
    private static int dirSyncCount;
    private static final Object mainLock;
    private static final Map<File, WeakReference<ReadWriteLock>> locks;

    RemoteFileSystem(ExecutionEnvironment execEnv) throws IOException {
        RemoteLogger.assertTrue(execEnv.isRemote());
        this.execEnv = execEnv;
        this.remoteFileSupport = new RemoteFileSupport(execEnv);
        this.factory = new RemoteFileObjectFactory(this);
        this.refreshManager = new RefreshManager(execEnv, this.factory);
        this.filePrefix = FileSystemCacheProvider.getCacheRoot((ExecutionEnvironment)execEnv);
        if (this.filePrefix == null) {
            throw new IllegalStateException("Can not find cache root for remote file system at " + execEnv);
        }
        this.cache = new File(this.filePrefix);
        if (!this.cache.exists() && !this.cache.mkdirs()) {
            throw new IOException(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ERR_CreateDir", (Object)this.cache.getAbsolutePath()));
        }
        this.root = new RootFileObject(this, execEnv, this.cache);
        final WindowFocusListener windowFocusListener = new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                if (ConnectionManager.getInstance().isConnectedTo(RemoteFileSystem.this.execEnv)) {
                    RemoteFileSystem.this.refreshManager.scheduleRefreshOnFocusGained(RemoteFileSystem.this.factory.getCachedFileObjects());
                }
            }

            public void windowLostFocus(WindowEvent e) {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                WindowManager.getDefault().getMainWindow().addWindowFocusListener(windowFocusListener);
            }
        });
        ConnectionManager.getInstance().addConnectionListener((ConnectionListener)this);
    }

    public void connected(ExecutionEnvironment env) {
        if (this.execEnv.equals(env)) {
            Collection<RemoteFileObjectBase> cachedFileObjects = this.factory.getCachedFileObjects();
            this.refreshManager.scheduleRefreshOnConnect(cachedFileObjects);
            for (RemoteFileObjectBase fo : cachedFileObjects) {
                fo.connectionChanged();
            }
        }
    }

    public void disconnected(ExecutionEnvironment env) {
        if (this.execEnv.equals(env)) {
            for (RemoteFileObjectBase fo : this.factory.getCachedFileObjects()) {
                fo.connectionChanged();
            }
        }
    }

    ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    public RemoteFileObjectFactory getFactory() {
        return this.factory;
    }

    public RefreshManager getRefreshManager() {
        return this.refreshManager;
    }

    public String normalizeAbsolutePath(String absPath) {
        return PathUtilities.normalizeUnixPath((String)absPath);
    }

    File getCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReadWriteLock getLock(File file) {
        Object object = mainLock;
        synchronized (object) {
            ReadWriteLock result;
            WeakReference<ReadWriteLock> ref = locks.get(file);
            ReadWriteLock readWriteLock = result = ref == null ? null : (ReadWriteLock)ref.get();
            if (result == null) {
                result = new ReentrantReadWriteLock();
                locks.put(file, new WeakReference<ReadWriteLock>(result));
            }
            return result;
        }
    }

    final void resetStatistic() {
        dirSyncCount = 0;
        fileCopyCount = 0;
    }

    final int getDirSyncCount() {
        return dirSyncCount;
    }

    final int getFileCopyCount() {
        return fileCopyCount;
    }

    final void incrementDirSyncCount() {
        ++dirSyncCount;
    }

    final void incrementFileCopyCount() {
        ++fileCopyCount;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RFS_DISPLAY_NAME", (Object)this.execEnv.getDisplayName());
    }

    public boolean isReadOnly() {
        return true;
    }

    public RemoteDirectory getRoot() {
        return this.root;
    }

    public RemoteFileObjectBase findResource(String name) {
        if (name.isEmpty() || name.equals("/")) {
            return this.getRoot();
        }
        return this.getRoot().getFileObject(name);
    }

    public SystemAction[] getActions() {
        return NO_SYSTEM_ACTIONS;
    }

    public RemoteFileSupport getRemoteFileSupport() {
        return this.remoteFileSupport;
    }

    public String toString() {
        return this.getDisplayName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAttribute(RemoteFileObjectBase file, String attrName, Object value) {
        RemoteFileObjectBase parent = file.getParent();
        if (parent != null) {
            File attr = this.getAttrFile(parent);
            Properties table = this.readProperties(attr);
            String translatedAttributeName = this.translateAttributeName(file, attrName);
            String encodedValue = this.encodeValue(value);
            if (encodedValue == null) {
                table.remove(translatedAttributeName);
            } else {
                table.setProperty(translatedAttributeName, encodedValue);
            }
            FileOutputStream fileOtputStream = null;
            try {
                fileOtputStream = new FileOutputStream(attr);
                table.store(fileOtputStream, "Set attribute " + attrName);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (fileOtputStream != null) {
                    try {
                        fileOtputStream.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }

    private File getAttrFile(RemoteFileObjectBase parent) {
        File attr = new File(parent.getCache(), ATTRIBUTES_FILE_NAME);
        return attr;
    }

    Object getAttribute(RemoteFileObjectBase file, String attrName) {
        RemoteFileObjectBase parent = file.getParent();
        if (parent != null) {
            if (attrName.equals(READONLY_ATTRIBUTES)) {
                return Boolean.FALSE;
            }
            if (attrName.equals("FileSystem.rootPath")) {
                return this.getRoot().getPath();
            }
            if (attrName.equals("java.io.File")) {
                return null;
            }
            if (attrName.equals("ExistsParentNoPublicAPI")) {
                return true;
            }
            if (attrName.startsWith("ProvidedExtensions")) {
                return null;
            }
            File attr = this.getAttrFile(parent);
            Properties table = this.readProperties(attr);
            return this.decodeValue(table.getProperty(this.translateAttributeName(file, attrName)));
        }
        return null;
    }

    Enumeration<String> getAttributes(RemoteFileObjectBase file) {
        RemoteFileObjectBase parent = file.getParent();
        if (parent != null) {
            File attr = this.getAttrFile(parent);
            Properties table = this.readProperties(attr);
            ArrayList<String> res = new ArrayList<String>();
            Enumeration<Object> keys = table.keys();
            String prefix = file.getNameExt() + "[";
            while (keys.hasMoreElements()) {
                String aKey = keys.nextElement().toString();
                if (!aKey.startsWith(prefix)) continue;
                aKey = aKey.substring(prefix.length(), aKey.length() - 1);
                res.add(aKey);
            }
            return Collections.enumeration(res);
        }
        return Collections.enumeration(Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties(File attr) {
        Properties table = new Properties();
        if (attr.exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(attr);
                table.load(fileInputStream);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return table;
    }

    private String translateAttributeName(RemoteFileObjectBase file, String attrName) {
        return file.getNameExt() + "[" + attrName + "]";
    }

    private Object decodeValue(String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        byte[] bytes = new byte[value.length() / 2];
        int count = 0;
        for (int i = 0; i < value.length(); i += 2) {
            try {
                int tempI = Integer.parseInt(value.substring(i, i + 2), 16);
                if (tempI > 127) {
                    tempI -= 256;
                }
                bytes[count++] = (byte)tempI;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes, 0, count);
        try {
            NbObjectInputStream ois = new NbObjectInputStream((InputStream)bis);
            Object ret = ois.readObject();
            return ret;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String encodeValue(Object value) {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(value);
            oos.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] bArray = bos.toByteArray();
        StringBuilder strBuff = new StringBuilder(bArray.length * 2);
        for (int i = 0; i < bArray.length; ++i) {
            if (bArray[i] < 16 && bArray[i] >= 0) {
                strBuff.append("0");
            }
            strBuff.append(Integer.toHexString(bArray[i] < 0 ? bArray[i] + 256 : bArray[i]));
        }
        return strBuff.toString();
    }

    static {
        mainLock = new Object();
        locks = new HashMap<File, WeakReference<ReadWriteLock>>();
    }

    private static class RootFileObject
    extends RemoteDirectory {
        public RootFileObject(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, File cache) {
            super(fileSystem, execEnv, null, "", cache);
        }

        public boolean isRoot() {
            return true;
        }

        public boolean isValid() {
            return true;
        }

        public RemoteDirectory getParent() {
            return null;
        }
    }
}

