/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.ui.AutocompletionProvider;
import org.netbeans.modules.remote.spi.AutocompletionProviderFactory;
import org.netbeans.modules.remote.util.ExecSupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class PathsCompletionProviderFactory
implements AutocompletionProviderFactory {
    public AutocompletionProvider newInstance(ExecutionEnvironment env) {
        try {
            return new Provider(env);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public boolean supports(ExecutionEnvironment env) {
        return ConnectionManager.getInstance().isConnectedTo(env);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CachedValue {
        final String key;
        final List<String> value;

        public CachedValue(String key, List<String> value) {
            this.key = key;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Provider
    implements AutocompletionProvider {
        private static final int cacheSizeLimit = 20;
        private static final int cacheLifetime = 600000;
        private final ExecutionEnvironment env;
        private String homeDir = null;
        private final LinkedList<CachedValue> cache = new LinkedList();
        private final RequestProcessor.Task cleanUpTask;

        public Provider(ExecutionEnvironment env) throws IOException {
            this.env = env;
            this.cleanUpTask = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    LinkedList linkedList = Provider.this.cache;
                    synchronized (linkedList) {
                        Provider.this.cache.clear();
                    }
                }
            }, 600000);
        }

        public List<String> autocomplete(String str) {
            this.cleanUpTask.schedule(600000);
            boolean absolutePaths = false;
            if ("~".equals(str) || ".".equals(str)) {
                ArrayList<String> dir = new ArrayList<String>();
                if (".".equals(str) && this.env.isLocal()) {
                    dir.add(new File("").getAbsolutePath() + '/');
                } else {
                    try {
                        HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.env);
                        dir.add(hostInfo.getUserDir() + '/');
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (CancellationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                return dir;
            }
            if (str.startsWith("~")) {
                str = str.replaceFirst("~", this.getHomeDir());
                absolutePaths = true;
            }
            if (!(str.startsWith(".") || str.startsWith("/") || str.startsWith("~"))) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>();
            int idx = str.lastIndexOf(47) + 1;
            String dir = str.substring(0, idx);
            String file = str.substring(idx);
            List<String> content = this.listDir(dir);
            for (String c : content) {
                if (!c.startsWith(file)) continue;
                if (absolutePaths) {
                    result.add(dir + c);
                    continue;
                }
                result.add(c);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> listDir(String dir) {
            LinkedList<CachedValue> linkedList = this.cache;
            synchronized (linkedList) {
                for (int i = 0; i < this.cache.size(); ++i) {
                    CachedValue cv = this.cache.get(i);
                    if (!cv.key.equals(dir)) continue;
                    this.cache.remove(i);
                    this.cache.add(cv);
                    return cv.value;
                }
            }
            ArrayList<String> content = new ArrayList<String>();
            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.env);
            npb.setExecutable("/bin/ls").setArguments(new String[]{"-1FL", dir});
            ExecSupport.Status result = ExecSupport.call(npb);
            if (result.isOK()) {
                for (String s : result.output) {
                    if (s.endsWith("*")) {
                        content.add(s.substring(0, s.length() - 1));
                        continue;
                    }
                    if (!s.endsWith("/")) continue;
                    content.add(s);
                }
            }
            LinkedList<CachedValue> linkedList2 = this.cache;
            synchronized (linkedList2) {
                this.cache.add(new CachedValue(dir, content));
                while (this.cache.size() > 20) {
                    this.cache.removeFirst();
                }
            }
            return content;
        }

        private synchronized String getHomeDir() {
            if (this.homeDir == null) {
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.env);
                    this.homeDir = hostInfo.getUserDir();
                }
                catch (Exception ex) {
                    this.homeDir = "/home/" + this.env.getUser() + "/";
                }
            }
            return this.homeDir;
        }
    }
}

