/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.ui.AutocompletionProvider;
import org.netbeans.modules.remote.spi.AutocompletionProviderFactory;
import org.netbeans.modules.remote.util.ExecSupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class ExecutablesCompletionProviderFactory
implements AutocompletionProviderFactory {
    public AutocompletionProvider newInstance(ExecutionEnvironment env) {
        try {
            return new Provider(env);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public boolean supports(ExecutionEnvironment env) {
        return ConnectionManager.getInstance().isConnectedTo(env) && HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Scanner
    implements Runnable {
        private final Iterator<String> pathsIterator;
        private final Set<String> executables = new HashSet<String>();
        private final ExecutionEnvironment env;
        private volatile boolean isInterrupted;

        public Scanner(ExecutionEnvironment env, List<String> paths) {
            ArrayList<String> pathsCopy = new ArrayList<String>(paths);
            this.pathsIterator = pathsCopy.iterator();
            this.env = env;
        }

        public void stop() {
            this.isInterrupted = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.isInterrupted = false;
            while (!this.isInterrupted()) {
                String path = null;
                Iterator<String> iterator = this.pathsIterator;
                synchronized (iterator) {
                    if (this.pathsIterator.hasNext()) {
                        path = this.pathsIterator.next();
                    }
                }
                if (path == null) break;
                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.env);
                npb.setExecutable("/bin/ls").setArguments(new String[]{"-1FL", path});
                ExecSupport.Status result = ExecSupport.call(npb);
                if (!result.isOK()) continue;
                for (String s : result.output) {
                    if (!s.endsWith("*")) continue;
                    Set<String> set = this.executables;
                    synchronized (set) {
                        this.executables.add(s.substring(0, s.length() - 1));
                    }
                }
            }
        }

        private boolean isInterrupted() {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException ex) {
                this.isInterrupted = true;
                Thread.currentThread().interrupt();
            }
            this.isInterrupted |= Thread.currentThread().isInterrupted();
            return this.isInterrupted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] getExecutables() {
            Set<String> set = this.executables;
            synchronized (set) {
                return this.executables.toArray(new String[0]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Provider
    implements AutocompletionProvider {
        private static final int numOfScanThreads = 2;
        private final Scanner scanner;
        private RequestProcessor.Task[] scanningTasks;

        public Provider(ExecutionEnvironment env) throws IOException {
            ArrayList<String> paths = new ArrayList<String>();
            HostInfo info = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
            String pathList = (String)info.getEnvironment().get("PATH");
            for (String path : pathList.split(":")) {
                if (paths.contains(path)) continue;
                paths.add(path);
            }
            this.scanner = new Scanner(env, paths);
            this.startScan();
        }

        public List<String> autocomplete(String str) {
            if ("".equals(str)) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>();
            for (String exec : this.scanner.getExecutables()) {
                if (!exec.startsWith(str)) continue;
                result.add(exec);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startScan() {
            Provider provider = this;
            synchronized (provider) {
                if (this.scanner != null && this.scanningTasks == null) {
                    this.scanningTasks = new RequestProcessor.Task[2];
                    for (int i = 0; i < 2; ++i) {
                        this.scanningTasks[i] = RequestProcessor.getDefault().post((Runnable)this.scanner);
                    }
                }
            }
        }
    }
}

