/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.CfgSelectionPanel;
import org.netbeans.modules.mobility.project.ui.QuickRunPanel;
import org.netbeans.modules.mobility.project.ui.actions.AddConfigurationAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class J2MEActionProvider
implements ActionProvider {
    public static final String COMMAND_COMPILE = "compile";
    public static final String COMMAND_OBFUSCATE = "obfuscate";
    public static final String COMMAND_PREVERIFY = "preverify";
    public static final String COMMAND_JAR = "jar";
    public static final String COMMAND_RUN_WITH = "runwith";
    public static final String COMMAND_JAVADOC = "javadoc";
    public static final String COMMAND_DEPLOY = "deploy";
    public static final String COMMAND_CLEAN_ALL = "clean-all";
    public static final String COMMAND_BUILD_ALL = "build-all";
    public static final String COMMAND_REBUILD_ALL = "rebuild-all";
    public static final String COMMAND_JAVADOC_ALL = "javadoc-all";
    public static final String COMMAND_DEPLOY_ALL = "deploy-all";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile", "compile.single", "obfuscate", "preverify", "jar", "run", "runwith", "debug", "javadoc", "deploy", "build-all", "clean-all", "rebuild-all", "javadoc-all", "deploy-all", "delete", "copy", "move", "rename"};
    final Set<String> bkgScanSensitiveActions;
    protected final AntProjectHelper helper;
    protected final J2MEProject project;
    Map<String, String[]> commands = new HashMap<String, String[]>();

    public J2MEActionProvider(J2MEProject project, AntProjectHelper helper) {
        this.commands.put("build", new String[]{"build"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"rebuild"});
        this.commands.put(COMMAND_COMPILE, new String[]{COMMAND_COMPILE});
        this.commands.put("compile.single", new String[]{"compile-single"});
        this.commands.put(COMMAND_OBFUSCATE, new String[]{COMMAND_OBFUSCATE});
        this.commands.put(COMMAND_PREVERIFY, new String[]{COMMAND_PREVERIFY});
        this.commands.put(COMMAND_JAR, new String[]{COMMAND_JAR});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put(COMMAND_RUN_WITH, new String[]{"run-no-build"});
        this.commands.put(COMMAND_JAVADOC, new String[]{COMMAND_JAVADOC});
        this.commands.put(COMMAND_DEPLOY, new String[]{COMMAND_DEPLOY});
        this.commands.put(COMMAND_BUILD_ALL, new String[]{COMMAND_BUILD_ALL});
        this.commands.put(COMMAND_CLEAN_ALL, new String[]{COMMAND_CLEAN_ALL});
        this.commands.put(COMMAND_REBUILD_ALL, new String[]{COMMAND_REBUILD_ALL});
        this.commands.put(COMMAND_JAVADOC_ALL, new String[]{COMMAND_JAVADOC_ALL});
        this.commands.put(COMMAND_DEPLOY_ALL, new String[]{COMMAND_DEPLOY_ALL});
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("debug"));
        this.project = project;
        this.helper = helper;
    }

    protected FileObject findBuildXml() {
        return this.project.getProjectDirectory().getFileObject("build.xml");
    }

    public String[] getSupportedActions() {
        return (String[])supportedActions.clone();
    }

    protected FileObject[] findSourcesAndPackages(Lookup context, FileObject srcDir) {
        if (srcDir != null) {
            FileObject[] files = ActionUtils.findSelectedFiles((Lookup)context, (FileObject)srcDir, null, (boolean)true);
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isFolder() || "java".equals(files[i].getExt())) continue;
                    return null;
                }
            }
            return files;
        }
        return null;
    }

    public String[] getTargetNames(String command) {
        return this.commands.get(command);
    }

    public void invokeAction(final String command, final Lookup context) throws IllegalArgumentException {
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
            return;
        }
        if ("copy".equals(command)) {
            DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
            return;
        }
        if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
            return;
        }
        if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
            return;
        }
        if ((COMMAND_BUILD_ALL.equals(command) || COMMAND_CLEAN_ALL.equals(command) || COMMAND_DEPLOY_ALL.equals(command) || COMMAND_JAVADOC_ALL.equals(command) || COMMAND_REBUILD_ALL.equals(command)) && !this.showCfgSelectionDialog(command)) {
            return;
        }
        Runnable action = new Runnable(){

            @Override
            public void run() {
                String[] targetNames = J2MEActionProvider.this.getTargetNames(command);
                if (targetNames == null) {
                    throw new IllegalArgumentException(command);
                }
                EditableProperties ep = J2MEActionProvider.this.helper.getProperties("nbproject/project.properties");
                ProjectConfigurationsHelper confs = J2MEActionProvider.this.project.getConfigurationHelper();
                String activeConfiguration = confs.getActiveConfiguration() != confs.getDefaultConfiguration() ? confs.getActiveConfiguration().getDisplayName() : null;
                Properties p = new Properties();
                if (command.equals("compile.single")) {
                    FileObject[] files;
                    FileObject srcDir;
                    String sDir = J2MEActionProvider.this.helper.getStandardPropertyEvaluator().getProperty("src.dir");
                    if (sDir != null && (srcDir = J2MEActionProvider.this.helper.resolveFileObject(sDir)) != null && (files = J2MEActionProvider.this.findSourcesAndPackages(context, srcDir)) != null) {
                        p.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)srcDir));
                    }
                } else if ("debug".equals(command)) {
                    p.put("obfuscation.level", "0");
                    p.put("app.codename", J2MEActionProvider.this.project.getName());
                }
                if ("run".equals(command) || J2MEActionProvider.COMMAND_RUN_WITH.equals(command) || "debug".equals(command)) {
                    String url = J2MEActionProvider.this.getJadURL();
                    if (url != null) {
                        p.put("dist.jad.url", url);
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(J2MEActionProvider.class, (String)"ERR_GetJadURL"), 0));
                        return;
                    }
                }
                if (J2MEActionProvider.COMMAND_RUN_WITH.equals(command)) {
                    QuickRunPanel qrp = new QuickRunPanel("j2me", J2MEActionProvider.this.evaluateProperty(ep, "platform.active", activeConfiguration), J2MEActionProvider.this.evaluateProperty(ep, "platform.device", activeConfiguration));
                    DialogDescriptor dd = new DialogDescriptor((Object)qrp, NbBundle.getMessage(J2MEActionProvider.class, (String)"Title_QuickRun"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(J2MEActionProvider.class), null);
                    if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd)) && qrp.getPlatformName() != null && qrp.getDeviceName() != null) {
                        p.put("platform.active", qrp.getPlatformName());
                        p.put("platform.device", qrp.getDeviceName());
                        p.put("run.use.security.domain", Boolean.FALSE.toString());
                    } else {
                        return;
                    }
                }
                try {
                    FileObject buildScript = J2MEActionProvider.this.findBuildXml();
                    if (buildScript != null) {
                        ActionUtils.runTarget((FileObject)buildScript, (String[])targetNames, (Properties)p);
                    } else {
                        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(J2MEActionProvider.class, (String)"MSG_NO_BUILD_SCRIPT"));
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        };
        action.run();
    }

    private boolean showCfgSelectionDialog(String command) {
        boolean configurationChanged;
        String allCfg = this.helper.getProperties("nbproject/project.properties").getProperty("all.configurations");
        if (allCfg == null) {
            return false;
        }
        if (allCfg.trim().length() == 0) {
            return true;
        }
        final EditableProperties priv = this.helper.getProperties("nbproject/private/private.properties");
        String selectedCfg = priv.getProperty("selected.configurations");
        CfgSelectionPanel panel = new CfgSelectionPanel(allCfg, selectedCfg);
        String title = NbBundle.getMessage(AddConfigurationAction.class, (String)("Title_CfgSelection_" + command));
        panel.getAccessibleContext().setAccessibleName(title);
        panel.getAccessibleContext().setAccessibleDescription(title);
        boolean result = DialogDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)panel, title, true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(CfgSelectionPanel.class), null)));
        final String newSel = panel.getSelectedConfigurations();
        boolean bl = configurationChanged = selectedCfg == null != (newSel == null) || selectedCfg != null && !selectedCfg.equals(newSel);
        if (result && configurationChanged) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                @Override
                public void run() {
                    priv.put("selected.configurations", newSel);
                    J2MEActionProvider.this.helper.putProperties("nbproject/private/private.properties", priv);
                    try {
                        ProjectManager.getDefault().saveProject((Project)J2MEActionProvider.this.project);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            });
        }
        return result;
    }

    protected String evaluateProperty(EditableProperties ep, String propertyName, String configuration) {
        if (configuration == null) {
            return ep.getProperty(propertyName);
        }
        String value = ep.getProperty("configs." + configuration + "." + propertyName);
        return value != null ? value : this.evaluateProperty(ep, propertyName, null);
    }

    protected String getJadURL() {
        FileObject fo = FileUtil.getConfigFile((String)"HTTPServer_DUMMY");
        URL base = URLMapper.findURL((FileObject)fo, (int)2);
        if (base == null) {
            return null;
        }
        PropertyEvaluator eval = this.helper.getStandardPropertyEvaluator();
        try {
            URL newURL = new URL(base.getProtocol(), "localhost", base.getPort(), this.encodeURL("/servlet/org.netbeans.modules.mobility.project.jam.JAMServlet/" + this.helper.getProjectDirectory().getPath() + "/" + eval.evaluate("${dist.dir}/${dist.jad}")));
            return newURL.toExternalForm();
        }
        catch (MalformedURLException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
            return null;
        }
    }

    private String encodeURL(String orig) {
        StringTokenizer slashTok = new StringTokenizer(orig, "/", true);
        StringBuffer path = new StringBuffer();
        while (slashTok.hasMoreTokens()) {
            String tok = slashTok.nextToken();
            if (tok.startsWith("/")) {
                path.append(tok);
                continue;
            }
            try {
                path.append(URLEncoder.encode(tok, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                path.append(URLEncoder.encode(tok));
            }
        }
        return path.toString();
    }

    public boolean isActionEnabled(String command, Lookup context) {
        if (COMMAND_RUN_WITH.equals(command)) {
            ProjectConfigurationsHelper confs = this.project.getConfigurationHelper();
            String activeConfiguration = confs.getActiveConfiguration() != confs.getDefaultConfiguration() ? confs.getActiveConfiguration().getDisplayName() : null;
            return !"CDC".equals(this.evaluateProperty(this.helper.getProperties("nbproject/project.properties"), "platform.trigger", activeConfiguration));
        }
        return true;
    }
}

